/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.DirectoryStringChoiceType;
import de.rub.nds.x509attacker.x509.model.AttributeTypeAndValue;
import de.rub.nds.x509attacker.x509.model.RelativeDistinguishedName;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelativeDistinguishedNameParser
extends X509ComponentContainerParser<RelativeDistinguishedName> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RelativeDistinguishedNameParser(X509Chooser chooser, RelativeDistinguishedName relativeDistinguishedName) {
        super(chooser, relativeDistinguishedName);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing RelativeDistinguishedName");
        try {
            while (inputStream.available() > 0) {
                LOGGER.debug("Parsing AttributeTypeAndValue");
                AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue("attributeTypeAndValue", DirectoryStringChoiceType.PRINTABLE_STRING);
                attributeTypeAndValue.getParser(this.chooser).parse(inputStream);
                attributeTypeAndValue.getHandler(this.chooser).adjustContextAfterParse();
                ((RelativeDistinguishedName)this.encodable).addAttributeTypeAndValue(attributeTypeAndValue);
            }
        }
        catch (IOException E) {
            throw new ParserException("IOException in RelativeDistinguishedNameParser", (Throwable)E);
        }
    }
}

