/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.x509attacker.trust.TrustPath;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.security.cert.TrustAnchor;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="X509CertificateChain")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class X509CertificateChain {
    @XmlElementWrapper(name="X509Certificates")
    @XmlElement(name="X509Certificate")
    @HoldsModifiableVariable
    private List<X509Certificate> certificateList = new LinkedList<X509Certificate>();

    public X509CertificateChain() {
    }

    public X509CertificateChain(List<X509Certificate> certChain) {
        this.certificateList = certChain;
    }

    public void addCertificate(int index, X509Certificate certificate) {
        this.certificateList.add(index, certificate);
    }

    public void addCertificate(X509Certificate certificate) {
        this.certificateList.add(certificate);
    }

    public void removeCertificate(int index) {
        this.certificateList.remove(index);
    }

    public int size() {
        return this.certificateList.size();
    }

    public X509Certificate getCertificate(int index) {
        if (index <= this.certificateList.size() - 1) {
            return this.certificateList.get(index);
        }
        return null;
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public void setCertificateList(List<X509Certificate> certificateList) {
        this.certificateList = certificateList;
    }

    public X509Certificate getLeaf() {
        if (!this.certificateList.isEmpty()) {
            return this.certificateList.get(0);
        }
        return null;
    }

    public Boolean isChainOrdered() {
        throw new UnsupportedOperationException("isChainOrdered is not yet implemented");
    }

    public Boolean containsTrustAnchor() {
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isSelfSigned().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean containsKnownTrustAnchor(List<TrustAnchor> anchor) {
        throw new UnsupportedOperationException("containsKnownTrustAnchor is not yet implemented");
    }

    public Boolean containsMultipleLeafs() {
        int counter = 0;
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isLeaf().booleanValue()) continue;
            ++counter;
        }
        return counter <= 1;
    }

    public Boolean containsValidLeaf(String uri) {
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isValidLeafForUri(uri).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<TrustPath> getAllTrustPaths(List<X509Certificate> trustAnchorList) {
        return new LinkedList<TrustPath>();
    }

    public Boolean containsExpiredCertificate() {
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isExpired().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean containsNotYetValidCertificate() {
        for (X509Certificate certificate : this.certificateList) {
            if (certificate.isYetValid().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean containsSelfSignedLeaf() {
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isLeaf().booleanValue() || !certificate.isSelfSigned().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasIncompleteChain() {
        throw new UnsupportedOperationException("hasIncompleteChain is not implemented yet");
    }

    public Boolean allSignaturesValid() {
        for (X509Certificate certificate : this.certificateList) {
            if (certificate.isSignatureValid().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean isExtendedValidation() {
        throw new UnsupportedOperationException("isExtendedValidation is not implemented yet");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificateList == null ? 0 : this.certificateList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CertificateChain other = (X509CertificateChain)obj;
        return !(this.certificateList == null ? other.certificateList != null : !this.certificateList.equals(other.certificateList));
    }
}

