/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp.fragmentation;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;

public class ServerTcpFragmentationTransportHandler
extends ServerTcpTransportHandler {
    private int packetChunks = 3;

    public ServerTcpFragmentationTransportHandler(Connection con) {
        super(con);
    }

    public ServerTcpFragmentationTransportHandler(long firstTimeout, long timeout, int port) {
        super(firstTimeout, timeout, port);
    }

    public ServerTcpFragmentationTransportHandler(long firstTimeout, long timeout, ServerSocket serverSocket) throws IOException {
        super(firstTimeout, timeout, serverSocket);
    }

    public ServerTcpFragmentationTransportHandler(Connection con, Socket socket) throws IOException {
        super(con, socket);
    }

    @Override
    public void sendData(byte[] data) throws IOException {
        if (!this.isInitialized()) {
            throw new IOException("Transporthandler is not initalized!");
        }
        int chunk_size = (int)Math.ceil((double)data.length / (double)this.packetChunks);
        for (int pointer = 0; pointer <= data.length - 1; pointer += chunk_size) {
            if (pointer + chunk_size > data.length - 1) {
                chunk_size = data.length - pointer;
            }
            byte[] slice = Arrays.copyOfRange(data, pointer, pointer + chunk_size);
            this.outStream.write(slice);
            this.outStream.flush();
        }
    }

    public int getPacketChunks() {
        return this.packetChunks;
    }

    public void setPacketChunks(int packetChunks) {
        this.packetChunks = packetChunks;
    }
}

