/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpNoDelayTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.fragmentation.ClientTcpFragmentationTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.fragmentation.ServerTcpFragmentationTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.proxy.TimingProxyClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.timing.TimingClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.timing.TimingServerTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.ClientUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.ServerUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.timing.TimingClientUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.timing.TimingServerUdpTransportHandler;

public class TransportHandlerFactory {
    public static TransportHandler createTransportHandler(Connection con) {
        ConnectionEndType localConEndType = con.getLocalConnectionEndType();
        switch (con.getTransportHandlerType()) {
            case TCP: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientTcpTransportHandler(con);
                }
                return new ServerTcpTransportHandler(con);
            }
            case EAP_TLS: {
                throw new UnsupportedOperationException("EAP_TLS is currently not supported");
            }
            case UDP: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientUdpTransportHandler(con);
                }
                return new ServerUdpTransportHandler(con);
            }
            case STREAM: {
                throw new UnsupportedOperationException("STREAM TransportHandler can only be created manually");
            }
            case TCP_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingClientTcpTransportHandler(con);
                }
                return new TimingServerTcpTransportHandler(con);
            }
            case UDP_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingClientUdpTransportHandler(con);
                }
                return new TimingServerUdpTransportHandler(con);
            }
            case UDP_PROXY: {
                throw new UnsupportedOperationException("UDP_PROXY for server sockets is currently not supported");
            }
            case TCP_PROXY_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingProxyClientTcpTransportHandler(con);
                }
                throw new UnsupportedOperationException("TCP_PROXY_TIMING for server sockets is currently not supported");
            }
            case TCP_NO_DELAY: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientTcpNoDelayTransportHandler(con);
                }
                throw new UnsupportedOperationException("This Transporthandler type is only supported in client mode");
            }
            case TCP_FRAGMENTATION: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientTcpFragmentationTransportHandler(con);
                }
                return new ServerTcpFragmentationTransportHandler(con);
            }
        }
        throw new UnsupportedOperationException("Transport handler " + String.valueOf((Object)con.getTransportHandlerType()) + " is not supported");
    }

    private TransportHandlerFactory() {
    }
}

