/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;

public abstract class StreambasedTransportHandler
extends TransportHandler {
    protected OutputStream outStream;
    protected PushbackInputStream inStream;

    public StreambasedTransportHandler(Connection connection) {
        super(connection);
    }

    public StreambasedTransportHandler(long timeout, ConnectionEndType type) {
        super(timeout, type);
    }

    @Override
    public byte[] fetchData(int amountOfData) throws IOException {
        try (SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();){
            for (int i = 0; i < amountOfData; ++i) {
                try {
                    int byteRead = this.inStream.read();
                    if (byteRead == -1) {
                        throw new EOFException(String.format("Encountered EOF after %d bytes while reading %d bytes of data", i, amountOfData));
                    }
                    outputStream.write(byteRead);
                    continue;
                }
                catch (IOException e) {
                    if (outputStream.size() > 0) {
                        this.inStream.unread(outputStream.toByteArray());
                    }
                    throw e;
                }
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    @Override
    public byte[] fetchData() throws IOException {
        this.setTimeout(this.timeout);
        try {
            if (this.inStream.available() == 0) {
                int read = this.inStream.read();
                if (read == -1) {
                    this.cachedSocketState = SocketState.CLOSED;
                    return new byte[0];
                }
                this.inStream.unread(read);
            }
            assert (this.inStream.available() != 0);
            byte[] data = new byte[this.inStream.available()];
            int read = this.inStream.read(data);
            if (read != data.length) {
                return Arrays.copyOf(data, read);
            }
            return data;
        }
        catch (SocketException E) {
            this.cachedSocketState = SocketState.SOCKET_EXCEPTION;
            return new byte[0];
        }
        catch (SocketTimeoutException E) {
            return new byte[0];
        }
    }

    @Override
    public void sendData(byte[] data) throws IOException {
        if (!this.initialized) {
            throw new IOException("Transport handler is not initialized!");
        }
        this.outStream.write(data);
        this.outStream.flush();
    }

    protected final void setStreams(PushbackInputStream inStream, OutputStream outStream) {
        this.outStream = outStream;
        this.inStream = inStream;
        this.initialized = true;
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }
}

