/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.stream;

import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class LocationByteStreamSucker {
    private static final int BUFFER_SIZE = 4096;
    @Nonnull
    private final byte[] buffer = new byte[4096];
    @Nonnull
    private final InputStream is;
    @Nonnull
    private final OutputStream os;
    @CheckForNull
    private Location inputLocation;
    @CheckForNull
    private Location outputLocation;
    @CheckForNull
    private HasLocation inputLocationProvider;
    @CheckForNull
    private HasLocation outputLocationProvider;

    public LocationByteStreamSucker(@Nonnull InputStream is, @Nonnull OutputStream os, @Nonnull Location inputLocation, @Nonnull Location outputLocation) {
        this.is = is;
        this.os = os;
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
    }

    public LocationByteStreamSucker(@Nonnull InputStream is, @Nonnull OutputStream os, @Nonnull HasLocation inputLocationProvider, @Nonnull HasLocation outputLocationProvider) {
        this.is = is;
        this.os = os;
        this.inputLocationProvider = inputLocationProvider;
        this.outputLocationProvider = outputLocationProvider;
    }

    public LocationByteStreamSucker(@Nonnull InputStream is, @Nonnull HasLocation inputLocationProvider) {
        this.is = is;
        this.os = ByteStreams.nullOutputStream();
        this.inputLocationProvider = inputLocationProvider;
        this.outputLocation = NoLocation.getInstance();
    }

    public LocationByteStreamSucker(@Nonnull InputStream is, @Nonnull Location inputLocation) {
        this(is, ByteStreams.nullOutputStream(), inputLocation, NoLocation.getInstance());
    }

    public void suck() throws CannotReadException, CannotWriteException {
        int bytesRead;
        while ((bytesRead = this.readToBuffer()) >= 0) {
            try {
                this.os.write(this.buffer, 0, bytesRead);
                this.os.flush();
            }
            catch (IOException e) {
                throw new CannotWriteException(this.getOutputLocation(), (Throwable)e);
            }
        }
    }

    private int readToBuffer() throws CannotReadException {
        try {
            return this.is.read(this.buffer);
        }
        catch (IOException e) {
            throw new CannotReadException(this.getInputLocation(), (Throwable)e);
        }
    }

    @Nonnull
    private Location getInputLocation() {
        if (this.inputLocation != null) {
            return this.inputLocation;
        }
        if (this.inputLocationProvider != null) {
            return this.inputLocationProvider.getLocation();
        }
        throw new AssertionError();
    }

    @Nonnull
    private Location getOutputLocation() {
        if (this.outputLocation != null) {
            return this.outputLocation;
        }
        if (this.outputLocationProvider != null) {
            return this.outputLocationProvider.getLocation();
        }
        throw new AssertionError();
    }
}

