/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.reflections.ReflectionFactory;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.ReflectDefaultCtorFactory;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class Selector<T> {
    @Nonnull
    private final Class<T> type;
    @CheckForNull
    private Map<String, Class<? extends T>> propertyValues;
    @CheckForNull
    private List<Parser.ValueDescription> descriptions;

    public Selector(@Nonnull Class<T> type) {
        this.type = type;
    }

    @Nonnull
    public String getUsage() {
        this.ensureScan();
        assert (this.propertyValues != null);
        ArrayList<String> values = new ArrayList<String>(this.propertyValues.keySet());
        Collections.sort(values, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        StringBuilder sb = new StringBuilder();
        return Joiner.on(',').appendTo(sb.append('{'), (Iterable<?>)values).append('}').toString();
    }

    @Nonnull
    public String getVariableName() {
        VariableName variableName = this.type.getAnnotation(VariableName.class);
        if (variableName == null || variableName.value() == null) {
            throw new AssertionError((Object)(this.type.getCanonicalName() + " has no or a wrong @" + VariableName.class.getSimpleName()));
        }
        return variableName.value();
    }

    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        if (this.descriptions == null) {
            this.ensureScan();
            assert (this.propertyValues != null);
            this.descriptions = new ArrayList<Parser.ValueDescription>(this.propertyValues.size());
            for (Class<T> subClass : this.propertyValues.values()) {
                ImplementationName value = subClass.getAnnotation(ImplementationName.class);
                assert (value != null);
                if (value.description().isEmpty()) continue;
                this.descriptions.add(new Parser.ValueDescription(value.name(), value.description()));
            }
            Collections.sort(this.descriptions, new Comparator<Parser.ValueDescription>(){

                @Override
                public int compare(Parser.ValueDescription o1, Parser.ValueDescription o2) {
                    return o1.getValue().compareToIgnoreCase(o2.getValue());
                }
            });
        }
        assert (this.descriptions != null);
        return this.descriptions;
    }

    @Nonnull
    public Class<? extends T> getClass(@Nonnull String string) throws ParsingException {
        this.ensureScan();
        assert (this.propertyValues != null);
        Class<? extends T> value = this.propertyValues.get(string);
        if (value == null) {
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
        return value;
    }

    @Nonnull
    public String getName(@Nonnull Class<? extends T> type) {
        this.ensureScan();
        assert (this.propertyValues != null);
        for (Map.Entry<String, Class<T>> entry : this.propertyValues.entrySet()) {
            if (entry.getValue() != type) continue;
            return entry.getKey();
        }
        throw new ConfigurationError("The class '" + type.getName() + "' does not have @" + ImplementationName.class.getSimpleName() + " annotation");
    }

    public boolean checkClass(@Nonnull Class<? extends T> type) {
        this.ensureScan();
        assert (this.propertyValues != null);
        for (Map.Entry<String, Class<T>> entry : this.propertyValues.entrySet()) {
            if (entry.getValue() != type) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<String> getNames(@Nonnull Class<? extends T> type) {
        ArrayList<String> list = new ArrayList<String>();
        this.ensureScan();
        assert (this.propertyValues != null);
        for (Map.Entry<String, Class<T>> entry : this.propertyValues.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        if (list.isEmpty()) {
            throw new ConfigurationError("No sub-class of '" + type.getName() + "' have @" + ImplementationName.class.getSimpleName() + " annotation");
        }
        return list;
    }

    @Nonnull
    public Set<Class<? extends T>> getClasses() {
        this.ensureScan();
        assert (this.propertyValues != null);
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        set.addAll(this.propertyValues.values());
        return set;
    }

    private synchronized void ensureScan() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap<String, Class<? extends T>>();
            ReflectionManager reflectionManager = ReflectionFactory.getManager();
            Set<Class<T>> propertyValueClasses = reflectionManager.getSubTypesOf(this.type);
            propertyValueClasses.add(this.type);
            for (Class<T> subClass : propertyValueClasses) {
                ImplementationName value = subClass.getAnnotation(ImplementationName.class);
                if (value == null) continue;
                if (this.propertyValues.containsKey(value.name())) {
                    throw new ConfigurationError("The same value " + value.name() + " is used for several classes.");
                }
                ImplementationFilter filter = new ReflectDefaultCtorFactory<ImplementationFilter>(value.filter(), false).create();
                if (!filter.isValid()) continue;
                this.propertyValues.put(value.name(), subClass);
            }
        }
    }
}

