/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CharsetCodec
implements StringCodec<Charset> {
    private boolean forEncoder = false;
    @Nonnegative
    private int minCharsetToDisplay = 10;
    @Nonnegative
    private int maxCharsetToDisplay = Integer.MAX_VALUE;

    @Override
    @Nonnull
    public Charset parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return Charset.forName(string);
        }
        catch (Exception e) {
            throw new ConfigurationError(e.getMessage(), e);
        }
    }

    @Override
    @CheckForNull
    public Charset checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (!Charset.isSupported(string)) {
            throw new ParsingException("The value must be " + this.getDetailedUsage() + " but is '" + string + "'");
        }
        return null;
    }

    @Nonnull
    public CharsetCodec withMinCharsetToDisplay(@Nonnegative int min) {
        this.minCharsetToDisplay = min;
        return this;
    }

    @Nonnull
    public CharsetCodec withMaxCharsetToDisplay(@Nonnegative int max) {
        this.maxCharsetToDisplay = max;
        return this;
    }

    public CharsetCodec forEncoder() {
        this.forEncoder = true;
        return this;
    }

    @Nonnull
    public String getDetailedUsage() {
        return this.getUsage(this.maxCharsetToDisplay);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return this.getUsage(this.minCharsetToDisplay);
    }

    @Nonnull
    private String getUsage(@Nonnegative int max) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        boolean first = true;
        sb.append('{');
        for (Map.Entry<String, Charset> entry : Charset.availableCharsets().entrySet()) {
            if (this.forEncoder && !entry.getValue().canEncode()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (++count > max) {
                sb.append("<...>");
                break;
            }
            sb.append(entry.getValue().displayName());
        }
        sb.append("} (case insensitive)");
        return sb.toString();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        ArrayList<Parser.ValueDescription> list = new ArrayList<Parser.ValueDescription>();
        for (Map.Entry<String, Charset> entry : Charset.availableCharsets().entrySet()) {
            if (this.forEncoder && !entry.getValue().canEncode()) continue;
            for (String alias : entry.getValue().aliases()) {
                list.add(new Parser.ValueDescription(alias, "alias for " + entry.getValue().displayName()));
            }
        }
        return list;
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "charset";
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Charset charset) {
        return charset.name();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Charset charset) {
    }
}

