/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.EnumPropertyId;
import com.android.sched.util.config.id.IntegerPropertyId;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public abstract class MultipleScheduleInstance<T extends Component>
extends ScheduleInstance<T> {
    @Nonnull
    private static final EnumPropertyId<NumThreadsPolicy> NUM_THREADS_POLICY = ((EnumPropertyId)EnumPropertyId.create((String)"sched.runner.thread.kind", (String)"Number of threads policy used by the scheduler", NumThreadsPolicy.class, (Enum[])NumThreadsPolicy.values()).addDefaultValue("num-cores")).ignoreCase().requiredIf(ScheduleInstance.DEFAULT_RUNNER.getClazz().isSubClassOf(MultipleScheduleInstance.class));
    @Nonnull
    private static final IntegerPropertyId NUM_FIXED_THREADS = IntegerPropertyId.create("sched.runner.thread.fixed.count", "Number of threads used by the scheduler").withMin(2L).requiredIf(NUM_THREADS_POLICY.is(NumThreadsPolicy.FIXED));
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnegative
    private int threadPoolSize;

    protected MultipleScheduleInstance(@Nonnull Plan<T> plan) throws Exception {
        super(plan);
        switch (ThreadConfig.get(NUM_THREADS_POLICY)) {
            case NUM_CORES: {
                this.threadPoolSize = Runtime.getRuntime().availableProcessors();
                this.logger.log(Level.FINE, "Multi-threaded based executor with {0} threads (one by number of cores)", this.threadPoolSize);
                break;
            }
            case FIXED: {
                this.threadPoolSize = ThreadConfig.get(NUM_FIXED_THREADS).intValue();
                this.logger.log(Level.FINE, "Multi-threaded based executor with {0} threads (on a system with {1} cores)", new Object[]{this.threadPoolSize, Runtime.getRuntime().availableProcessors()});
            }
        }
    }

    @Nonnegative
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @VariableName(value="policy")
    private static enum NumThreadsPolicy {
        NUM_CORES,
        FIXED;

    }
}

