/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanBuilder;
import com.android.sched.scheduler.PlanNotFoundException;
import com.android.sched.scheduler.Planner;
import com.android.sched.scheduler.PlannerFactory;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.SubPlanBuilder;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.ReaderFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Stack;
import javax.annotation.Nonnull;

@ImplementationName(iface=Planner.class, name="deserializer")
public class DeserializerPlanner<T extends Component>
implements Planner<T> {
    @Nonnull
    private final ReaderFile planFile = ThreadConfig.get(PlannerFactory.PLANNER_FILE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Plan<T> buildPlan(@Nonnull Request request, @Nonnull Class<T> rootRunOn) throws PlanNotFoundException {
        PlanBuilder<T> builder = new PlanBuilder<T>(request, rootRunOn);
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(this.planFile.getBufferedReader());
                Stack<SubPlanBuilder> subPlanStack = new Stack<SubPlanBuilder>();
                subPlanStack.add(builder);
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).equals("}")) {
                        subPlanStack.pop();
                    } else if (!line.equals("{")) {
                        SubPlanBuilder subPlanBuilder;
                        Class<?> runnableClass = this.getClass().getClassLoader().loadClass(line);
                        if (AdapterSchedulable.class.isAssignableFrom(runnableClass)) {
                            subPlanBuilder = (SubPlanBuilder)subPlanStack.peek();
                            SubPlanBuilder newSubPlanBuilder = subPlanBuilder.appendSubPlan(runnableClass);
                            subPlanStack.push(newSubPlanBuilder);
                        } else {
                            subPlanBuilder = (SubPlanBuilder)subPlanStack.peek();
                            subPlanBuilder.append(runnableClass);
                        }
                    }
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new PlanNotFoundException("Error reading plan from file", e);
        }
        catch (ClassNotFoundException e) {
            throw new PlanNotFoundException("Error instantiating schedulable from plan file", e);
        }
        Plan<T> plan = builder.getPlan();
        return plan;
    }
}

