/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jill.signature.GenericSignatureAction;
import com.android.jill.signature.GenericSignatureParser;
import java.lang.reflect.GenericSignatureFormatError;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AsmHelper {
    @Nonnull
    private static final String JAVA_LANG_ENUM = "java/lang/Enum";
    private static final int JAVA_ACCESS_FLAGS_MASK = 65535;

    public static boolean hasValidGenericSignature(@Nonnull ClassNode cn) {
        if (cn.signature != null) {
            try {
                new GenericSignatureParser<Object>(DummyAction.INSTANCE).parseClassSignature(cn.signature);
                return true;
            }
            catch (GenericSignatureFormatError genericSignatureFormatError) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasValidGenericSignature(@Nonnull FieldNode fn) {
        if (fn.signature != null) {
            try {
                new GenericSignatureParser<Object>(DummyAction.INSTANCE).parseFieldSignature(fn.signature);
                return true;
            }
            catch (GenericSignatureFormatError genericSignatureFormatError) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasValidGenericSignature(@Nonnull MethodNode mn) {
        if (mn.signature != null) {
            try {
                new GenericSignatureParser<Object>(DummyAction.INSTANCE).parseMethodSignature(mn.signature);
                return true;
            }
            catch (GenericSignatureFormatError genericSignatureFormatError) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isInterface(@Nonnull ClassNode cn) {
        return (cn.access & 0x200) != 0;
    }

    public static boolean isAnnotation(@Nonnull ClassNode cn) {
        return (cn.access & 0x2000) != 0;
    }

    public static boolean isEnum(@Nonnull ClassNode cn) {
        if ((cn.access & 0x4000) != 0) {
            assert (cn.superName != null);
            return cn.superName.equals(JAVA_LANG_ENUM);
        }
        return false;
    }

    public static boolean isStatic(@Nonnull FieldNode fn) {
        return (fn.access & 8) != 0;
    }

    public static boolean isEnumField(@Nonnull FieldNode fn) {
        return (fn.access & 0x4000) != 0;
    }

    public static boolean isNative(@Nonnull MethodNode mn) {
        return (mn.access & 0x100) != 0;
    }

    public static boolean isAbstract(@Nonnull MethodNode mn) {
        return (mn.access & 0x400) != 0;
    }

    public static boolean isStatic(@Nonnull MethodNode mn) {
        return (mn.access & 8) != 0;
    }

    public static boolean isPrivate(MethodNode mn) {
        return (mn.access & 2) != 0;
    }

    public static boolean isConstructor(@Nonnull MethodNode mn) {
        return mn.name.equals("<init>");
    }

    public static boolean isStaticInit(@Nonnull MethodNode mn) {
        return mn.name.equals("<clinit>");
    }

    public static boolean isLocalStoreOf(@Nonnull AbstractInsnNode insn, @Nonnegative int localIdx) {
        if (!(insn instanceof VarInsnNode) && !(insn instanceof IincInsnNode)) {
            return false;
        }
        switch (insn.getOpcode()) {
            case 132: {
                return ((IincInsnNode)insn).var == localIdx;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                VarInsnNode varInsn = (VarInsnNode)insn;
                return varInsn.var == localIdx;
            }
        }
        return false;
    }

    public static boolean isLocalLoadOf(@Nonnull AbstractInsnNode insn, @Nonnegative int localIdx) {
        if (!(insn instanceof VarInsnNode) && !(insn instanceof IincInsnNode)) {
            return false;
        }
        switch (insn.getOpcode()) {
            case 132: {
                return ((IincInsnNode)insn).var == localIdx;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                VarInsnNode varInsn = (VarInsnNode)insn;
                return varInsn.var == localIdx;
            }
        }
        return false;
    }

    @Nonnull
    public static String getDescriptor(@Nonnull ClassNode cn) {
        return Type.getObjectType(cn.name).getDescriptor();
    }

    @Nonnull
    public static List<String> getDescriptorsFromInternalNames(@Nonnull List<String> internalInterfaceNames) {
        ArrayList<String> interfaceDescs = new ArrayList<String>(internalInterfaceNames.size());
        for (String internalName : internalInterfaceNames) {
            interfaceDescs.add(Type.getObjectType(internalName).getDescriptor());
        }
        return interfaceDescs;
    }

    @Nonnull
    public static String getSourceName(@Nonnull ClassNode cn) {
        int lastPathSeparatorIndex;
        if (cn.innerClasses != null) {
            InnerClassNode matchingInnerClassNode = null;
            for (InnerClassNode innerClassNode : cn.innerClasses) {
                if (!innerClassNode.name.equals(cn.name)) continue;
                matchingInnerClassNode = innerClassNode;
                break;
            }
            if (matchingInnerClassNode != null) {
                return matchingInnerClassNode.innerName != null ? matchingInnerClassNode.innerName : "";
            }
        }
        int startIndex = (lastPathSeparatorIndex = cn.name.lastIndexOf(47)) >= 0 ? lastPathSeparatorIndex + 1 : 0;
        return cn.name.substring(startIndex);
    }

    public static int getModifiers(@Nonnull ClassNode cn) {
        int modifier = cn.access;
        if (cn.innerClasses != null) {
            InnerClassNode matchingInnerClassNode = null;
            for (InnerClassNode innerClassNode : cn.innerClasses) {
                if (!innerClassNode.name.equals(cn.name)) continue;
                matchingInnerClassNode = innerClassNode;
                break;
            }
            if (matchingInnerClassNode != null) {
                modifier = matchingInnerClassNode.access;
            }
        }
        return (modifier &= 0xFFFFFFDF) & 0xFFFF;
    }

    public static int getModifiers(@Nonnull MethodNode mn) {
        return mn.access & 0xFFFF;
    }

    public static int getModifiers(@Nonnull FieldNode fn) {
        return fn.access & 0xFFFF;
    }

    private static class DummyAction
    implements GenericSignatureAction<Object> {
        @Nonnull
        public static final DummyAction INSTANCE = new DummyAction();

        private DummyAction() {
        }

        @Override
        public void parsedSymbol(char symbol) {
        }

        @Override
        public void parsedIdentifier(@Nonnull String identifier) {
        }

        @Override
        @CheckForNull
        public Object parsedTypeName(@Nonnull String name) {
            return null;
        }

        @Override
        @CheckForNull
        public Object parsedInnerTypeName(@CheckForNull Object enclosingTypeName, @Nonnull String name) {
            return null;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }
    }
}

