/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill;

import com.android.jill.ContainerType;
import com.android.jill.IllegalOptionsException;
import com.android.jill.utils.FileUtils;
import com.android.sched.util.file.CannotListDirException;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class Options {
    @CheckForNull
    @Argument(usage="read command line from file", metaVar="@<FILE>")
    private File binaryFile;
    @Option(name="--verbose", usage="enable verbosity (default: false)")
    private boolean verbose = false;
    @Option(name="-h", aliases={"--help"}, usage="display help")
    protected boolean help;
    @CheckForNull
    @Option(name="--output", usage="output file", metaVar="FILE")
    protected File output;
    @Option(name="--version", usage="display version")
    protected boolean version;
    @Option(name="--tolerant", usage="be tolerant to malformed input (default: false)")
    protected boolean tolerant = false;
    private final ContainerType outputContainer = ContainerType.ZIP;
    @Option(name="--no-debug", usage="disable debug info emission")
    protected boolean disableEmitDebugInfo = false;
    @CheckForNull
    private PrintStream err;
    @CheckForNull
    private File workingDir;

    public void checkValidity() throws IllegalOptionsException, CannotListDirException {
        if (this.askForVersion() || this.askForHelp()) {
            return;
        }
        if (this.binaryFile == null) {
            throw new IllegalOptionsException("Input file not provided");
        }
        this.checkBinaryFileValidity();
        if (this.output != null) {
            if (this.outputContainer == ContainerType.DIR) {
                this.checkOutputDir();
            }
        } else {
            throw new IllegalOptionsException("Output directory not provided");
        }
    }

    public void setBinaryFile(@Nonnull File binaryFile) {
        this.binaryFile = binaryFile;
    }

    public void setOutput(@Nonnull File output) {
        this.output = output;
    }

    @Nonnull
    public File getOutput() {
        assert (this.output != null);
        if (this.workingDir != null && !this.output.isAbsolute()) {
            return new File(this.workingDir, this.output.getPath());
        }
        return this.output;
    }

    @Nonnull
    public File getBinaryFile() {
        assert (this.binaryFile != null);
        if (this.workingDir != null && !this.binaryFile.isAbsolute()) {
            return new File(this.workingDir, this.binaryFile.getPath());
        }
        return this.binaryFile;
    }

    public boolean askForVersion() {
        return this.version;
    }

    public boolean askForHelp() {
        return this.help;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTolerant(boolean tolerant) {
        this.tolerant = tolerant;
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public boolean isEmitDebugInfo() {
        return !this.disableEmitDebugInfo;
    }

    public void setEmitDebugInfo(boolean emitDebugInfo) {
        this.disableEmitDebugInfo = !emitDebugInfo;
    }

    @Nonnull
    public ContainerType getOutputContainer() {
        return this.outputContainer;
    }

    public void setStandardError(@Nonnull PrintStream standardError) {
        this.err = standardError;
    }

    @CheckForNull
    public PrintStream getStandardError() {
        return this.err;
    }

    public void setWorkingDirectory(@Nonnull File workingDir) {
        this.workingDir = workingDir;
    }

    private void checkBinaryFileValidity() throws IllegalOptionsException, CannotListDirException {
        assert (this.binaryFile != null);
        File binaryFile = this.getBinaryFile();
        if (!binaryFile.exists()) {
            throw new IllegalOptionsException(binaryFile.getName() + " does not exists.");
        }
        if (binaryFile.isFile() && FileUtils.isJarFile(binaryFile)) {
            return;
        }
        if (binaryFile.isFile() && !FileUtils.isJavaBinaryFile(binaryFile) && !FileUtils.isJarFile(binaryFile)) {
            throw new IllegalOptionsException(binaryFile.getName() + " is not a supported binary file.");
        }
        ArrayList<File> binaryFiles = new ArrayList<File>();
        FileUtils.getJavaBinaryFiles(binaryFile, binaryFiles);
        if (binaryFiles.isEmpty()) {
            System.err.println("Warning: Folder " + binaryFile.getName() + " does not contains class files.");
        }
    }

    private void checkOutputDir() throws IllegalOptionsException {
        assert (this.output != null);
        File output = this.getOutput();
        if (!output.exists()) {
            throw new IllegalOptionsException(output.getName() + " does not exist.");
        }
        if (!output.canRead() || !output.canWrite()) {
            throw new IllegalOptionsException("The specified output folder '" + output.getAbsolutePath() + "' for jack files cannot be written to or read from.");
        }
    }
}

