/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSigner;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.AndroidBinXmlParser;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.stamp.SourceStampVerifier;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.apk.v4.V4SchemeVerifier;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.util.RunnablesExecutor;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ApkVerifier {
    private static final Map<Integer, String> SUPPORTED_APK_SIG_SCHEME_NAMES = ApkVerifier.loadSupportedApkSigSchemeNames();
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final File mV4SignatureFile;
    private final Integer mMinSdkVersion;
    private final int mMaxSdkVersion;
    private static final int TARGET_SANDBOX_VERSION_ATTR_ID = 16844108;
    private static final String TARGET_SANDBOX_VERSION_ELEMENT_NAME = "manifest";
    private static final int TARGET_SDK_VERSION_ATTR_ID = 16843376;
    private static final String TARGET_SDK_VERSION_ELEMENT_NAME = "uses-sdk";

    private static Map<Integer, String> loadSupportedApkSigSchemeNames() {
        HashMap<Integer, String> supportedMap = new HashMap<Integer, String>(2);
        supportedMap.put(2, "APK Signature Scheme v2");
        supportedMap.put(3, "APK Signature Scheme v3");
        return supportedMap;
    }

    private ApkVerifier(File apkFile, DataSource apkDataSource, File v4SignatureFile, Integer minSdkVersion, int maxSdkVersion) {
        this.mApkFile = apkFile;
        this.mApkDataSource = apkDataSource;
        this.mV4SignatureFile = v4SignatureFile;
        this.mMinSdkVersion = minSdkVersion;
        this.mMaxSdkVersion = maxSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verify() throws IOException, ApkFormatException, NoSuchAlgorithmException, IllegalStateException {
        try (Closeable in = null;){
            DataSource apk;
            if (this.mApkDataSource != null) {
                apk = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                RandomAccessFile f = new RandomAccessFile(this.mApkFile, "r");
                in = f;
                apk = DataSources.asDataSource(f, 0L, f.length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            Result result = this.verify(apk);
            return result;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Result verify(DataSource apk) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        if (this.mMinSdkVersion != null) {
            if (this.mMinSdkVersion < 0) {
                throw new IllegalArgumentException("minSdkVersion must not be negative: " + this.mMinSdkVersion);
            }
            if (this.mMinSdkVersion != null && this.mMinSdkVersion > this.mMaxSdkVersion) {
                throw new IllegalArgumentException("minSdkVersion (" + this.mMinSdkVersion + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
            }
        }
        maxSdkVersion = this.mMaxSdkVersion;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", e);
        }
        androidManifest = null;
        if (this.mMinSdkVersion != null) {
            minSdkVersion = this.mMinSdkVersion;
        } else {
            if (androidManifest == null) {
                androidManifest = ApkVerifier.getAndroidManifestFromApk(apk, zipSections);
            }
            if ((minSdkVersion = ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(androidManifest.slice())) > this.mMaxSdkVersion) {
                throw new IllegalArgumentException("minSdkVersion from APK (" + minSdkVersion + ") > maxSdkVersion (" + this.mMaxSdkVersion + ")");
            }
        }
        result = new Result();
        apkContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
        if (maxSdkVersion >= 28) {
            supportedSchemeNames = ApkVerifier.SUPPORTED_APK_SIG_SCHEME_NAMES;
        } else if (maxSdkVersion >= 24) {
            supportedSchemeNames = new HashMap<Integer, String>(1);
            supportedSchemeNames.put(2, ApkVerifier.SUPPORTED_APK_SIG_SCHEME_NAMES.get(2));
        } else {
            supportedSchemeNames = Collections.emptyMap();
        }
        foundApkSigSchemeIds = new HashSet<Integer>(2);
        if (maxSdkVersion >= 24) {
            executor = RunnablesExecutor.SINGLE_THREADED;
            if (maxSdkVersion >= 28) {
                try {
                    v3Result = V3SchemeVerifier.verify(executor, apk, zipSections, Math.max(minSdkVersion, 28), maxSdkVersion);
                    foundApkSigSchemeIds.add(3);
                    Result.access$000(result, v3Result);
                    if (apkContentDigests.isEmpty()) {
                        apkContentDigests.putAll(ApkVerifier.getApkContentDigestsFromSigningSchemeResult(v3Result));
                    }
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException v3Result) {
                    // empty catch block
                }
                if (result.containsErrors()) {
                    return result;
                }
            }
            if (minSdkVersion < 28 || foundApkSigSchemeIds.isEmpty()) {
                try {
                    v2Result = V2SchemeVerifier.verify(executor, apk, zipSections, supportedSchemeNames, foundApkSigSchemeIds, Math.max(minSdkVersion, 24), maxSdkVersion);
                    foundApkSigSchemeIds.add(2);
                    Result.access$000(result, v2Result);
                    if (apkContentDigests.isEmpty()) {
                        apkContentDigests.putAll(ApkVerifier.getApkContentDigestsFromSigningSchemeResult(v2Result));
                    }
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException v2Result) {
                    // empty catch block
                }
                if (result.containsErrors()) {
                    return result;
                }
            }
            if (maxSdkVersion >= 30) {
                try {
                    cdRecords = V1SchemeVerifier.parseZipCentralDirectory(apk, zipSections);
                    sourceStampCdRecord = null;
                    for (CentralDirectoryRecord cdRecord : cdRecords) {
                        if (!"stamp-cert-sha256".equals(cdRecord.getName())) continue;
                        sourceStampCdRecord = cdRecord;
                        break;
                    }
                    if (sourceStampCdRecord != null) {
                        sourceStampCertificateDigest = LocalFileRecord.getUncompressedData(apk, sourceStampCdRecord, zipSections.getZipCentralDirectoryOffset());
                        sourceStampResult = SourceStampVerifier.verify(apk, zipSections, sourceStampCertificateDigest, apkContentDigests, Math.max(minSdkVersion, 30), maxSdkVersion);
                        Result.access$000(result, sourceStampResult);
                    }
                }
                catch (ApkSigningBlockUtils.SignatureNotFoundException ignored) {
                    result.addWarning(Issue.SOURCE_STAMP_SIG_MISSING, new Object[0]);
                }
                catch (ZipFormatException e) {
                    throw new ApkFormatException("Failed to read APK", e);
                }
                if (result.containsErrors()) {
                    return result;
                }
            }
            if (this.mV4SignatureFile != null) {
                v4Result = V4SchemeVerifier.verify(apk, this.mV4SignatureFile);
                foundApkSigSchemeIds.add(4);
                Result.access$000(result, v4Result);
                if (result.containsErrors()) {
                    return result;
                }
            }
        }
        if (maxSdkVersion >= 26) {
            if (androidManifest == null) {
                androidManifest = ApkVerifier.getAndroidManifestFromApk(apk, zipSections);
            }
            if ((targetSandboxVersion = ApkVerifier.getTargetSandboxVersionFromBinaryAndroidManifest(androidManifest.slice())) > 1 && foundApkSigSchemeIds.isEmpty()) {
                result.addError(Issue.NO_SIG_FOR_TARGET_SANDBOX_VERSION, new Object[]{targetSandboxVersion});
            }
        }
        if (minSdkVersion < 24 || foundApkSigSchemeIds.isEmpty()) {
            v1Result = V1SchemeVerifier.verify(apk, zipSections, supportedSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion);
            Result.access$100(result, v1Result);
        }
        if (result.containsErrors()) {
            return result;
        }
        if (result.isVerifiedUsingV1Scheme() && result.isVerifiedUsingV2Scheme()) {
            v1Signers = new ArrayList<Result.V1SchemeSignerInfo>(result.getV1SchemeSigners());
            v2Signers = new ArrayList<Result.V2SchemeSignerInfo>(result.getV2SchemeSigners());
            v1SignerCerts = new ArrayList<ByteArray>();
            v2SignerCerts = new ArrayList<ByteArray>();
            for (Object signer : v1Signers) {
                try {
                    v1SignerCerts.add(new ByteArray(signer.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException e) {
                    throw new IllegalStateException("Failed to encode JAR signer " + signer.getName() + " certs", e);
                }
            }
            for (Object signer : v2Signers) {
                try {
                    v2SignerCerts.add(new ByteArray(signer.getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException e) {
                    throw new IllegalStateException("Failed to encode APK Signature Scheme v2 signer (index: " + signer.getIndex() + ") certs", e);
                }
            }
            for (i = 0; i < v1SignerCerts.size(); ++i) {
                v1Cert = (ByteArray)v1SignerCerts.get(i);
                if (v2SignerCerts.contains(v1Cert)) continue;
                v1Signer = v1Signers.get(i);
                Result.V1SchemeSignerInfo.access$300(v1Signer, Issue.V2_SIG_MISSING, new Object[0]);
                break;
            }
            for (i = 0; i < v2SignerCerts.size(); ++i) {
                v2Cert = (ByteArray)v2SignerCerts.get(i);
                if (v1SignerCerts.contains(v2Cert)) continue;
                v2Signer = v2Signers.get(i);
                Result.V2SchemeSignerInfo.access$400(v2Signer, Issue.JAR_SIG_MISSING, new Object[0]);
                break;
            }
        }
        if (result.isVerifiedUsingV3Scheme() && (result.isVerifiedUsingV1Scheme() || result.isVerifiedUsingV2Scheme())) {
            lineage = result.getSigningCertificateLineage();
            if (result.isVerifiedUsingV1Scheme()) {
                v1Signers = result.getV1SchemeSigners();
                if (v1Signers.size() != 1) {
                    result.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                oldSignerCert = (X509Certificate)Result.V1SchemeSignerInfo.access$500(v1Signers.get(0)).get(0);
            } else {
                v2Signers = result.getV2SchemeSigners();
                if (v2Signers.size() != 1) {
                    result.addError(Issue.V3_SIG_MULTIPLE_PAST_SIGNERS, new Object[0]);
                }
                oldSignerCert = (X509Certificate)Result.V2SchemeSignerInfo.access$600(v2Signers.get(0)).get(0);
            }
            if (lineage == null) {
                v3Signers = result.getV3SchemeSigners();
                if (v3Signers.size() != 1) {
                    result.addError(Issue.V3_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                try {
                    if (Arrays.equals(oldSignerCert.getEncoded(), ((X509Certificate)Result.V3SchemeSignerInfo.access$700(v3Signers.get(0)).get(0)).getEncoded())) ** GOTO lbl157
                    result.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException("Failed to encode APK Signature Scheme v3 signer cert", e);
                }
            } else {
                try {
                    lineage = lineage.getSubLineage(oldSignerCert);
                    if (lineage.size() != 1) {
                        result.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                    }
                }
                catch (IllegalArgumentException e) {
                    result.addError(Issue.V3_SIG_PAST_SIGNERS_MISMATCH, new Object[0]);
                }
            }
        }
lbl157:
        // 6 sources

        if (result.isVerifiedUsingV4Scheme()) {
            v4Signers = Result.access$800(result);
            if (v4Signers.size() != 1) {
                result.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
            }
            if ((digestsFromV4 = ((Result.V4SchemeSignerInfo)v4Signers.get(0)).getContentDigests()).size() != 1) {
                result.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
            }
            digestFromV4 = digestsFromV4.get(0).getValue();
            if (result.isVerifiedUsingV3Scheme()) {
                v3Signers = result.getV3SchemeSigners();
                if (v3Signers.size() != 1) {
                    result.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                ApkVerifier.checkV4Certificate(Result.V4SchemeSignerInfo.access$900((Result.V4SchemeSignerInfo)v4Signers.get(0)), Result.V3SchemeSignerInfo.access$700(v3Signers.get(0)), result);
                digestFromV3 = ApkVerifier.pickBestDigestForV4(v3Signers.get(0).getContentDigests());
                if (!Arrays.equals(digestFromV4, digestFromV3)) {
                    result.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
                }
            } else if (result.isVerifiedUsingV2Scheme()) {
                v2Signers = result.getV2SchemeSigners();
                if (v2Signers.size() != 1) {
                    result.addError(Issue.V4_SIG_MULTIPLE_SIGNERS, new Object[0]);
                }
                ApkVerifier.checkV4Certificate(Result.V4SchemeSignerInfo.access$900((Result.V4SchemeSignerInfo)v4Signers.get(0)), Result.V2SchemeSignerInfo.access$600(v2Signers.get(0)), result);
                digestFromV2 = ApkVerifier.pickBestDigestForV4(v2Signers.get(0).getContentDigests());
                if (!Arrays.equals(digestFromV4, digestFromV2)) {
                    result.addError(Issue.V4_SIG_V2_V3_DIGESTS_MISMATCH, new Object[0]);
                }
            } else {
                throw new RuntimeException("V4 signature must be also verified with V2/V3");
            }
        }
        if (androidManifest == null) {
            androidManifest = ApkVerifier.getAndroidManifestFromApk(apk, zipSections);
        }
        if ((minSchemeVersion = ApkVerifier.getMinimumSignatureSchemeVersionForTargetSdk(targetSdkVersion = ApkVerifier.getTargetSdkVersionFromBinaryAndroidManifest(androidManifest))) > 1 && maxSdkVersion >= targetSdkVersion) {
            switch (minSchemeVersion) {
                case 2: {
                    if (result.isVerifiedUsingV2Scheme()) break;
                }
                case 3: {
                    if (result.isVerifiedUsingV3Scheme()) break;
                    result.addError(Issue.MIN_SIG_SCHEME_FOR_TARGET_SDK_NOT_MET, new Object[]{targetSdkVersion, minSchemeVersion});
                }
            }
        }
        if (result.containsErrors()) {
            return result;
        }
        Result.access$1000(result);
        if (result.isVerifiedUsingV3Scheme()) {
            v3Signers = result.getV3SchemeSigners();
            Result.access$1100(result, v3Signers.get(v3Signers.size() - 1).getCertificate());
        } else if (result.isVerifiedUsingV2Scheme()) {
            for (Object signerInfo : result.getV2SchemeSigners()) {
                Result.access$1100(result, signerInfo.getCertificate());
            }
        } else if (result.isVerifiedUsingV1Scheme()) {
            for (Object signerInfo : result.getV1SchemeSigners()) {
                Result.access$1100(result, signerInfo.getCertificate());
            }
        } else {
            throw new RuntimeException("APK verified, but has not verified using any of v1, v2 or v3 schemes");
        }
        return result;
    }

    private static void checkV4Certificate(List<X509Certificate> v4Certs, List<X509Certificate> v2v3Certs, Result result) {
        try {
            byte[] v4Cert = v4Certs.get(0).getEncoded();
            byte[] cert = v2v3Certs.get(0).getEncoded();
            if (!Arrays.equals(cert, v4Cert)) {
                result.addError(Issue.V4_SIG_V2_V3_SIGNERS_MISMATCH, new Object[0]);
            }
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Failed to encode APK signer cert", e);
        }
    }

    private static byte[] pickBestDigestForV4(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests) {
        HashMap<ContentDigestAlgorithm, byte[]> apkContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
        ApkVerifier.collectApkContentDigests(contentDigests, apkContentDigests);
        return ApkSigningBlockUtils.pickBestDigestForV4(apkContentDigests);
    }

    private static Map<ContentDigestAlgorithm, byte[]> getApkContentDigestsFromSigningSchemeResult(ApkSigningBlockUtils.Result apkSigningSchemeResult) {
        HashMap<ContentDigestAlgorithm, byte[]> apkContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
        for (ApkSigningBlockUtils.Result.SignerInfo signerInfo : apkSigningSchemeResult.signers) {
            ApkVerifier.collectApkContentDigests(signerInfo.contentDigests, apkContentDigests);
        }
        return apkContentDigests;
    }

    private static void collectApkContentDigests(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests, Map<ContentDigestAlgorithm, byte[]> apkContentDigests) {
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : contentDigests) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
            if (signatureAlgorithm == null) continue;
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            apkContentDigests.put(contentDigestAlgorithm, contentDigest.getValue());
        }
    }

    private static ByteBuffer getAndroidManifestFromApk(DataSource apk, ApkUtils.ZipSections zipSections) throws IOException, ApkFormatException {
        List<CentralDirectoryRecord> cdRecords = V1SchemeVerifier.parseZipCentralDirectory(apk, zipSections);
        try {
            return ApkSigner.getAndroidManifestFromApk(cdRecords, apk.slice(0L, zipSections.getZipCentralDirectoryOffset()));
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Failed to read AndroidManifest.xml", e);
        }
    }

    private static int getTargetSandboxVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        return ApkVerifier.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, TARGET_SANDBOX_VERSION_ELEMENT_NAME, 16844108);
    }

    private static int getTargetSdkVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        return ApkVerifier.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, TARGET_SDK_VERSION_ELEMENT_NAME, 16843376);
    }

    private static int getAttributeValueFromBinaryAndroidManifest(ByteBuffer androidManifestContents, String elementName, int attributeId) throws ApkFormatException {
        try {
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && elementName.equals(parser.getName()) && parser.getNamespace().isEmpty()) {
                    int result = 1;
                    block6: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNameResourceId(i) != attributeId) continue;
                        int valueType = parser.getAttributeValueType(i);
                        switch (valueType) {
                            case 2: {
                                result = parser.getAttributeIntValue(i);
                                break block6;
                            }
                            default: {
                                throw new ApkFormatException("Failed to determine APK's " + elementName + " attribute: unsupported value type of AndroidManifest.xml " + String.format("0x%08X", attributeId) + ". Only integer values supported.");
                            }
                        }
                    }
                    return result;
                }
                eventType = parser.next();
            }
            throw new ApkFormatException("Failed to determine APK's " + elementName + " attribute " + String.format("0x%08X", attributeId) + " : no " + elementName + " element in AndroidManifest.xml");
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new ApkFormatException("Failed to determine APK's " + elementName + " attribute " + String.format("0x%08X", attributeId) + ": malformed AndroidManifest.xml", e);
        }
    }

    private static int getMinimumSignatureSchemeVersionForTargetSdk(int targetSdkVersion) {
        if (targetSdkVersion >= 30) {
            return 2;
        }
        return 1;
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private File mV4SignatureFile;
        private Integer mMinSdkVersion;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File apk) {
            if (apk == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = apk;
            this.mApkDataSource = null;
        }

        public Builder(DataSource apk) {
            if (apk == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = apk;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int minSdkVersion) {
            this.mMinSdkVersion = minSdkVersion;
            return this;
        }

        public Builder setMaxCheckedPlatformVersion(int maxSdkVersion) {
            this.mMaxSdkVersion = maxSdkVersion;
            return this;
        }

        public Builder setV4SignatureFile(File v4SignatureFile) {
            this.mV4SignatureFile = v4SignatureFile;
            return this;
        }

        public ApkVerifier build() {
            return new ApkVerifier(this.mApkFile, this.mApkDataSource, this.mV4SignatureFile, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    private static class ByteArray {
        private final byte[] mArray;
        private final int mHashCode;

        private ByteArray(byte[] arr) {
            this.mArray = arr;
            this.mHashCode = Arrays.hashCode(this.mArray);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteArray)) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            return Arrays.equals(this.mArray, other.mArray);
        }
    }

    public static class IssueWithParams {
        private final Issue mIssue;
        private final Object[] mParams;

        public IssueWithParams(Issue issue, Object[] params) {
            this.mIssue = issue;
            this.mParams = params;
        }

        public Issue getIssue() {
            return this.mIssue;
        }

        public Object[] getParams() {
            return (Object[])this.mParams.clone();
        }

        public String toString() {
            return String.format(this.mIssue.getFormat(), this.mParams);
        }
    }

    public static enum Issue {
        JAR_SIG_NO_SIGNATURES("No JAR signatures"),
        JAR_SIG_NO_SIGNED_ZIP_ENTRIES("No JAR entries covered by JAR signatures"),
        JAR_SIG_DUPLICATE_ZIP_ENTRY("Duplicate entry: %1$s"),
        JAR_SIG_DUPLICATE_MANIFEST_SECTION("Duplicate section in META-INF/MANIFEST.MF: %1$s"),
        JAR_SIG_UNNNAMED_MANIFEST_SECTION("Malformed META-INF/MANIFEST.MF: invidual section #%1$d does not have a name"),
        JAR_SIG_UNNNAMED_SIG_FILE_SECTION("Malformed %1$s: invidual section #%2$d does not have a name"),
        JAR_SIG_NO_MANIFEST("Missing META-INF/MANIFEST.MF"),
        JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST("%1$s entry referenced by META-INF/MANIFEST.MF not found in the APK"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST("No digest for %1$s in META-INF/MANIFEST.MF"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE("No digest for %1$s in %2$s"),
        JAR_SIG_ZIP_ENTRY_NOT_SIGNED("%1$s entry not signed"),
        JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH("Entries %1$s and %3$s are signed with different sets of signers : <%2$s> vs <%4$s>"),
        JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY("%2$s digest of %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY("%1$s digest of META-INF/MANIFEST.MF main section does not match the digest specified in %2$s. Expected: <%4$s>, actual: <%3$s>"),
        JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY("%2$s digest of META-INF/MANIFEST.MF section for %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE("%1$s does not specify digest of META-INF/MANIFEST.MF. This slows down verification."),
        JAR_SIG_NO_APK_SIG_STRIP_PROTECTION("APK is signed using APK Signature Scheme v2 but these signatures may be stripped without being detected because %1$s does not contain anti-stripping protections."),
        JAR_SIG_MISSING_FILE("Partial JAR signature. Found: %1$s, missing: %2$s"),
        JAR_SIG_VERIFY_EXCEPTION("Failed to verify JAR signature %1$s against %2$s: %3$s"),
        JAR_SIG_UNSUPPORTED_SIG_ALG("JAR signature %1$s uses digest algorithm %5$s and signature algorithm %6$s which is not supported on API Level(s) %4$s for which this APK is being verified"),
        JAR_SIG_PARSE_EXCEPTION("Failed to parse JAR signature %1$s: %2$s"),
        JAR_SIG_MALFORMED_CERTIFICATE("Malformed certificate in JAR signature %1$s: %2$s"),
        JAR_SIG_DID_NOT_VERIFY("JAR signature %1$s did not verify against %2$s"),
        JAR_SIG_NO_SIGNERS("JAR signature %1$s contains no signers"),
        JAR_SIG_DUPLICATE_SIG_FILE_SECTION("Duplicate section in %1$s: %2$s"),
        JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE("Malformed %1$s: missing Signature-Version attribute"),
        JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID("JAR signature %1$s references unknown APK signature scheme ID: %2$d"),
        JAR_SIG_MISSING_APK_SIG_REFERENCED("JAR signature %1$s indicates the APK is signed using %3$s but no such signature was found. Signature stripped?"),
        JAR_SIG_UNPROTECTED_ZIP_ENTRY("%1$s not protected by signature. Unauthorized modifications to this JAR entry will not be detected. Delete or move the entry outside of META-INF/."),
        JAR_SIG_MISSING("No JAR signature from this signer"),
        NO_SIG_FOR_TARGET_SANDBOX_VERSION("Missing APK Signature Scheme v2 signature required for target sandbox version %1$d"),
        MIN_SIG_SCHEME_FOR_TARGET_SDK_NOT_MET("Target SDK version %1$d requires a minimum of signature scheme v%2$d; the APK is not signed with this or a later signature scheme"),
        V2_SIG_MISSING("No APK Signature Scheme v2 signature from this signer"),
        V2_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V2_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V2_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V2_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V2_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v2 signature record #%1$d"),
        V2_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v2 digest record #%1$d"),
        V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V2_SIG_UNKNOWN_APK_SIG_SCHEME_ID("APK Signature Scheme v2 signer: %1$s references unknown APK signature scheme ID: %2$d"),
        V2_SIG_MISSING_APK_SIG_REFERENCED("APK Signature Scheme v2 signature %1$s indicates the APK is signed using %2$s but no such signature was found. Signature stripped?"),
        V2_SIG_NO_SIGNERS("No signers in APK Signature Scheme v2 signature"),
        V2_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V2_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V2_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V2_SIG_NO_SIGNATURES("No signatures"),
        V2_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures: %1$s"),
        V2_SIG_NO_CERTIFICATES("No certificates"),
        V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V2_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V3_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V3_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V3_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V3_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v3 signature record #%1$d"),
        V3_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v3 digest record #%1$d"),
        V3_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V3_SIG_NO_SIGNERS("No signers in APK Signature Scheme v3 signature"),
        V3_SIG_MULTIPLE_SIGNERS("Multiple APK Signature Scheme v3 signatures found for a single  platform version."),
        V3_SIG_MULTIPLE_PAST_SIGNERS("Multiple signatures found for pre-v3 signing with an APK  Signature Scheme v3 signer.  Only one allowed."),
        V3_SIG_PAST_SIGNERS_MISMATCH("v3 signer differs from v1/v2 signer without proper signing certificate lineage."),
        V3_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V3_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V3_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V3_SIG_INVALID_SDK_VERSIONS("Invalid SDK Version parameter(s) encountered in APK Signature scheme v3 signature: minSdkVersion %1$s maxSdkVersion: %2$s"),
        V3_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V3_SIG_NO_SIGNATURES("No signatures"),
        V3_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V3_SIG_NO_CERTIFICATES("No certificates"),
        V3_MIN_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("minSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_MAX_SDK_VERSION_MISMATCH_BETWEEN_SIGNER_AND_SIGNED_DATA_RECORD("maxSdkVersion mismatch between signed data and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V3_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V3_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        V3_SIG_POR_DID_NOT_VERIFY("SigningCertificateLineage attribute containd a proof-of-rotation record with signature(s) that did not verify."),
        V3_SIG_MALFORMED_LINEAGE("Failed to parse the SigningCertificateLineage structure in the APK Signature Scheme v3 signature's additional attributes section."),
        V3_SIG_POR_CERT_MISMATCH("APK signing certificate differs from the associated certificate found in the signer's SigningCertificateLineage."),
        V3_INCONSISTENT_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions are not continuous."),
        V3_MISSING_SDK_VERSIONS("APK Signature Scheme v3 signers supported min/max SDK versions do not cover the entire desired range.  Found min:  %1$s max %2$s"),
        V3_INCONSISTENT_LINEAGES("SigningCertificateLineages targeting different platform versions using APK Signature Scheme v3 are not all a part of the same overall lineage."),
        APK_SIG_BLOCK_UNKNOWN_ENTRY_ID("APK Signing Block contains unknown entry: ID %1$#x"),
        V4_SIG_MALFORMED_SIGNERS("V4 signature has malformed signer block"),
        V4_SIG_UNKNOWN_SIG_ALGORITHM("V4 signature has unknown signing algorithm: %1$#x"),
        V4_SIG_NO_SIGNATURES("V4 signature has no signature found"),
        V4_SIG_NO_SUPPORTED_SIGNATURES("V4 signature has no supported signature"),
        V4_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V4_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V4_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V4_SIG_MALFORMED_CERTIFICATE("V4 signature has malformed certificate"),
        V4_SIG_NO_CERTIFICATE("V4 signature has no certificate"),
        V4_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("V4 signature has mismatched certificate and signature: <%1$s> vs <%2$s>"),
        V4_SIG_APK_ROOT_DID_NOT_VERIFY("V4 signature's hash tree root (content digest) did not verity"),
        V4_SIG_APK_TREE_DID_NOT_VERIFY("V4 signature's hash tree did not verity"),
        V4_SIG_MULTIPLE_SIGNERS("V4 signature only supports one signer"),
        V4_SIG_V2_V3_SIGNERS_MISMATCH("V4 signature and V2/V3 signature have mismatched certificates"),
        V4_SIG_V2_V3_DIGESTS_MISMATCH("V4 signature and V2/V3 signature have mismatched digests"),
        V4_SIG_VERSION_NOT_CURRENT("V4 signature format version %1$d is different from the tool's current version %2$d"),
        SOURCE_STAMP_SIG_MISSING("No SourceStamp signature"),
        SOURCE_STAMP_MALFORMED_CERTIFICATE("Malformed certificate: %1$s"),
        SOURCE_STAMP_MALFORMED_SIGNATURE("Malformed SourceStamp signature"),
        SOURCE_STAMP_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        SOURCE_STAMP_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        SOURCE_STAMP_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        SOURCE_STAMP_NO_SIGNATURE("No signature"),
        SOURCE_STAMP_NO_SUPPORTED_SIGNATURE("Signature not supported"),
        SOURCE_STAMP_CERTIFICATE_MISMATCH_BETWEEN_SIGNATURE_BLOCK_AND_APK("Certificate mismatch between SourceStamp block in APK signing block and SourceStamp file in APK: <%1$s> vs <%2$s>");

        private final String mFormat;

        private Issue(String format) {
            this.mFormat = format;
        }

        private String getFormat() {
            return this.mFormat;
        }
    }

    public static class Result {
        private final List<IssueWithParams> mErrors = new ArrayList<IssueWithParams>();
        private final List<IssueWithParams> mWarnings = new ArrayList<IssueWithParams>();
        private final List<X509Certificate> mSignerCerts = new ArrayList<X509Certificate>();
        private final List<V1SchemeSignerInfo> mV1SchemeSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V1SchemeSignerInfo> mV1SchemeIgnoredSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V2SchemeSignerInfo> mV2SchemeSigners = new ArrayList<V2SchemeSignerInfo>();
        private final List<V3SchemeSignerInfo> mV3SchemeSigners = new ArrayList<V3SchemeSignerInfo>();
        private final List<V4SchemeSignerInfo> mV4SchemeSigners = new ArrayList<V4SchemeSignerInfo>();
        private SourceStampInfo mSourceStampInfo;
        private boolean mVerified;
        private boolean mVerifiedUsingV1Scheme;
        private boolean mVerifiedUsingV2Scheme;
        private boolean mVerifiedUsingV3Scheme;
        private boolean mVerifiedUsingV4Scheme;
        private boolean mSourceStampVerified;
        private SigningCertificateLineage mSigningCertificateLineage;

        public boolean isVerified() {
            return this.mVerified;
        }

        private void setVerified() {
            this.mVerified = true;
        }

        public boolean isVerifiedUsingV1Scheme() {
            return this.mVerifiedUsingV1Scheme;
        }

        public boolean isVerifiedUsingV2Scheme() {
            return this.mVerifiedUsingV2Scheme;
        }

        public boolean isVerifiedUsingV3Scheme() {
            return this.mVerifiedUsingV3Scheme;
        }

        public boolean isVerifiedUsingV4Scheme() {
            return this.mVerifiedUsingV4Scheme;
        }

        public boolean isSourceStampVerified() {
            return this.mSourceStampVerified;
        }

        public List<X509Certificate> getSignerCertificates() {
            return this.mSignerCerts;
        }

        private void addSignerCertificate(X509Certificate cert) {
            this.mSignerCerts.add(cert);
        }

        public List<V1SchemeSignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<V1SchemeSignerInfo> getV1SchemeIgnoredSigners() {
            return this.mV1SchemeIgnoredSigners;
        }

        public List<V2SchemeSignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<V3SchemeSignerInfo> getV3SchemeSigners() {
            return this.mV3SchemeSigners;
        }

        private List<V4SchemeSignerInfo> getV4SchemeSigners() {
            return this.mV4SchemeSigners;
        }

        public SourceStampInfo getSourceStampInfo() {
            return this.mSourceStampInfo;
        }

        public SigningCertificateLineage getSigningCertificateLineage() {
            return this.mSigningCertificateLineage;
        }

        void addError(Issue msg, Object ... parameters) {
            this.mErrors.add(new IssueWithParams(msg, parameters));
        }

        void addWarning(Issue msg, Object ... parameters) {
            this.mWarnings.add(new IssueWithParams(msg, parameters));
        }

        public List<IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        private void mergeFrom(V1SchemeVerifier.Result source) {
            this.mVerifiedUsingV1Scheme = source.verified;
            this.mErrors.addAll(source.getErrors());
            this.mWarnings.addAll(source.getWarnings());
            for (V1SchemeVerifier.Result.SignerInfo signer : source.signers) {
                this.mV1SchemeSigners.add(new V1SchemeSignerInfo(signer));
            }
            for (V1SchemeVerifier.Result.SignerInfo signer : source.ignoredSigners) {
                this.mV1SchemeIgnoredSigners.add(new V1SchemeSignerInfo(signer));
            }
        }

        private void mergeFrom(ApkSigningBlockUtils.Result source) {
            switch (source.signatureSchemeVersion) {
                case 2: {
                    this.mVerifiedUsingV2Scheme = source.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signer : source.signers) {
                        this.mV2SchemeSigners.add(new V2SchemeSignerInfo(signer));
                    }
                    break;
                }
                case 3: {
                    this.mVerifiedUsingV3Scheme = source.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signer : source.signers) {
                        this.mV3SchemeSigners.add(new V3SchemeSignerInfo(signer));
                    }
                    this.mSigningCertificateLineage = source.signingCertificateLineage;
                    break;
                }
                case 4: {
                    this.mVerifiedUsingV4Scheme = source.verified;
                    for (ApkSigningBlockUtils.Result.SignerInfo signer : source.signers) {
                        this.mV4SchemeSigners.add(new V4SchemeSignerInfo(signer));
                    }
                    break;
                }
                case 0: {
                    this.mSourceStampVerified = source.verified;
                    if (source.signers.isEmpty()) break;
                    this.mSourceStampInfo = new SourceStampInfo(source.signers.get(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Signing Block Scheme Id");
                }
            }
            this.mErrors.addAll(source.getErrors());
            this.mWarnings.addAll(source.getWarnings());
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.mV1SchemeSigners.isEmpty()) {
                for (V1SchemeSignerInfo v1SchemeSignerInfo : this.mV1SchemeSigners) {
                    if (!v1SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo v2SchemeSignerInfo : this.mV2SchemeSigners) {
                    if (!v2SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            if (!this.mV3SchemeSigners.isEmpty()) {
                for (V3SchemeSignerInfo v3SchemeSignerInfo : this.mV3SchemeSigners) {
                    if (!v3SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            return this.mSourceStampInfo != null && this.mSourceStampInfo.containsErrors();
        }

        static /* synthetic */ void access$000(Result x0, ApkSigningBlockUtils.Result x1) {
            x0.mergeFrom(x1);
        }

        static /* synthetic */ void access$100(Result x0, V1SchemeVerifier.Result x1) {
            x0.mergeFrom(x1);
        }

        static /* synthetic */ List access$800(Result x0) {
            return x0.getV4SchemeSigners();
        }

        static /* synthetic */ void access$1000(Result x0) {
            x0.setVerified();
        }

        static /* synthetic */ void access$1100(Result x0, X509Certificate x1) {
            x0.addSignerCertificate(x1);
        }

        public static class SourceStampInfo {
            private final List<X509Certificate> mCertificates;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private SourceStampInfo(ApkSigningBlockUtils.Result.SignerInfo result) {
                this.mCertificates = result.certs;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
            }

            public X509Certificate getCertificate() {
                return this.mCertificates.isEmpty() ? null : this.mCertificates.get(0);
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }

        public static class V4SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V4SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo result) {
                this.mIndex = result.index;
                this.mCerts = result.certs;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
                this.mContentDigests = result.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ List access$900(V4SchemeSignerInfo x0) {
                return x0.mCerts;
            }
        }

        public static class V3SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V3SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo result) {
                this.mIndex = result.index;
                this.mCerts = result.certs;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
                this.mContentDigests = result.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ List access$700(V3SchemeSignerInfo x0) {
                return x0.mCerts;
            }
        }

        public static class V2SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;
            private final List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> mContentDigests;

            private V2SchemeSignerInfo(ApkSigningBlockUtils.Result.SignerInfo result) {
                this.mIndex = result.index;
                this.mCerts = result.certs;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
                this.mContentDigests = result.contentDigests;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            private void addError(Issue msg, Object ... parameters) {
                this.mErrors.add(new IssueWithParams(msg, parameters));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> getContentDigests() {
                return this.mContentDigests;
            }

            static /* synthetic */ void access$400(V2SchemeSignerInfo x0, Issue x1, Object[] x2) {
                x0.addError(x1, x2);
            }

            static /* synthetic */ List access$600(V2SchemeSignerInfo x0) {
                return x0.mCerts;
            }
        }

        public static class V1SchemeSignerInfo {
            private final String mName;
            private final List<X509Certificate> mCertChain;
            private final String mSignatureBlockFileName;
            private final String mSignatureFileName;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V1SchemeSignerInfo(V1SchemeVerifier.Result.SignerInfo result) {
                this.mName = result.name;
                this.mCertChain = result.certChain;
                this.mSignatureBlockFileName = result.signatureBlockFileName;
                this.mSignatureFileName = result.signatureFileName;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
            }

            public String getName() {
                return this.mName;
            }

            public String getSignatureBlockFileName() {
                return this.mSignatureBlockFileName;
            }

            public String getSignatureFileName() {
                return this.mSignatureFileName;
            }

            public X509Certificate getCertificate() {
                return this.mCertChain.isEmpty() ? null : this.mCertChain.get(0);
            }

            public List<X509Certificate> getCertificateChain() {
                return this.mCertChain;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            private void addError(Issue msg, Object ... parameters) {
                this.mErrors.add(new IssueWithParams(msg, parameters));
            }

            static /* synthetic */ void access$300(V1SchemeSignerInfo x0, Issue x1, Object[] x2) {
                x0.addError(x1, x2);
            }

            static /* synthetic */ List access$500(V1SchemeSignerInfo x0) {
                return x0.mCertChain;
            }
        }
    }
}

