/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.ReaderFileCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.ReaderFile;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.log.LoggerFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ReaderFilePropertyId
extends PropertyId<ReaderFile> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static ReaderFilePropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull ReaderFileCodec codec) {
        return new ReaderFilePropertyId(name, description, codec);
    }

    protected ReaderFilePropertyId(@Nonnull String name, @Nonnull String description, @Nonnull ReaderFileCodec codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public ReaderFilePropertyId withAutoClose() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<ReaderFile>(){

            @Override
            public void run(ReaderFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    try {
                        file.getBufferedReader().close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to close '" + file.getPath() + "' from property '" + ReaderFilePropertyId.this.getName() + "'", e);
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public ReaderFilePropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<ReaderFile>(){

            @Override
            public void run(ReaderFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    throw new AssertionError((Object)("File '" + file.getPath() + "' from property '" + ReaderFilePropertyId.this.getName() + "' is not closed"));
                }
            }
        });
        return this;
    }

    @Nonnull
    public ReaderFilePropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }

    @Nonnull
    public ReaderFilePropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public ReaderFilePropertyId addDefaultValue(@Nonnull ReaderFile defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public ReaderFilePropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public ReaderFileCodec getCodec() {
        return (ReaderFileCodec)super.getCodec();
    }

    @Nonnull
    public ReaderFilePropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public ReaderFilePropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

