/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.OutputVFSCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.DirectFS;
import com.android.sched.vfs.GenericOutputVFS;
import com.android.sched.vfs.OutputVFS;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DirectDirOutputVFSCodec
extends OutputVFSCodec {
    @CheckForNull
    private String infoString;

    public DirectDirOutputVFSCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to an output directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "dir";
    }

    @Override
    @Nonnull
    public OutputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            DirectFS dirFS = new DirectFS(new Directory(context.getWorkingDirectory(), string, context.getRunnableHooks(), this.existence, this.permissions, this.change), this.permissions);
            dirFS.setInfoString(this.infoString);
            return new GenericOutputVFS(dirFS);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Nonnull
    public DirectDirOutputVFSCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

