/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.parent;

import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.transformations.SanityChecks;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import java.util.Stack;
import javax.annotation.Nonnull;

@Description(value="Check that AST is correct.")
@Support(value={SanityChecks.class})
public class AstChecker
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        AstCheckerVisitor checker = new AstCheckerVisitor();
        checker.accept(session);
    }

    static class AstCheckerVisitor
    extends JVisitor {
        @Nonnull
        private final Stack<JNode> nodes = new Stack();

        AstCheckerVisitor() {
            super(false);
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            node.checkValidity();
            if (node instanceof JSession) {
                if (node.getParent() != null) {
                    throw new AssertionError((Object)"Parent of JSession must be null.");
                }
            } else if (node.getParent() != this.nodes.peek()) {
                throw new AssertionError((Object)"Node with wrong parent.");
            }
            this.nodes.push(node);
            return super.visit(node);
        }

        @Override
        public void endVisit(@Nonnull JNode node) {
            this.nodes.pop();
            super.endVisit(node);
        }
    }
}

