/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.removeinit;

import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.removeinit.FieldInitMethod;
import com.android.jack.transformations.ast.removeinit.FieldInitMethodCall;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.CloneStatementVisitor;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import javax.annotation.Nonnull;

@Description(value="Remove call to method initializing field values.")
@Name(value="FieldInitMethodCallRemover")
@Constraint(need={JMethodCall.class, FieldInitMethod.class, OriginalNames.class}, no={JFieldInitializer.class})
@Transform(remove={FieldInitMethodCall.class, ThreeAddressCodeForm.class})
@Use(value={CloneStatementVisitor.class})
@Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class FieldInitMethodCallRemover
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        if (!(method instanceof JConstructor)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor v = new Visitor(tr, method.getEnclosingType());
        v.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final JDefinedClassOrInterface declaredType;

        public Visitor(@Nonnull TransformationRequest tr, @Nonnull JDefinedClassOrInterface declaredType) {
            this.tr = tr;
            this.declaredType = declaredType;
        }

        @Override
        public void endVisit(@Nonnull JMethodCall methodCall) {
            if (methodCall.getMethodName().equals("$init")) {
                JMethod varInitMethod;
                assert (methodCall.getParent() instanceof JExpressionStatement);
                try {
                    varInitMethod = this.declaredType.getMethod("$init", (JType)JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), new JType[0]);
                }
                catch (JMethodLookupException e) {
                    throw new AssertionError((Object)e);
                }
                JAbstractMethodBody body = varInitMethod.getBody();
                assert (body instanceof JMethodBody);
                JBlock varInitMethodBLock = ((JMethodBody)body).getBlock();
                if (varInitMethodBLock.getStatements().isEmpty()) {
                    this.tr.append(new Remove(methodCall.getParent()));
                } else {
                    CloneStatementVisitor csv = new CloneStatementVisitor(this.tr, methodCall.getParent(JMethod.class));
                    this.tr.append(new Replace(methodCall.getParent(), csv.cloneStatement(varInitMethodBLock)));
                }
            }
            super.endVisit(methodCall);
        }
    }
}

