/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.resource;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.Resource;
import com.android.jack.library.FileType;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryWritingException;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.ResourceInInputLibraryLocation;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.feature.Resources;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Writer of resources")
@Name(value="LibraryResourceWriter")
@Support(value={Resources.class})
public class LibraryResourceWriter
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        OutputJackLibrary ojl = session.getJackOutputLibrary();
        List<Resource> resources = session.getResources();
        boolean generateLibFromIncremental = ThreadConfig.get(Options.GENERATE_LIBRARY_FROM_INCREMENTAL_FOLDER);
        for (Resource resource : resources) {
            if (resource.getLocation() instanceof ResourceInInputLibraryLocation && generateLibFromIncremental) continue;
            InputVFile inputFile = resource.getVFile();
            VPath path = resource.getPath();
            try {
                OutputVFile outputFile = ojl.createFile(FileType.RSC, path);
                outputFile.copy(inputFile);
            }
            catch (CannotCloseException | CannotCreateFileException | CannotReadException | CannotWriteException | WrongPermissionException e) {
                LibraryWritingException reportable = new LibraryWritingException(new LibraryIOException(ojl.getLocation(), e));
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
        }
    }
}

