/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.Jack;
import com.android.jack.annotations.DisableClassFinalizerOptimization;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.common.DirectlyDerivedClassesMarker;
import com.android.jack.optimizations.modifiers.EffectivelyFinalClassMarker;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

@Description(value="Tighten 'final' modifiers on classes.")
@Constraint(need={DirectlyDerivedClassesMarker.class})
@Support(value={Optimizations.ClassFinalizer.class})
@Transform(add={EffectivelyFinalClassMarker.class})
public class ClassFinalizer
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private final boolean addFinalModifier = ThreadConfig.get(Optimizations.ClassFinalizer.ADD_FINAL_MODIFIER);
    @Nonnull
    public static final StatisticId<Counter> TYPES_FINALIZED = new StatisticId<Counter>("jack.optimization.class-finalizer", "Classes made final", CounterImpl.class, Counter.class);
    @Nonnull
    private final JAnnotationType disablingAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableClassFinalizerOptimization.class.getName()));
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        JDefinedClass definedClass;
        if (type instanceof JDefinedClass && !DirectlyDerivedClassesMarker.hasDirectlyDerivedClasses(definedClass = (JDefinedClass)type) && !type.isAbstract() && !type.isFinal()) {
            EffectivelyFinalClassMarker.markAsEffectivelyFinal(definedClass);
            if (this.addFinalModifier && type.getAnnotations(this.disablingAnnotationType).isEmpty()) {
                definedClass.setFinal();
                this.tracer.getStatistic(TYPES_FINALIZED).incValue();
            }
        }
    }
}

