/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.kohsuke.args4j.spi;

import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.IllegalAnnotationError;
import com.android.jack.kohsuke.args4j.spi.FieldSetter;
import com.android.jack.kohsuke.args4j.spi.Messages;
import com.android.jack.kohsuke.args4j.spi.Setter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MethodSetter
implements Setter {
    private final CmdLineParser parser;
    private final Object bean;
    private final Method m;

    public MethodSetter(CmdLineParser parser, Object bean, Method m) {
        this.parser = parser;
        this.bean = bean;
        this.m = m;
        if (m.getParameterTypes().length != 1) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_METHOD_SIGNATURE.format(m));
        }
    }

    public Class getType() {
        return this.m.getParameterTypes()[0];
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public FieldSetter asFieldSetter() {
        return null;
    }

    @Override
    public AnnotatedElement asAnnotatedElement() {
        return this.m;
    }

    public void addValue(Object value) throws CmdLineException {
        try {
            try {
                this.m.invoke(this.bean, value);
            }
            catch (IllegalAccessException ex) {
                this.m.setAccessible(true);
                try {
                    this.m.invoke(this.bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof CmdLineException) {
                throw (CmdLineException)t;
            }
            if (t != null) {
                throw new CmdLineException(this.parser, t);
            }
            throw new CmdLineException(this.parser, (Throwable)e);
        }
    }
}

