/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency.file;

import com.android.jack.Jack;
import com.android.jack.analysis.dependency.Dependency;
import com.android.jack.google.common.io.LineReader;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class FileDependencies
extends Dependency {
    @Nonnull
    public static final VPath vpath = new VPath("files", '/');
    @Nonnull
    private Map<String, Set<String>> javaFileToTypes = new HashMap<String, Set<String>>();

    public void addMappingBetweenJavaFileAndType(@Nonnull String javaFileName, @Nonnull JType type) {
        String typeFqn = BinaryQualifiedNameFormatter.getFormatter().getName(type);
        Set<String> types = this.javaFileToTypes.get(javaFileName);
        if (types == null) {
            types = new HashSet<String>();
            this.javaFileToTypes.put(javaFileName, types);
        }
        types.add(typeFqn);
    }

    public void update(@Nonnull Set<String> deleteFileNames, @Nonnull Set<String> modifiedFileNames) {
        for (String deletedJavaFileName : deleteFileNames) {
            this.javaFileToTypes.remove(deletedJavaFileName);
        }
        for (String modifiedJavaFileName : modifiedFileNames) {
            this.javaFileToTypes.remove(modifiedJavaFileName);
        }
    }

    public void write(@Nonnull PrintStream ps) {
        this.writeMapOne2Many(ps, this.javaFileToTypes);
        ps.print("#");
        ps.println();
    }

    @Nonnull
    public Set<String> getTypeNames(@Nonnull String javaFileName) {
        Set<String> typeNames = this.javaFileToTypes.get(javaFileName);
        if (typeNames == null) {
            typeNames = Collections.emptySet();
        }
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(typeNames);
    }

    @CheckForNull
    public String getJavaFileName(@Nonnull String typeName) {
        for (Map.Entry<String, Set<String>> entry : this.javaFileToTypes.entrySet()) {
            if (!entry.getValue().contains(typeName)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nonnull
    public Set<String> getCompiledJavaFiles() {
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(this.javaFileToTypes.keySet());
    }

    @Override
    @Nonnull
    public void read(@Nonnull Readable reader) throws IOException {
        this.javaFileToTypes = this.readMapOne2Many(new LineReader(reader));
    }

    @Description(value="File dependencies are collected")
    @Name(value="FileDependencies.Collected")
    public static final class Collected
    implements Tag {
    }
}

