/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.util.SyntheticAccessorFSM;

public class SyntheticAccessorResolver {
    private final SyntheticAccessorFSM syntheticAccessorFSM;
    private final Map<String, ClassDef> classDefMap;
    private final Map<String, AccessedMember> resolvedAccessors = Maps.newConcurrentMap();

    public SyntheticAccessorResolver(Opcodes opcodes, Iterable<? extends ClassDef> classDefs) {
        this.syntheticAccessorFSM = new SyntheticAccessorFSM(opcodes);
        ImmutableMap.Builder<String, ClassDef> builder = ImmutableMap.builder();
        for (ClassDef classDef : classDefs) {
            builder.put(classDef.getType(), classDef);
        }
        this.classDefMap = builder.build();
    }

    public static boolean looksLikeSyntheticAccessor(String methodName) {
        return methodName.startsWith("access$");
    }

    public AccessedMember getAccessedMember(MethodReference methodReference) {
        String methodDescriptor = ReferenceUtil.getMethodDescriptor(methodReference);
        AccessedMember accessedMember = this.resolvedAccessors.get(methodDescriptor);
        if (accessedMember != null) {
            return accessedMember;
        }
        String type = methodReference.getDefiningClass();
        ClassDef classDef = this.classDefMap.get(type);
        if (classDef == null) {
            return null;
        }
        Method matchedMethod = null;
        MethodImplementation matchedMethodImpl = null;
        for (Method method : classDef.getMethods()) {
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null || !SyntheticAccessorResolver.methodReferenceEquals(method, methodReference)) continue;
            matchedMethod = method;
            matchedMethodImpl = methodImpl;
            break;
        }
        if (matchedMethod == null) {
            return null;
        }
        if (!AccessFlags.SYNTHETIC.isSet(matchedMethod.getAccessFlags())) {
            return null;
        }
        ImmutableList<? extends Instruction> instructions = ImmutableList.copyOf(matchedMethodImpl.getInstructions());
        int n = this.syntheticAccessorFSM.test(instructions);
        if (n >= 0) {
            AccessedMember member = new AccessedMember(n, ((ReferenceInstruction)instructions.get(0)).getReference());
            this.resolvedAccessors.put(methodDescriptor, member);
            return member;
        }
        return null;
    }

    private static boolean methodReferenceEquals(MethodReference ref1, MethodReference ref2) {
        return ref1.getName().equals(ref2.getName()) && ref1.getReturnType().equals(ref2.getReturnType()) && ref1.getParameterTypes().equals(ref2.getParameterTypes());
    }

    public static class AccessedMember {
        public final int accessedMemberType;
        public final Reference accessedMember;

        public AccessedMember(int accessedMemberType, Reference accessedMember) {
            this.accessedMemberType = accessedMemberType;
            this.accessedMember = accessedMember;
        }
    }
}

