/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.util.Collection;
import org.jf.dexlib2.base.reference.BaseFieldReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.ImmutableAnnotation;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import org.jf.util.ImmutableConverter;

public class ImmutableField
extends BaseFieldReference
implements Field {
    protected final String definingClass;
    protected final String name;
    protected final String type;
    protected final int accessFlags;
    protected final ImmutableEncodedValue initialValue;
    protected final ImmutableSet<? extends ImmutableAnnotation> annotations;
    private static final ImmutableConverter<ImmutableField, Field> CONVERTER = new ImmutableConverter<ImmutableField, Field>(){

        @Override
        protected boolean isImmutable(Field item) {
            return item instanceof ImmutableField;
        }

        @Override
        protected ImmutableField makeImmutable(Field item) {
            return ImmutableField.of(item);
        }
    };

    public ImmutableField(String definingClass, String name, String type, int accessFlags, EncodedValue initialValue, Collection<? extends Annotation> annotations) {
        this.definingClass = definingClass;
        this.name = name;
        this.type = type;
        this.accessFlags = accessFlags;
        this.initialValue = ImmutableEncodedValueFactory.ofNullable(initialValue);
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
    }

    public static ImmutableField of(Field field) {
        if (field instanceof ImmutableField) {
            return (ImmutableField)field;
        }
        return new ImmutableField(field.getDefiningClass(), field.getName(), field.getType(), field.getAccessFlags(), field.getInitialValue(), field.getAnnotations());
    }

    @Override
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    public ImmutableSet<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    public static ImmutableSortedSet<ImmutableField> immutableSetOf(Iterable<? extends Field> list) {
        return CONVERTER.toSortedSet(Ordering.natural(), list);
    }
}

