/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class AnnotationSetRefList {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "annotation_set_ref_list";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int size = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", size);
                for (int i = 0; i < size; ++i) {
                    int annotationSetOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                    out.annotate(4, "annotation_set_item[0x%x]", annotationSetOffset);
                }
            }

            @Override
            public int getItemAlignment() {
                return 4;
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int annotationSetRefListOffset) {
        if (annotationSetRefListOffset == 0) {
            return "annotation_set_ref_list[NO_OFFSET]";
        }
        return String.format("annotation_set_ref_list[0x%x]", annotationSetRefListOffset);
    }
}

