/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.EncodedValue;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class AnnotationItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "annotation_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int visibility = this.dexFile.getBuffer().readUbyte(out.getCursor());
                out.annotate(1, "visibility = %d: %s", visibility, AnnotationItem.getAnnotationVisibility(visibility));
                DexReader reader = this.dexFile.getBuffer().readerAt(out.getCursor());
                EncodedValue.annotateEncodedAnnotation(this.dexFile, out, reader);
            }
        };
    }

    private static String getAnnotationVisibility(int visibility) {
        switch (visibility) {
            case 0: {
                return "build";
            }
            case 1: {
                return "runtime";
            }
            case 2: {
                return "system";
            }
        }
        return "invalid visibility";
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int annotationItemOffset) {
        try {
            DexReader reader = dexFile.getDataBuffer().readerAt(annotationItemOffset);
            reader.readUbyte();
            int typeIndex = reader.readSmallUleb128();
            String annotationType = (String)dexFile.getTypeSection().get(typeIndex);
            return String.format("annotation_item[0x%x]: %s", annotationItemOffset, annotationType);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("annotation_item[0x%x]", annotationItemOffset);
        }
    }
}

