/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.List;
import org.jf.baksmali.AnalysisArguments;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.DexInputCommand;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.util.SparseArray;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Lists the instance field offsets for classes in a dex file.")
@ExtendedParameters(commandName="fieldoffsets", commandAliases={"fieldoffset", "fo"})
public class ListFieldOffsetsCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @ParametersDelegate
    private AnalysisArguments analysisArguments = new AnalysisArguments();

    public ListFieldOffsetsCommand(List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        BaksmaliOptions options = this.getOptions();
        try {
            for (ClassDef classDef : this.dexFile.getClasses()) {
                ClassProto classProto = (ClassProto)options.classPath.getClass(classDef);
                SparseArray<FieldReference> fields = classProto.getInstanceFields();
                String className = "Class " + classDef.getType() + " : " + fields.size() + " instance fields\n";
                System.out.write(className.getBytes());
                for (int i = 0; i < fields.size(); ++i) {
                    String field = fields.keyAt(i) + ":" + fields.valueAt(i).getType() + " " + fields.valueAt(i).getName() + "\n";
                    System.out.write(field.getBytes());
                }
                System.out.write("\n".getBytes());
            }
            System.out.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private BaksmaliOptions getOptions() {
        if (this.dexFile == null) {
            throw new IllegalStateException("You must call loadDexFile first");
        }
        BaksmaliOptions options = new BaksmaliOptions();
        options.apiLevel = this.apiLevel;
        try {
            options.classPath = this.analysisArguments.loadClassPathForDexFile(this.inputFile.getAbsoluteFile().getParentFile(), this.dexEntry, false);
        }
        catch (Exception ex) {
            System.err.println("Error occurred while loading class path files.");
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
        return options;
    }
}

