/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.Y;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.a;
import com.android.tools.r8.r.a.a.b.W;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.P0;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.e;
import com.android.tools.r8.utils.f0;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    static final String j = String.join((CharSequence)"\n", W.a("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --lib <file>             # Add <file> as a library resource.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));
    private final List<ProguardConfigurationRule> e;
    private final StringConsumer f;
    private final GraphConsumer g;
    private final Y h;
    private final P0 i;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder parse(String[] stringArray) {
        Builder builder = GenerateMainDexListCommand.builder();
        for (int i4 = 0; i4 < stringArray.length; ++i4) {
            String string = stringArray[i4].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(stringArray[++i4], new String[0]));
                continue;
            }
            if (string.startsWith("--")) {
                builder.b().error(new StringDiagnostic("Unknown option: " + string, a.a));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        return builder;
    }

    private GenerateMainDexListCommand(Y y4, e e4, List<ProguardConfigurationRule> list, StringConsumer stringConsumer, GraphConsumer graphConsumer, P0 p02) {
        super(e4);
        this.h = y4;
        this.e = list;
        this.f = stringConsumer;
        this.g = graphConsumer;
        this.i = p02;
    }

    private GenerateMainDexListCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.h = new Y();
        this.e = W.i();
        this.f = null;
        this.g = null;
        this.i = new P0();
    }

    public StringConsumer getMainDexListConsumer() {
        return this.f;
    }

    P0 b() {
        return this.i;
    }

    @Override
    f0 a() {
        f0 f02;
        f0 f03 = f02;
        GenerateMainDexListCommand generateMainDexListCommand = y4;
        GenerateMainDexListCommand generateMainDexListCommand2 = y4;
        GenerateMainDexListCommand generateMainDexListCommand3 = y4;
        GenerateMainDexListCommand generateMainDexListCommand4 = y4;
        Y y4 = generateMainDexListCommand4.h;
        f03(y4, generateMainDexListCommand4.i);
        f03.d = ClassFileConsumer.emptyConsumer();
        f03.X0 = generateMainDexListCommand3.e;
        f03.f1 = generateMainDexListCommand2.f;
        f02.n1 = generateMainDexListCommand.g;
        f02.Y0 = f02.T0;
        f02.c0 = false;
        f02.y = false;
        return f02;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final Y f;
        private final List<ProguardConfigurationSource> g;
        private StringConsumer h;
        private GraphConsumer i;

        private Builder() {
            ArrayList arrayList;
            Y y4;
            Object object = y4;
            y4 = new Y();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            ArrayList arrayList;
            Y y4;
            Object object = y4;
            y4 = new Y();
            v1.f = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.g = object;
            v1.h = null;
            v1.i = null;
        }

        public Builder addMainDexRulesFiles(Path ... pathArray) {
            Builder builder = this;
            builder.a(() -> {
                for (Path path : pathArray) {
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRulesFiles(List<Path> list) {
            Builder builder = this;
            builder.a(() -> {
                list = list.iterator();
                while (list.hasNext()) {
                    Path path = (Path)list.next();
                    this.g.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return builder;
        }

        public Builder addMainDexRules(List<String> list, Origin origin) {
            Builder builder = this;
            builder.a(() -> this.g.add(new ProguardConfigurationSourceStrings(list, Paths.get(".", new String[0]), origin)));
            return builder;
        }

        public Builder setMainDexListOutputPath(Path path) {
            this.h = new StringConsumer.FileConsumer(path);
            return this;
        }

        public Builder setMainDexListConsumer(StringConsumer stringConsumer) {
            this.h = stringConsumer;
            return this;
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.i = graphConsumer;
            return this;
        }

        @Override
        protected BaseCommand c() {
            GenerateMainDexListCommand generateMainDexListCommand;
            if (!((BaseCommand.Builder)((Object)y4)).isPrintHelp() && !((BaseCommand.Builder)((Object)y4)).isPrintVersion()) {
                GenerateMainDexListCommand generateMainDexListCommand2;
                List<ProguardConfigurationRule> list;
                if (((Builder)((Object)y4)).g.isEmpty()) {
                    list = W.i();
                } else {
                    Builder builder = y4;
                    list = builder.f;
                    ProguardConfigurationParser proguardConfigurationParser = new ProguardConfigurationParser((Y)((Object)list), builder.b());
                    proguardConfigurationParser.parse(((Builder)((Object)y4)).g);
                    list = proguardConfigurationParser.getConfig().getRules();
                }
                generateMainDexListCommand = generateMainDexListCommand2;
                Builder builder = y4;
                Y y4 = builder.f;
                e e4 = builder.a().a();
                StringConsumer stringConsumer = builder.h;
                GraphConsumer graphConsumer = builder.i;
                P0 p02 = builder.b();
                generateMainDexListCommand2 = new GenerateMainDexListCommand(y4, e4, list, stringConsumer, graphConsumer, p02);
            } else {
                GenerateMainDexListCommand generateMainDexListCommand3;
                generateMainDexListCommand = generateMainDexListCommand3;
                Builder builder = y4;
                boolean bl = builder.isPrintHelp();
                generateMainDexListCommand3 = new GenerateMainDexListCommand(bl, builder.isPrintVersion());
            }
            return generateMainDexListCommand;
        }

        @Override
        BaseCommand.Builder d() {
            return this;
        }
    }
}

