#!/usr/bin/env python

#       tftp-proxy.py
#       
#       Copyright 2012 Daniel Mende <mail@c0decafe.de>
#

#       Redistribution and use in source and binary forms, with or without
#       modification, are permitted provided that the following conditions are
#       met:
#       
#       * Redistributions of source code must retain the above copyright
#         notice, this list of conditions and the following disclaimer.
#       * Redistributions in binary form must reproduce the above
#         copyright notice, this list of conditions and the following disclaimer
#         in the documentation and/or other materials provided with the
#         distribution.
#       * Neither the name of the  nor the names of its
#         contributors may be used to endorse or promote products derived from
#         this software without specific prior written permission.
#       
#       THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#       "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#       LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#       A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#       OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#       SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#       LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#       DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#       THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#       (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#       OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import sys
import logging
import os
from optparse import OptionParser

import tftpy

DEBUG = False
VERSION="0.1"

TFTPROOT = None
UPSTREAMIP = None

MODULES = {}

def dyn_file_func(filename):
    sys.stdout.write("*** Asked for %s, " % filename)
    print "fetching... ***"
    path = "%s/%s" % (TFTPROOT, filename)
    if filename.find(os.sep) >= 0:
        if not os.path.exists(os.path.dirname(path)):
            os.mkdir(os.path.dirname(path))
    try:
        tclient = tftpy.TftpClient(CMIP, 69)
        tclient.download(filename, path)
    except:
        #sys.stderr.write("%s\n" % str(err))
        return None
    if os.path.getsize(path) > 0:
        for i in MODULES:
            path = MODULES[i].run(filename, path)
        return open(path)
    else:
        os.remove(path)
    return None


parser = OptionParser(usage="usage: %s [options] tftproot upstreamip " % os.path.basename(sys.argv[0]), version=VERSION)
parser.add_option("-d", help="Debug", action="store_true", dest="debug", default=False)
parser.add_option("-m", type="string", help="Modules to load", dest="modules", default="")
(options, args) = parser.parse_args()
if len(args) != 2:
    parser.error("incorrect number of arguments")

if options.debug:
    DEBUG = True
    
TFTPROOT = args[0]
UPSTREAMIP = args[1]

if DEBUG:
    tftpy.setLogLevel(logging.DEBUG)
else:
    tftpy.setLogLevel(logging.ERROR)

sys.path.append("./modules")
for i in options.modules.split(','):
    try:
        MODULES[i] = __import__(i)
    except Exception, e:
        print "Cannont import module %s: %s" % (i, str(e))

server = tftpy.TftpServer(TFTPROOT, dyn_file_func)
try:
    server.listen("", 69)
except tftpy.TftpException, err:
    sys.stderr.write("%s\n" % str(err))
    sys.exit(1)
except KeyboardInterrupt:
    sys.exit(1)
