# 
# TAOF, the general purpose TCP fuzzer.
# Copyright (C) 2007 Rodrigo Marcos
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 


import os # for folder creation
import fuzzutils
import time

#############################################################################
#
# Logger
#
#############################################################################


class Log:
	

	def __init__(self, path=0):
		#self.folder = "." + time
		if path:
			self.folder = path
			try:
				os.chdir(self.folder)
			except:
				sys.stderr.write('Problem changing folder.\n')
			
		else:
			self.folder = fuzzutils.context["TAOF_PATH"] + "fuzzing_session-" + time.strftime('%j-%H.%M.%S')
			try:
				os.mkdir(self.folder)
				os.chdir(self.folder)
			except:
				sys.stderr.write('Problem creating logging folder.\n')

	def end(self):
		os.chdir(fuzzutils.context["TAOF_PATH"])
#		os.rmdir(".fuzzing")

	def log_request(self, ID, request):
		file_object = open(str(ID) + "req" , "wb")
		file_object.write(request)
		file_object.close()

	def log_response(self, ID, response):
		file_object = open(str(ID) + "res" , "wb")
		file_object.write(response)
		file_object.close()

	def read_request(self, ID):
		file_object = open(str(ID) + "req" , "rb")
		request = file_object.read()
		file_object.close()
		return request

	def read_response(self, ID):
		file_object = open(str(ID) + "res" , "rb")
		response = file_object.read()
		file_object.close()
		return response




####################################