/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    long adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0L) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0L) {
            return GTK.gtk_widget_get_sensitive(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_step_increment(this.adjustmentHandle);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_upper(this.adjustmentHandle);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_lower(this.adjustmentHandle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_page_increment(this.adjustmentHandle);
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_value(this.adjustmentHandle);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        if (this.handle == 0L) {
            return new Point(0, 0);
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.handle, gtkRequisition);
        return new Point(gtkRequisition.width, gtkRequisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        return (int)GTK.gtk_adjustment_get_page_size(this.adjustmentHandle);
    }

    public Rectangle getThumbBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getThumbBoundsInPixels());
    }

    Rectangle getThumbBoundsInPixels() {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l = GTK.GTK4 ? GTK4.gtk_widget_get_first_child(this.handle) : this.handle;
        GTK.gtk_range_get_slider_range(l, nArray, nArray2);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        if ((this.style & 0x200) != 0) {
            n4 = gtkAllocation.x;
            n3 = nArray[0];
            n2 = gtkAllocation.width;
            n = nArray2[0] - nArray[0];
        } else {
            n4 = nArray[0];
            n3 = gtkAllocation.y;
            n2 = nArray2[0] - nArray[0];
            n = gtkAllocation.height;
        }
        Rectangle rectangle = new Rectangle(n4, n3, n2, n);
        if (GTK.GTK4) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            boolean bl = GTK4.gtk_widget_translate_coordinates(this.parent.scrolledHandle, this.parent.getShell().shellHandle, 0.0, 0.0, dArray, dArray2);
            if (bl) {
                rectangle.x = (int)((double)rectangle.x + dArray[0]);
                rectangle.y = (int)((double)rectangle.y + dArray2[0]);
            }
            if (bl = GTK4.gtk_widget_translate_coordinates(this.parent.handle, this.parent.getShell().shellHandle, 0.0, 0.0, dArray, dArray2)) {
                rectangle.x = (int)((double)rectangle.x - dArray[0]);
                rectangle.y = (int)((double)rectangle.y - dArray2[0]);
            }
        } else {
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            long l2 = this.gtk_widget_get_window(this.parent.scrolledHandle);
            if (l2 != 0L) {
                GDK.gdk_window_get_origin(l2, nArray3, nArray4);
            }
            rectangle.x += nArray3[0];
            rectangle.y += nArray4[0];
            l2 = this.gtk_widget_get_window(this.parent.handle);
            if (l2 != 0L) {
                GDK.gdk_window_get_origin(l2, nArray3, nArray4);
            }
            rectangle.x -= nArray3[0];
            rectangle.y -= nArray4[0];
        }
        return rectangle;
    }

    public Rectangle getThumbTrackBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getThumbTrackBoundsInPixels());
    }

    Rectangle getThumbTrackBoundsInPixels() {
        long l;
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        int n2;
        Object object;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!GTK.GTK4) {
            object = new int[1];
            GTK3.gtk_widget_style_get(this.handle, OS.has_backward_stepper, object, 0L);
            bl = object[0] != 0;
            GTK3.gtk_widget_style_get(this.handle, OS.has_secondary_backward_stepper, object, 0L);
            bl2 = object[0] != 0;
            GTK3.gtk_widget_style_get(this.handle, OS.has_forward_stepper, object, 0L);
            bl3 = object[0] != 0;
            GTK3.gtk_widget_style_get(this.handle, OS.has_secondary_forward_stepper, object, 0L);
            bl4 = object[0] != 0;
        }
        object = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, (GtkAllocation)object);
        if ((this.style & 0x200) != 0) {
            var10_8 = object.width;
            n3 = object.x;
            if (bl) {
                n4 += var10_8;
            }
            if (bl4) {
                n4 += var10_8;
            }
            n2 = object.width;
            n = object.height - n4;
            if (bl2) {
                n -= var10_8;
            }
            if (bl3) {
                n -= var10_8;
            }
            if (n < 0) {
                objectArray2 = new int[1];
                objectArray = new int[1];
                l = GTK.GTK4 ? GTK4.gtk_widget_get_first_child(this.handle) : this.handle;
                GTK.gtk_range_get_slider_range(l, objectArray2, objectArray);
                n4 = objectArray2[0];
                n = 0;
            }
        } else {
            var10_8 = object.height;
            if (bl) {
                n3 += var10_8;
            }
            if (bl4) {
                n3 += var10_8;
            }
            n4 = object.y;
            n2 = object.width - n3;
            if (bl2) {
                n2 -= var10_8;
            }
            if (bl3) {
                n2 -= var10_8;
            }
            n = object.height;
            if (n2 < 0) {
                objectArray2 = new int[1];
                objectArray = new int[1];
                l = GTK.GTK4 ? GTK4.gtk_widget_get_first_child(this.handle) : this.handle;
                GTK.gtk_range_get_slider_range(l, objectArray2, objectArray);
                n3 = objectArray2[0];
                n2 = 0;
            }
        }
        Rectangle rectangle = new Rectangle(n3, n4, n2, n);
        if (GTK.GTK4) {
            objectArray2 = new double[1];
            objectArray = new double[1];
            boolean bl5 = GTK4.gtk_widget_translate_coordinates(this.parent.scrolledHandle, this.parent.getShell().shellHandle, 0.0, 0.0, objectArray2, objectArray);
            if (bl5) {
                rectangle.x = (int)((double)rectangle.x + objectArray2[0]);
                rectangle.y = (int)((double)rectangle.y + objectArray[0]);
            }
            if (bl5 = GTK4.gtk_widget_translate_coordinates(this.parent.handle, this.parent.getShell().shellHandle, 0.0, 0.0, objectArray2, objectArray)) {
                rectangle.x = (int)((double)rectangle.x - objectArray2[0]);
                rectangle.y = (int)((double)rectangle.y - objectArray[0]);
            }
        } else {
            objectArray2 = new int[1];
            objectArray = new int[1];
            l = this.gtk_widget_get_window(this.parent.scrolledHandle);
            if (l != 0L) {
                GDK.gdk_window_get_origin(l, objectArray2, objectArray);
            }
            rectangle.x += objectArray2[0];
            rectangle.y += objectArray[0];
            l = this.gtk_widget_get_window(this.parent.handle);
            if (l != 0L) {
                GDK.gdk_window_get_origin(l, objectArray2, objectArray);
            }
            rectangle.x -= objectArray2[0];
            rectangle.y -= objectArray[0];
        }
        return rectangle;
    }

    public boolean getVisible() {
        this.checkWidget();
        long l = this.parent.scrolledHandle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_scrolled_window_get_policy(l, nArray, nArray2);
        if ((this.style & 0x100) != 0) {
            return nArray[0] != 2 && nArray[0] != 3 && GTK.gtk_widget_get_visible(this.handle);
        }
        return nArray2[0] != 2 && nArray2[0] != 3 && GTK.gtk_widget_get_visible(this.handle);
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        this.detail = 0;
        this.dragSent = false;
        return l3;
    }

    @Override
    boolean gtk_change_value(long l, int n, double d, long l2) {
        this.detail = n;
        return false;
    }

    @Override
    long gtk_value_changed(long l) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        this.parent.updateScrollBarValue(this);
        GTK.gtk_widget_queue_draw(this.parent.handle);
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Control.fixGdkEventTypeValues(n);
        switch (n) {
            case 7: {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                }
                if (nArray[0] == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
                break;
            }
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.getClosure(57), false);
        if (GTK.GTK4) {
            long l = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.handle, l);
            OS.g_signal_connect(l, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.getClosure(7), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    @Override
    void register() {
        super.register();
        if (this.adjustmentHandle != 0L) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.handle != 0L) {
            GTK.gtk_widget_set_sensitive(this.handle, bl);
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_set_step_increment(this.adjustmentHandle, n);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        int n2 = (int)gtkAdjustment.lower;
        if (n <= n2) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n2);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        int n2 = (int)gtkAdjustment.upper;
        if (n >= n2) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n2 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!((this.parent.style & 0x8000000) == 0 && bl || (this.parent.state & 2) == 0 || (this.style & 0x100) == 0)) {
            GTK.gtk_range_set_inverted(this.handle, (this.parent.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_set_page_increment(this.adjustmentHandle, n);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = Math.min(n, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_set_value(this.adjustmentHandle, n);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(this.adjustmentHandle, gtkAdjustment);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(this.adjustmentHandle, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, bl)) {
            this.sendEvent(bl ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }
}

