/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    long modelHandle;
    int topIndex;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    static final int TEXT_COLUMN = 0;
    double cachedAdjustment;
    double currentAdjustment;
    boolean rowActivated;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l == 0L) {
            this.error(14);
        }
        GTK.gtk_list_store_append(this.modelHandle, l);
        GTK.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1);
        OS.g_free(l);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n > n2) {
            this.error(6);
        }
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l == 0L) {
            this.error(14);
        }
        if (n == n2) {
            GTK.gtk_list_store_append(this.modelHandle, l);
        } else {
            GTK.gtk_list_store_insert(this.modelHandle, l, n);
        }
        GTK.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1);
        OS.g_free(l);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int n) {
        long l;
        long l2;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.scrolledHandle = GTK4.gtk_scrolled_window_new();
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.scrolledHandle = GTK3.gtk_scrolled_window_new(0L, 0L);
        }
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = new long[]{OS.G_TYPE_STRING()};
        this.modelHandle = GTK.gtk_list_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((l2 = GTK.gtk_cell_renderer_text_new()) == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        GTK.gtk_tree_view_column_pack_start(l, l2, true);
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.text, 0);
        GTK.gtk_tree_view_column_set_min_width(l, 0);
        GTK.gtk_tree_view_insert_column(this.handle, l, n);
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
            GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK3.gtk_container_add(this.scrolledHandle, this.handle);
        }
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l3 = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(l3, n2);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
            } else {
                GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.getShell().style & 0x4000) != 0) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        GTK.gtk_widget_realize(this.handle);
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = this.getItemCount() * this.getItemHeightInPixels();
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrimInPixels(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int n) {
        this.checkWidget();
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        GTK.gtk_tree_selection_unselect_iter(l2, l);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n < 0 && n2 < 0) {
            return;
        }
        int n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n >= n3 && n2 >= n3) {
            return;
        }
        n = Math.min(n3 - 1, Math.max(0, n));
        n2 = Math.min(n3 - 1, Math.max(0, n2));
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            GTK.gtk_tree_selection_unselect_iter(l2, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 > n - 1) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n2);
            GTK.gtk_tree_selection_unselect_iter(l2, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void deselectAll() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3 = false;
        if (OS.isX11()) {
            boolean bl4;
            if (bl) {
                long[] lArray = new long[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                    if (lArray[0] != 0L) {
                        long l = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                            bl3 = true;
                        }
                        GTK.gtk_tree_path_free(lArray[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((bl4 = super.dragDetect(n, n2, bl, false, blArray)) && bl3 && blArray != null) {
                blArray[0] = true;
            }
            return bl4;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        long[] lArray = new long[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, dArray, dArray2)) {
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    boolean bl5 = super.dragDetect(n, n2, bl, false, blArray);
                    if (bl5 && bl3 && blArray != null) {
                        blArray[0] = true;
                    }
                    return bl5;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    public int getFocusIndex() {
        this.checkWidget();
        long[] lArray = new long[1];
        GTK.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return -1;
        }
        long l = GTK.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[]{-1};
        if (l != 0L) {
            C.memmove(nArray, l, 4L);
        }
        GTK.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long[] lArray = new long[1];
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        GTK.gtk_tree_model_get(this.modelHandle, l, 0, lArray, -1);
        OS.g_free(l);
        if (lArray[0] == 0L) {
            return null;
        }
        int n2 = C.strlen(lArray[0]);
        byte[] byArray = new byte[n2];
        C.memmove(byArray, lArray[0], (long)n2);
        OS.g_free(lArray[0]);
        return new String(Converter.mbcsToWcs(byArray));
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int[] nArray = new int[1];
        long l = GTK.gtk_widget_create_pango_layout(this.handle, Converter.wcsToMbcs(" ", true));
        OS.pango_layout_get_pixel_size(l, null, nArray);
        int n = nArray[0] + 2;
        OS.g_object_unref(l);
        long l2 = GTK.gtk_tree_view_get_column(this.handle, 0);
        long l3 = this.getTextRenderer(l2);
        int[] nArray2 = new int[1];
        if (l3 != 0L) {
            GTK.gtk_cell_renderer_get_padding(l3, null, nArray2);
        }
        return n += nArray2[0] * 2;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long[] lArray = new long[1];
        String[] stringArray = new String[n];
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        for (int i = 0; i < n; ++i) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            GTK.gtk_tree_model_get(this.modelHandle, l, 0, lArray, -1);
            if (lArray[0] == 0L) continue;
            int n2 = C.strlen(lArray[0]);
            byte[] byArray = new byte[n2];
            C.memmove(byArray, lArray[0], (long)n2);
            OS.g_free(lArray[0]);
            stringArray[i] = new String(Converter.mbcsToWcs(byArray));
        }
        OS.g_free(l);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(l);
    }

    public int getSelectionIndex() {
        long l;
        this.checkWidget();
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = l = GTK.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int[] nArray = new int[1];
            boolean bl = false;
            while (l != 0L) {
                long l4;
                long l5 = OS.g_list_data(l);
                if (!bl && (l4 = GTK.gtk_tree_path_get_indices(l5)) != 0L) {
                    C.memmove(nArray, l4, 4L);
                    bl = true;
                }
                l = OS.g_list_next(l);
                GTK.gtk_tree_path_free(l5);
            }
            OS.g_list_free(l3);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long l;
        this.checkWidget();
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = l = GTK.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int n = OS.g_list_length(l);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l);
                long l5 = GTK.gtk_tree_path_get_indices(l4);
                if (l5 != 0L) {
                    int[] nArray2 = new int[1];
                    C.memmove(nArray2, l5, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                GTK.gtk_tree_path_free(l4);
                l = OS.g_list_next(l);
            }
            OS.g_list_free(l3);
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return new int[0];
    }

    long getTextRenderer(long l) {
        long l2 = GTK.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public int getTopIndex() {
        this.checkWidget();
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(l);
        if (this.cachedAdjustment == this.currentAdjustment) {
            if (Device.DEBUG) {
                System.out.println("Using the cached GtkAdjustment, topIndex is " + this.topIndex);
            }
            return this.topIndex;
        }
        long[] lArray = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return 0;
        }
        if (lArray[0] == 0L) {
            return 0;
        }
        long l2 = GTK.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[1];
        if (l2 != 0L) {
            C.memmove(nArray, l2, 4L);
        }
        GTK.gtk_tree_path_free(lArray[0]);
        if (Device.DEBUG) {
            System.out.println("Fetching the top index from GTK, topIndex is " + nArray[0]);
        }
        return nArray[0];
    }

    @Override
    long gtk_changed(long l) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long[] lArray;
        int n;
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int n2 = GDK.gdk_event_get_event_type(l2);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            nArray2[0] = GDK.gdk_button_event_get_button(l2);
            nArray[0] = GDK.gdk_event_get_modifier_state(l2);
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_button(l2, nArray2);
            GDK.gdk_event_get_state(l2, nArray);
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland() && n2 == 4) {
            long l4 = GDK.gdk_event_peek();
            if (l4 == 0L) {
                long[] lArray2 = new long[1];
                long l5 = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray2, null, null, null) && lArray2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(l5, lArray2[0]) && ((nArray[0] & 5) == 0 || (nArray[0] & 4) != 0)) {
                        long l6 = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(l5, l6, 0L, 0L);
                    }
                }
            } else {
                this.gdk_event_free(l4);
            }
        }
        if ((n = nArray2[0]) == 3 && n2 == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l7 = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(l7, lArray[0])) {
                l3 = 1L;
            }
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l8 = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l8, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l8, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if (n2 == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return l3;
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        if (n == 1) {
            return;
        }
        super.gtk_gesture_press_event(l, n, d, d2, l2);
        if (n == 2 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
    }

    @Override
    long gtk_row_activated(long l, long l2, long l3) {
        this.rowActivated = true;
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l2);
        } else {
            GDK.gdk_event_get_keyval(l2, nArray);
        }
        this.keyPressDefaultSelectionHandler(l2, nArray[0]);
        return super.gtk_key_press_event(l, l2);
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        int[] nArray = new int[1];
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_event_get_modifier_state(l2);
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_state(l2, nArray);
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        long l3 = this.gdk_event_get_surface_or_window(l2);
        if (GTK.GTK4 ? l3 != this.gtk_widget_get_surface(this.handle) : l3 != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland()) {
            long[] lArray = new long[1];
            long l4 = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(l4, 0L, 0L, 0L);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null) && lArray[0] != 0L && GTK.gtk_tree_selection_path_is_selected(l4, lArray[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((nArray[0] & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
                }
                if ((nArray[0] & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(l4, lArray[0]);
                }
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    void keyPressDefaultSelectionHandler(long l, int n) {
        int n2 = this.gdk_event_get_state(l);
        switch (n) {
            case 65293: {
                if ((n2 & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        Event event = new Event();
        event.index = this.getFocusIndex();
        if (event.index >= 0) {
            event.text = this.getItem(event.index);
        }
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] stringArray = this.getItems();
        for (int i = n; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(Integer.toString(n), true);
        long l2 = GTK.gtk_tree_path_new_from_string(byArray);
        boolean bl = GTK.gtk_tree_selection_path_is_selected(l, l2);
        GTK.gtk_tree_path_free(l2);
        return bl;
    }

    @Override
    long paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK3.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_remove(this.modelHandle, l);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n2; i >= n; --i) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            GTK.gtk_list_store_remove(this.modelHandle, l);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = this.getItemCount();
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        int n4 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            int n5 = nArray2[i];
            if (n5 == n4) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n5);
            GTK.gtk_list_store_remove(this.modelHandle, l);
            n4 = n5;
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void removeAll() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        GTK.gtk_tree_selection_select_iter(l2, l);
        if ((this.style & 4) != 0) {
            long l3 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
            GTK.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            GTK.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, i);
            GTK.gtk_tree_selection_select_iter(l2, l);
            if ((this.style & 4) == 0) continue;
            long l3 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
            GTK.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            GTK.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (0 > n3 || n3 >= n2) continue;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n3);
            GTK.gtk_tree_selection_select_iter(l2, l);
            if ((this.style & 4) == 0) continue;
            long l3 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
            GTK.gtk_tree_view_set_cursor(this.handle, l3, 0L, false);
            GTK.gtk_tree_path_free(l3);
        }
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        OS.g_free(l);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
    }

    void selectFocusIndex(int n) {
        int n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (0 > n || n >= n2) {
            return;
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
        long l3 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
        OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_path_free(l2);
        OS.g_free(l);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        GTK.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        byte[] byArray = Converter.wcsToMbcs(string, true);
        GTK.gtk_list_store_set(this.modelHandle, l, 0, byArray, -1);
        OS.g_free(l);
    }

    public void setItems(String ... stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            this.error(5);
        }
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(14);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            byte[] byArray = Converter.wcsToMbcs(string, true);
            GTK.gtk_list_store_append(this.modelHandle, l2);
            GTK.gtk_list_store_set(this.modelHandle, l2, 0, byArray, -1);
        }
        OS.g_free(l2);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = gdkRGBA == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : gdkRGBA;
        this.setForegroundGdkRGBA(this.handle, gdkRGBA2);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            int n2 = 0;
            String string = stringArray[i];
            if (string == null) continue;
            while ((n2 = this.indexOf(string, n2)) != -1) {
                if ((this.style & 2) != 0) {
                    if (bl) {
                        bl = false;
                        this.selectFocusIndex(n2);
                    } else {
                        this.select(n2);
                    }
                } else {
                    this.selectFocusIndex(n2);
                    continue block0;
                }
                ++n2;
            }
        }
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(l);
        this.topIndex = n;
        if (0 > n || n >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            return;
        }
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n);
        long l3 = GTK.gtk_tree_model_get_path(this.modelHandle, l2);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, l3, 0L, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(l3);
        OS.g_free(l2);
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n == -1) {
            return;
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
        GTK.gtk_widget_realize(this.handle);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, false, 0.0f, 0.0f);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(this.handle, l2, 0L, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        if (nArray2[0] < gdkRectangle.y) {
            GTK.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n2 = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n2 > gdkRectangle.y + gdkRectangle.height) {
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                GTK.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        GTK.gtk_tree_path_free(l2);
        OS.g_free(l);
    }
}

