/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = File.separatorChar;
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long l;
        long l2;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            l2 = 0L;
            l2 = GTK.GTK4 ? GTK4.gtk_file_chooser_get_files(this.handle) : (this.uriMode ? GTK3.gtk_file_chooser_get_uris(this.handle) : GTK3.gtk_file_chooser_get_filenames(this.handle));
            int n = GTK.GTK4 ? OS.g_list_model_get_n_items(l2) : OS.g_slist_length(l2);
            this.fileNames = new String[n];
            var4_7 = l2;
            var6_8 = 0;
            for (int i = 0; i < n; ++i) {
                long l3 = GTK.GTK4 ? OS.g_list_model_get_item(l2, i) : OS.g_slist_data(var4_7);
                long l4 = 0L;
                if (this.uriMode) {
                    l4 = GTK.GTK4 ? OS.g_file_get_uri(l3) : l3;
                } else {
                    if (GTK.GTK4) {
                        l3 = OS.g_file_get_path(l3);
                    }
                    if ((l4 = OS.g_filename_to_utf8(l3, -1L, null, null, null)) == 0L) {
                        l4 = OS.g_filename_display_name(l3);
                    }
                }
                if (l3 != l4) {
                    OS.g_free(l3);
                }
                if (l4 != 0L) {
                    long[] lArray = new long[1];
                    long l5 = OS.g_utf8_to_utf16(l4, -1L, null, lArray, null);
                    OS.g_free(l4);
                    if (l5 != 0L) {
                        int n2 = (int)lArray[0];
                        char[] cArray = new char[n2];
                        C.memmove(cArray, l5, (long)(n2 * 2));
                        OS.g_free(l5);
                        this.fullPath = new String(cArray);
                        this.fileNames[var6_8++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                if (GTK.GTK4) continue;
                var4_7 = OS.g_slist_next(var4_7);
            }
            if (var6_8 != 0 && var6_8 != n) {
                String[] stringArray = new String[var6_8];
                System.arraycopy(this.fileNames, 0, stringArray, 0, var6_8);
                this.fileNames = stringArray;
            }
            if (GTK.GTK4) {
                OS.g_object_unref(l2);
            } else {
                OS.g_slist_free(l2);
            }
        } else {
            l2 = 0L;
            if (this.uriMode) {
                if (GTK.GTK4) {
                    var3_3 = GTK4.gtk_file_chooser_get_file(this.handle);
                    l2 = OS.g_file_get_uri(var3_3);
                } else {
                    l2 = GTK3.gtk_file_chooser_get_uri(this.handle);
                }
            } else {
                if (GTK.GTK4) {
                    long l6 = GTK4.gtk_file_chooser_get_file(this.handle);
                    var3_3 = OS.g_file_get_path(l6);
                } else {
                    var3_3 = GTK3.gtk_file_chooser_get_filename(this.handle);
                }
                if (var3_3 != 0L) {
                    l2 = OS.g_filename_to_utf8(var3_3, -1L, null, null, null);
                    if (l2 == 0L) {
                        l2 = OS.g_filename_display_name(var3_3);
                    }
                    if (var3_3 != l2) {
                        OS.g_free(var3_3);
                    }
                }
            }
            if (l2 != 0L) {
                long[] lArray = new long[1];
                var4_7 = OS.g_utf8_to_utf16(l2, -1L, null, lArray, null);
                OS.g_free(l2);
                if (var4_7 != 0L) {
                    var6_8 = (int)lArray[0];
                    char[] cArray = new char[var6_8];
                    C.memmove(cArray, var4_7, (long)(var6_8 * 2));
                    OS.g_free(var4_7);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        l2 = GTK.gtk_file_chooser_get_filter(this.handle);
        if (l2 != 0L && (l = GTK.gtk_file_filter_get_name(l2)) != 0L) {
            int n = C.strlen(l);
            byte[] byArray = new byte[n];
            C.memmove(byArray, l, (long)n);
            String string = new String(Converter.mbcsToWcs(byArray));
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[i].equals(string)) continue;
                    this.filterIndex = i;
                    break;
                }
                if (!this.filterExtensions[i].equals(string)) continue;
                this.filterIndex = i;
                break;
            }
        }
        if (this.fullPath != null) {
            int n = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n + 1);
            this.filterPath = this.fullPath.substring(0, n);
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openNativeChooserDialog();
    }

    String openNativeChooserDialog() {
        int n;
        byte[] byArray = Converter.wcsToMbcs(this.title, true);
        int n2 = (this.style & 0x2000) != 0 ? 1 : 0;
        long l = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = GTK.gtk_file_chooser_native_new(byArray, l, n2, null, null);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (this.uriMode && !GTK.GTK4) {
            GTK3.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        int n3 = 0;
        long l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, this.handle, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run(display, this.handle, true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_native_dialog_run(this.handle);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l2);
        }
        if (n == -3) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        return string;
    }

    void presetChooserDialog() {
        Object object;
        long l;
        if ((this.style & 0x2002) == 2) {
            GTK.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.fileName.equals("")) {
                this.fileName = "Untitled";
            }
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    var1_1 = Converter.wcsToMbcs(this.filterPath, true);
                    if (GTK.GTK4) {
                        var2_3 = OS.g_file_new_for_uri((byte[])var1_1);
                        GTK4.gtk_file_chooser_set_current_folder(this.handle, var2_3, 0L);
                        OS.g_object_unref(var2_3);
                    } else {
                        GTK3.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])var1_1);
                    }
                } else {
                    var1_1 = Converter.wcsToMbcs(SEPARATOR + this.filterPath, true);
                    var2_3 = OS.realpath((byte[])var1_1, null);
                    if (var2_3 != 0L) {
                        if (GTK.GTK4) {
                            l = OS.g_file_new_for_path((byte[])var1_1);
                            GTK4.gtk_file_chooser_set_current_folder(this.handle, l, 0L);
                            OS.g_object_unref(l);
                        } else {
                            GTK3.gtk_file_chooser_set_current_folder(this.handle, var2_3);
                        }
                        OS.g_free(var2_3);
                    }
                }
            }
            if (this.fileName.length() > 0) {
                var1_1 = new StringBuilder();
                ((StringBuilder)var1_1).append(this.fileName);
                if (this.fileName.lastIndexOf(46) == -1 && this.filterExtensions.length != 0) {
                    int n;
                    String string = null;
                    string = this.filterIndex == -1 ? this.filterExtensions[0] : this.filterExtensions[this.filterIndex];
                    String string2 = null;
                    int n2 = string.indexOf(59);
                    string2 = n2 == -1 ? string.trim() : string.substring(0, n2).trim();
                    object = string2.substring(n = string2.lastIndexOf(46));
                    if (!this.isGlobPattern((String)object)) {
                        ((StringBuilder)var1_1).append((String)object);
                    }
                }
                byte[] byArray = Converter.wcsToMbcs(((StringBuilder)var1_1).toString(), true);
                GTK.gtk_file_chooser_set_current_name(this.handle, byArray);
            }
        } else {
            var1_1 = new StringBuilder();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuilder)var1_1).append(SEPARATOR);
                }
                ((StringBuilder)var1_1).append(this.filterPath);
                ((StringBuilder)var1_1).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuilder)var1_1).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs(((StringBuilder)var1_1).toString(), true);
            if (GTK.GTK4) {
                long l2;
                if (this.uriMode) {
                    l2 = OS.g_file_new_for_uri(byArray);
                    GTK4.gtk_file_chooser_set_file(this.handle, l2, 0L);
                } else {
                    l2 = OS.g_file_new_for_path(byArray);
                    if (this.fileName.length() > 0) {
                        GTK4.gtk_file_chooser_set_file(this.handle, l2, 0L);
                    }
                }
                OS.g_object_unref(l2);
            } else if (this.uriMode) {
                GTK3.gtk_file_chooser_set_uri(this.handle, byArray);
            } else {
                long l3 = OS.realpath(byArray, null);
                if (l3 != 0L) {
                    if (this.fileName.length() > 0) {
                        GTK3.gtk_file_chooser_set_filename(this.handle, l3);
                    } else {
                        GTK3.gtk_file_chooser_set_current_folder(this.handle, l3);
                    }
                    OS.g_free(l3);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && !GTK.GTK4) {
            GTK3.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l4 = 0L;
        for (int i = 0; i < this.filterExtensions.length; ++i) {
            byte[] byArray;
            String string;
            if (this.filterExtensions[i] == null) continue;
            l = GTK.gtk_file_filter_new();
            if (this.filterNames.length > i && this.filterNames[i] != null) {
                object = Converter.wcsToMbcs(this.filterNames[i], true);
                GTK.gtk_file_filter_set_name(l, object);
            } else {
                object = Converter.wcsToMbcs(this.filterExtensions[i], true);
                GTK.gtk_file_filter_set_name(l, object);
            }
            int n = 0;
            int n3 = this.filterExtensions[i].indexOf(59);
            while (n3 != -1) {
                string = this.filterExtensions[i].substring(n, n3);
                byArray = Converter.wcsToMbcs(string, true);
                GTK.gtk_file_filter_add_pattern(l, byArray);
                n = n3 + 1;
                n3 = this.filterExtensions[i].indexOf(59, n);
            }
            string = this.filterExtensions[i].substring(n);
            byArray = Converter.wcsToMbcs(string, true);
            GTK.gtk_file_filter_add_pattern(l, byArray);
            GTK.gtk_file_chooser_add_filter(this.handle, l);
            if (i != this.filterIndex) continue;
            l4 = l;
        }
        if (l4 != 0L) {
            GTK.gtk_file_chooser_set_filter(this.handle, l4);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    private boolean isGlobPattern(String string) {
        return string.contains("*") || string.contains("?") || string.contains("[") && string.contains("]");
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

