/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    long textEntryHandle;
    long spinButtonHandle;
    long containerHandle;
    long calendarHandle;
    long editableHandle;
    Calendar calendar;
    Button down;
    FieldPosition currentField;
    StringBuilder typeBuffer = new StringBuilder();
    int typeBufferPos = -1;
    boolean firstTime = true;
    private DateFormat dateFormat;
    Color fg;
    Color bg;
    boolean hasFocus;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Point prefferedSize;
    Locale locale;
    Listener mouseEventListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "dd/MM/yy";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "d-MMM-yyyy";
    static final String DEFAULT_LONG_DATE_FORMAT = "MMMM d, yyyy";
    static final String DEFAULT_SHORT_TIME_FORMAT = "h:mm a";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "h:mm:ss a";
    static final String DEFAULT_LONG_TIME_FORMAT = "h:mm:ss z a";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    static final int SPACE_FOR_CURSOR = 1;
    private int mdYear;
    private int mdMonth;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
        if (this.isDate() || this.isTime()) {
            this.createText();
        }
        if (this.isCalendar()) {
            GTK.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
        }
        if (this.isDateWithDropDownButton()) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
            this.addListener(11, event -> this.setDropDownButtonSize());
        }
        this.initAccessible();
        if (this.isDateWithDropDownButton()) {
            Point point = this.computeSizeInPixels(-1, -1);
            this.setBoundsInPixels(0, 0, point.x, point.y);
        }
    }

    void createText() {
        String string = System.getProperty("swt.datetime.locale");
        this.locale = string == null || string.isEmpty() ? Locale.getDefault() : Locale.forLanguageTag(string);
        this.dateFormat = this.getFormat(this.locale, this.style);
        this.dateFormat.setLenient(false);
        this.calendar = Calendar.getInstance(this.locale);
        this.updateControl();
        this.selectField(this.updateField(this.currentField));
    }

    DateFormat getFormat(Locale locale, int n) {
        int n2 = (n & 0x10000000) != 0 ? 1 : ((n & 0x8000) != 0 ? 3 : 2);
        if (this.isDate()) {
            return DateFormat.getDateInstance(n2, locale);
        }
        if (this.isTime()) {
            return DateFormat.getTimeInstance(n2, locale);
        }
        throw new IllegalStateException("can only be called for date or time widgets!");
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        if (((n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            n &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Point computeMaxTextSize(int n, int n2, boolean bl) {
        String string3 = this.getFormattedString();
        String string4 = this.getComputeSizeString(this.style);
        switch (string4) {
            case "d-MMM-yyyy": {
                String string5 = string3.replaceFirst("\\d{1,2}", "00");
                this.setText(string5);
                break;
            }
            case "MMMM d, yyyy": {
                Set<String> set = this.calendar.getDisplayNames(2, 2, this.locale).keySet();
                String string6 = Collections.max(set, (string, string2) -> string.length() - string2.length());
                String string7 = string3.replaceFirst("\\d{1,2}", "00");
                String string8 = string7.replaceFirst("[^\\s]+", string6);
                this.setText(string8);
                break;
            }
            case "h:mm a": 
            case "h:mm:ss a": 
            case "h:mm:ss z a": {
                String string9 = string3.replaceFirst("\\d{1,2}", "00");
                this.setText(string9);
                break;
            }
        }
        Object object = this.computeNativeSize(GTK.GTK4 ? this.handle : this.textEntryHandle, n, n2, bl);
        this.updateControl();
        return object;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (!bl && (this.isDate() || this.isTime()) && this.prefferedSize != null) {
            n3 = n != -1 ? n : this.prefferedSize.x;
            n4 = n2 != -1 ? n2 : this.prefferedSize.y;
            return new Point(n3, n4);
        }
        if (n == -1 || n2 == -1) {
            if (this.isCalendar()) {
                var6_6 = this.computeNativeSize(this.containerHandle, n, n2, bl);
                n3 = var6_6.x;
                n4 = var6_6.y;
            } else {
                var6_6 = this.computeMaxTextSize(n, n2, bl);
                Rectangle rectangle = this.computeTrimInPixels(0, 0, var6_6.x, var6_6.y);
                if (this.isDateWithDropDownButton()) {
                    Point point = this.down.computeSizeInPixels(-1, -1, bl);
                    n3 = rectangle.width + point.x;
                    n4 = Math.max(rectangle.height, point.y);
                } else if (this.isDate() || this.isTime()) {
                    n3 = rectangle.width;
                    n4 = rectangle.height;
                }
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidthInPixels();
        if (this.prefferedSize == null && this.isDateWithDropDownButton()) {
            this.prefferedSize = new Point(n3 + 2 * n5, n4 + 2 * n5);
            return this.prefferedSize;
        }
        return new Point(n3 + 2 * n5, n4 + 2 * n5);
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        if (this.isCalendar()) {
            return super.computeTrimInPixels(n, n2, n3, n4);
        }
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        GtkBorder gtkBorder = new GtkBorder();
        long l = GTK.gtk_widget_get_style_context(GTK.GTK4 ? this.editableHandle : this.textEntryHandle);
        int n7 = GTK.gtk_widget_get_state_flags(GTK.GTK4 ? this.editableHandle : this.textEntryHandle);
        this.gtk_style_context_get_padding(l, n7, gtkBorder);
        rectangle.x -= gtkBorder.left;
        rectangle.y -= gtkBorder.top;
        rectangle.width += gtkBorder.left + gtkBorder.right;
        rectangle.height += gtkBorder.top + gtkBorder.bottom;
        if ((this.style & 0x800) != 0) {
            int n8 = GTK.gtk_widget_get_state_flags(GTK.GTK4 ? this.editableHandle : this.textEntryHandle);
            this.gtk_style_context_get_border(l, n8, gtkBorder);
            rectangle.x -= gtkBorder.left;
            rectangle.y -= gtkBorder.top;
            rectangle.width += gtkBorder.left + gtkBorder.right;
            rectangle.height += gtkBorder.top + gtkBorder.bottom;
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    void createHandle(int n) {
        if (this.isCalendar()) {
            this.state |= 8;
            this.createSWTFixedHandle();
            this.createHandleForCalendar();
        } else {
            this.createSWTFixedHandle();
            if (this.isDateWithDropDownButton()) {
                this.createHandleForDateWithDropDown();
            } else {
                this.createHandleForDateTime();
            }
            GTK.gtk_editable_set_editable(this.textEntryHandle, (this.style & 8) == 0);
        }
    }

    private void createSWTFixedHandle() {
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
    }

    private void createHandleForCalendar() {
        this.handle = GTK.gtk_calendar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        this.containerHandle = this.calendarHandle = this.handle;
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
            GTK4.gtk_calendar_set_show_heading(this.handle, true);
            GTK4.gtk_calendar_set_show_day_names(this.handle, true);
            GTK4.gtk_calendar_set_show_week_numbers(this.handle, this.showWeekNumbers());
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
            int n = 3;
            if (this.showWeekNumbers()) {
                n |= 8;
            }
            GTK3.gtk_calendar_set_display_options(this.handle, n);
            GTK.gtk_widget_show(this.handle);
        }
    }

    private void createHandleForDateWithDropDown() {
        this.handle = this.gtk_box_new(0, false, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.containerHandle = this.handle;
        if (GTK.GTK4) {
            this.editableHandle = GTK.gtk_entry_new();
            if (this.editableHandle == 0L) {
                this.error(2);
            }
            this.textEntryHandle = GTK4.gtk_editable_get_delegate(this.editableHandle);
            OS.swt_fixed_add(this.fixedHandle, this.handle);
            GTK4.gtk_box_append(this.handle, this.editableHandle);
        } else {
            this.textEntryHandle = GTK.gtk_entry_new();
            if (this.textEntryHandle == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
            GTK3.gtk_container_add(this.handle, this.textEntryHandle);
            GTK.gtk_widget_show(this.containerHandle);
            GTK.gtk_widget_show(this.textEntryHandle);
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    private void createHandleForDateTime() {
        long l = GTK.gtk_adjustment_new(0.0, -9999.0, 9999.0, 1.0, 0.0, 0.0);
        if (GTK.GTK4) {
            this.editableHandle = this.handle = GTK.gtk_spin_button_new(l, 1.0, 0);
            this.containerHandle = this.textEntryHandle = GTK4.gtk_editable_get_delegate(this.editableHandle);
        } else {
            this.containerHandle = this.textEntryHandle = (this.handle = GTK.gtk_spin_button_new(l, 1.0, 0));
        }
        if (this.textEntryHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_spin_button_set_numeric(this.handle, false);
        GTK.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        GTK.gtk_widget_set_can_focus(this.down.handle, false);
        this.down.addListener(13, event -> {
            this.setFocus();
            this.dropDownCalendar(!this.isDropped());
        });
        this.popupListener = event -> {
            if (event.widget == this.popupShell) {
                this.popupShellEvent(event);
                return;
            }
            if (event.widget == this.popupCalendar) {
                this.popupCalendarEvent(event);
                return;
            }
            if (event.widget == this) {
                this.onDispose(event);
                return;
            }
            if (event.widget == this.getShell()) {
                this.getDisplay().asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.handleFocus(16);
                });
            }
        };
        this.popupFilter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
    }

    void createPopupShell(int n, int n2, int n3) {
        int n4;
        this.popupShell = new Shell(this.getShell(), 16392);
        int n5 = 1024;
        if (this.showWeekNumbers()) {
            n5 |= 0x4000;
        }
        this.popupCalendar = new DateTime(this.popupShell, n5);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.mouseEventListener = event -> {
            Control control;
            if (event.widget instanceof Control && (control = (Control)event.widget) != this.down && control.getShell() != this.popupShell) {
                this.dropDownCalendar(false);
            }
        };
        int[] nArray = new int[]{21, 4};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupShell.addListener(nArray[n4], this.popupListener);
        }
        nArray = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupCalendar.addListener(nArray[n4], this.popupListener);
        }
        this.addListener(12, this.popupListener);
        if (n != -1) {
            this.popupCalendar.setDate(n, n2, n3);
        }
    }

    @Override
    void setFontDescription(long l) {
        if (this.isDateWithDropDownButton()) {
            this.prefferedSize = null;
            this.setFontDescription(this.textEntryHandle, l);
        }
        super.setFontDescription(l);
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        if (this.isCalendar()) {
            this.getDate();
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.popupCalendar = null;
        this.down = null;
    }

    void dropDownCalendar(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.hideDropDownCalendar();
            return;
        }
        this.setCurrentDate();
        if (this.getShell() != this.popupShell.getParent()) {
            this.recreateCalendar();
        }
        Point point = this.getSizeInPixels();
        Point point2 = this.popupCalendar.computeSizeInPixels(-1, -1, false);
        this.popupCalendar.setBoundsInPixels(1, 1, Math.max(point.x - 2, point2.x), point2.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        this.focusDayOnPopupCalendar();
        Display display = this.getDisplay();
        Rectangle rectangle = display.mapInPixels(this.getParent(), null, this.getBoundsInPixels());
        Rectangle rectangle2 = DPIUtil.autoScaleUp(this.getMonitor().getClientArea());
        this.showPopupShell(point, point2, rectangle, rectangle2);
        display.addFilter(3, this.mouseEventListener);
    }

    private void showPopupShell(Point point, Point point2, Rectangle rectangle, Rectangle rectangle2) {
        int n = Math.max(point.x, point2.x + 2);
        int n2 = point2.y + 2;
        int n3 = this.calculateCalendarYpos(point, rectangle, n2, rectangle2);
        int n4 = this.calculateCalendarXpos(point2, rectangle, rectangle2, n);
        this.popupShell.setBoundsInPixels(n4, n3, n, n2);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
    }

    private int calculateCalendarYpos(Point point, Rectangle rectangle, int n, Rectangle rectangle2) {
        int n2 = this.computeNativeSize((long)this.containerHandle, (int)-1, (int)-1, (boolean)false).y;
        int n3 = rectangle.y + point.y / 2 + n2 / 2;
        if (n3 + n > rectangle2.y + rectangle2.height) {
            n3 -= n + n2;
        }
        return n3;
    }

    private int calculateCalendarXpos(Point point, Rectangle rectangle, Rectangle rectangle2, int n) {
        Integer n2 = rectangle.x;
        if (n2 + n > rectangle2.x + rectangle2.width) {
            n2 = rectangle2.x + rectangle2.width - point.x;
        }
        return n2;
    }

    private void focusDayOnPopupCalendar() {
        int n = Calendar.getInstance().get(1);
        int n2 = Calendar.getInstance().get(2);
        if (this.savedYear == n && this.savedMonth == n2) {
            int n3 = Calendar.getInstance().get(5);
            GTK.gtk_calendar_mark_day(this.popupCalendar.handle, n3);
        }
    }

    private void setCurrentDate() {
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
    }

    private void recreateCalendar() {
        int n = this.popupCalendar.getYear();
        int n2 = this.popupCalendar.getMonth();
        int n3 = this.popupCalendar.getDay();
        this.popupCalendar.removeListener(12, this.popupListener);
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
        this.createPopupShell(n, n2, n3);
    }

    private void hideDropDownCalendar() {
        this.popupShell.setVisible(false);
        GTK.gtk_calendar_clear_marks(this.popupCalendar.handle);
        this.display.removeFilter(3, this.mouseEventListener);
    }

    String getComputeSizeString(int n) {
        if ((n & 0x20) != 0) {
            return (n & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((n & 0x10000000) != 0 ? DEFAULT_LONG_DATE_FORMAT : DEFAULT_MEDIUM_DATE_FORMAT);
        }
        return (n & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((n & 0x10000000) != 0 ? DEFAULT_LONG_TIME_FORMAT : DEFAULT_MEDIUM_TIME_FORMAT);
    }

    String getFormattedString() {
        return this.dateFormat.format(this.calendar.getTime());
    }

    void getDate() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (GTK.GTK4) {
            long l = GTK4.gtk_calendar_get_date(this.calendarHandle);
            OS.g_date_time_get_ymd(l, nArray, nArray2, nArray3);
            this.year = nArray[0];
            this.month = nArray2[0] - 1;
            this.day = nArray3[0];
        } else {
            GTK3.gtk_calendar_get_date(this.calendarHandle, nArray, nArray2, nArray3);
            this.year = nArray[0];
            this.month = nArray2[0];
            this.day = nArray3[0];
        }
    }

    public int getDay() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    @Override
    String getNameText() {
        if (this.calendar == null) {
            return "";
        }
        if (this.isTime()) {
            return this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds();
        }
        return this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        if (this.isTime()) {
            return DateFormat.getTimeInstance(0).format(this.calendar.getTime());
        }
        if (this.isDate()) {
            return DateFormat.getDateInstance(0).format(this.calendar.getTime());
        }
        Calendar calendar = Calendar.getInstance();
        this.getDate();
        calendar.set(this.year, this.month, this.day);
        return DateFormat.getDateInstance(0).format(calendar.getTime());
    }

    public int getYear() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    @Override
    long gtk_day_selected(long l) {
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long gtk_day_selected_double_click(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_month_changed(long l) {
        this.sendSelectionEvent();
        return 0L;
    }

    @Override
    long eventHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long focusHandle() {
        return this.dateTimeHandle();
    }

    @Override
    long fontHandle() {
        return this.dateTimeHandle();
    }

    private long dateTimeHandle() {
        if (this.isCalendar() && this.calendarHandle != 0L) {
            return this.calendarHandle;
        }
        if (this.isDate() || this.isTime()) {
            if (this.textEntryHandle != 0L) {
                return this.textEntryHandle;
            }
            return super.focusHandle();
        }
        return super.focusHandle();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.isCalendar()) {
            this.hookEventsForCalendar();
        } else {
            if ((this.style & 4) == 0) {
                this.hookEventsForDateTimeSpinner();
            }
            if (!GTK.GTK4) {
                int n = 772;
                GTK3.gtk_widget_add_events(this.textEntryHandle, n);
                if (OS.G_OBJECT_TYPE(this.textEntryHandle) == GTK3.GTK_TYPE_MENU()) {
                    this.hookEventsForMenu();
                }
            }
        }
    }

    private final void hookEventsForCalendar() {
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected, this.display.getClosure(61), false);
        if (GTK.GTK4) {
            OS.g_signal_connect_closure(this.calendarHandle, OS.next_month, this.display.getClosure(62), false);
            OS.g_signal_connect_closure(this.calendarHandle, OS.next_year, this.display.getClosure(62), false);
            OS.g_signal_connect_closure(this.calendarHandle, OS.prev_month, this.display.getClosure(62), false);
            OS.g_signal_connect_closure(this.calendarHandle, OS.prev_year, this.display.getClosure(62), false);
        } else {
            OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected_double_click, this.display.getClosure(66), false);
            OS.g_signal_connect_closure(this.calendarHandle, OS.month_changed, this.display.getClosure(62), false);
        }
    }

    private final void hookEventsForDateTimeSpinner() {
        OS.g_signal_connect_closure(this.handle, OS.output, this.display.getClosure(36), true);
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure(this.textEntryHandle, OS.focus_in_event, this.display.getClosure(21), true);
        }
    }

    private final void hookEventsForMenu() {
        OS.g_signal_connect_closure(this.down.handle, OS.selection_done, this.display.getClosure(68), true);
    }

    void incrementField(int n) {
        if (this.currentField != null) {
            int n2 = DateTime.getCalendarField(this.currentField);
            if (n2 == 10 && this.hasAmPm()) {
                int n3 = this.calendar.getMaximum(10);
                int n4 = this.calendar.getMinimum(10);
                int n5 = this.calendar.get(10);
                if (n5 == n3 && n == 1 || n5 == n4 && n == -1) {
                    this.calendar.roll(9, n);
                }
            }
            if (n2 > -1) {
                this.calendar.roll(n2, n);
                this.updateControl();
                this.selectField(this.updateField(this.currentField));
            }
        }
    }

    private boolean hasAmPm() {
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (attributedCharacterIterator.current() != '\uffff') {
            for (AttributedCharacterIterator.Attribute attribute : attributedCharacterIterator.getAttributes().keySet()) {
                if (!DateFormat.Field.AM_PM.equals(attribute)) continue;
                return true;
            }
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return false;
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    private boolean isCalendar() {
        return (this.style & 0x400) != 0;
    }

    private boolean isDateWithDropDownButton() {
        return (this.style & 4) != 0 && (this.style & 0x20) != 0;
    }

    private boolean isDate() {
        return (this.style & 0x20) != 0;
    }

    private boolean isTime() {
        return (this.style & 0x80) != 0;
    }

    private boolean isReadOnly() {
        return (this.style & 8) != 0;
    }

    private boolean showWeekNumbers() {
        return (this.style & 0x4000) != 0;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getSpokenText();
            }

            @Override
            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = DateTime.this.isCalendar() ? 41 : 42;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            @Override
            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int n, int n2) {
        Calendar calendar = this.isCalendar() ? Calendar.getInstance() : this.calendar;
        int n3 = calendar.getActualMinimum(n);
        int n4 = calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    boolean isValidDate(int n, int n2, int n3) {
        if (n < 1752 || n > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar.get(1) == n && calendar.get(2) == n2 && calendar.get(5) == n3;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int n = this.popupCalendar.getYear();
                int n2 = this.popupCalendar.getMonth();
                int n3 = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(n, n2, n3);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                this.mdYear = this.getYear();
                this.mdMonth = this.getMonth();
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.mdYear != this.getYear() || this.mdMonth != this.getMonth()) break;
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int n = this.popupCalendar.getYear();
                int n4 = this.popupCalendar.getMonth();
                int n5 = this.popupCalendar.getDay();
                this.setDate(n, n4, n5);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
                break;
            }
        }
    }

    void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.down || control == this.popupCalendar) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(3, this.mouseEventListener);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectField(DateFormat.Field field) {
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (attributedCharacterIterator.current() != '\uffff') {
            for (AttributedCharacterIterator.Attribute attribute : attributedCharacterIterator.getAttributes().keySet()) {
                if (!attribute.equals(field)) continue;
                this.selectField(DateTime.getFieldPosition(field, attributedCharacterIterator));
                return;
            }
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
    }

    void selectField(FieldPosition fieldPosition) {
        boolean bl = DateTime.isSameField(fieldPosition, this.currentField);
        if (bl) {
            if (this.typeBufferPos > -1) {
                this.typeBufferPos = 0;
            }
        } else {
            this.typeBufferPos = -1;
            this.commitData();
            fieldPosition = this.updateField(fieldPosition);
        }
        Point point = this.getTextSelection();
        int n = fieldPosition.getBeginIndex();
        int n2 = fieldPosition.getEndIndex();
        if (bl && n == point.x && n2 == point.y) {
            return;
        }
        this.currentField = fieldPosition;
        this.display.syncExec(() -> {
            if (this.textEntryHandle != 0L) {
                String string = this.getText(this.getText(), n, n2 - 1);
                int n3 = string.lastIndexOf(32);
                n3 = n3 == -1 ? n : n + n3 + 1;
                this.setTextSelection(n3, n2);
            }
        });
        this.sendSelectionEvent(13);
    }

    void sendSelectionEvent() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (GTK.GTK4) {
            long l = GTK4.gtk_calendar_get_date(this.calendarHandle);
            OS.g_date_time_get_ymd(l, nArray, nArray2, nArray3);
        } else {
            GTK3.gtk_calendar_get_date(this.calendarHandle, nArray, nArray2, nArray3);
        }
        if (nArray3[0] != this.day || nArray2[0] != this.month || nArray[0] != this.year) {
            this.year = nArray[0];
            this.month = nArray2[0];
            this.day = nArray3[0];
            if (this.year == Calendar.getInstance().get(1) && this.month == Calendar.getInstance().get(2)) {
                GTK.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
            } else {
                GTK.gtk_calendar_clear_marks(this.calendarHandle);
            }
            this.sendSelectionEvent(13);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.bg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    @Override
    void setBackgroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setBackgroundGdkRGBA(gdkRGBA);
        if (this.calendarHandle != 0L) {
            this.setBackgroundGdkRGBA(this.calendarHandle, gdkRGBA);
        }
        super.setBackgroundGdkRGBA(gdkRGBA);
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        String string = this.display.gtk_widget_class_get_css_name(l2);
        String string2 = string + " {background: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}\n" + string + ":selected {background: " + this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_SELECTION_RGBA) + ";}";
        this.cssBackground = string2;
        String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string3);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isDateWithDropDownButton()) {
            this.down.setEnabled(bl);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.setForegroundGdkRGBA(this.containerHandle, gdkRGBA);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFieldOfInternalDataStructure(FieldPosition fieldPosition, int n) {
        int n2 = DateTime.getCalendarField(fieldPosition);
        if (this.calendar.get(n2) == n) {
            return;
        }
        if (n2 == 9 && this.hasAmPm()) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(n2, n);
        if (this.calendar.get(n2) != n) {
            this.calendar.set(n2, n);
        }
        this.sendSelectionEvent(13);
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidDate(n, n2, n3)) {
            return;
        }
        if (this.isCalendar()) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            if (GTK.GTK4) {
                long l = OS.g_date_time_new_local(n, n2 + 1, n3, 0, 0, 0.0);
                GTK4.gtk_calendar_select_day(this.calendarHandle, l);
                OS.g_date_time_unref(l);
            } else {
                GTK3.gtk_calendar_select_month(this.calendarHandle, n2, n);
                GTK3.gtk_calendar_select_day(this.calendarHandle, n3);
            }
        } else {
            this.calendar.set(n, n2, n3);
            this.updateControl();
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), n)) {
            return;
        }
        if (this.isCalendar()) {
            this.day = n;
            if (GTK.GTK4) {
                long l = OS.g_date_time_new_local(this.year, this.month + 1, n, 0, 0, 0.0);
                GTK4.gtk_calendar_select_day(this.calendarHandle, l);
            } else {
                GTK3.gtk_calendar_select_day(this.calendarHandle, n);
            }
        } else {
            this.calendar.set(5, n);
            this.updateControl();
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = n;
        } else {
            this.calendar.set(11, n);
            this.updateControl();
        }
    }

    @Override
    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.down != null) {
            this.down.setMenu(menu);
        }
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValidTime(12, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.minutes = n;
        } else {
            this.calendar.set(12, n);
            this.updateControl();
        }
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), n, this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.month = n;
            if (GTK.GTK4) {
                long l = OS.g_date_time_new_local(this.year, n + 1, this.day, 0, 0, 0.0);
                GTK4.gtk_calendar_select_day(this.calendarHandle, l);
                OS.g_date_time_unref(l);
            } else {
                GTK3.gtk_calendar_select_month(this.calendarHandle, n, this.year);
            }
        } else {
            this.calendar.set(2, n);
            this.updateControl();
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValidTime(13, n)) {
            return;
        }
        if (this.isCalendar()) {
            this.seconds = n;
        } else {
            this.calendar.set(13, n);
            this.updateControl();
        }
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (!this.isValidTime(12, n2)) {
            return;
        }
        if (!this.isValidTime(13, n3)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = n;
            this.minutes = n2;
            this.seconds = n3;
        } else {
            this.calendar.set(11, n);
            this.calendar.set(12, n2);
            this.calendar.set(13, n3);
            this.updateControl();
        }
    }

    public void setYear(int n) {
        this.checkWidget();
        if (!this.isValidDate(n, this.getMonth(), this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.year = n;
            if (GTK.GTK4) {
                long l = OS.g_date_time_new_local(n, this.month + 1, this.day, 0, 0, 0.0);
                GTK4.gtk_calendar_select_day(this.calendarHandle, l);
                OS.g_date_time_unref(l);
            } else {
                GTK3.gtk_calendar_select_month(this.calendarHandle, this.month, n);
            }
        } else {
            this.calendar.set(1, n);
            this.updateControl();
        }
    }

    @Override
    void setBoundsInPixels(int n, int n2, int n3, int n4) {
        if (this.isDateWithDropDownButton()) {
            long l = GTK.GTK4 ? this.editableHandle : this.textEntryHandle;
            GtkRequisition gtkRequisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(l, null, gtkRequisition);
            int n5 = gtkRequisition.height;
            int n6 = n3 - (this.down.getSizeInPixels().x + this.getGtkBorderPadding().right);
            GTK.gtk_widget_set_size_request(l, n6 >= 0 ? n6 : 0, n5);
        }
        super.setBoundsInPixels(n, n2, n3, n4);
    }

    private void setDropDownButtonSize() {
        Rectangle rectangle = this.getClientAreaInPixels();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.down.computeSizeInPixels(-1, n2);
        int n3 = this.computeNativeSize((long)(GTK.GTK4 ? this.editableHandle : this.textEntryHandle), (int)-1, (int)-1, (boolean)false).y;
        int n4 = n - point.x - this.getGtkBorderPadding().left - this.getGtkBorderPadding().right;
        int n5 = n2 / 2 - n3 / 2;
        this.down.setBoundsInPixels(n4, n5, point.x, n3);
    }

    GtkBorder getGtkBorderPadding() {
        GtkBorder gtkBorder = new GtkBorder();
        long l = GTK.GTK4 ? this.editableHandle : this.textEntryHandle;
        long l2 = GTK.gtk_widget_get_style_context(l);
        int n = GTK.gtk_widget_get_state_flags(l);
        this.gtk_style_context_get_padding(l2, n, gtkBorder);
        return gtkBorder;
    }

    boolean onNumberKeyInput(int n) {
        Object object;
        if (this.currentField == null) {
            return false;
        }
        int n2 = DateTime.getCalendarField(this.currentField);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        char c = attributedCharacterIterator.first();
        do {
            if (DateTime.isSameField(this.currentField, DateTime.getFieldPosition(attributedCharacterIterator))) {
                stringBuilder2.append(c);
                continue;
            }
            if (stringBuilder2.length() == 0) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder3.append(c);
        } while ((c = attributedCharacterIterator.next()) != '\uffff');
        if (this.typeBufferPos < 0) {
            this.typeBuffer.setLength(0);
            this.typeBuffer.append((CharSequence)stringBuilder2);
            this.typeBufferPos = 0;
        }
        if (n == 65288) {
            if (this.typeBufferPos > 0 && this.typeBufferPos <= this.typeBuffer.length()) {
                this.typeBuffer.deleteCharAt(this.typeBufferPos - 1);
                --this.typeBufferPos;
            }
        } else if (n == 65535) {
            if (this.typeBufferPos >= 0 && this.typeBufferPos < this.typeBuffer.length()) {
                this.typeBuffer.deleteCharAt(this.typeBufferPos);
            }
        } else {
            char c2 = this.keyToString(n);
            if ((this.style & 0x80) != 0 && n2 != 9 && !Character.isDigit(c2)) {
                return false;
            }
            if (!Character.isAlphabetic(c2) && !Character.isDigit(c2)) {
                return false;
            }
            if (n2 == 9 && this.dateFormat instanceof SimpleDateFormat) {
                object = ((SimpleDateFormat)this.dateFormat).getDateFormatSymbols().getAmPmStrings();
                if (object[0].charAt(0) == c2) {
                    this.setTextField(this.currentField, 0);
                    return false;
                }
                if (object[1].charAt(0) == c2) {
                    this.setTextField(this.currentField, 1);
                    return false;
                }
            }
            if (this.typeBufferPos < this.typeBuffer.length()) {
                this.typeBuffer.replace(this.typeBufferPos, this.typeBufferPos + 1, Character.toString(c2));
            } else {
                this.typeBuffer.append(c2);
            }
            ++this.typeBufferPos;
        }
        StringBuilder stringBuilder4 = new StringBuilder(stringBuilder);
        stringBuilder4.append((CharSequence)this.typeBuffer);
        stringBuilder4.append((CharSequence)stringBuilder3);
        this.setText(stringBuilder4.toString());
        this.setTextSelection(stringBuilder.length() + this.typeBufferPos, stringBuilder.length() + this.typeBuffer.length());
        this.currentField.setBeginIndex(stringBuilder.length());
        this.currentField.setEndIndex(stringBuilder.length() + this.typeBuffer.length());
        if (!this.isCalendar()) {
            try {
                object = this.dateFormat.parse(this.getText());
                this.calendar.setTime((Date)object);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private char keyToString(int n) {
        if (n >= 65456 && n <= 65465) {
            n -= 65408;
        }
        return (char)GDK.gdk_keyval_to_unicode(n);
    }

    void updateControl() {
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0L) {
            this.setText(this.getFormattedString());
        }
        this.redraw();
    }

    @Override
    void register() {
        super.register();
        if (this.handle != 0L && this.display.getWidget(this.handle) == null) {
            this.display.addWidget(this.handle, this);
        }
        if (this.containerHandle != 0L && this.containerHandle != this.handle) {
            this.display.addWidget(this.containerHandle, this);
        }
        if (this.textEntryHandle != 0L && this.textEntryHandle != this.containerHandle) {
            this.display.addWidget(this.textEntryHandle, this);
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.handle != 0L && this.display.getWidget(this.handle) != null) {
            this.display.removeWidget(this.handle);
        }
        if (this.containerHandle != 0L && this.containerHandle != this.handle) {
            this.display.removeWidget(this.containerHandle);
        }
        if (this.textEntryHandle != 0L && this.textEntryHandle != this.containerHandle) {
            this.display.removeWidget(this.textEntryHandle);
        }
    }

    int getArrow(long l) {
        this.updateControl();
        int n = (int)GTK.gtk_adjustment_get_value(GTK.gtk_spin_button_get_adjustment(l));
        int n2 = 0;
        if (this.isDate()) {
            FieldPosition fieldPosition = this.getNextField(null);
            int n3 = DateTime.getCalendarField(fieldPosition);
            n2 = this.calendar.get(DateTime.getCalendarField(fieldPosition));
            if (n3 == 2) {
                if ((this.style & 0x8000) != 0) {
                    --n;
                } else if ((this.style & 0x10000) != 0 || (this.style & 0x10000000) != 0) {
                    if (n == 0) {
                        return 0;
                    }
                    return n > 0 ? 0x1000001 : 0x1000002;
                }
            }
        } else if (this.isTime()) {
            n2 = this.getHours();
            if (this.hasAmPm()) {
                if (this.getHours() > 12) {
                    n2 = this.getHours() - 12;
                }
                if (n2 == 0) {
                    n2 = 12;
                }
            }
        }
        if (n == 0 && this.firstTime) {
            return 0;
        }
        this.firstTime = false;
        if (n == n2) {
            return 0;
        }
        return n > n2 ? 0x1000001 : 0x1000002;
    }

    void setText(String string) {
        if (string != null) {
            byte[] byArray = Converter.javaStringToCString(string);
            if (GTK.GTK4) {
                GTK.gtk_entry_buffer_set_text(GTK4.gtk_text_get_buffer(this.textEntryHandle), byArray, string.length());
            } else {
                GTK3.gtk_entry_set_width_chars(this.textEntryHandle, string.length());
                GTK3.gtk_entry_set_text(this.textEntryHandle, byArray);
            }
            if (this.popupCalendar != null && this.calendar != null) {
                Date date;
                try {
                    date = this.dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    return;
                }
                Calendar calendar = (Calendar)this.calendar.clone();
                calendar.setTime(date);
                try {
                    this.popupCalendar.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
                }
                catch (SWTException sWTException) {
                    if (sWTException.code == 24) {
                        return;
                    }
                    throw sWTException;
                }
            }
        }
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        if (!this.isReadOnly() && (this.isTime() || this.isDate())) {
            switch (n) {
                case 65362: 
                case 65431: {
                    this.incrementField(1);
                    break;
                }
                case 65364: 
                case 65433: {
                    this.incrementField(-1);
                    break;
                }
                case 65289: 
                case 65363: 
                case 65432: {
                    this.selectField(this.getNextField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65361: 
                case 65430: {
                    this.selectField(this.getPreviousField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65360: 
                case 65429: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMinimum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                case 65367: 
                case 65436: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMaximum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                default: {
                    this.onNumberKeyInput(n);
                }
            }
        }
        return true;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (!this.isReadOnly() && (this.isTime() || this.isDate())) {
            int[] nArray = new int[1];
            GDK.gdk_event_get_keyval(l2, nArray);
            switch (nArray[0]) {
                case 65362: 
                case 65431: {
                    this.incrementField(1);
                    this.commitData();
                    break;
                }
                case 65364: 
                case 65433: {
                    this.incrementField(-1);
                    this.commitData();
                    break;
                }
                case 65289: 
                case 65363: 
                case 65432: {
                    this.selectField(this.getNextField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65361: 
                case 65430: {
                    this.selectField(this.getPreviousField(this.currentField));
                    this.sendEvent(31);
                    break;
                }
                case 65360: 
                case 65429: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMinimum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                case 65367: 
                case 65436: {
                    if (this.currentField == null) break;
                    this.setTextField(this.currentField, this.calendar.getActualMaximum(DateTime.getCalendarField(this.currentField)));
                    break;
                }
                default: {
                    this.onNumberKeyInput(nArray[0]);
                }
            }
        }
        return 1L;
    }

    void commitData() {
        try {
            Date date = this.dateFormat.parse(this.getText());
            this.calendar.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateControl();
    }

    String getText() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(GTK4.gtk_text_get_buffer(this.textEntryHandle)) : GTK3.gtk_entry_get_text(this.textEntryHandle);
            if (l == 0L) {
                return "";
            }
            int n = C.strlen(l);
            byte[] byArray = new byte[n];
            C.memmove(byArray, l, (long)n);
            return new String(Converter.mbcsToWcs(byArray));
        }
        return "";
    }

    String getText(String string, int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    Point getTextSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_editable_get_selection_bounds(this.textEntryHandle, nArray, nArray2);
        long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(GTK4.gtk_text_get_buffer(this.textEntryHandle)) : GTK3.gtk_entry_get_text(this.textEntryHandle);
        nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
        nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
        return new Point(nArray[0], nArray2[0]);
    }

    void setTextSelection(int n, int n2) {
        this.checkWidget();
        long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(GTK4.gtk_text_get_buffer(this.textEntryHandle)) : GTK3.gtk_entry_get_text(this.textEntryHandle);
        n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
        n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
        GTK.gtk_editable_set_position(this.textEntryHandle, n);
        GTK.gtk_editable_select_region(this.textEntryHandle, n, n2);
    }

    void setTextField(FieldPosition fieldPosition, int n) {
        int n2 = this.validateValueBounds(fieldPosition, n);
        this.setFieldOfInternalDataStructure(fieldPosition, n2);
        this.setFieldOfInternalDataStructure(fieldPosition, n);
        this.updateControl();
        if (this.currentField != null) {
            this.selectField(this.currentField);
        }
    }

    private int validateValueBounds(FieldPosition fieldPosition, int n) {
        int n2 = DateTime.getCalendarField(fieldPosition);
        int n3 = this.calendar.getActualMaximum(n2);
        int n4 = this.calendar.getActualMinimum(n2);
        if (n2 == 1) {
            n3 = 9999;
            n4 = 1752;
            int n5 = Calendar.getInstance().get(1);
            int n6 = n5 / 100 * 100;
            if (n < (n5 + 30) % 100) {
                n += n6;
            } else if (n < 100) {
                n += n6 - 100;
            }
        }
        if (n > n3) {
            n = n4;
        }
        if (n < n4) {
            n = n3;
        }
        return n;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        if (this.isDate() || this.isTime()) {
            int[] nArray = new int[1];
            GDK.gdk_event_get_button(l2, nArray);
            if (nArray[0] == 1) {
                this.onTextMouseClick();
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    @Override
    void gtk_gesture_release_event(long l, int n, double d, double d2, long l2) {
        int n2;
        if ((this.isDate() || this.isTime()) && (n2 = GTK.gtk_gesture_single_get_current_button(l)) == 1) {
            this.onTextMouseClick();
        }
        super.gtk_gesture_release_event(l, n, d, d2, l2);
    }

    @Override
    long gtk_output(long l) {
        if (this.calendar == null) {
            return 0L;
        }
        int n = this.getArrow(l);
        switch (n) {
            case 0x1000001: {
                this.commitData();
                this.incrementField(1);
                break;
            }
            case 0x1000002: {
                this.commitData();
                this.incrementField(-1);
            }
        }
        return 1L;
    }

    void replaceCurrentlySelectedTextRegion(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(string, false);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_editable_get_selection_bounds(this.textEntryHandle, nArray, nArray2);
        GTK.gtk_editable_delete_selection(this.textEntryHandle);
        GTK.gtk_editable_insert_text(this.textEntryHandle, byArray, byArray.length, nArray);
        GTK.gtk_editable_set_position(this.textEntryHandle, nArray[0]);
    }

    void onTextMouseClick() {
        if (this.calendar == null) {
            return;
        }
        int n = this.getTextSelection().x;
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        attributedCharacterIterator.first();
        int n2 = 0;
        do {
            FieldPosition fieldPosition = DateTime.getFieldPosition(attributedCharacterIterator);
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            if (DateTime.isSameField(fieldPosition, this.currentField)) {
                fieldPosition = this.currentField;
            }
            int n3 = fieldPosition.getEndIndex() - fieldPosition.getBeginIndex();
            if (fieldPosition.getFieldAttribute() == null || (n2 += n3) < n) continue;
            FieldPosition fieldPosition2 = new FieldPosition(fieldPosition.getFieldAttribute());
            fieldPosition2.setBeginIndex(n2 - n3);
            fieldPosition2.setEndIndex(n2);
            this.selectField(fieldPosition2);
            break;
        } while (attributedCharacterIterator.current() != '\uffff');
    }

    String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    void selectAll() {
        this.checkWidget();
        if (this.textEntryHandle != 0L) {
            GTK.gtk_editable_select_region(this.textEntryHandle, 0, -1);
        }
    }

    void hideDateTime() {
        if (this.isDate() || this.isTime()) {
            GTK.gtk_widget_hide(this.fixedHandle);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.fixedHandle != 0L) {
            this.hideDateTime();
        }
    }

    private FieldPosition updateField(FieldPosition fieldPosition) {
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        while (attributedCharacterIterator.current() != '\uffff') {
            FieldPosition fieldPosition2 = DateTime.getFieldPosition(attributedCharacterIterator);
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            if (fieldPosition != null && !DateTime.isSameField(fieldPosition2, fieldPosition)) continue;
            return fieldPosition2;
        }
        return fieldPosition;
    }

    private FieldPosition getNextField(FieldPosition fieldPosition) {
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        FieldPosition fieldPosition2 = null;
        boolean bl = false;
        while (attributedCharacterIterator.current() != '\uffff') {
            FieldPosition fieldPosition3 = DateTime.getFieldPosition(attributedCharacterIterator);
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            if (fieldPosition3.getFieldAttribute() == null) continue;
            if (bl) {
                return fieldPosition3;
            }
            if (fieldPosition2 == null) {
                fieldPosition2 = fieldPosition3;
            }
            if (!DateTime.isSameField(fieldPosition3, fieldPosition)) continue;
            bl = true;
        }
        return fieldPosition2;
    }

    private FieldPosition getPreviousField(FieldPosition fieldPosition) {
        AttributedCharacterIterator attributedCharacterIterator = this.dateFormat.formatToCharacterIterator(this.calendar.getTime());
        FieldPosition fieldPosition2 = null;
        do {
            FieldPosition fieldPosition3;
            if (DateTime.isSameField(fieldPosition3 = DateTime.getFieldPosition(attributedCharacterIterator), fieldPosition) && fieldPosition2 != null) {
                return fieldPosition2;
            }
            if (fieldPosition3.getFieldAttribute() != null) {
                fieldPosition2 = fieldPosition3;
            }
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        } while (attributedCharacterIterator.current() != '\uffff');
        return fieldPosition2;
    }

    private static FieldPosition getFieldPosition(AttributedCharacterIterator attributedCharacterIterator) {
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAttributes().keySet();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            if (!(attribute instanceof DateFormat.Field)) continue;
            return DateTime.getFieldPosition((DateFormat.Field)attribute, attributedCharacterIterator);
        }
        return DateTime.getFieldPosition(null, attributedCharacterIterator);
    }

    private static FieldPosition getFieldPosition(DateFormat.Field field, AttributedCharacterIterator attributedCharacterIterator) {
        FieldPosition fieldPosition = new FieldPosition(field);
        fieldPosition.setBeginIndex(attributedCharacterIterator.getRunStart());
        fieldPosition.setEndIndex(attributedCharacterIterator.getRunLimit());
        return fieldPosition;
    }

    private static boolean isSameField(FieldPosition fieldPosition, FieldPosition fieldPosition2) {
        if (fieldPosition == fieldPosition2) {
            return true;
        }
        if (fieldPosition == null || fieldPosition2 == null) {
            return false;
        }
        if (fieldPosition.getFieldAttribute() == null && fieldPosition2.getFieldAttribute() == null) {
            return fieldPosition.equals(fieldPosition2);
        }
        if (fieldPosition.getFieldAttribute() == null) {
            return false;
        }
        return fieldPosition.getFieldAttribute().equals(fieldPosition2.getFieldAttribute());
    }

    private static int getCalendarField(FieldPosition fieldPosition) {
        if (fieldPosition.getFieldAttribute() instanceof DateFormat.Field) {
            return DateTime.getCalendarField((DateFormat.Field)fieldPosition.getFieldAttribute());
        }
        return -1;
    }

    private static int getCalendarField(DateFormat.Field field) {
        if (DateFormat.Field.HOUR1.equals(field)) {
            field = DateFormat.Field.HOUR0;
        } else if (DateFormat.Field.HOUR_OF_DAY1.equals(field)) {
            field = DateFormat.Field.HOUR_OF_DAY0;
        }
        return field.getCalendarField();
    }
}

