/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public long embeddedHandle;
    long imHandle;
    long socketHandle;
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    long fixClipHandle;
    Map<Control, long[]> fixClipMap = new HashMap<Control, long[]>();
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";
    Shell popupChild;
    boolean noChildDrawing = false;
    HashMap<Widget, Boolean> childrenLowered = new HashMap();

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, Composite.checkStyle(n));
        if ((n & 0x40000) != 0) {
            this.cachedNoBackground = true;
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFBFFFF;
        return n &= 0xBFFFFFFF;
    }

    Control[] _getChildren() {
        long l = this.parentingHandle();
        if (GTK.GTK4) {
            ArrayList<Control> arrayList = new ArrayList<Control>();
            long l2 = GTK4.gtk_widget_get_first_child(l);
            while (l2 != 0L) {
                Widget widget = this.display.getWidget(l2);
                if (widget != null && widget instanceof Control && widget != this) {
                    arrayList.add((Control)widget);
                }
                l2 = GTK4.gtk_widget_get_next_sibling(l2);
            }
            return arrayList.toArray(new Control[arrayList.size()]);
        }
        long l3 = GTK3.gtk_container_get_children(l);
        if (l3 == 0L) {
            return new Control[0];
        }
        int n = OS.g_list_length(l3);
        Control[] controlArray = new Control[n];
        int n2 = 0;
        long l4 = l3;
        while (l4 != 0L) {
            Widget widget;
            long l5 = OS.g_list_data(l4);
            if (l5 != 0L && (widget = this.display.getWidget(l5)) != null && widget != this && widget instanceof Control) {
                controlArray[n2++] = (Control)widget;
            }
            l4 = OS.g_list_next(l4);
        }
        OS.g_list_free(l3);
        if (n2 == n) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n2];
        System.arraycopy(controlArray, 0, controlArray2, 0, n2);
        return controlArray2;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n2 = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            controlArray[n2++] = this.tabList[i];
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    @Deprecated
    public void changed(Control[] controlArray) {
        this.layout(controlArray, 4);
    }

    @Override
    void checkBuffered() {
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            return;
        }
        super.checkBuffered();
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point;
        this.checkWidget();
        this.display.runSkin();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (this.layout != null) {
            if (n == -1 || n2 == -1) {
                point = DPIUtil.autoScaleUp(this.layout.computeSize(this, DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), bl |= (this.state & 0x40000) != 0));
                this.state &= 0xFFFBFFFF;
            } else {
                point = new Point(n, n2);
            }
        } else {
            point = this.minimumSize(n, n2, bl);
            if (point.x == 0) {
                point.x = 64;
            }
            if (point.y == 0) {
                point.y = 64;
            }
        }
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.computeTrim(0, 0, DPIUtil.autoScaleDown(point.x), DPIUtil.autoScaleDown(point.y)));
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    Widget[] computeTabList() {
        Widget[] widgetArray = super.computeTabList();
        if (widgetArray.length == 0) {
            return widgetArray;
        }
        Control[] controlArray = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            Widget[] widgetArray2 = control.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        return widgetArray;
    }

    @Override
    void createHandle(int n) {
        boolean bl;
        this.state |= 0x200000A;
        boolean bl2 = bl = (this.style & 0x300) != 0;
        if (!bl) {
            this.state |= 0x10000;
        }
        this.createHandle(n, true, bl || (this.style & 0x800) != 0);
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0x300) == 0 ? 1 : 0;
    }

    void createHandle(int n, boolean bl, boolean bl2) {
        if (bl2) {
            long l;
            long l2;
            if (bl) {
                this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
                if (this.fixedHandle == 0L) {
                    this.error(2);
                }
                if (!GTK.GTK4) {
                    GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
                }
            }
            if ((l2 = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            if ((l = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                this.scrolledHandle = GTK4.gtk_scrolled_window_new();
                GTK.gtk_scrolled_window_set_hadjustment(this.scrolledHandle, l);
                GTK.gtk_scrolled_window_set_vadjustment(this.scrolledHandle, l2);
                GTK.gtk_widget_set_hexpand(this.scrolledHandle, true);
                GTK.gtk_widget_set_vexpand(this.scrolledHandle, true);
            } else {
                this.scrolledHandle = GTK3.gtk_scrolled_window_new(l, l2);
            }
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
        }
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_widget_set_focusable(this.handle, true);
        } else {
            GTK3.gtk_widget_set_has_window(this.handle, true);
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && this.display.getData(NO_INPUT_METHOD) == null) {
            this.imHandle = GTK.gtk_im_multicontext_new();
            if (this.imHandle == 0L) {
                this.error(2);
            }
        }
        if (bl2) {
            if (bl) {
                if (GTK.GTK4) {
                    OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
                } else {
                    GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                }
            }
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
            } else {
                boolean bl3 = this.display.getWarnings();
                this.display.setWarnings(false);
                GTK3.gtk_container_add(this.scrolledHandle, this.handle);
                this.display.setWarnings(bl3);
            }
            int n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, n2, n3);
            if (this.hasBorder()) {
                if (GTK.GTK4) {
                    GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
                } else {
                    GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
                }
            }
        }
        if ((this.style & 0x1000000) != 0) {
            if (OS.isWayland()) {
                if (Device.DEBUG) {
                    new SWTError(5, "SWT.EMBEDDED is currently not yet supported in Wayland. \nPlease refer to https://bugs.eclipse.org/bugs/show_bug.cgi?id=514487 for development status.").printStackTrace();
                }
            } else if (GTK.GTK4) {
                if (Device.DEBUG) {
                    new SWTError(5, "SWT.EMBEDDED is not supported for GTK >= 4.").printStackTrace();
                }
            } else {
                this.socketHandle = GTK.gtk_socket_new();
                if (this.socketHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_container_add(this.handle, this.socketHandle);
            }
        }
        if (!GTK.GTK4) {
            if ((this.style & 0x100000) != 0 && (this.style & 0x4000000) == 0) {
                GTK3.gtk_widget_set_redraw_on_allocate(this.handle, false);
            }
            if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
                GTK3.gtk_widget_set_double_buffered(this.handle, false);
            }
        }
    }

    void fixClippings() {
        Control[] controlArray;
        if (this.fixClipHandle == 0L || this.fixClipMap.isEmpty()) {
            return;
        }
        for (Control control : controlArray = this._getChildren()) {
            long[] lArray;
            if (!this.fixClipMap.containsKey(control)) continue;
            for (long l : lArray = this.fixClipMap.get(control)) {
                control.adjustChildClipping(l);
            }
        }
    }

    @Override
    void adjustChildClipping(long l) {
        GtkRequisition gtkRequisition = new GtkRequisition();
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GtkAllocation gtkAllocation2 = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation2);
        GTK3.gtk_widget_get_clip(l, gtkAllocation);
        if (gtkAllocation.x < 0 && gtkAllocation2.x < -1 && (gtkAllocation2.width > 1 || gtkAllocation2.height > 1)) {
            gtkAllocation2.width += gtkAllocation2.x;
            gtkAllocation2.x = 0;
            GTK.gtk_widget_get_preferred_size(l, gtkRequisition, gtkRequisition2);
            this.gtk_widget_size_allocate(l, gtkAllocation2, -1);
            GTK.gtk_widget_queue_resize(l);
        }
        GTK3.gtk_widget_set_clip(l, gtkAllocation2);
    }

    @Override
    long gtk_draw(long l, long l2) {
        long l3 = GTK.gtk_widget_get_style_context(l);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        GTK.gtk_render_background(l3, l2, 0.0, 0.0, n, n2);
        if (l == this.fixClipHandle) {
            this.fixClippings();
        }
        return super.gtk_draw(l, l2);
    }

    @Override
    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.socketHandle != 0L) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        n5 = DPIUtil.autoScaleUp(n5);
        n6 = DPIUtil.autoScaleUp(n6);
        this.drawBackgroundInPixels(gC, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5, n6);
    }

    void drawBackgroundInPixels(GC gC, int n, int n2, int n3, int n4, int n5, int n6) {
        Control control;
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            GCData gCData = gC.getGCData();
            long l = gCData.cairo;
            Cairo.cairo_save(l);
            if (control.backgroundImage != null) {
                Point point = this.display.mapInPixels(this, control, 0, 0);
                Cairo.cairo_translate(l, -point.x - n5, -point.y - n6);
                n += point.x + n5;
                n2 += point.y + n6;
                long l2 = control.backgroundImage.surface;
                if (l2 == 0L) {
                    this.error(2);
                }
                Cairo.cairo_surface_reference(l2);
                long l3 = Cairo.cairo_pattern_create_for_surface(l2);
                if (l3 == 0L) {
                    this.error(2);
                }
                Cairo.cairo_pattern_set_extend(l3, 1);
                if ((gCData.style & 0x8000000) != 0) {
                    double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(l3, dArray);
                }
                Cairo.cairo_set_source(l, l3);
                Cairo.cairo_surface_destroy(l2);
                Cairo.cairo_pattern_destroy(l3);
            } else {
                GdkRGBA gdkRGBA = control.getBackgroundGdkRGBA();
                Cairo.cairo_set_source_rgba(l, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, gdkRGBA.alpha);
            }
            Cairo.cairo_rectangle(l, n, n2, n3, n4);
            Cairo.cairo_fill(l);
            Cairo.cairo_restore(l);
        } else {
            gC.fillRectangle(DPIUtil.autoScaleDown(new Rectangle(n, n2, n3, n4)));
        }
    }

    @Override
    void enableWidget(boolean bl) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(bl);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    @Override
    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control2 = controlArray[i];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length == 0) continue;
            Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
            System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
            System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
            menuArray = menuArray3;
        }
        return menuArray;
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
    }

    @Override
    void fixParentGdkResource() {
        for (Control control : this._getChildren()) {
            control.fixParentGdkResource();
        }
    }

    @Override
    void fixModal(long l, long l2) {
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].fixModal(l, l2);
        }
    }

    @Override
    void fixStyle() {
        super.fixStyle();
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].fixStyle();
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i] != control) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n2 = this.tabList.length - n;
        if (n2 != 0) {
            controlArray = new Control[n2];
            int n3 = 0;
            for (int i = 0; i < this.tabList.length; ++i) {
                if (this.tabList[i] == control) continue;
                controlArray[n3++] = this.tabList[i];
            }
        }
        this.tabList = controlArray;
    }

    void fixZOrder() {
        if ((this.state & 2) != 0) {
            return;
        }
        long l = this.parentingHandle();
        if (!GTK.GTK4) {
            long l2 = this.gtk_widget_get_window(l);
            if (l2 == 0L) {
                return;
            }
            long[] lArray = new long[1];
            long l3 = GDK.gdk_window_get_children(l2);
            if (l3 != 0L) {
                long l4 = l3;
                while (l4 != 0L) {
                    long l5 = OS.g_list_data(l4);
                    if (l5 != this.redrawWindow) {
                        GDK.gdk_window_get_user_data(l5, lArray);
                        if (lArray[0] == 0L || OS.G_OBJECT_TYPE(lArray[0]) != this.display.gtk_fixed_get_type()) {
                            GDK.gdk_window_lower(l5);
                        }
                    }
                    l4 = OS.g_list_next(l4);
                }
                OS.g_list_free(l3);
            }
        }
    }

    @Override
    long focusHandle() {
        if (this.socketHandle != 0L) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean forceFocus(long l) {
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_set_can_focus(l, true);
        }
        boolean bl = super.forceFocus(l);
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_set_can_focus(l, false);
        }
        return bl;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int n = 0;
        if (GTK.GTK4) {
            long l = GTK4.gtk_widget_get_first_child(this.handle);
            while (l != 0L) {
                ++n;
                l = GTK4.gtk_widget_get_next_sibling(l);
            }
        } else {
            long l = GTK3.gtk_container_get_children(this.handle);
            if (l != 0L) {
                n = OS.g_list_length(l);
                OS.g_list_free(l);
            }
        }
        return n;
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            if (RESIZE_ON_GETCLIENTAREA) {
                this.forceResize();
            }
            long l = this.clientHandle();
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(l, gtkAllocation);
            int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
            return new Rectangle(0, 0, n, n2);
        }
        return super.getClientAreaInPixels();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n;
            int n2 = 0;
            Control[] controlArray2 = this._getChildren();
            for (n = 0; n < controlArray2.length; ++n) {
                if (!controlArray2[n].isTabGroup()) continue;
                ++n2;
            }
            controlArray = new Control[n2];
            n = 0;
            for (int i = 0; i < controlArray2.length; ++i) {
                if (!controlArray2[i].isTabGroup()) continue;
                controlArray[n++] = controlArray2[i];
            }
        }
        return controlArray;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            int[] nArray = new int[1];
            GDK.gdk_event_get_button(l2, nArray);
            if (nArray[0] == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return l3;
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        boolean bl = super.gtk4_key_press_event(l, n, n2, n3, l2);
        if (!bl && (n3 & 2) != 0) {
            switch (n) {
                case 65293: 
                case 65421: {
                    return true;
                }
            }
        }
        return bl;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.state & 2) != 0 && this.socketHandle == 0L) {
            int[] nArray = new int[1];
            GDK.gdk_event_get_keyval(l2, nArray);
            switch (nArray[0]) {
                case 65293: 
                case 65421: {
                    return 1L;
                }
            }
        }
        return l3;
    }

    @Override
    long gtk_focus(long l, long l2) {
        if (l == this.socketHandle) {
            return 0L;
        }
        return super.gtk_focus(l, l2);
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        return (this.state & 2) != 0 ? 1L : l3;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        return (this.state & 2) != 0 ? 1L : l3;
    }

    @Override
    long gtk_map(long l) {
        this.fixZOrder();
        return 0L;
    }

    @Override
    long gtk_realize(long l) {
        long l2 = super.gtk_realize(l);
        if (this.socketHandle != 0L) {
            this.embeddedHandle = GTK.gtk_socket_get_id(this.socketHandle);
        }
        return l2;
    }

    @Override
    long gtk_scroll_child(long l, long l2, long l3) {
        OS.g_signal_stop_emission_by_name(l, OS.scroll_child);
        if (GTK.GTK4) {
            if (this.horizontalBar != null) {
                this.horizontalBar.detail = (int)l2;
            }
            if (this.verticalBar != null) {
                this.verticalBar.detail = (int)l2;
            }
        }
        return 1L;
    }

    @Override
    long gtk_style_updated(long l) {
        long l2 = super.gtk_style_updated(l);
        if ((this.style & 0x40000) != 0) {
            // empty if block
        }
        return l2;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            if (!GTK.GTK4) {
                GTK3.gtk_widget_add_events(this.handle, 8);
            }
            if (this.scrolledHandle != 0L) {
                OS.g_signal_connect_closure(this.scrolledHandle, OS.scroll_child, this.display.getClosure(42), false);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    @Override
    long imHandle() {
        return this.imHandle;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    @Override
    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    public void layout(Control[] controlArray) {
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        this.layout(controlArray, 0);
    }

    public void layout(Control[] controlArray, int n) {
        this.checkWidget();
        if (controlArray != null) {
            Control control;
            int n2;
            Composite[] compositeArray;
            int n3;
            for (n3 = 0; n3 < controlArray.length; ++n3) {
                compositeArray = controlArray[n3];
                if (compositeArray == null) {
                    this.error(5);
                }
                if (compositeArray.isDisposed()) {
                    this.error(5);
                }
                n2 = 0;
                control = compositeArray.parent;
                while (control != null) {
                    int n4 = n2 = control == this ? 1 : 0;
                    if (n2 != 0) break;
                    control = ((Composite)control).parent;
                }
                if (n2 != 0) continue;
                this.error(32);
            }
            n3 = 0;
            compositeArray = new Composite[16];
            for (n2 = 0; n2 < controlArray.length; ++n2) {
                control = controlArray[n2];
                Composite composite = control.parent;
                control.markLayout(false, false);
                while (control != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20000;
                        if (!composite.layout.flushCache(control)) {
                            composite.state |= 0x40000;
                        }
                    }
                    if (n3 == compositeArray.length) {
                        Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                        System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                        compositeArray = compositeArray2;
                    }
                    int n5 = n3++;
                    Composite composite2 = composite;
                    compositeArray[n5] = composite2;
                    control = composite2;
                    composite = control.parent;
                }
            }
            if (!this.display.externalEventLoop && (n & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                compositeArray[n2].updateLayout(false);
            }
        } else {
            if (this.layout == null && (n & 1) == 0) {
                return;
            }
            this.markLayout((n & 2) != 0, (n & 1) != 0);
            if (!this.display.externalEventLoop && (n & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((n & 1) != 0);
        }
    }

    @Override
    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x20000;
            if (bl) {
                this.state |= 0x40000;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].markLayout(bl, bl2);
            }
        }
    }

    void moveAbove(long l, long l2) {
        if (l == l2) {
            return;
        }
        long l3 = this.parentingHandle();
        OS.swt_fixed_restack(l3, l, l2, true);
    }

    void moveBelow(long l, long l2) {
        if (l == l2) {
            return;
        }
        long l3 = this.parentingHandle();
        if (l2 == 0L && l3 == this.fixedHandle) {
            this.moveAbove(l, this.scrolledHandle != 0L ? this.scrolledHandle : this.handle);
            return;
        }
        OS.swt_fixed_restack(l3, l, l2, false);
    }

    @Override
    void moveChildren(int n) {
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            int n2;
            Control control = controlArray[i];
            long l = control.topHandle();
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(l, gtkAllocation);
            int n3 = gtkAllocation.x;
            int n4 = gtkAllocation.y;
            int n5 = n2 = (control.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            if (n > 0) {
                n3 = n - n2 - n3;
            }
            int n6 = this.getClientWidth();
            n3 = n6 - n2 - n3;
            if (!GTK.GTK4 && control.enableWindow != 0L) {
                GDK.gdk_window_move(control.enableWindow, n3, n4);
            }
            control.moveHandle(n3, n4);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(l, gtkRequisition);
            gtkAllocation.x = n3;
            gtkAllocation.y = n4;
            this.gtk_widget_size_allocate(l, gtkAllocation, -1);
            Control control2 = control.findBackgroundControl();
            if (control2 == null || control2.backgroundImage == null || !control.isVisible()) continue;
            control.redrawWidget(0, 0, 0, 0, true, true, true);
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        Rectangle rectangle = DPIUtil.autoScaleUp(this.getClientArea());
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            Rectangle rectangle2 = DPIUtil.autoScaleUp(controlArray[i].getBounds());
            n3 = Math.max(n3, rectangle2.x - rectangle.x + rectangle2.width);
            n4 = Math.max(n4, rectangle2.y - rectangle.y + rectangle2.height);
        }
        return new Point(n3, n4);
    }

    long parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0L ? this.fixedHandle : this.handle;
    }

    @Override
    void printWidget(GC gC, long l, int n, int n2, int n3) {
        Region region = new Region(gC.getDevice());
        Region region2 = new Region(gC.getDevice());
        Point point = DPIUtil.autoScaleDown(new Point(n2, n3));
        gC.getClipping(region);
        Rectangle rectangle = this.getBounds();
        region2.add(region);
        region2.intersect(point.x, point.y, rectangle.width, rectangle.height);
        gC.setClipping(region2);
        super.printWidget(gC, l, n, n2, n3);
        Rectangle rectangle2 = this.getClientAreaInPixels();
        Point point2 = this.display.mapInPixels(this, this.parent, rectangle2.x, rectangle2.y);
        rectangle2.x = n2 + point2.x - rectangle.x;
        rectangle2.y = n3 + point2.y - rectangle.y;
        region2.intersect(DPIUtil.autoScaleDown(rectangle2));
        gC.setClipping(region2);
        Control[] controlArray = this._getChildren();
        for (int i = controlArray.length - 1; i >= 0; --i) {
            Control control = controlArray[i];
            if (!control.getVisible()) continue;
            Point point3 = control.getLocationInPixels();
            control.printWidget(gC, l, n, n2 + point3.x, n3 + point3.y);
        }
        gC.setClipping(region);
        region.dispose();
        region2.dispose();
    }

    void connectFixedHandleDraw() {
        long l = this.fixedHandle;
        int n = 2;
        GTK3.gtk_widget_add_events(l, n);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[18], 0, this.display.getClosure(18), true);
    }

    void propagateDraw(long l, long l2) {
        if (l == this.fixedHandle) {
            if (GTK.GTK4) {
                long l3 = GTK4.gtk_widget_get_first_child(l);
                while (l3 != 0L) {
                    l3 = GTK4.gtk_widget_get_next_sibling(l3);
                }
            } else {
                long l4;
                long l5 = l4 = GTK3.gtk_container_get_children(l);
                while (l5 != 0L) {
                    Widget widget;
                    long l6 = OS.g_list_data(l5);
                    if (l6 != 0L && (widget = this.display.getWidget(l6)) != this) {
                        if (this.noChildDrawing) {
                            Boolean bl = this.childrenLowered.get(widget);
                            if (bl == null) {
                                this.childrenLowered.put(widget, false);
                                bl = false;
                            }
                            GtkAllocation gtkAllocation = new GtkAllocation();
                            GTK.gtk_widget_get_allocation(l6, gtkAllocation);
                            if (gtkAllocation.y < 0) {
                                if (!bl.booleanValue()) {
                                    var14_10 = this.gtk_widget_get_window(l6);
                                    GDK.gdk_window_lower(var14_10);
                                    this.childrenLowered.put(widget, true);
                                }
                            } else {
                                if (bl.booleanValue()) {
                                    var14_10 = this.gtk_widget_get_window(l6);
                                    GDK.gdk_window_raise(var14_10);
                                    this.childrenLowered.put(widget, false);
                                }
                                GTK3.gtk_container_propagate_draw(l, l6, l2);
                            }
                        } else {
                            GTK3.gtk_container_propagate_draw(l, l6, l2);
                        }
                    }
                    l5 = OS.g_list_next(l5);
                }
                OS.g_list_free(l4);
            }
        }
    }

    @Override
    void redrawChildren() {
        super.redrawChildren();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if ((control.state & 0x8000) == 0) continue;
            control.redrawWidget(0, 0, 0, 0, true, false, true);
            control.redrawChildren();
        }
    }

    @Override
    void register() {
        super.register();
        if (this.socketHandle != 0L) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        try (ExceptionStash exceptionStash = new ExceptionStash();){
            for (Control control : this._getChildren()) {
                if (control == null || control.isDisposed()) continue;
                try {
                    control.release(false);
                }
                catch (Error | RuntimeException throwable) {
                    exceptionStash.stash(throwable);
                }
            }
            super.releaseChildren(bl);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0L;
        this.socketHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imHandle != 0L) {
            OS.g_object_unref(this.imHandle);
        }
        this.imHandle = 0L;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    @Override
    void reskinChildren(int n) {
        super.reskinChildren(n);
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (control == null) continue;
            control.reskin(n);
        }
    }

    @Override
    void resizeHandle(int n, int n2) {
        super.resizeHandle(n, n2);
        if (this.socketHandle != 0L) {
            OS.swt_fixed_resize(this.handle, this.socketHandle, n, n2);
        }
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].updateBackgroundMode();
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        long l = this.topHandle();
        if (this.fixedHandle != 0L && this.handle != 0L && this.getVisible() && !GTK.gtk_widget_get_visible(l) && l == this.fixedHandle && n3 > 0 && n4 > 0 && bl2) {
            GTK.gtk_widget_show(l);
        }
        if (((n5 = super.setBounds(n, n2, n3, n4, bl, bl2)) & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return n5;
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (!control.getVisible() || !control.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        this.checkWidget();
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x80000) != 0 || (this.state & 0x20000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!bl) {
            int n = 0x6000000;
            int n2 = this.style & n;
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].setOrientation(n2);
            }
            if ((this.style & 0x4000000) != 0 != ((this.style & 0x8000000) != 0)) {
                this.moveChildren(-1);
            }
        }
    }

    @Override
    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean bl2 = super.setScrollBarVisible(scrollBar, bl);
        if (bl2 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl2;
    }

    @Override
    boolean setTabGroupFocus(boolean bl) {
        boolean bl2;
        if (this.isTabItem()) {
            return this.setTabItemFocus(bl);
        }
        boolean bl3 = bl2 = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl2 = this.hooksKeys();
        }
        if (this.socketHandle != 0L) {
            bl2 = true;
        }
        if (bl2 && this.setTabItemFocus(bl)) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus(bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean setTabItemFocus(boolean bl) {
        if (!super.setTabItemFocus(bl)) {
            return false;
        }
        if (this.socketHandle != 0L) {
            int n = bl ? 0 : 1;
            GTK.gtk_widget_child_focus(this.socketHandle, n);
        }
        return true;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.socketHandle != 0L) {
            GTK.gtk_widget_show(this.socketHandle);
            this.embeddedHandle = GTK.gtk_socket_get_id(this.socketHandle);
        }
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
    }

    @Override
    boolean checkSubwindow() {
        return (this.state & 0x2000000) != 0;
    }

    @Override
    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control2 = controlArray[i];
                if (!control2.translateMnemonic(event, control)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    int traversalCode(int n, long l) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n, l);
    }

    @Override
    boolean translateTraversal(long l) {
        if (this.socketHandle != 0L) {
            return false;
        }
        return super.translateTraversal(l);
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].updateBackgroundMode();
        }
    }

    @Override
    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x80000;
            return;
        }
        if ((this.state & 0x20000) != 0) {
            boolean bl2 = (this.state & 0x40000) != 0;
            this.state &= 0xFFF9FFFF;
            this.display.runSkin();
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFF7FFFF;
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].updateLayout(bl);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [layout=" + String.valueOf(this.layout) + "]";
    }
}

