/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    long boxHandle;
    long labelHandle;
    long imageHandle;
    long arrowHandle;
    long groupHandle;
    boolean selected;
    boolean grayed;
    boolean toggleButtonTheming;
    Image image;
    String text;
    GdkRGBA background;
    Image defaultDisableImage;
    boolean enabled = true;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    GtkBorder getBorder(byte[] byArray, long l, int n) {
        GtkBorder gtkBorder = new GtkBorder();
        long[] lArray = new long[1];
        if (GTK.GTK4) {
            long l2 = GTK.gtk_widget_get_style_context(l);
            int n2 = GTK.gtk_widget_get_state_flags(l);
            this.gtk_style_context_get_border(l2, n2, gtkBorder);
            return gtkBorder;
        }
        GTK3.gtk_widget_style_get(l, byArray, lArray, 0L);
        if (lArray[0] != 0L) {
            OS.memmove(gtkBorder, lArray[0], (long)GtkBorder.sizeof);
            GTK.gtk_border_free(lArray[0]);
            return gtkBorder;
        }
        gtkBorder.left = n;
        gtkBorder.top = n;
        gtkBorder.right = n;
        gtkBorder.bottom = n;
        return gtkBorder;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point;
        int n3;
        boolean bl2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        this.forceResize();
        int[] nArray = null;
        int[] nArray2 = null;
        if ((this.style & 0x30) != 0) {
            nArray = new int[1];
            nArray2 = new int[1];
            GTK.gtk_widget_get_size_request(this.boxHandle, nArray, nArray2);
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl3 = bl2 = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (bl2) {
            Object object;
            GtkRequisition gtkRequisition;
            int n4;
            Object object2;
            n3 = this.gtk_container_get_border_width_or_margin(this.handle);
            if (!GTK.GTK4) {
                int[] nArray3 = new int[1];
                GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray3, 0L);
                object2 = new int[1];
                GTK3.gtk_widget_style_get(this.handle, OS.focus_padding, object2, 0L);
                n4 = 2 * (n3 + nArray3[0] + object2[0]);
            } else {
                n4 = 2 * n3;
            }
            int n5 = n4;
            int n6 = 0;
            if ((this.style & 0x30) != 0) {
                if (GTK.GTK4) {
                    long l = GTK4.gtk_widget_get_first_child(this.handle);
                    gtkRequisition = new GtkRequisition();
                    GTK.gtk_widget_get_preferred_size(l, gtkRequisition, null);
                    long l2 = GTK.gtk_widget_get_style_context(l);
                    object = new GtkBorder();
                    GTK4.gtk_style_context_get_margin(l2, (GtkBorder)object);
                    n4 += gtkRequisition.width + ((GtkBorder)object).right;
                } else {
                    object2 = new int[1];
                    var13_23 = new int[1];
                    GTK3.gtk_widget_style_get(this.handle, OS.indicator_size, object2, 0L);
                    GTK3.gtk_widget_style_get(this.handle, OS.indicator_spacing, var13_23, 0L);
                    n6 = object2[0] + 2 * var13_23[0];
                    n4 += n6 + var13_23[0];
                }
            } else {
                boolean bl4;
                object2 = this.getThickness(this.handle);
                n4 += object2.x * 2;
                n5 += object2.y * 2;
                var13_23 = this.getBorder(OS.inner_border, this.handle, 1);
                n4 += var13_23.left + var13_23.right;
                n5 += var13_23.top + var13_23.bottom;
                boolean bl5 = bl4 = GTK.GTK4 ? GTK4.gtk_widget_get_receives_default(this.handle) : GTK3.gtk_widget_get_can_default(this.handle);
                if (bl4) {
                    GtkBorder gtkBorder = this.getBorder(OS.default_border, this.handle, 1);
                    n4 += gtkBorder.left + gtkBorder.right;
                    n5 += gtkBorder.top + gtkBorder.bottom;
                }
            }
            int n7 = 0;
            int n8 = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                gtkRequisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, gtkRequisition);
                n7 = gtkRequisition.width;
                n8 = gtkRequisition.height;
                int[] nArray4 = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, nArray4, 0L);
                n7 += nArray4[0];
            }
            long l = GTK.gtk_label_get_layout(this.labelHandle);
            int n9 = OS.pango_layout_get_width(l);
            if (n != -1) {
                OS.pango_layout_set_width(l, Math.max(1, n - n7 - n4) * 1024);
            } else {
                OS.pango_layout_set_width(l, -1);
            }
            object = new int[1];
            int[] nArray5 = new int[1];
            OS.pango_layout_get_pixel_size(l, (int[])object, nArray5);
            OS.pango_layout_set_width(l, n9);
            point = new Point(0, 0);
            point.x = point.x + (n == -1 ? (int)(object[0] + n7 + n4) : n);
            point.y = point.y + (n2 == -1 ? Math.max(Math.max(n8, n6), nArray5[0]) + n5 : n2);
        } else {
            point = this.computeNativeSize(this.handle, n, n2, bl);
        }
        if ((this.style & 0x30) != 0) {
            GTK.gtk_widget_set_size_request(this.boxHandle, nArray[0], nArray2[0]);
        }
        if ((n != -1 || n2 != -1) && (n3 = (int)((GTK.GTK4 ? GTK4.gtk_widget_get_receives_default(this.handle) : GTK3.gtk_widget_get_can_default(this.handle)) ? 1 : 0)) != 0) {
            GtkBorder gtkBorder = this.getBorder(OS.default_border, this.handle, 1);
            if (n != -1) {
                point.x += gtkBorder.left + gtkBorder.right;
            }
            if (n2 != -1) {
                point.y += gtkBorder.top + gtkBorder.bottom;
            }
        }
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int n2 = 62;
        switch (this.style & n2) {
            case 4: {
                byte[] byArray = GTK.GTK_NAMED_ICON_GO_UP;
                if ((this.style & 0x80) != 0) {
                    byArray = GTK.GTK_NAMED_ICON_GO_UP;
                }
                if ((this.style & 0x400) != 0) {
                    byArray = GTK.GTK_NAMED_ICON_GO_DOWN;
                }
                if ((this.style & 0x4000) != 0) {
                    byArray = GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                }
                if ((this.style & 0x20000) != 0) {
                    byArray = GTK.GTK_NAMED_ICON_GO_NEXT;
                }
                if (GTK.GTK4) {
                    this.handle = GTK4.gtk_button_new_from_icon_name(byArray);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.arrowHandle = GTK4.gtk_widget_get_first_child(this.handle);
                    if (this.arrowHandle != 0L) break;
                    this.error(2);
                    break;
                }
                this.arrowHandle = GTK3.gtk_image_new_from_icon_name(byArray, 1);
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                this.handle = GTK.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_button_set_image(this.handle, this.arrowHandle);
                break;
            }
            case 2: {
                this.handle = GTK.gtk_toggle_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            case 32: {
                this.handle = GTK.gtk_check_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            case 16: {
                if (GTK.GTK4) {
                    this.groupHandle = GTK.gtk_check_button_new();
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    this.handle = GTK.gtk_check_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_check_button_set_group(this.handle, this.groupHandle);
                } else {
                    this.groupHandle = GTK3.gtk_radio_button_new(0L);
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    this.handle = GTK3.gtk_radio_button_new(GTK3.gtk_radio_button_get_group(this.groupHandle));
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                }
                if (Display.themeName == null) break;
                this.toggleButtonTheming = GTK.GTK_VERSION >= OS.VERSION(3, 24, 11) && Display.themeName.contains("Adwaita") || Display.themeName.contains("Yaru");
                break;
            }
            default: {
                this.handle = GTK.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                if (GTK.GTK4) break;
                GTK3.gtk_widget_set_can_default(this.handle, true);
            }
        }
        if ((this.style & 4) == 0) {
            this.boxHandle = this.gtk_box_new(0, false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                this.imageHandle = GTK4.gtk_picture_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_widget_set_parent(this.boxHandle, this.handle);
                GTK4.gtk_box_append(this.boxHandle, this.imageHandle);
                GTK4.gtk_box_append(this.boxHandle, this.labelHandle);
            } else {
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_container_add(this.handle, this.boxHandle);
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK3.gtk_container_add(this.boxHandle, this.labelHandle);
            }
            if ((this.style & 0x40) != 0) {
                if (GTK.GTK4) {
                    GTK4.gtk_label_set_wrap(this.labelHandle, true);
                    GTK4.gtk_label_set_wrap_mode(this.labelHandle, 2);
                } else {
                    GTK3.gtk_label_set_line_wrap(this.labelHandle, true);
                    GTK3.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
                }
            }
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.setFontDescription(this.defaultFont().handle);
        this._setAlignment(this.style & 0x1024000);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    @Override
    void checkBackground() {
        if (this.toggleButtonTheming && (this.style & 0x30) != 0) {
            this.state &= 0xFFFF7FFF;
        } else {
            super.checkBackground();
        }
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.boxHandle != 0L) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    long fontHandle() {
        if (this.labelHandle != 0L) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            return GTK4.gtk_check_button_get_active(this.handle);
        }
        return GTK.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return l3;
    }

    @Override
    long gtk_clicked(long l) {
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0) {
            if (GTK.GTK4) {
                boolean bl = this.grayed && GTK4.gtk_check_button_get_active(this.handle);
                GTK4.gtk_check_button_set_inconsistent(this.handle, bl);
            } else {
                boolean bl = this.grayed && GTK.gtk_toggle_button_get_active(this.handle);
                GTK3.gtk_toggle_button_set_inconsistent(this.handle, bl);
            }
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_draw(long l, long l2) {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            if (GTK.gtk_widget_get_visible(l)) {
                GTK.gtk_widget_set_visible(l, false);
            }
            if (this.isDisposed() || this.display == null || this.display.isDisposed()) {
                this.error(45);
            }
        }
        return super.gtk_draw(l, l2);
    }

    @Override
    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0 && GTK.gtk_widget_has_default(this.handle)) {
            Decorations decorations = this.menuShell();
            decorations.defaultButton = this;
        }
        return l3;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0) {
            Decorations decorations = this.menuShell();
            if (decorations.defaultButton == this) {
                decorations.defaultButton = null;
            }
        }
        return l3;
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        boolean bl = super.gtk4_key_press_event(l, n, n2, n3, l2);
        if (!bl && (this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return bl;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return l3;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.toggled, this.display.getClosure(8), false);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0L) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0L) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0L;
        this.labelHandle = 0L;
        this.imageHandle = 0L;
        this.boxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (GTK.GTK4 && this.boxHandle != 0L) {
            GTK.gtk_widget_unparent(this.boxHandle);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.image = null;
        this.text = null;
        this.disposeDefaultDisabledImage();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void resizeHandle(int n, int n2) {
        if ((this.style & 0x30) != 0 && (this.style & 0x40) == 0) {
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.topHandle()), this.topHandle(), n, n2);
        } else {
            super.resizeHandle(n, n2);
        }
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (this == control) continue;
            control.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this._setAlignment(n);
    }

    void _setAlignment(int n) {
        boolean bl;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            boolean bl2 = (this.style & 0x4000000) != 0;
            byte[] byArray = GTK.GTK_NAMED_ICON_GO_UP;
            switch (n) {
                case 128: {
                    byArray = GTK.GTK_NAMED_ICON_GO_UP;
                    break;
                }
                case 1024: {
                    byArray = GTK.GTK_NAMED_ICON_GO_DOWN;
                    break;
                }
                case 16384: {
                    byArray = bl2 ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                    break;
                }
                case 131072: {
                    byte[] byArray2 = byArray = bl2 ? GTK.GTK_NAMED_ICON_GO_PREVIOUS : GTK.GTK_NAMED_ICON_GO_NEXT;
                }
            }
            if (GTK.GTK4) {
                GTK4.gtk_image_set_from_icon_name(this.arrowHandle, byArray);
            } else {
                GTK3.gtk_image_set_from_icon_name(this.arrowHandle, byArray, 1);
            }
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        boolean bl3 = bl = GTK.gtk_widget_get_visible(this.labelHandle) && GTK.gtk_widget_get_visible(this.imageHandle);
        if (bl) {
            if ((this.style & 0x30) != 0) {
                n = 16384;
            }
            if ((this.style & 0xA) != 0) {
                n = 0x1000000;
            }
        }
        if ((n & 0x4000) != 0) {
            if (bl) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
            this.gtk_widget_set_align(this.imageHandle, 1, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((n & 0x1000000) != 0) {
            if (bl) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                this.gtk_label_set_align(this.labelHandle, 0.5f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 3, 3);
                GTK.gtk_label_set_justify(this.labelHandle, 2);
            }
            return;
        }
        if ((n & 0x20000) != 0) {
            if (bl) {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            } else {
                this.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                this.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            this.gtk_label_set_align(this.labelHandle, 1.0f, 0.5f);
            this.gtk_widget_set_align(this.imageHandle, 2, 3);
            GTK.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA;
        Object object = "* {background : ";
        String string = this.display.gtk_rgba_to_css_string(gdkRGBA);
        object = (String)object + string + ";}";
        if (gdkRGBA == null && this.toggleButtonTheming) {
            super.setBackgroundGdkRGBA(l, l2, gdkRGBA);
            return;
        }
        this.cssBackground = object;
        String string2 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string2);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.labelHandle != 0L && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (bl3) {
            GTK.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            Object object;
            GtkRequisition gtkRequisition;
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.boxHandle, gtkAllocation);
            int n6 = gtkAllocation.width;
            int n7 = gtkAllocation.height;
            long l = GTK.gtk_label_get_layout(this.labelHandle);
            int n8 = OS.pango_layout_get_width(l);
            OS.pango_layout_set_width(l, -1);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.pango_layout_get_pixel_size(l, nArray, nArray2);
            OS.pango_layout_set_width(l, n8);
            int n9 = 0;
            if (GTK.gtk_widget_get_visible(this.imageHandle)) {
                gtkRequisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, gtkRequisition);
                n9 = gtkRequisition.width;
                object = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, object, 0L);
                n9 += object[0];
            }
            GTK.gtk_widget_set_size_request(this.labelHandle, Math.min(nArray[0], n6 - n9), -1);
            gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.boxHandle, gtkRequisition);
            gtkAllocation.width = n6;
            gtkAllocation.height = n7;
            object = this.resizeCalculationsGTK3(this.boxHandle, n6, n7);
            gtkAllocation.width = object.x;
            gtkAllocation.height = object.y;
            this.gtk_widget_size_allocate(this.boxHandle, gtkAllocation, -1);
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        if (this.text != null && this.text.isEmpty() || this.text == null) {
            return;
        }
        super.setFontDescription(l);
        if (GTK.GTK4) {
            if (this.labelHandle != 0L) {
                this.setFontDescription(this.labelHandle, l);
            }
        } else {
            boolean bl = this.getSelection();
            if (bl) {
                this.setSelection(!bl);
            }
            if (this.labelHandle != 0L) {
                this.setFontDescription(this.labelHandle, l);
            }
            this.setSelection(bl);
        }
    }

    @Override
    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        this.setForegroundGdkRGBA(this.fixedHandle, gdkRGBA);
        if (this.labelHandle != 0L) {
            this.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundGdkRGBA(this.imageHandle, gdkRGBA);
        }
    }

    @Override
    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        String string;
        String string2;
        long l2 = GTK.gtk_widget_get_style_context(l);
        GdkRGBA gdkRGBA2 = gdkRGBA == null ? this.display.COLOR_WIDGET_FOREGROUND_RGBA : gdkRGBA;
        String string3 = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        int n = 48;
        switch (this.style & n) {
            case 32: {
                string2 = "checkbutton {color: " + string3 + ";}";
                if (this.toggleButtonTheming) {
                    GdkRGBA gdkRGBA3 = gdkRGBA == null ? this.display.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA : gdkRGBA;
                    string = this.display.gtk_rgba_to_css_string(gdkRGBA3);
                } else {
                    string = this.display.gtk_rgba_to_css_string(gdkRGBA2);
                }
                string2 = string2 + " check {color: " + string + ";}";
                break;
            }
            case 16: {
                String string4;
                string2 = "radiobutton {color: " + string3 + ";}";
                if (this.toggleButtonTheming) {
                    GdkRGBA gdkRGBA4 = gdkRGBA == null ? this.display.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA : gdkRGBA;
                    string4 = this.display.gtk_rgba_to_css_string(gdkRGBA4);
                } else {
                    string4 = this.display.gtk_rgba_to_css_string(gdkRGBA2);
                }
                string2 = string2 + " radio {color: " + string4 + ";}";
                break;
            }
            default: {
                string2 = "button {color: " + string3 + ";}";
            }
        }
        this.cssForeground = string2;
        string = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(l2, string);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
        if (GTK.GTK4) {
            boolean bl2 = bl && GTK4.gtk_check_button_get_active(this.handle);
            GTK4.gtk_check_button_set_inconsistent(this.handle, bl2);
        } else {
            boolean bl3 = bl && GTK.gtk_toggle_button_get_active(this.handle);
            GTK3.gtk_toggle_button_set_inconsistent(this.handle, bl3);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.disposeDefaultDisabledImage();
        if (!this.enabled && this.defaultDisableImage != image && this.defaultDisableImage != null) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    private void _setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (GTK.GTK4) {
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_picture_set_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, image.surface);
            }
        } else if (GTK.GTK4) {
            GTK4.gtk_picture_set_paintable(this.imageHandle, 0L);
        } else {
            GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
        }
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.boxHandle != 0L) {
                GTK.gtk_widget_set_direction(this.boxHandle, n);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_set_direction(this.imageHandle, n);
            }
            if (this.arrowHandle != 0L && (this.style & 0x24000) != 0) {
                byte[] byArray;
                byte[] byArray2 = byArray = (this.style & 0x4000000) != 0 ? GTK.GTK_NAMED_ICON_GO_NEXT : GTK.GTK_NAMED_ICON_GO_PREVIOUS;
                if (GTK.GTK4) {
                    GTK4.gtk_image_set_from_icon_name(this.arrowHandle, byArray);
                } else {
                    GTK3.gtk_image_set_from_icon_name(this.arrowHandle, byArray, 1);
                }
            }
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        if (GTK.GTK4 && (this.style & 0x30) != 0) {
            GTK4.gtk_check_button_set_active(this.handle, bl);
        } else {
            GTK.gtk_toggle_button_set_active(this.handle, bl);
        }
        if ((this.style & 0x20) != 0) {
            boolean bl2;
            boolean bl3 = bl2 = bl && this.grayed;
            if (GTK.GTK4) {
                GTK4.gtk_check_button_set_inconsistent(this.handle, bl2);
            } else {
                GTK3.gtk_toggle_button_set_inconsistent(this.handle, bl2);
            }
        }
        if ((this.style & 0x10) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_check_button_set_active(this.groupHandle, !bl);
            } else {
                GTK.gtk_toggle_button_set_active(this.groupHandle, !bl);
            }
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
        this.setFontDescription(this.font == null ? this.defaultFont().handle : this.font.handle);
    }

    private void updateWidgetsVisibility() {
        if (this.text.length() == 0 && this.image == null) {
            GTK.gtk_widget_hide(this.boxHandle);
            GTK.gtk_widget_hide(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        } else {
            GTK.gtk_widget_show(this.boxHandle);
            if (this.text.length() == 0) {
                GTK.gtk_widget_hide(this.labelHandle);
            } else {
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.image == null) {
                GTK.gtk_widget_hide(this.imageHandle);
            } else {
                GTK.gtk_widget_show(this.imageHandle);
            }
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0L && (this.text != null && this.text.length() != 0 || this.image != null)) {
            GTK.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0L && this.text != null && this.text.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0L) {
            GTK.gtk_widget_show(this.arrowHandle);
        }
    }

    @Override
    int traversalCode(int n, long l) {
        int n2 = super.traversalCode(n, l);
        if ((this.style & 4) != 0) {
            n2 &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            n2 |= 0x60;
        }
        return n2;
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 18: {
                if (this.paintHandle() != l) break;
                return this.gtk_draw(l, l2);
            }
        }
        return super.windowProc(l, l2, l3);
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        super.setEnabled(bl);
        if (!bl) {
            if (this.defaultDisableImage == null && this.image != null) {
                this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
            }
            this._setImage(this.defaultDisableImage);
        }
        if (bl && this.image != null) {
            this._setImage(this.image);
        }
    }

    private void disposeDefaultDisabledImage() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }
}

