/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int n, boolean bl) {
        this.numColumns = n;
        this.makeColumnsEqualWidth = bl;
    }

    @Override
    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = this.layout(composite, false, 0, 0, n, n2, bl);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((GridData)object).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] controlArray, int n, int n2, int n3, int n4, boolean bl) {
        Control control = controlArray[n][n2];
        if (control != null) {
            int n5;
            GridData gridData = (GridData)control.getLayoutData();
            int n6 = Math.max(1, Math.min(gridData.horizontalSpan, n4));
            int n7 = Math.max(1, gridData.verticalSpan);
            int n8 = bl ? n + n7 - 1 : n - n7 + 1;
            int n9 = n5 = bl ? n2 + n6 - 1 : n2 - n6 + 1;
            if (0 <= n8 && n8 < n3 && 0 <= n5 && n5 < n4 && control == controlArray[n8][n5]) {
                return gridData;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    Point layout(Composite composite, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        Object object;
        int n23;
        Control[][] controlArray;
        int n24;
        GridData gridData;
        Control control;
        int n25;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] controlArray2 = composite.getChildren();
        int n26 = 0;
        for (n25 = 0; n25 < controlArray2.length; ++n25) {
            control = controlArray2[n25];
            gridData = (GridData)control.getLayoutData();
            if (gridData != null && gridData.exclude) continue;
            controlArray2[n26++] = controlArray2[n25];
        }
        if (n26 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        for (n25 = 0; n25 < n26; ++n25) {
            control = controlArray2[n25];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData(gridData);
            }
            if (bl2) {
                gridData.flushCache();
            }
            gridData.computeSize(control, gridData.widthHint, gridData.heightHint, bl2);
            if (gridData.grabExcessHorizontalSpace && gridData.minimumWidth > 0 && gridData.cacheWidth < gridData.minimumWidth) {
                n24 = 0;
                if (control instanceof Scrollable) {
                    controlArray = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                    n24 = controlArray.width;
                } else {
                    n24 = control.getBorderWidth() * 2;
                }
                gridData.cacheHeight = -1;
                gridData.cacheWidth = -1;
                gridData.computeSize(control, Math.max(0, gridData.minimumWidth - n24), gridData.heightHint, false);
            }
            if (!gridData.grabExcessVerticalSpace || gridData.minimumHeight <= 0) continue;
            gridData.cacheHeight = Math.max(gridData.cacheHeight, gridData.minimumHeight);
        }
        n25 = 0;
        int n27 = 0;
        int n28 = 0;
        n24 = this.numColumns;
        controlArray = new Control[4][n24];
        for (n23 = 0; n23 < n26; ++n23) {
            Control control2 = controlArray2[n23];
            object = (GridData)control2.getLayoutData();
            int n29 = Math.max(1, Math.min(((GridData)object).horizontalSpan, n24));
            int n30 = Math.max(1, ((GridData)object).verticalSpan);
            while (true) {
                if ((n22 = n25 + n30) >= controlArray.length) {
                    Control[][] controlArray3 = new Control[n22 + 4][n24];
                    System.arraycopy(controlArray, 0, controlArray3, 0, controlArray.length);
                    controlArray = controlArray3;
                }
                if (controlArray[n25] == null) {
                    controlArray[n25] = new Control[n24];
                }
                while (n27 < n24 && controlArray[n25][n27] != null) {
                    ++n27;
                }
                n21 = n27 + n29;
                if (n21 <= n24) {
                    int n31;
                    for (n31 = n27; n31 < n21 && controlArray[n25][n31] == null; ++n31) {
                    }
                    if (n31 == n21) break;
                    n27 = n31;
                }
                if (n27 + n29 < n24) continue;
                n27 = 0;
                ++n25;
            }
            for (n22 = 0; n22 < n30; ++n22) {
                if (controlArray[n25 + n22] == null) {
                    controlArray[n25 + n22] = new Control[n24];
                }
                for (n21 = 0; n21 < n29; ++n21) {
                    controlArray[n25 + n22][n27 + n21] = control2;
                }
            }
            n28 = Math.max(n28, n25 + n30);
            n27 += n29;
        }
        n23 = n3 - this.horizontalSpacing * (n24 - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int n32 = 0;
        object = new int[n24];
        int[] nArray = new int[n24];
        boolean[] blArray = new boolean[n24];
        for (n22 = 0; n22 < n24; ++n22) {
            GridData gridData2;
            for (n21 = 0; n21 < n28; ++n21) {
                gridData2 = this.getData(controlArray, n21, n22, n28, n24, true);
                if (gridData2 == null || (n20 = Math.max(1, Math.min(gridData2.horizontalSpan, n24))) != 1) continue;
                n19 = gridData2.cacheWidth + gridData2.horizontalIndent;
                object[n22] = Math.max((int)object[n22], n19);
                if (gridData2.grabExcessHorizontalSpace) {
                    if (!blArray[n22]) {
                        ++n32;
                    }
                    blArray[n22] = true;
                }
                if (gridData2.grabExcessHorizontalSpace && gridData2.minimumWidth == 0) continue;
                n19 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                nArray[n22] = Math.max(nArray[n22], n19 += gridData2.horizontalIndent);
            }
            for (n21 = 0; n21 < n28; ++n21) {
                int n33;
                gridData2 = this.getData(controlArray, n21, n22, n28, n24, false);
                if (gridData2 == null || (n20 = Math.max(1, Math.min(gridData2.horizontalSpan, n24))) <= 1) continue;
                n19 = 0;
                n18 = 0;
                n17 = 0;
                for (n33 = 0; n33 < n20; ++n33) {
                    n19 += object[n22 - n33];
                    n18 += nArray[n22 - n33];
                    if (!blArray[n22 - n33]) continue;
                    ++n17;
                }
                if (gridData2.grabExcessHorizontalSpace && n17 == 0) {
                    ++n32;
                    blArray[n22] = true;
                }
                if ((n33 = gridData2.cacheWidth + gridData2.horizontalIndent - n19 - (n20 - 1) * this.horizontalSpacing) > 0) {
                    if (this.makeColumnsEqualWidth) {
                        n16 = (n33 + n19) / n20;
                        n15 = (n33 + n19) % n20;
                        n14 = -1;
                        for (n13 = 0; n13 < n20; ++n13) {
                            n14 = n22 - n13;
                            object[n14] = Math.max(n16, (int)object[n22 - n13]);
                        }
                        if (n14 > -1) {
                            Object object2 = object;
                            int n34 = n14;
                            object2[n34] = object2[n34] + n15;
                        }
                    } else if (n17 == 0) {
                        Object object3 = object;
                        int n35 = n22;
                        object3[n35] = object3[n35] + n33;
                    } else {
                        n16 = n33 / n17;
                        n15 = n33 % n17;
                        n14 = -1;
                        for (n13 = 0; n13 < n20; ++n13) {
                            if (!blArray[n22 - n13]) continue;
                            Object object4 = object;
                            n14 = n22 - n13;
                            object4[n14] = object4[n14] + n16;
                        }
                        if (n14 > -1) {
                            Object object5 = object;
                            int n36 = n14;
                            object5[n36] = object5[n36] + n15;
                        }
                    }
                }
                if (gridData2.grabExcessHorizontalSpace && gridData2.minimumWidth == 0) continue;
                int n37 = n33 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                if ((n33 += gridData2.horizontalIndent - n18 - (n20 - 1) * this.horizontalSpacing) <= 0) continue;
                if (n17 == 0) {
                    int n38 = n22;
                    nArray[n38] = nArray[n38] + n33;
                    continue;
                }
                n16 = n33 / n17;
                n15 = n33 % n17;
                n14 = -1;
                for (n13 = 0; n13 < n20; ++n13) {
                    if (!blArray[n22 - n13]) continue;
                    n14 = n22 - n13;
                    nArray[n14] = nArray[n14] + n16;
                }
                if (n14 <= -1) continue;
                int n39 = n14;
                nArray[n39] = nArray[n39] + n15;
            }
        }
        if (this.makeColumnsEqualWidth) {
            int n40;
            n22 = 0;
            n21 = 0;
            for (n40 = 0; n40 < n24; ++n40) {
                n22 = Math.max(n22, nArray[n40]);
                n21 = Math.max(n21, (int)object[n40]);
            }
            n21 = n3 == -1 || n32 == 0 ? n21 : Math.max(n22, n23 / n24);
            for (n40 = 0; n40 < n24; ++n40) {
                blArray[n40] = n32 > 0;
                object[n40] = n21;
            }
        } else if (n3 != -1 && n32 > 0) {
            n22 = 0;
            for (n21 = 0; n21 < n24; ++n21) {
                n22 += object[n21];
            }
            n21 = n32;
            int n41 = (n23 - n22) / n21;
            n20 = (n23 - n22) % n21;
            n19 = -1;
            while (n22 != n23) {
                for (n18 = 0; n18 < n24; ++n18) {
                    if (!blArray[n18]) continue;
                    if (object[n18] + n41 > nArray[n18]) {
                        n19 = n18;
                        object[n19] = object[n18] + n41;
                        continue;
                    }
                    object[n18] = nArray[n18];
                    blArray[n18] = false;
                    --n21;
                }
                if (n19 > -1) {
                    Object object6 = object;
                    int n42 = n19;
                    object6[n42] = object6[n42] + n20;
                }
                for (n18 = 0; n18 < n24; ++n18) {
                    for (n17 = 0; n17 < n28; ++n17) {
                        GridData gridData3 = this.getData(controlArray, n17, n18, n28, n24, false);
                        if (gridData3 == null || (n16 = Math.max(1, Math.min(gridData3.horizontalSpan, n24))) <= 1 || gridData3.grabExcessHorizontalSpace && gridData3.minimumWidth == 0) continue;
                        n15 = 0;
                        n14 = 0;
                        for (n13 = 0; n13 < n16; ++n13) {
                            n15 += object[n18 - n13];
                            if (!blArray[n18 - n13]) continue;
                            ++n14;
                        }
                        int n43 = n13 = !gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth == -1 ? gridData3.cacheWidth : gridData3.minimumWidth;
                        if ((n13 += gridData3.horizontalIndent - n15 - (n16 - 1) * this.horizontalSpacing) <= 0) continue;
                        if (n14 == 0) {
                            Object object7 = object;
                            int n44 = n18;
                            object7[n44] = object7[n44] + n13;
                            continue;
                        }
                        n12 = n13 / n14;
                        n11 = n13 % n14;
                        n10 = -1;
                        for (n9 = 0; n9 < n16; ++n9) {
                            if (!blArray[n18 - n9]) continue;
                            Object object8 = object;
                            n10 = n18 - n9;
                            object8[n10] = object8[n10] + n12;
                        }
                        if (n10 <= -1) continue;
                        Object object9 = object;
                        int n45 = n10;
                        object9[n45] = object9[n45] + n11;
                    }
                }
                if (n21 != 0) {
                    n22 = 0;
                    for (n18 = 0; n18 < n24; ++n18) {
                        n22 += object[n18];
                    }
                    n41 = (n23 - n22) / n21;
                    n20 = (n23 - n22) % n21;
                    n19 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] gridDataArray = null;
        n21 = 0;
        if (n3 != -1) {
            for (int i = 0; i < n24; ++i) {
                for (n20 = 0; n20 < n28; ++n20) {
                    GridData gridData4 = this.getData(controlArray, n20, i, n28, n24, false);
                    if (gridData4 == null || gridData4.heightHint != -1) continue;
                    Control control3 = controlArray[n20][i];
                    n17 = Math.max(1, Math.min(gridData4.horizontalSpan, n24));
                    int n46 = 0;
                    for (n16 = 0; n16 < n17; ++n16) {
                        n46 += object[i - n16];
                    }
                    if (((n46 += (n17 - 1) * this.horizontalSpacing - gridData4.horizontalIndent) == gridData4.cacheWidth || gridData4.horizontalAlignment != 4) && gridData4.cacheWidth <= n46) continue;
                    n16 = 0;
                    if (control3 instanceof Scrollable) {
                        Rectangle rectangle = ((Scrollable)control3).computeTrim(0, 0, 0, 0);
                        n16 = rectangle.width;
                    } else {
                        n16 = control3.getBorderWidth() * 2;
                    }
                    gridData4.cacheHeight = -1;
                    gridData4.cacheWidth = -1;
                    gridData4.computeSize(control3, Math.max(0, n46 - n16), gridData4.heightHint, false);
                    if (gridData4.grabExcessVerticalSpace && gridData4.minimumHeight > 0) {
                        gridData4.cacheHeight = Math.max(gridData4.cacheHeight, gridData4.minimumHeight);
                    }
                    if (gridDataArray == null) {
                        gridDataArray = new GridData[n26];
                    }
                    gridDataArray[n21++] = gridData4;
                }
            }
        }
        int n47 = n4 - this.verticalSpacing * (n28 - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        n32 = 0;
        int[] nArray2 = new int[n28];
        int[] nArray3 = new int[n28];
        boolean[] blArray2 = new boolean[n28];
        for (n17 = 0; n17 < n28; ++n17) {
            int n48;
            GridData gridData5;
            int n49;
            for (n49 = 0; n49 < n24; ++n49) {
                gridData5 = this.getData(controlArray, n17, n49, n28, n24, true);
                if (gridData5 == null || (n48 = Math.max(1, Math.min(gridData5.verticalSpan, n28))) != 1) continue;
                n14 = gridData5.cacheHeight + gridData5.verticalIndent;
                nArray2[n17] = Math.max(nArray2[n17], n14);
                if (gridData5.grabExcessVerticalSpace) {
                    if (!blArray2[n17]) {
                        ++n32;
                    }
                    blArray2[n17] = true;
                }
                if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight == 0) continue;
                n14 = !gridData5.grabExcessVerticalSpace || gridData5.minimumHeight == -1 ? gridData5.cacheHeight : gridData5.minimumHeight;
                nArray3[n17] = Math.max(nArray3[n17], n14 += gridData5.verticalIndent);
            }
            for (n49 = 0; n49 < n24; ++n49) {
                gridData5 = this.getData(controlArray, n17, n49, n28, n24, false);
                if (gridData5 == null || (n48 = Math.max(1, Math.min(gridData5.verticalSpan, n28))) <= 1) continue;
                n14 = 0;
                n13 = 0;
                n12 = 0;
                for (n11 = 0; n11 < n48; ++n11) {
                    n14 += nArray2[n17 - n11];
                    n13 += nArray3[n17 - n11];
                    if (!blArray2[n17 - n11]) continue;
                    ++n12;
                }
                if (gridData5.grabExcessVerticalSpace && n12 == 0) {
                    ++n32;
                    blArray2[n17] = true;
                }
                if ((n11 = gridData5.cacheHeight + gridData5.verticalIndent - n14 - (n48 - 1) * this.verticalSpacing) > 0) {
                    if (n12 == 0) {
                        int n50 = n17;
                        nArray2[n50] = nArray2[n50] + n11;
                    } else {
                        n10 = n11 / n12;
                        n9 = n11 % n12;
                        n8 = -1;
                        for (n7 = 0; n7 < n48; ++n7) {
                            if (!blArray2[n17 - n7]) continue;
                            n8 = n17 - n7;
                            nArray2[n8] = nArray2[n8] + n10;
                        }
                        if (n8 > -1) {
                            int n51 = n8;
                            nArray2[n51] = nArray2[n51] + n9;
                        }
                    }
                }
                if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight == 0) continue;
                int n52 = n11 = !gridData5.grabExcessVerticalSpace || gridData5.minimumHeight == -1 ? gridData5.cacheHeight : gridData5.minimumHeight;
                if ((n11 += gridData5.verticalIndent - n13 - (n48 - 1) * this.verticalSpacing) <= 0) continue;
                if (n12 == 0) {
                    int n53 = n17;
                    nArray3[n53] = nArray3[n53] + n11;
                    continue;
                }
                n10 = n11 / n12;
                n9 = n11 % n12;
                n8 = -1;
                for (n7 = 0; n7 < n48; ++n7) {
                    if (!blArray2[n17 - n7]) continue;
                    n8 = n17 - n7;
                    nArray3[n8] = nArray3[n8] + n10;
                }
                if (n8 <= -1) continue;
                int n54 = n8;
                nArray3[n54] = nArray3[n54] + n9;
            }
        }
        if (n4 != -1 && n32 > 0) {
            int n55;
            n17 = 0;
            for (n55 = 0; n55 < n28; ++n55) {
                n17 += nArray2[n55];
            }
            n55 = n32;
            int n56 = (n47 - n17) / n55;
            int n57 = (n47 - n17) % n55;
            n14 = -1;
            while (n17 != n47) {
                for (n13 = 0; n13 < n28; ++n13) {
                    if (!blArray2[n13]) continue;
                    if (nArray2[n13] + n56 > nArray3[n13]) {
                        n14 = n13;
                        nArray2[n14] = nArray2[n13] + n56;
                        continue;
                    }
                    nArray2[n13] = nArray3[n13];
                    blArray2[n13] = false;
                    --n55;
                }
                if (n14 > -1) {
                    int n58 = n14;
                    nArray2[n58] = nArray2[n58] + n57;
                }
                for (n13 = 0; n13 < n28; ++n13) {
                    for (n12 = 0; n12 < n24; ++n12) {
                        GridData gridData6 = this.getData(controlArray, n13, n12, n28, n24, false);
                        if (gridData6 == null || (n10 = Math.max(1, Math.min(gridData6.verticalSpan, n28))) <= 1 || gridData6.grabExcessVerticalSpace && gridData6.minimumHeight == 0) continue;
                        n9 = 0;
                        n8 = 0;
                        for (n7 = 0; n7 < n10; ++n7) {
                            n9 += nArray2[n13 - n7];
                            if (!blArray2[n13 - n7]) continue;
                            ++n8;
                        }
                        int n59 = n7 = !gridData6.grabExcessVerticalSpace || gridData6.minimumHeight == -1 ? gridData6.cacheHeight : gridData6.minimumHeight;
                        if ((n7 += gridData6.verticalIndent - n9 - (n10 - 1) * this.verticalSpacing) <= 0) continue;
                        if (n8 == 0) {
                            int n60 = n13;
                            nArray2[n60] = nArray2[n60] + n7;
                            continue;
                        }
                        n6 = n7 / n8;
                        int n61 = n7 % n8;
                        int n62 = -1;
                        for (int i = 0; i < n10; ++i) {
                            if (!blArray2[n13 - i]) continue;
                            n62 = n13 - i;
                            nArray2[n62] = nArray2[n62] + n6;
                        }
                        if (n62 <= -1) continue;
                        int n63 = n62;
                        nArray2[n63] = nArray2[n63] + n61;
                    }
                }
                if (n55 == 0) break;
                n17 = 0;
                for (n13 = 0; n13 < n28; ++n13) {
                    n17 += nArray2[n13];
                }
                n56 = (n47 - n17) / n55;
                n57 = (n47 - n17) % n55;
                n14 = -1;
            }
        }
        if (bl) {
            n17 = n2 + this.marginTop + this.marginHeight;
            for (int i = 0; i < n28; ++i) {
                int n64 = n + this.marginLeft + this.marginWidth;
                for (int j = 0; j < n24; ++j) {
                    GridData gridData7 = this.getData(controlArray, i, j, n28, n24, true);
                    if (gridData7 != null) {
                        n13 = Math.max(1, Math.min(gridData7.horizontalSpan, n24));
                        n12 = Math.max(1, gridData7.verticalSpan);
                        int n65 = 0;
                        n10 = 0;
                        for (n9 = 0; n9 < n13; ++n9) {
                            n65 += object[j + n9];
                        }
                        for (n9 = 0; n9 < n12; ++n9) {
                            n10 += nArray2[i + n9];
                        }
                        n9 = n64 + gridData7.horizontalIndent;
                        n8 = Math.min(gridData7.cacheWidth, n65 += this.horizontalSpacing * (n13 - 1));
                        switch (gridData7.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n9 += Math.max(0, (n65 - gridData7.horizontalIndent - n8) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                n9 += Math.max(0, n65 - gridData7.horizontalIndent - n8);
                                break;
                            }
                            case 4: {
                                n8 = n65 - gridData7.horizontalIndent;
                            }
                        }
                        n7 = n17 + gridData7.verticalIndent;
                        n6 = Math.min(gridData7.cacheHeight, n10 += this.verticalSpacing * (n12 - 1));
                        switch (gridData7.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n7 += Math.max(0, (n10 - gridData7.verticalIndent - n6) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                n7 += Math.max(0, n10 - gridData7.verticalIndent - n6);
                                break;
                            }
                            case 4: {
                                n6 = n10 - gridData7.verticalIndent;
                            }
                        }
                        Control control4 = controlArray[i][j];
                        if (control4 != null) {
                            control4.setBounds(n9, n7, n8, n6);
                        }
                    }
                    n64 += object[j] + this.horizontalSpacing;
                }
                n17 += nArray2[i] + this.verticalSpacing;
            }
        }
        for (n17 = 0; n17 < n21; ++n17) {
            gridDataArray[n17].cacheHeight = -1;
            gridDataArray[n17].cacheWidth = -1;
        }
        n17 = 0;
        int n66 = 0;
        for (n5 = 0; n5 < n24; ++n5) {
            n17 += object[n5];
        }
        for (n5 = 0; n5 < n28; ++n5) {
            n66 += nArray2[n5];
        }
        return new Point(n17 += this.horizontalSpacing * (n24 - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, n66 += this.verticalSpacing * (n28 - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        Object object = this.getName() + " {";
        if (this.numColumns != 1) {
            object = (String)object + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            object = (String)object + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            object = (String)object + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            object = (String)object + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            object = (String)object + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            object = (String)object + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            object = (String)object + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            object = (String)object + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            object = (String)object + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            object = (String)object + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        object = ((String)object).trim();
        object = (String)object + "}";
        return object;
    }
}

