/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.widgets.Display;

public class ExceptionStash
implements AutoCloseable {
    Throwable storedThrowable;

    public void stash(Throwable throwable) {
        try {
            Display display = Display.getCurrent();
            if (display != null) {
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    display.getRuntimeExceptionHandler().accept(runtimeException);
                    return;
                }
                if (throwable instanceof Error) {
                    Error error = (Error)throwable;
                    display.getErrorHandler().accept(error);
                    return;
                }
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (this.storedThrowable != null) {
            this.storedThrowable.addSuppressed(throwable);
        } else {
            this.storedThrowable = throwable;
        }
    }

    @Override
    public void close() {
        if (this.storedThrowable == null) {
            return;
        }
        Throwable throwable = this.storedThrowable;
        this.storedThrowable = null;
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
    }
}

