/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static AutoScaleMethod autoScaleMethodSetting = AutoScaleMethod.AUTO;
    private static AutoScaleMethod autoScaleMethod = AutoScaleMethod.NEAREST;
    private static String autoScaleValue;
    private static boolean useCairoAutoScale;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = 1.0f / DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static int[] autoScaleDown(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] / f);
        }
        return nArray2;
    }

    public static int[] autoScaleDown(Drawable drawable, int[] nArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.autoScaleDown(nArray);
    }

    public static float[] autoScaleDown(float[] fArray) {
        if (deviceZoom == 100 || fArray == null) {
            return fArray;
        }
        float f = DPIUtil.getScalingFactor();
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[i] / f;
        }
        return fArray2;
    }

    public static float[] autoScaleDown(Drawable drawable, float[] fArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return fArray;
        }
        return DPIUtil.autoScaleDown(fArray);
    }

    public static int autoScaleDown(int n) {
        if (deviceZoom == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n / f);
    }

    public static int autoScaleDown(Drawable drawable, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n;
        }
        return DPIUtil.autoScaleDown(n);
    }

    public static float autoScaleDown(float f) {
        if (deviceZoom == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f / f2;
    }

    public static float autoScaleDown(Drawable drawable, float f) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f;
        }
        return DPIUtil.autoScaleDown(f);
    }

    public static Point autoScaleDown(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x / f);
        point2.y = Math.round((float)point.y / f);
        return point2;
    }

    public static Point autoScaleDown(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleDown(point);
    }

    public static Rectangle autoScaleDown(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleDown(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleDown(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleDown(Drawable drawable, Rectangle rectangle) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.autoScaleDown(rectangle);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n, int n2) {
        if (imageData == null || n == n2 || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)n / (float)n2;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    private static ImageData autoScaleImageData(Device device, ImageData imageData, float f) {
        int n2 = imageData.width;
        int n3 = imageData.height;
        int n4 = Math.round((float)n2 * f);
        int n5 = Math.round((float)n3 * f);
        return switch (autoScaleMethod.ordinal()) {
            case 2 -> {
                Image var7_7 = new Image(device, n -> imageData);
                ImageData var8_8 = new ImageData(n4, n5, 24, new PaletteData(255, 65280, 0xFF0000));
                var8_8.alphaData = new byte[n4 * n5];
                Image var9_9 = new Image(device, n -> imageData);
                GC var10_10 = new GC(var9_9);
                var10_10.setAntialias(1);
                var10_10.drawImage(var7_7, 0, 0, DPIUtil.autoScaleDown(n2), DPIUtil.autoScaleDown(n3), 0, 0, Math.round(DPIUtil.autoScaleDown((float)n2 * f)), Math.round(DPIUtil.autoScaleDown((float)n3 * f)));
                var10_10.dispose();
                var7_7.dispose();
                ImageData var11_11 = var9_9.getImageData(DPIUtil.getDeviceZoom());
                var9_9.dispose();
                yield var11_11;
            }
            default -> imageData.scaledTo(n4, n5);
        };
    }

    public static Rectangle autoScaleBounds(Rectangle rectangle, int n, int n2) {
        if (deviceZoom == 100 || rectangle == null || n == n2) {
            return rectangle;
        }
        float f = (float)n / (float)n2;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f);
        rectangle2.y = Math.round((float)rectangle.y * f);
        rectangle2.width = Math.round((float)rectangle.width * f);
        rectangle2.height = Math.round((float)rectangle.height * f);
        return rectangle2;
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n) {
        if (deviceZoom == n || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)deviceZoom / (float)n;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        return DPIUtil.autoScaleImageData(device, imageData, 100);
    }

    public static int[] autoScaleUp(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] * f);
        }
        return nArray2;
    }

    public static int[] autoScaleUp(Drawable drawable, int[] nArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return nArray;
        }
        return DPIUtil.autoScaleUp(nArray);
    }

    public static int autoScaleUp(int n) {
        if (deviceZoom == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n * f);
    }

    public static int autoScaleUpUsingNativeDPI(int n) {
        if (nativeDeviceZoom == 100 || n == -1) {
            return n;
        }
        float f = (float)nativeDeviceZoom / 100.0f;
        return Math.round((float)n * f);
    }

    public static int autoScaleUp(Drawable drawable, int n) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return n;
        }
        return DPIUtil.autoScaleUp(n);
    }

    public static float autoScaleUp(float f) {
        if (deviceZoom == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f * f2;
    }

    public static float autoScaleUp(Drawable drawable, float f) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return f;
        }
        return DPIUtil.autoScaleUp(f);
    }

    public static Point autoScaleUp(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f);
        point2.y = Math.round((float)point.y * f);
        return point2;
    }

    public static Point autoScaleUp(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleUp(point);
    }

    public static Rectangle autoScaleUp(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleUp(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleUp(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Rectangle autoScaleUp(Drawable drawable, Rectangle rectangle) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rectangle;
        }
        return DPIUtil.autoScaleUp(rectangle);
    }

    private static float getScalingFactor() {
        if (useCairoAutoScale) {
            return 1.0f;
        }
        return (float)deviceZoom / 100.0f;
    }

    public static int mapDPIToZoom(int n) {
        double d = (double)n * 100.0 / 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static ElementAtZoom<ImageData> validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n2) {
        ElementAtZoom<ImageData> elementAtZoom;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageDataProvider.getImageData((int)n), n2)) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(imageDataProvider) + "] returns null ImageData at 100% zoom.");
        }
        return elementAtZoom;
    }

    public static ElementAtZoom<String> validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n2) {
        ElementAtZoom<String> elementAtZoom;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageFileNameProvider.getImagePath((int)n), n2)) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(imageFileNameProvider) + "] returns null filename at 100% zoom.");
        }
        return elementAtZoom;
    }

    private static <T> ElementAtZoom<T> getElementAtZoom(Function<Integer, T> function, int n) {
        T t;
        T t2 = function.apply(n);
        if (t2 != null) {
            return new ElementAtZoom<T>(t2, n);
        }
        if (n > 100 && n <= 150 && (t = function.apply(150)) != null) {
            return new ElementAtZoom<T>(t, 150);
        }
        if (n > 100 && (t = function.apply(200)) != null) {
            return new ElementAtZoom<T>(t, 200);
        }
        if (n != 100 && (t = function.apply(100)) != null) {
            return new ElementAtZoom<T>(t, 100);
        }
        return null;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int n) {
        int n2;
        nativeDeviceZoom = n;
        deviceZoom = n2 = DPIUtil.getZoomForAutoscaleProperty(n);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(n2));
        if (n2 != 100 && autoScaleMethodSetting == AutoScaleMethod.AUTO) {
            autoScaleMethod = n2 / 100 * 100 == n2 || !"gtk".equals(SWT.getPlatform()) ? AutoScaleMethod.NEAREST : AutoScaleMethod.SMOOTH;
        }
    }

    public static void setUseCairoAutoScale(boolean bl) {
        useCairoAutoScale = bl;
    }

    public static boolean useCairoAutoScale() {
        return useCairoAutoScale;
    }

    public static int getZoomForAutoscaleProperty(int n) {
        int n2 = 0;
        if (autoScaleValue != null) {
            if ("false".equalsIgnoreCase(autoScaleValue)) {
                n2 = 100;
            } else if ("half".equalsIgnoreCase(autoScaleValue)) {
                n2 = (int)Math.rint((double)n / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(autoScaleValue)) {
                n2 = Math.round((float)n / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(autoScaleValue)) {
                n2 = n;
            } else {
                try {
                    int n3 = Integer.parseInt(autoScaleValue);
                    n2 = Math.max(Math.min(n3, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n2 == 0) {
            n2 = Math.max((n + 25) / 100 * 100, 100);
        }
        return n2;
    }

    static {
        useCairoAutoScale = false;
        autoScaleValue = System.getProperty(SWT_AUTOSCALE);
        String string = System.getProperty(SWT_AUTOSCALE_METHOD);
        if (string != null) {
            if (AutoScaleMethod.NEAREST.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.NEAREST;
            } else if (AutoScaleMethod.SMOOTH.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.SMOOTH;
            }
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;

    }

    public record ElementAtZoom<T>(T element, int zoom) {
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData imageData, int n) {
            this.device = device;
            this.imageData = imageData;
            this.currentZoom = n;
        }

        @Override
        public ImageData getImageData(int n) {
            return DPIUtil.autoScaleImageData(this.device, this.imageData, n, this.currentZoom);
        }
    }
}

