/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascentInPoints;
    int descentInPoints;
    int indent;
    int wrapIndent;
    int wrapWidth;
    int[] segments;
    char[] segmentsChars;
    int[] tabs;
    StyleItem[] styles;
    int stylesCount;
    long layout;
    long context;
    long attrList;
    long selAttrList;
    int[] invalidOffsets;
    int verticalIndentInPoints;
    MetricsAdapter metricsAdapter = new MetricsAdapter();
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        device = this.device;
        if (GTK.GTK4) {
            long l = OS.pango_cairo_font_map_get_default();
            this.context = OS.pango_font_map_create_context(l);
        } else {
            this.context = GDK.gdk_pango_context_get();
        }
        if (this.context == 0L) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, GTK.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_font_description(this.layout, device.systemFont.handle);
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        OS.pango_layout_set_auto_dir(this.layout, false);
        this.text = "";
        this.descentInPoints = -1;
        this.ascentInPoints = -1;
        this.wrapWidth = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        boolean bl;
        int n6;
        long l;
        if (this.attrList != 0L) {
            return;
        }
        String string = this.getSegmentsText();
        byte[] byArray = Converter.wcsToMbcs(string, false);
        OS.pango_layout_set_text(this.layout, byArray, byArray.length);
        this.attrList = OS.pango_attr_list_new();
        this.selAttrList = OS.pango_attr_list_new();
        if (14400 <= OS.pango_version()) {
            l = OS.pango_attr_insert_hyphens_new(false);
            OS.pango_attr_list_insert(this.attrList, l);
            OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l));
        }
        if (this.stylesCount == 2 && this.styles[0].style == null && this.ascentInPoints == -1 && this.descentInPoints == -1 && this.segments == null) {
            OS.pango_layout_set_attributes(this.layout, this.attrList);
            return;
        }
        l = OS.pango_layout_get_text(this.layout);
        PangoAttribute pangoAttribute = new PangoAttribute();
        char[] cArray = null;
        int n7 = string.length();
        int n8 = n6 = n7 - this.text.length();
        int[] nArray = null;
        boolean bl2 = bl = !this.metricsAdapter.isFixedMetrics() && (this.ascentInPoints != -1 || this.descentInPoints != -1);
        if (bl && n7 > 0) {
            PangoRectangle pangoRectangle = new PangoRectangle();
            if (this.ascentInPoints != -1) {
                pangoRectangle.y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints) * 1024);
            }
            pangoRectangle.height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), Math.max(0, this.ascentInPoints) + Math.max(0, this.descentInPoints)) * 1024;
            n5 = OS.pango_layout_get_line_count(this.layout);
            cArray = new char[n7 + n5 * 2];
            nArray = new int[n5];
            n4 = 0;
            object = new PangoLayoutLine();
            for (n3 = 0; n3 < n5; ++n3) {
                long l2 = OS.pango_layout_get_line(this.layout, n3);
                OS.memmove((PangoLayoutLine)object, l2, (long)PangoLayoutLine.sizeof);
                n2 = ((PangoLayoutLine)object).start_index;
                n = n3 * 6;
                long l3 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2 + n;
                pangoAttribute.end_index = n2 + n + 3;
                OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l3);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l3));
                l3 = OS.pango_attr_shape_new(pangoRectangle, pangoRectangle);
                OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2 + n + 3;
                pangoAttribute.end_index = n2 + n + 6;
                OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l3);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l3));
                int n9 = (int)OS.g_utf16_pointer_to_offset(l, l + (long)n2);
                cArray[n9 + n3 * 2] = 8203;
                cArray[n9 + n3 * 2 + 1] = 65279;
                string.getChars(n4, n9, cArray, n4 + n3 * 2);
                nArray[n3] = n9 + n3 * 2;
                n4 = n9;
            }
            string.getChars(n4, n7, cArray, n4 + n3 * 2);
            byArray = Converter.wcsToMbcs(cArray, false);
            OS.pango_layout_set_text(this.layout, byArray, byArray.length);
            l = OS.pango_layout_get_text(this.layout);
            n8 += 2 * n5;
        } else {
            cArray = new char[n7];
            string.getChars(0, n7, cArray, 0);
        }
        this.invalidOffsets = new int[n8];
        if (n8 > 0) {
            n8 = 0;
            int n10 = 0;
            n5 = 0;
            for (n4 = 0; n4 < cArray.length; ++n4) {
                n3 = cArray[n4];
                if (n3 == 8203 && nArray != null && n10 < nArray.length && n4 == nArray[n10]) {
                    this.invalidOffsets[n8++] = n4++;
                    this.invalidOffsets[n8++] = n4;
                    ++n10;
                    continue;
                }
                if (n5 >= n6 || n4 - n8 != this.segments[n5]) continue;
                this.invalidOffsets[n8++] = n4;
                ++n5;
            }
        }
        int n11 = C.strlen(l);
        Font font = this.font != null ? this.font : this.device.systemFont;
        for (n4 = 0; n4 < this.stylesCount - 1; ++n4) {
            int n12;
            Color color;
            Color color2;
            Object object2;
            Object object3;
            long l4;
            StyleItem styleItem = this.styles[n4];
            object = styleItem.style;
            if (object == null) continue;
            int n13 = this.translateOffset(styleItem.start);
            int n14 = this.translateOffset(this.styles[n4 + 1].start - 1);
            n2 = (int)(OS.g_utf16_offset_to_pointer(l, n13) - l);
            n = (int)(OS.g_utf16_offset_to_pointer(l, n14 + 1) - l);
            n2 = Math.min(n2, n11);
            n = Math.min(n, n11);
            Font font2 = ((TextStyle)object).font;
            if (font2 != null && !font2.isDisposed() && !font.equals(font2)) {
                l4 = OS.pango_attr_font_desc_new(font2.handle);
                OS.memmove(pangoAttribute, l4, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l4, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l4);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l4));
            }
            if (((TextStyle)object).underline) {
                int n15 = 0;
                switch (((TextStyle)object).underlineStyle) {
                    case 0: {
                        n15 = 1;
                        break;
                    }
                    case 1: {
                        n15 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n15 = 4;
                        break;
                    }
                    case 4: {
                        if (((TextStyle)object).foreground == null) {
                            object3 = this.device.getSystemColor((int)36).handle;
                            long l5 = OS.pango_attr_foreground_new((short)(((GdkRGBA)object3).red * 65535.0), (short)(((GdkRGBA)object3).green * 65535.0), (short)(((GdkRGBA)object3).blue * 65535.0));
                            OS.memmove(pangoAttribute, l5, (long)PangoAttribute.sizeof);
                            pangoAttribute.start_index = n2;
                            pangoAttribute.end_index = n;
                            OS.memmove(l5, pangoAttribute, (long)PangoAttribute.sizeof);
                            OS.pango_attr_list_insert(this.attrList, l5);
                        }
                        n15 = 1;
                    }
                }
                long l6 = OS.pango_attr_underline_new(n15);
                OS.memmove(pangoAttribute, l6, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l6, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l6);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l6));
                if (((TextStyle)object).underlineColor != null) {
                    object3 = ((TextStyle)object).underlineColor.handle;
                    l6 = OS.pango_attr_underline_color_new((short)(((GdkRGBA)object3).red * 65535.0), (short)(((GdkRGBA)object3).green * 65535.0), (short)(((GdkRGBA)object3).blue * 65535.0));
                    if (l6 != 0L) {
                        OS.memmove(pangoAttribute, l6, (long)PangoAttribute.sizeof);
                        pangoAttribute.start_index = n2;
                        pangoAttribute.end_index = n;
                        OS.memmove(l6, pangoAttribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, l6);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l6));
                    }
                }
            }
            if (((TextStyle)object).strikeout) {
                l4 = OS.pango_attr_strikethrough_new(true);
                OS.memmove(pangoAttribute, l4, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l4, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l4);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l4));
                if (((TextStyle)object).strikeoutColor != null) {
                    object2 = ((TextStyle)object).strikeoutColor.handle;
                    l4 = OS.pango_attr_strikethrough_color_new((short)(((GdkRGBA)object2).red * 65535.0), (short)(((GdkRGBA)object2).green * 65535.0), (short)(((GdkRGBA)object2).blue * 65535.0));
                    if (l4 != 0L) {
                        OS.memmove(pangoAttribute, l4, (long)PangoAttribute.sizeof);
                        pangoAttribute.start_index = n2;
                        pangoAttribute.end_index = n;
                        OS.memmove(l4, pangoAttribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, l4);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l4));
                    }
                }
            }
            if ((color2 = ((TextStyle)object).foreground) != null && !color2.isDisposed()) {
                object3 = color2.handle;
                long l7 = OS.pango_attr_foreground_new((short)(((GdkRGBA)object3).red * 65535.0), (short)(((GdkRGBA)object3).green * 65535.0), (short)(((GdkRGBA)object3).blue * 65535.0));
                OS.memmove(pangoAttribute, l7, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l7, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l7);
            }
            if ((color = ((TextStyle)object).background) != null && !color.isDisposed()) {
                GdkRGBA gdkRGBA = color.handle;
                long l8 = OS.pango_attr_background_new((short)(gdkRGBA.red * 65535.0), (short)(gdkRGBA.green * 65535.0), (short)(gdkRGBA.blue * 65535.0));
                OS.memmove(pangoAttribute, l8, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l8, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l8);
            }
            if ((object2 = ((TextStyle)object).metrics) != null) {
                object3 = new PangoRectangle();
                ((PangoRectangle)object3).y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).ascent) * 1024);
                ((PangoRectangle)object3).height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).ascent + ((GlyphMetrics)object2).descent) * 1024;
                ((PangoRectangle)object3).width = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ((GlyphMetrics)object2).width) * 1024;
                long l9 = OS.pango_attr_shape_new((PangoRectangle)object3, (PangoRectangle)object3);
                OS.memmove(pangoAttribute, l9, (long)PangoAttribute.sizeof);
                pangoAttribute.start_index = n2;
                pangoAttribute.end_index = n;
                OS.memmove(l9, pangoAttribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, l9);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l9));
            }
            if ((n12 = ((TextStyle)object).rise) == 0) continue;
            long l10 = OS.pango_attr_rise_new(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n12) * 1024);
            OS.memmove(pangoAttribute, l10, (long)PangoAttribute.sizeof);
            pangoAttribute.start_index = n2;
            pangoAttribute.end_index = n;
            OS.memmove(l10, pangoAttribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(this.attrList, l10);
            OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(l10));
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        for (int i = 0; i < n8; ++i) {
            int n9 = 4 * i;
            nArray[n9] = n + n7 * i;
            nArray[n9 + 1] = n4;
            nArray[n9 + 2] = nArray[n9] + n7 / 2;
            nArray[n9 + 3] = n2;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    @Override
    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        this.segments = null;
        this.segmentsChars = null;
        if (this.layout != 0L) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0L;
        if (this.context != 0L) {
            OS.g_object_unref(this.context);
        }
        this.context = 0L;
    }

    public void draw(GC gC, int n, int n2) {
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2);
    }

    void drawInPixels(GC gC, int n, int n2) {
        this.drawInPixels(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.checkLayout();
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2, n3, n4, color, color2);
    }

    void drawInPixels(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.drawInPixels(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        n = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n);
        n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2);
        this.drawInPixels(gC, n, n2, n3, n4, color, color2, n5);
    }

    void drawInPixels(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n7 = this.text.length();
        n += Math.min(this.indent, this.wrapIndent);
        n2 += this.getScaledVerticalIndent();
        boolean bl = n3 <= n4 && n3 != -1 && n4 != -1;
        GCData gCData = gC.data;
        long l = gCData.cairo;
        if ((n5 & 0x30000) != 0 && (bl || (n5 & 0x100000) != 0)) {
            long[] lArray = new long[1];
            int[] nArray = new int[1];
            PangoLogAttr pangoLogAttr = new PangoLogAttr();
            PangoRectangle pangoRectangle = new PangoRectangle();
            n6 = OS.pango_layout_get_line_count(this.layout);
            long l2 = OS.pango_layout_get_text(this.layout);
            long l3 = OS.pango_layout_get_iter(this.layout);
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            Cairo.cairo_save(l);
            GdkRGBA gdkRGBA = color2.handle;
            Cairo.cairo_set_source_rgba(l, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, gdkRGBA.alpha);
            int n8 = 0;
            do {
                int n9;
                int n10;
                this.metricsAdapter.pango_layout_iter_get_line_extents(l3, null, pangoRectangle);
                if (OS.pango_layout_iter_next_line(l3)) {
                    n10 = OS.pango_layout_iter_get_index(l3);
                    n9 = (int)OS.g_utf16_pointer_to_offset(l2, l2 + (long)n10);
                } else {
                    n9 = (int)OS.g_utf16_strlen(l2, -1L);
                }
                n10 = 0;
                if (n8 == n6 - 1 && (n5 & 0x100000) != 0) {
                    n10 = 1;
                } else {
                    if (lArray[0] == 0L) {
                        OS.pango_layout_get_log_attrs(this.layout, lArray, nArray);
                    }
                    OS.memmove(pangoLogAttr, lArray[0] + (long)(n9 * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
                    if (!pangoLogAttr.is_line_break) {
                        if (n3 <= n9 && n9 <= n4) {
                            n10 = 1;
                        }
                    } else if (n3 <= n9 && n9 < n4 && (n5 & 0x10000) != 0) {
                        n10 = 1;
                    }
                }
                if (n10 == 0) continue;
                int n11 = n + OS.PANGO_PIXELS(pangoRectangle.x) + OS.PANGO_PIXELS(pangoRectangle.width);
                int n12 = n2 + OS.PANGO_PIXELS(pangoRectangle.y);
                int n13 = OS.PANGO_PIXELS(pangoRectangle.height);
                if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
                    n13 = Math.max(n13, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
                }
                int n14 = (n5 & 0x10000) != 0 ? Short.MAX_VALUE : n13 / 3;
                Cairo.cairo_rectangle(l, n11, n12, n14, n13);
                Cairo.cairo_fill(l);
            } while (++n8 < n6);
            OS.pango_layout_iter_free(l3);
            if (lArray[0] != 0L) {
                OS.g_free(lArray[0]);
            }
            Cairo.cairo_restore(l);
        }
        if (n7 == 0) {
            return;
        }
        if (!bl) {
            if ((gCData.style & 0x8000000) != 0) {
                Cairo.cairo_save(l);
                Cairo.cairo_scale(l, -1.0, 1.0);
                Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
            }
            this.metricsAdapter.pango_cairo_show_layout(l, this.layout, n, n2);
            this.drawBorder(gC, n, n2, null);
            if ((gCData.style & 0x8000000) != 0) {
                Cairo.cairo_restore(l);
            }
        } else {
            boolean bl2;
            n3 = Math.min(Math.max(0, n3), n7 - 1);
            n4 = Math.min(Math.max(0, n4), n7 - 1);
            n7 = (int)OS.g_utf16_strlen(OS.pango_layout_get_text(this.layout), -1L);
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            boolean bl3 = bl2 = n3 == 0 && n4 == n7 - 1;
            if (bl2) {
                long l4 = OS.pango_layout_get_text(this.layout);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_save(l);
                    Cairo.cairo_scale(l, -1.0, 1.0);
                    Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
                }
                this.drawWithCairo(gC, n, n2, 0, C.strlen(l4), bl2, color.handle, color2.handle);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(l);
                }
            } else {
                long l5 = OS.pango_layout_get_text(this.layout);
                int n15 = (int)(OS.g_utf16_offset_to_pointer(l5, n3) - l5);
                n6 = (int)(OS.g_utf16_offset_to_pointer(l5, n4 + 1) - l5);
                int n16 = C.strlen(l5);
                n15 = Math.min(n15, n16);
                n6 = Math.min(n6, n16);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_save(l);
                    Cairo.cairo_scale(l, -1.0, 1.0);
                    Cairo.cairo_translate(l, -2 * n - this.width(), 0.0);
                }
                this.drawWithCairo(gC, n, n2, n15, n6, bl2, color.handle, color2.handle);
                if ((gCData.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(l);
                }
            }
        }
        Cairo.cairo_new_path(l);
    }

    void drawWithCairo(GC gC, int n, int n2, int n3, int n4, boolean bl, GdkRGBA gdkRGBA, GdkRGBA gdkRGBA2) {
        int[] nArray;
        long l;
        GCData gCData = gC.data;
        long l2 = gCData.cairo;
        Cairo.cairo_save(l2);
        if (!bl) {
            this.metricsAdapter.pango_cairo_show_layout(l2, this.layout, n, n2);
            this.drawBorder(gC, n, n2, null);
        }
        if ((l = this.metricsAdapter.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray = new int[]{n3, n4}, nArray.length / 2)) != 0L) {
            GDK.gdk_cairo_region(l2, l);
            Cairo.cairo_clip(l2);
            Cairo.cairo_set_source_rgba(l2, gdkRGBA2.red, gdkRGBA2.green, gdkRGBA2.blue, gdkRGBA2.alpha);
            Cairo.cairo_paint(l2);
            Cairo.cairo_region_destroy(l);
        }
        Cairo.cairo_set_source_rgba(l2, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, gdkRGBA.alpha);
        OS.pango_layout_set_attributes(this.layout, this.selAttrList);
        this.metricsAdapter.pango_cairo_show_layout(l2, this.layout, n, n2);
        OS.pango_layout_set_attributes(this.layout, this.attrList);
        this.drawBorder(gC, n, n2, gdkRGBA);
        Cairo.cairo_restore(l2);
    }

    void drawBorder(GC gC, int n, int n2, GdkRGBA gdkRGBA) {
        GCData gCData = gC.data;
        long l = gCData.cairo;
        long l2 = OS.pango_layout_get_text(this.layout);
        Cairo.cairo_save(l);
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            int n3;
            int n4;
            boolean bl;
            TextStyle textStyle = this.styles[i].style;
            if (textStyle == null) continue;
            boolean bl2 = bl = textStyle.borderStyle != 0;
            if (!bl || textStyle.isAdherentBorder(this.styles[i + 1].style)) continue;
            int n5 = this.styles[i].start;
            for (n4 = i; n4 > 0 && textStyle.isAdherentBorder(this.styles[n4 - 1].style); --n4) {
                n5 = this.styles[n4 - 1].start;
            }
            n5 = this.translateOffset(n5);
            n4 = this.translateOffset(this.styles[i + 1].start - 1);
            int n6 = (int)(OS.g_utf16_offset_to_pointer(l2, n5) - l2);
            int[] nArray = new int[]{n6, n3 = (int)(OS.g_utf16_offset_to_pointer(l2, n4 + 1) - l2)};
            long l3 = this.metricsAdapter.gdk_pango_layout_get_clip_region(this.layout, n, n2, nArray, nArray.length / 2);
            if (l3 == 0L) continue;
            int[] nArray2 = new int[1];
            long[] lArray = new long[1];
            Region.cairo_region_get_rectangles(l3, lArray, nArray2);
            cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
            GdkRGBA gdkRGBA2 = null;
            if (gdkRGBA2 == null && textStyle.borderColor != null) {
                gdkRGBA2 = textStyle.borderColor.handle;
            }
            if (gdkRGBA2 == null && gdkRGBA != null) {
                gdkRGBA2 = gdkRGBA;
            }
            if (gdkRGBA2 == null && textStyle.foreground != null) {
                gdkRGBA2 = textStyle.foreground.handle;
            }
            if (gdkRGBA2 == null) {
                gdkRGBA2 = gCData.foregroundRGBA;
            }
            boolean bl3 = true;
            float[] fArray = null;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = bl3 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                    break;
                }
                case 4: {
                    fArray = bl3 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                }
            }
            Cairo.cairo_set_source_rgba(l, gdkRGBA2.red, gdkRGBA2.green, gdkRGBA2.blue, gdkRGBA2.alpha);
            Cairo.cairo_set_line_width(l, (double)bl3);
            if (fArray != null) {
                double[] dArray = new double[fArray.length];
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[j] = !bl3 || gCData.lineStyle == 6 ? (double)fArray[j] : (double)(fArray[j] * (float)bl3);
                }
                Cairo.cairo_set_dash(l, dArray, dArray.length, 0.0);
            } else {
                Cairo.cairo_set_dash(l, null, 0, 0.0);
            }
            for (int j = 0; j < nArray2[0]; ++j) {
                Cairo.memmove(cairo_rectangle_int_t2, lArray[0] + (long)(j * cairo_rectangle_int_t.sizeof), (long)cairo_rectangle_int_t.sizeof);
                Cairo.cairo_rectangle(l, (double)cairo_rectangle_int_t2.x + 0.5, (double)cairo_rectangle_int_t2.y + 0.5, cairo_rectangle_int_t2.width - 1, cairo_rectangle_int_t2.height - 1);
            }
            Cairo.cairo_stroke(l);
            if (lArray[0] != 0L) {
                OS.g_free(lArray[0]);
            }
            Cairo.cairo_region_destroy(l3);
        }
        Cairo.cairo_restore(l);
    }

    void freeRuns() {
        if (this.attrList == 0L) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0L);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0L;
        if (this.selAttrList != 0L) {
            OS.pango_attr_list_unref(this.selAttrList);
            this.selAttrList = 0L;
        }
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int n = OS.pango_layout_get_alignment(this.layout);
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (n) {
            case 0: {
                return bl ? 131072 : 16384;
            }
            case 2: {
                return bl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascentInPoints;
    }

    public Rectangle getBounds() {
        int n = this.getSpacingInPixels();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(n));
    }

    Rectangle getBoundsInPixels(int n) {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.metricsAdapter.pango_layout_get_size(this.layout, nArray, nArray2);
        int n2 = OS.pango_layout_get_width(this.layout);
        nArray[0] = n2 != -1 ? n2 : nArray[0] + OS.pango_layout_get_indent(this.layout);
        int n3 = OS.PANGO_PIXELS(nArray[0]);
        int n4 = OS.PANGO_PIXELS(nArray2[0]);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            n4 = Math.max(n4, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        return new Rectangle(0, 0, n3, (n4 += n) + this.getScaledVerticalIndent());
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(n, n2));
    }

    Rectangle getBoundsInPixels(int n, int n2) {
        long l;
        this.checkLayout();
        this.computeRuns();
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        long l2 = OS.pango_layout_get_text(this.layout);
        int n4 = (int)(OS.g_utf16_offset_to_pointer(l2, n) - l2);
        int n5 = (int)(OS.g_utf16_offset_to_pointer(l2, n2 + 1) - l2);
        int n6 = C.strlen(l2);
        int[] nArray = new int[]{n4 = Math.min(n4, n6), n5 = Math.min(n5, n6)};
        long l3 = this.metricsAdapter.gdk_pango_layout_get_clip_region(this.layout, 0, 0, nArray, 1);
        if (l3 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        PangoRectangle pangoRectangle = new PangoRectangle();
        long l4 = OS.pango_layout_get_iter(this.layout);
        if (l4 == 0L) {
            SWT.error(2);
        }
        if ((l = Cairo.cairo_region_create()) == 0L) {
            SWT.error(2);
        }
        int n7 = 0;
        do {
            this.metricsAdapter.pango_layout_iter_get_line_extents(l4, null, pangoRectangle);
            n7 = OS.pango_layout_iter_next_line(l4) ? OS.pango_layout_iter_get_index(l4) - 1 : n6;
            if (n4 > n7) continue;
            cairo_rectangle_int_t2.x = OS.PANGO_PIXELS(pangoRectangle.x);
            cairo_rectangle_int_t2.y = OS.PANGO_PIXELS(pangoRectangle.y);
            cairo_rectangle_int_t2.width = OS.PANGO_PIXELS(pangoRectangle.width);
            cairo_rectangle_int_t2.height = OS.PANGO_PIXELS(pangoRectangle.height);
            Cairo.cairo_region_union_rectangle(l, cairo_rectangle_int_t2);
        } while (n7 + 1 <= n5);
        Cairo.cairo_region_intersect(l3, l);
        Cairo.cairo_region_destroy(l);
        OS.pango_layout_iter_free(l4);
        Cairo.cairo_region_get_extents(l3, cairo_rectangle_int_t2);
        Cairo.cairo_region_destroy(l3);
        cairo_rectangle_int_t2.x += Math.min(this.indent, this.wrapIndent);
        return new Rectangle(cairo_rectangle_int_t2.x, cairo_rectangle_int_t2.y, cairo_rectangle_int_t2.width, cairo_rectangle_int_t2.height + this.getScaledVerticalIndent());
    }

    public int getDescent() {
        this.checkLayout();
        return this.descentInPoints;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        long l = OS.pango_layout_get_iter(this.layout);
        if (l == 0L) {
            SWT.error(2);
        }
        int n3 = 0;
        PangoItem pangoItem = new PangoItem();
        PangoLayoutRun pangoLayoutRun = new PangoLayoutRun();
        long l2 = OS.pango_layout_get_text(this.layout);
        long l3 = OS.g_utf16_offset_to_pointer(l2, n) - l2;
        int n4 = C.strlen(l2);
        l3 = Math.min(l3, (long)n4);
        do {
            long l4;
            if ((l4 = OS.pango_layout_iter_get_run(l)) == 0L) continue;
            OS.memmove(pangoLayoutRun, l4, (long)PangoLayoutRun.sizeof);
            OS.memmove(pangoItem, pangoLayoutRun.item, (long)PangoItem.sizeof);
            if ((long)pangoItem.offset > l3 || l3 >= (long)(pangoItem.offset + pangoItem.length)) continue;
            n3 = pangoItem.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(l));
        OS.pango_layout_iter_free(l);
        return n3;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(n));
    }

    Rectangle getLineBoundsInPixels(int n) {
        this.computeRuns();
        int n2 = OS.pango_layout_get_line_count(this.layout);
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        long l = OS.pango_layout_get_iter(this.layout);
        for (int i = 0; i < n; ++i) {
            OS.pango_layout_iter_next_line(l);
        }
        Rectangle rectangle = this.getLineBoundsInPixels(n, l);
        OS.pango_layout_iter_free(l);
        return rectangle;
    }

    private Rectangle getLineBoundsInPixels(int n, long l) {
        if (l == 0L) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        this.metricsAdapter.pango_layout_iter_get_line_extents(l, null, pangoRectangle);
        int n2 = OS.PANGO_PIXELS(pangoRectangle.x);
        int n3 = OS.PANGO_PIXELS(pangoRectangle.y);
        int n4 = OS.PANGO_PIXELS(pangoRectangle.width);
        int n5 = OS.PANGO_PIXELS(pangoRectangle.height);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            n5 = Math.max(n5, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        return new Rectangle(n2 += Math.min(this.indent, this.wrapIndent), n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(5);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        long l = OS.pango_layout_get_text(this.layout);
        long l2 = OS.g_utf16_offset_to_pointer(l, n) - l;
        int n4 = C.strlen(l);
        l2 = Math.min(l2, (long)n4);
        long l3 = OS.pango_layout_get_iter(this.layout);
        if (l3 == 0L) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(l3) && (long)OS.pango_layout_iter_get_index(l3) <= l2) {
            ++n3;
        }
        OS.pango_layout_iter_free(l3);
        return n3;
    }

    public FontMetrics getLineMetrics(int n) {
        int n2;
        int n3;
        if (this.metricsAdapter.isFixedMetrics()) {
            return this.metricsAdapter.getFixedLineMetrics(this.getDevice());
        }
        this.checkLayout();
        this.computeRuns();
        int n4 = OS.pango_layout_get_line_count(this.layout);
        if (0 > n || n >= n4) {
            SWT.error(6);
        }
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        OS.memmove(pangoLayoutLine, OS.pango_layout_get_line(this.layout, n), (long)PangoLayoutLine.sizeof);
        if (pangoLayoutLine.runs == 0L) {
            long l = this.font != null ? this.font.handle : this.device.systemFont.handle;
            long l2 = OS.pango_context_get_language(this.context);
            long l3 = OS.pango_context_get_metrics(this.context, l, l2);
            int n5 = OS.pango_font_metrics_get_ascent(l3);
            int n6 = OS.pango_font_metrics_get_descent(l3);
            n3 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(n5));
            n2 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(n5 + n6));
            OS.pango_font_metrics_unref(l3);
        } else {
            PangoRectangle pangoRectangle = new PangoRectangle();
            this.metricsAdapter.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, n), null, pangoRectangle);
            n3 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(-pangoRectangle.y));
            n2 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(pangoRectangle.height));
        }
        n2 = Math.max(this.ascentInPoints + this.descentInPoints, n2);
        n3 = Math.max(this.ascentInPoints, n3);
        int n7 = n2 - n3;
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.ascentInPoints = n3;
        fontMetrics.descentInPoints = n7;
        fontMetrics.averageCharWidthInPoints = 0;
        return fontMetrics;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int n = OS.pango_layout_get_line_count(this.layout);
        int[] nArray = new int[n + 1];
        long l = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine pangoLayoutLine = new PangoLayoutLine();
        for (int i = 0; i < n; ++i) {
            long l2 = OS.pango_layout_get_line(this.layout, i);
            OS.memmove(pangoLayoutLine, l2, (long)PangoLayoutLine.sizeof);
            int n2 = (int)OS.g_utf16_pointer_to_offset(l, l + (long)pangoLayoutLine.start_index);
            nArray[i] = this.untranslateOffset(n2);
        }
        nArray[n] = this.text.length();
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(n, bl));
    }

    Point getLocationInPixels(int n, boolean bl) {
        this.computeRuns();
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        long l = OS.pango_layout_get_text(this.layout);
        int n3 = (int)(OS.g_utf16_offset_to_pointer(l, n) - l);
        int n4 = C.strlen(l);
        n3 = Math.min(n3, n4);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, n3, pangoRectangle);
        int n5 = bl ? pangoRectangle.x + pangoRectangle.width : pangoRectangle.x;
        int n6 = pangoRectangle.y;
        n5 = OS.PANGO_PIXELS(n5);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n5 = this.width() - n5;
        }
        return new Point(n5 += Math.min(this.indent, this.wrapIndent), OS.PANGO_PIXELS(n6) + this.getScaledVerticalIndent());
    }

    public int getNextOffset(int n, int n2) {
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (0 > n || n > n4) {
            SWT.error(6);
        }
        if (bl) {
            if (n == n4) {
                return n4;
            }
        } else if (n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        long[] lArray = new long[1];
        int[] nArray = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, lArray, nArray);
        if (lArray[0] == 0L) {
            return n + n3;
        }
        long l = OS.pango_layout_get_text(this.layout);
        int n6 = (int)OS.g_utf16_offset_to_utf8_offset(l, this.translateOffset(n));
        int n7 = (int)OS.g_utf8_strlen(l, -1L);
        n6 += n3;
        PangoLogAttr pangoLogAttr = new PangoLogAttr();
        while (0 <= n6 && n6 <= n7) {
            OS.memmove(pangoLogAttr, lArray[0] + (long)(n6 * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
            boolean bl2 = false;
            boolean bl3 = false;
            if ((n2 & 2) != 0 && pangoLogAttr.is_cursor_position) {
                bl2 = true;
            }
            if ((n2 & 4) != 0) {
                if (bl) {
                    if (pangoLogAttr.is_word_end) {
                        bl2 = true;
                    }
                } else if (pangoLogAttr.is_word_start) {
                    bl2 = true;
                }
            }
            if ((n2 & 0x10) != 0) {
                if (pangoLogAttr.is_word_start) {
                    bl2 = true;
                }
                if (pangoLogAttr.is_sentence_end) {
                    bl2 = true;
                }
            }
            if ((n2 & 8) != 0) {
                if (pangoLogAttr.is_word_end) {
                    bl2 = true;
                }
                if (pangoLogAttr.is_sentence_start) {
                    bl2 = true;
                }
            }
            if (bl) {
                if (n6 == n7) {
                    bl3 = true;
                }
            } else if (n6 == 0) {
                bl3 = true;
            }
            if (bl2 || bl3) {
                int n8 = (int)OS.g_utf8_offset_to_utf16_offset(l, n6);
                if (bl2 && this.invalidOffsets != null) {
                    for (int i = 0; i < this.invalidOffsets.length; ++i) {
                        if (n8 != this.invalidOffsets[i]) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (bl2 || bl3) {
                    n = this.untranslateOffset(n8);
                    break;
                }
            }
            n6 += n3;
        }
        OS.g_free(lArray[0]);
        return Math.min(Math.max(0, n), n4);
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), nArray);
    }

    int getOffsetInPixels(Point point, int[] nArray) {
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        return this.getOffset(new Point(n, n2), nArray);
    }

    int getOffsetInPixels(int n, int n2, int[] nArray) {
        long l;
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        n -= Math.min(this.indent, this.wrapIndent);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            n = this.width() - n;
        }
        if ((l = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        PangoRectangle pangoRectangle = new PangoRectangle();
        do {
            this.metricsAdapter.pango_layout_iter_get_line_extents(l, null, pangoRectangle);
            pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
            pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
            if (pangoRectangle.y > n2 || n2 >= pangoRectangle.y + pangoRectangle.height) continue;
            pangoRectangle.x = OS.PANGO_PIXELS(pangoRectangle.x);
            pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
            if (n >= pangoRectangle.x + pangoRectangle.width) {
                n = pangoRectangle.x + pangoRectangle.width - 1;
            }
            if (n >= pangoRectangle.x) break;
            n = pangoRectangle.x;
            break;
        } while (OS.pango_layout_iter_next_line(l));
        OS.pango_layout_iter_free(l);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.pango_layout_xy_to_index(this.layout, n * 1024, n2 * 1024, nArray2, nArray3);
        long l2 = OS.pango_layout_get_text(this.layout);
        int n3 = (int)OS.g_utf16_pointer_to_offset(l2, l2 + (long)nArray2[0]);
        if (nArray != null) {
            nArray[0] = nArray3[0];
            if (nArray3[0] != 0) {
                nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l2, OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray2[0]) + (long)nArray3[0]) - n3;
            }
        }
        return this.untranslateOffset(n3);
    }

    public int getOrientation() {
        this.checkLayout();
        int n = OS.pango_context_get_base_dir(this.context);
        return n == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int n, int n2) {
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            nArray[n++] = this.styles[i].start;
            nArray[n++] = this.styles[i + 1].start - 1;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return this.text;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return this.text;
            }
        }
        char[] cArray = new char[n3];
        this.text.getChars(0, n3, cArray, 0);
        char[] cArray2 = new char[n3 + n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n5 < n3) {
            if (n6 < n4 && n5 == this.segments[n6]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
                cArray2[n5 + n6++] = n;
                continue;
            }
            cArray2[n5 + n6] = cArray[n5++];
        }
        while (n6 < n4) {
            this.segments[n6] = n5;
            n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
            cArray2[n5 + n6++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getSpacingInPixels());
    }

    int getSpacingInPixels() {
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public int getVerticalIndent() {
        this.checkLayout();
        return this.verticalIndentInPoints;
    }

    private int getScaledVerticalIndent() {
        if (this.verticalIndentInPoints == 0) {
            return this.verticalIndentInPoints;
        }
        return DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.verticalIndentInPoints);
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            StyleItem styleItem = this.styles[i];
            if (styleItem.start <= n) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            textStyleArray[n++] = this.styles[i].style;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        return this.getOrientation();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.layout == 0L;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
        int n3 = 1;
        switch (n) {
            case 16384: {
                n3 = bl ? 2 : 0;
                break;
            }
            case 131072: {
                n3 = bl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, n3);
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascentInPoints == n) {
            return;
        }
        this.freeRuns();
        this.ascentInPoints = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descentInPoints == n) {
            return;
        }
        this.freeRuns();
        this.descentInPoints = n;
    }

    public void setFixedLineMetrics(FontMetrics fontMetrics) {
        this.metricsAdapter.setFixedLineMetrics(this.getDevice(), fontMetrics);
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.freeRuns();
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : this.device.systemFont.handle);
    }

    public void setIndent(int n) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setIndentInPixels(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.indent = n;
        OS.pango_layout_set_indent(this.layout, (n - this.wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, bl);
    }

    public void setOrientation(int n) {
        int n2;
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n &= n3) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        int n4 = n2 = n == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == n2) {
            return;
        }
        this.freeRuns();
        OS.pango_context_set_base_dir(this.context, n2);
        OS.pango_layout_context_changed(this.layout);
        int n5 = OS.pango_layout_get_alignment(this.layout);
        if (n5 != 1) {
            n5 = n5 == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, n5);
        }
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        this.setSpacingInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setSpacingInPixels(int n) {
        OS.pango_layout_set_spacing(this.layout, n * 1024);
    }

    public void setVerticalIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.verticalIndentInPoints == n) {
            return;
        }
        this.verticalIndentInPoints = n;
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.segments[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n;
            for (n = 0; n < cArray.length && this.segmentsChars[n] == cArray[n]; ++n) {
            }
            if (n == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.checkLayout();
        int n7 = this.text.length();
        if (n7 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n7 - 1);
        n2 = Math.min(Math.max(0, n2), n7 - 1);
        if (n > 0 && TextLayout.isAlef(this.text.charAt(n)) && TextLayout.isLam(this.text.charAt(n - 1))) {
            --n;
        }
        if (n2 < n7 - 1 && TextLayout.isLam(this.text.charAt(n2)) && TextLayout.isAlef(this.text.charAt(n2 + 1))) {
            ++n2;
        }
        int n8 = -1;
        int n9 = this.stylesCount;
        while (n9 - n8 > 1) {
            int n10 = (n9 + n8) / 2;
            if (this.styles[n10 + 1].start > n) {
                n9 = n10;
                continue;
            }
            n8 = n10;
        }
        if (0 <= n9 && n9 < this.stylesCount) {
            StyleItem styleItem = this.styles[n9];
            if (styleItem.start == n && this.styles[n9 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        for (n6 = n5 = n9; n6 < this.stylesCount && this.styles[n6 + 1].start <= n2; ++n6) {
        }
        if (n5 == n6) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n6 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n11 = this.stylesCount + 2;
                if (n11 > this.styles.length) {
                    int n12 = Math.min(n11 + 1024, Math.max(64, n11 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n12];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n6 + 1, this.styles, n6 + 3, this.stylesCount - n6 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n11;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n6 + 1].start - 1) {
            ++n6;
        }
        if ((n4 = this.stylesCount + 1 - (n6 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n6, this.styles, n5 + 2, this.stylesCount - n6);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), nArray));
    }

    void setTabsInPixels(int[] nArray) {
        if (Arrays.equals(this.tabs, nArray)) {
            return;
        }
        this.tabs = nArray;
        if (nArray == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            long l = OS.pango_tab_array_new(nArray.length, true);
            if (l != 0L) {
                for (int i = 0; i < nArray.length; ++i) {
                    OS.pango_tab_array_set_tab(l, i, 0L, nArray[i]);
                }
                OS.pango_layout_set_tabs(this.layout, l);
                OS.pango_tab_array_free(l);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int n) {
        this.checkLayout();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        this.setWidthInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setWidthInPixels(int n) {
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
        this.setWidth();
    }

    void setWidth() {
        if (this.wrapWidth == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean bl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, bl ? 2 : 0);
        } else {
            int n = Math.min(this.indent, this.wrapIndent);
            OS.pango_layout_set_width(this.layout, (this.wrapWidth - n) * 1024);
        }
    }

    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n));
    }

    void setWrapIndentInPixels(int n) {
        if (this.wrapIndent == n) {
            return;
        }
        this.wrapIndent = n;
        OS.pango_layout_set_indent(this.layout, (this.indent - n) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    static final boolean isLam(int n) {
        return n == 1604;
    }

    static final boolean isAlef(int n) {
        switch (n) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        for (int i = 0; i < this.invalidOffsets.length && n >= this.invalidOffsets[i]; ++n, ++i) {
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (this.invalidOffsets == null) {
            return n;
        }
        for (n2 = 0; n2 < this.invalidOffsets.length && n > this.invalidOffsets[n2]; ++n2) {
        }
        return n - n2;
    }

    int width() {
        int n = OS.pango_layout_get_width(this.layout);
        if (n != -1) {
            return OS.PANGO_PIXELS(n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_pixel_size(this.layout, nArray, nArray2);
        return nArray[0];
    }

    public void setDefaultTabWidth(int n) {
    }

    private static class MetricsAdapter {
        private FontMetrics lineMetricsInPixels;

        private MetricsAdapter() {
        }

        private int wantToRealInPango(PangoRectangle pangoRectangle) {
            int n = this.lineMetricsInPixels.getHeight();
            int n2 = OS.PANGO_PIXELS(pangoRectangle.height);
            if (n2 == n) {
                return 0;
            }
            int n3 = 1024 * this.lineMetricsInPixels.getAscent();
            int n4 = -pangoRectangle.y;
            return n3 - n4;
        }

        private int wantToRealInPango(long l) {
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_line_get_extents(l, null, pangoRectangle);
            return this.wantToRealInPango(pangoRectangle);
        }

        public boolean isFixedMetrics() {
            return this.lineMetricsInPixels != null;
        }

        public FontMetrics getFixedLineMetrics(Device device) {
            if (this.lineMetricsInPixels == null) {
                return null;
            }
            FontMetrics fontMetrics = new FontMetrics();
            fontMetrics.ascentInPoints = DPIUtil.autoScaleDown((Drawable)device, this.lineMetricsInPixels.ascentInPoints);
            fontMetrics.descentInPoints = DPIUtil.autoScaleDown((Drawable)device, this.lineMetricsInPixels.descentInPoints);
            fontMetrics.averageCharWidthInPoints = DPIUtil.autoScaleDown((Drawable)device, this.lineMetricsInPixels.averageCharWidthInPoints);
            return fontMetrics;
        }

        public void setFixedLineMetrics(Device device, FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                this.lineMetricsInPixels = null;
                return;
            }
            FontMetrics fontMetrics2 = new FontMetrics();
            fontMetrics2.ascentInPoints = DPIUtil.autoScaleUp((Drawable)device, fontMetrics.ascentInPoints);
            fontMetrics2.descentInPoints = DPIUtil.autoScaleUp((Drawable)device, fontMetrics.descentInPoints);
            fontMetrics2.averageCharWidthInPoints = DPIUtil.autoScaleUp((Drawable)device, fontMetrics.averageCharWidthInPoints);
            this.lineMetricsInPixels = fontMetrics2;
        }

        private void validateLayout(long l) {
            if (OS.pango_layout_get_line_count(l) > 1) {
                SWT.error(5);
            }
        }

        public long gdk_pango_layout_get_clip_region(long l, int n, int n2, int[] nArray, int n3) {
            long l2;
            int n4 = 0;
            if (this.isFixedMetrics()) {
                this.validateLayout(l);
                l2 = OS.pango_layout_get_line(l, 0);
                n4 = OS.PANGO_PIXELS(this.wantToRealInPango(l2));
            }
            l2 = GDK.gdk_pango_layout_get_clip_region(l, n, n2 + n4, nArray, n3);
            if (this.isFixedMetrics()) {
                cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
                Cairo.cairo_region_get_extents(l2, cairo_rectangle_int_t2);
                cairo_rectangle_int_t2.y = n2;
                cairo_rectangle_int_t2.height = this.lineMetricsInPixels.getHeight();
                long l3 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
                Cairo.cairo_region_intersect(l2, l3);
                Cairo.cairo_region_destroy(l3);
            }
            return l2;
        }

        public void pango_cairo_show_layout(long l, long l2, double d, double d2) {
            int n = 0;
            if (this.isFixedMetrics()) {
                this.validateLayout(l2);
                long l3 = OS.pango_layout_get_line(l2, 0);
                n = OS.PANGO_PIXELS(this.wantToRealInPango(l3));
            }
            Cairo.cairo_move_to(l, d, d2 + (double)n);
            OS.pango_cairo_show_layout(l, l2);
        }

        public void pango_layout_get_size(long l, int[] nArray, int[] nArray2) {
            OS.pango_layout_get_size(l, nArray, nArray2);
            if (this.isFixedMetrics()) {
                this.validateLayout(l);
                nArray2[0] = this.lineMetricsInPixels.getHeight();
            }
        }

        public void pango_layout_iter_get_line_extents(long l, PangoRectangle pangoRectangle, PangoRectangle pangoRectangle2) {
            OS.pango_layout_iter_get_line_extents(l, pangoRectangle, pangoRectangle2);
            if (this.isFixedMetrics()) {
                if (pangoRectangle != null) {
                    SWT.error(5);
                }
                if (pangoRectangle2 != null) {
                    pangoRectangle2.height = 1024 * this.lineMetricsInPixels.getHeight();
                }
            }
        }

        public void pango_layout_line_get_extents(long l, PangoRectangle pangoRectangle, PangoRectangle pangoRectangle2) {
            OS.pango_layout_line_get_extents(l, pangoRectangle, pangoRectangle2);
            if (this.isFixedMetrics()) {
                if (pangoRectangle != null) {
                    SWT.error(5);
                }
                if (pangoRectangle2 != null) {
                    pangoRectangle2.height = 1024 * this.lineMetricsInPixels.getHeight();
                }
            }
        }
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + String.valueOf(this.style) + "}";
        }
    }
}

