/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long mask;
    public long surface;
    int transparentPixel = -1;
    GC memGC;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private int styleFlag = 0;
    private int currentDeviceZoom = 100;

    Image(Device device) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
    }

    public Image(Device device, int n, int n2) {
        super(device);
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        this.init(point.x, point.y);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        long l;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = image.type;
        this.imageDataProvider = image.imageDataProvider;
        this.imageFileNameProvider = image.imageFileNameProvider;
        this.styleFlag = image.styleFlag | n;
        this.currentDeviceZoom = image.currentDeviceZoom;
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        long l2 = image.surface;
        int n2 = this.width = image.width;
        int n3 = this.height = image.height;
        int n4 = Cairo.cairo_surface_get_content(l2) == 4096 ? 1 : 0;
        boolean bl = n4 == 0;
        this.surface = Cairo.cairo_image_surface_create(n4, n2, n3);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.getDeviceZoom() != this.currentDeviceZoom && DPIUtil.useCairoAutoScale()) {
            double d = (float)DPIUtil.getDeviceZoom() / 100.0f;
            Cairo.cairo_surface_set_device_scale(this.surface, d, d);
        }
        if ((l = Cairo.cairo_create(this.surface)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_operator(l, 1);
        Cairo.cairo_set_source_surface(l, l2, 0.0, 0.0);
        Cairo.cairo_paint(l);
        Cairo.cairo_destroy(l);
        if (n != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = Cairo.cairo_image_surface_get_stride(this.surface);
            long l3 = Cairo.cairo_image_surface_get_data(this.surface);
            if (OS.BIG_ENDIAN) {
                n8 = 0;
                n7 = 1;
                n6 = 2;
                n5 = 3;
            } else {
                n8 = 3;
                n7 = 2;
                n6 = 1;
                n5 = 0;
            }
            switch (n) {
                case 1: {
                    byte[] byArray = new byte[n9];
                    for (int i = 0; i < n3; ++i) {
                        C.memmove(byArray, l3 + (long)(i * n9), (long)n9);
                        int n10 = 0;
                        int n11 = 0;
                        while (n10 < n2) {
                            int n12 = byArray[n11 + n8] & 0xFF;
                            int n13 = byArray[n11 + n7] & 0xFF;
                            int n14 = byArray[n11 + n6] & 0xFF;
                            int n15 = byArray[n11 + n5] & 0xFF;
                            byArray[n11 + n8] = (byte)Math.round((double)n12 * 0.5);
                            byArray[n11 + n7] = (byte)Math.round((double)n13 * 0.5);
                            byArray[n11 + n6] = (byte)Math.round((double)n14 * 0.5);
                            byArray[n11 + n5] = (byte)Math.round((double)n15 * 0.5);
                            ++n10;
                            n11 += 4;
                        }
                        C.memmove(l3 + (long)(i * n9), byArray, (long)n9);
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n9];
                    for (int i = 0; i < n3; ++i) {
                        C.memmove(byArray, l3 + (long)(i * n9), (long)n9);
                        int n16 = 0;
                        int n17 = 0;
                        while (n16 < n2) {
                            int n18 = byArray[n17 + n8] & 0xFF;
                            int n19 = byArray[n17 + n7] & 0xFF;
                            int n20 = byArray[n17 + n6] & 0xFF;
                            int n21 = byArray[n17 + n5] & 0xFF;
                            if (bl && n18 != 0) {
                                n19 = (n19 * 255 + n18 / 2) / n18;
                                n20 = (n20 * 255 + n18 / 2) / n18;
                                n21 = (n21 * 255 + n18 / 2) / n18;
                            }
                            int n22 = n19 + n19 + n20 + n20 + n20 + n20 + n20 + n21 >> 3;
                            if (bl) {
                                n22 = n22 * n18 + 128;
                                n22 = n22 + (n22 >> 8) >> 8;
                            }
                            byte by = (byte)n22;
                            byArray[n17 + n5] = by;
                            byArray[n17 + n6] = by;
                            byArray[n17 + n7] = by;
                            ++n16;
                            n17 += 4;
                        }
                        C.memmove(l3 + (long)(i * n9), byArray, (long)n9);
                    }
                    break;
                }
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        Rectangle rectangle2 = DPIUtil.autoScaleUp(rectangle);
        this.init(rectangle2.width, rectangle2.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        imageData = DPIUtil.autoScaleUp(device, imageData);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        imageData = DPIUtil.autoScaleUp(device, imageData);
        imageData2 = DPIUtil.autoScaleUp(device, imageData2);
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        ImageData imageData = new ImageData(inputStream);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        imageData = DPIUtil.autoScaleUp(device, imageData);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        ImageData imageData = new ImageData(string);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        imageData = DPIUtil.autoScaleUp(device, imageData);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom<String> elementAtZoom = DPIUtil.validateAndGetImagePathAtZoom(imageFileNameProvider, this.currentDeviceZoom);
        if (elementAtZoom.zoom() == this.currentDeviceZoom) {
            this.initNative(elementAtZoom.element());
            if (this.surface == 0L) {
                ImageData imageData = new ImageData(elementAtZoom.element());
                this.init(imageData);
            }
        } else {
            ImageData imageData = new ImageData(elementAtZoom.element());
            ImageData imageData2 = DPIUtil.autoScaleImageData(device, imageData, elementAtZoom.zoom());
            this.init(imageData2);
        }
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom<ImageData> elementAtZoom = DPIUtil.validateAndGetImageDataAtZoom(imageDataProvider, this.currentDeviceZoom);
        ImageData imageData = DPIUtil.autoScaleImageData(device, elementAtZoom.element(), elementAtZoom.zoom());
        this.init(imageData);
        this.init();
    }

    public boolean internal_gtk_refreshImageForZoom() {
        return this.refreshImageForZoom();
    }

    boolean refreshImageForZoom() {
        int n;
        boolean bl = false;
        int n2 = DPIUtil.getDeviceZoom();
        if (this.imageFileNameProvider != null) {
            int n3 = n2;
            if (n3 != this.currentDeviceZoom) {
                DPIUtil.ElementAtZoom<String> elementAtZoom = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, n3);
                if (elementAtZoom.zoom() == n3) {
                    this.destroy();
                    this.initNative(elementAtZoom.element());
                    if (this.surface == 0L) {
                        ImageData imageData = new ImageData(elementAtZoom.element());
                        this.init(imageData);
                    }
                    this.init();
                    bl = true;
                } else {
                    this.destroy();
                    ImageData imageData = new ImageData(elementAtZoom.element());
                    ImageData imageData2 = DPIUtil.autoScaleImageData(this.device, imageData, elementAtZoom.zoom());
                    this.init(imageData2);
                    this.init();
                    bl = true;
                }
                this.currentDeviceZoom = n3;
            }
        } else if (this.imageDataProvider != null) {
            int n4 = n2;
            if (n4 != this.currentDeviceZoom) {
                DPIUtil.ElementAtZoom<ImageData> elementAtZoom = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, n4);
                this.destroy();
                ImageData imageData = DPIUtil.autoScaleImageData(this.device, elementAtZoom.element(), elementAtZoom.zoom());
                this.init(imageData);
                this.init();
                bl = true;
                this.currentDeviceZoom = n4;
            }
        } else if (!DPIUtil.useCairoAutoScale() && (n = n2) != this.currentDeviceZoom) {
            ImageData imageData = this.getImageDataAtCurrentZoom();
            this.destroy();
            ImageData imageData3 = DPIUtil.autoScaleImageData(this.device, imageData, n, this.currentDeviceZoom);
            this.init(imageData3);
            this.init();
            bl = true;
            this.currentDeviceZoom = n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        block6: {
            try {
                byte[] byArray = Converter.javaStringToCString(string);
                long l = GDK.gdk_pixbuf_new_from_file(byArray, null);
                if (l == 0L) break block6;
                try {
                    this.createFromPixbuf(0, l);
                }
                finally {
                    if (l != 0L) {
                        OS.g_object_unref(l);
                    }
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    void createFromPixbuf(int n, long l) {
        this.type = n;
        int n2 = GDK.gdk_pixbuf_get_width(l);
        int n3 = GDK.gdk_pixbuf_get_height(l);
        double d = (float)DPIUtil.getDeviceZoom() / 100.0f;
        this.width = (int)Math.round((double)n2 / d);
        this.height = (int)Math.round((double)n3 / d);
        int n4 = GDK.gdk_pixbuf_get_rowstride(l);
        long l2 = GDK.gdk_pixbuf_get_pixels(l);
        boolean bl = GDK.gdk_pixbuf_get_has_alpha(l);
        int n5 = bl ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create(n5, n2, n3);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.useCairoAutoScale()) {
            Cairo.cairo_surface_set_device_scale(this.surface, d, d);
        }
        long l3 = Cairo.cairo_image_surface_get_data(this.surface);
        int n6 = Cairo.cairo_image_surface_get_stride(this.surface);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (OS.BIG_ENDIAN) {
            n7 = 0;
            n8 = 1;
            n9 = 2;
            n10 = 3;
        } else {
            n7 = 3;
            n8 = 2;
            n9 = 1;
            n10 = 0;
        }
        byte[] byArray = new byte[n4];
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                C.memmove(byArray, l2 + (long)(i * n4), (long)n4);
                int n11 = 0;
                int n12 = 0;
                while (n11 < n2) {
                    int n13 = byArray[n12 + 3] & 0xFF;
                    int n14 = (byArray[n12 + 0] & 0xFF) * n13 + 128;
                    n14 = n14 + (n14 >> 8) >> 8;
                    int n15 = (byArray[n12 + 1] & 0xFF) * n13 + 128;
                    n15 = n15 + (n15 >> 8) >> 8;
                    int n16 = (byArray[n12 + 2] & 0xFF) * n13 + 128;
                    n16 = n16 + (n16 >> 8) >> 8;
                    byArray[n12 + n7] = (byte)n13;
                    byArray[n12 + n8] = (byte)n14;
                    byArray[n12 + n9] = (byte)n15;
                    byArray[n12 + n10] = (byte)n16;
                    ++n11;
                    n12 += 4;
                }
                C.memmove(l3 + (long)(i * n4), byArray, (long)n4);
            }
        } else {
            byte[] byArray2 = new byte[n6];
            for (int i = 0; i < n3; ++i) {
                C.memmove(byArray, l2 + (long)(i * n4), (long)n4);
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                while (n17 < n2) {
                    int n20 = byArray[n18 + 0] & 0xFF;
                    int n21 = byArray[n18 + 1] & 0xFF;
                    int n22 = byArray[n18 + 2] & 0xFF;
                    byArray2[n19 + n8] = (byte)n20;
                    byArray2[n19 + n9] = (byte)n21;
                    byArray2[n19 + n10] = (byte)n22;
                    ++n17;
                    n18 += 3;
                    n19 += 4;
                }
                C.memmove(l3 + (long)(i * n6), byArray2, (long)n6);
            }
        }
        Cairo.cairo_surface_mark_dirty(this.surface);
    }

    void createMask() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.width;
        int n9 = this.height;
        int n10 = Cairo.cairo_image_surface_get_stride(this.surface);
        long l = Cairo.cairo_image_surface_get_data(this.surface);
        if (OS.BIG_ENDIAN) {
            n7 = 0;
            n6 = 1;
            n5 = 2;
            n4 = 3;
            n3 = this.transparentPixel >> 24 & 0xFF;
            n2 = this.transparentPixel >> 16 & 0xFF;
            n = this.transparentPixel >> 8 & 0xFF;
        } else {
            n7 = 3;
            n6 = 2;
            n5 = 1;
            n4 = 0;
            n3 = this.transparentPixel >> 16 & 0xFF;
            n2 = this.transparentPixel >> 8 & 0xFF;
            n = this.transparentPixel >> 0 & 0xFF;
        }
        byte[] byArray = new byte[n10 * n9];
        C.memmove(byArray, l, (long)byArray.length);
        int n11 = 0;
        for (int i = 0; i < n9; ++i) {
            int n12 = 0;
            while (n12 < n8) {
                int n13 = byArray[n11 + n7] & 0xFF;
                int n14 = byArray[n11 + n6] & 0xFF;
                int n15 = byArray[n11 + n5] & 0xFF;
                int n16 = byArray[n11 + n4] & 0xFF;
                if (n14 == n3 && n15 == n2 && n16 == n) {
                    n16 = 0;
                    n15 = 0;
                    n14 = 0;
                    n13 = 0;
                } else {
                    n13 = 255;
                }
                byArray[n11 + n7] = (byte)n13;
                byArray[n11 + n6] = (byte)n14;
                byArray[n11 + n5] = (byte)n15;
                byArray[n11 + n4] = (byte)n16;
                ++n12;
                n11 += 4;
            }
        }
        C.memmove(l, byArray, (long)byArray.length);
    }

    void createSurface() {
        if (this.surface != 0L) {
            return;
        }
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0L;
        this.surface = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.surface == image.surface;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    @Deprecated
    public Rectangle getBoundsInPixels() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    @Deprecated
    public ImageData getImageDataAtCurrentZoom() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        long l = ImageList.convertSurface(this);
        int n5 = Cairo.cairo_image_surface_get_format(l);
        int n6 = Cairo.cairo_image_surface_get_width(l);
        int n7 = Cairo.cairo_image_surface_get_height(l);
        int n8 = Cairo.cairo_image_surface_get_stride(l);
        long l2 = Cairo.cairo_image_surface_get_data(l);
        boolean bl2 = bl = n5 == 0;
        if (OS.BIG_ENDIAN) {
            n4 = 0;
            n3 = 1;
            n2 = 2;
            n = 3;
        } else {
            n4 = 3;
            n3 = 2;
            n2 = 1;
            n = 0;
        }
        byte[] byArray = new byte[n8 * n7];
        C.memmove(byArray, l2, (long)byArray.length);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n6, n7, 32, paletteData, 4, byArray);
        if (bl) {
            imageData.alphaData = new byte[n6 * n7];
            byte[] byArray2 = imageData.alphaData;
            int n9 = 0;
            int n10 = 0;
            for (int i = 0; i < n7; ++i) {
                int n11 = 0;
                while (n11 < n6) {
                    int n12 = byArray[n9 + n4] & 0xFF;
                    int n13 = byArray[n9 + n3] & 0xFF;
                    int n14 = byArray[n9 + n2] & 0xFF;
                    int n15 = byArray[n9 + n] & 0xFF;
                    byArray[n9 + 0] = 0;
                    byArray2[n10++] = (byte)n12;
                    if (n12 != 0) {
                        byArray[n9 + 1] = (byte)((n13 * 255 + n12 / 2) / n12);
                        byArray[n9 + 2] = (byte)((n14 * 255 + n12 / 2) / n12);
                        byArray[n9 + 3] = (byte)((n15 * 255 + n12 / 2) / n12);
                    }
                    ++n11;
                    n9 += 4;
                }
            }
        } else {
            int n16 = 0;
            for (int i = 0; i < n7; ++i) {
                int n17 = 0;
                while (n17 < n6) {
                    byte by = byArray[n16 + n3];
                    byte by2 = byArray[n16 + n2];
                    byte by3 = byArray[n16 + n];
                    byArray[n16 + 0] = 0;
                    byArray[n16 + 1] = by;
                    byArray[n16 + 2] = by2;
                    byArray[n16 + 3] = by3;
                    ++n17;
                    n16 += 4;
                }
            }
        }
        Cairo.cairo_surface_destroy(l);
        return imageData;
    }

    public ImageData getImageData(int n) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n == this.currentDeviceZoom) {
            return this.getImageDataAtCurrentZoom();
        }
        if (this.imageDataProvider != null) {
            DPIUtil.ElementAtZoom<ImageData> elementAtZoom = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, n);
            return DPIUtil.autoScaleImageData(this.device, elementAtZoom.element(), n, elementAtZoom.zoom());
        }
        if (this.imageFileNameProvider != null) {
            DPIUtil.ElementAtZoom<String> elementAtZoom = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, n);
            return DPIUtil.autoScaleImageData(this.device, new ImageData(elementAtZoom.element()), n, elementAtZoom.zoom());
        }
        return DPIUtil.autoScaleImageData(this.device, this.getImageDataAtCurrentZoom(), n, this.currentDeviceZoom);
    }

    public static Image gtk_new(Device device, int n, long l, long l2) {
        Image image = new Image(device);
        image.type = n;
        image.surface = l;
        image.mask = l2;
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int n, long l) {
        Image image = new Image(device);
        image.createFromPixbuf(n, l);
        image.type = n;
        return image;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return (int)this.surface;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.surface = GTK.GTK4 ? Cairo.cairo_image_surface_create(1, n, n2) : GDK.gdk_window_create_similar_surface(GDK.gdk_get_default_root_window(), 4096, n, n2);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.useCairoAutoScale()) {
            this.currentDeviceZoom = 100;
            Cairo.cairo_surface_set_device_scale(this.surface, 1.0, 1.0);
        } else {
            this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        }
        long l = Cairo.cairo_create(this.surface);
        if (l == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_source_rgb(l, 1.0, 1.0, 1.0);
        Cairo.cairo_rectangle(l, 0.0, 0.0, n, n2);
        Cairo.cairo_fill(l);
        Cairo.cairo_destroy(l);
        this.width = n;
        this.height = n2;
    }

    void init(ImageData imageData) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (imageData == null) {
            SWT.error(4);
        }
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n7 = imageData.width;
        int n8 = imageData.height;
        double d = (float)DPIUtil.getDeviceZoom() / 100.0f;
        this.width = (int)Math.round((double)n7 / d);
        this.height = (int)Math.round((double)n8 / d);
        boolean bl = imageData.transparentPixel != -1 || imageData.alpha != -1 || imageData.maskData != null || imageData.alphaData != null;
        int n9 = bl ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create(n9, n7, n8);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.useCairoAutoScale()) {
            Cairo.cairo_surface_set_device_scale(this.surface, d, d);
        }
        int n10 = Cairo.cairo_image_surface_get_stride(this.surface);
        long l = Cairo.cairo_image_surface_get_data(this.surface);
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 32;
        if (OS.BIG_ENDIAN) {
            n11 = 0;
            n12 = 1;
            n13 = 2;
            n14 = 3;
            n6 = 65280;
            n5 = 0xFF0000;
            n4 = -16777216;
            n3 = 1;
        } else {
            n11 = 3;
            n12 = 2;
            n13 = 1;
            n14 = 0;
            n6 = 0xFF0000;
            n5 = 65280;
            n4 = 255;
            n3 = 0;
        }
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != n15 || n10 != imageData.bytesPerLine || paletteData.redMask != n6 || paletteData.greenMask != n5 || paletteData.blueMask != n4 || n3 != imageData.getByteOrder()) {
            byArray = new byte[n10 * n8];
            if (paletteData.isDirect) {
                ImageData.blit(imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n7, n8, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, byArray, n15, n10, n3, n7, n8, n6, n5, n4, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                n2 = rGBArray.length;
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                byte[] byArray4 = new byte[n2];
                for (n = 0; n < rGBArray.length; ++n) {
                    RGB rGB = rGBArray[n];
                    if (rGB == null) continue;
                    byArray2[n] = (byte)rGB.red;
                    byArray3[n] = (byte)rGB.green;
                    byArray4[n] = (byte)rGB.blue;
                }
                ImageData.blit(n7, n8, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), byArray2, byArray3, byArray4, byArray, n15, n10, n3, n6, n5, n4);
            }
        }
        boolean bl2 = imageData.getTransparencyType() == 2;
        int n16 = this.type = bl2 ? 1 : 0;
        if (bl2 || imageData.transparentPixel != -1) {
            if (imageData.transparentPixel != -1) {
                RGB rGB = null;
                if (paletteData.isDirect) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                }
                if (rGB != null) {
                    this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                }
            }
            ImageData imageData2 = imageData.getTransparencyMask();
            int n17 = 0;
            for (int i = 0; i < n8; ++i) {
                int n18 = 0;
                while (n18 < n7) {
                    n = imageData2.getPixel(n18, i) == 0 ? 0 : 255;
                    int n19 = (byArray[n17 + n12] & 0xFF) * n + 128;
                    n19 = n19 + (n19 >> 8) >> 8;
                    int n20 = (byArray[n17 + n13] & 0xFF) * n + 128;
                    n20 = n20 + (n20 >> 8) >> 8;
                    int n21 = (byArray[n17 + n14] & 0xFF) * n + 128;
                    n21 = n21 + (n21 >> 8) >> 8;
                    byArray[n17 + n11] = (byte)n;
                    byArray[n17 + n12] = (byte)n19;
                    byArray[n17 + n13] = (byte)n20;
                    byArray[n17 + n14] = (byte)n21;
                    ++n18;
                    n17 += 4;
                }
            }
        } else if (imageData.alpha != -1) {
            n2 = imageData.alpha;
            int n22 = 0;
            for (int i = 0; i < n8; ++i) {
                int n23 = 0;
                while (n23 < n7) {
                    n = (byArray[n22 + n12] & 0xFF) * n2 + 128;
                    n = n + (n >> 8) >> 8;
                    int n24 = (byArray[n22 + n13] & 0xFF) * n2 + 128;
                    n24 = n24 + (n24 >> 8) >> 8;
                    int n25 = (byArray[n22 + n14] & 0xFF) * n2 + 128;
                    n25 = n25 + (n25 >> 8) >> 8;
                    byArray[n22 + n11] = (byte)n2;
                    byArray[n22 + n12] = (byte)n;
                    byArray[n22 + n13] = (byte)n24;
                    byArray[n22 + n14] = (byte)n25;
                    ++n23;
                    n22 += 4;
                }
            }
        } else if (imageData.alphaData != null) {
            byte[] byArray5 = imageData.alphaData;
            int n26 = 0;
            for (int i = 0; i < n8; ++i) {
                int n27 = 0;
                while (n27 < n7) {
                    n = byArray5[i * n7 + n27] & 0xFF;
                    int n28 = (byArray[n26 + n12] & 0xFF) * n + 128;
                    n28 = n28 + (n28 >> 8) >> 8;
                    int n29 = (byArray[n26 + n13] & 0xFF) * n + 128;
                    n29 = n29 + (n29 >> 8) >> 8;
                    int n30 = (byArray[n26 + n14] & 0xFF) * n + 128;
                    n30 = n30 + (n30 >> 8) >> 8;
                    byArray[n26 + n11] = (byte)n;
                    byArray[n26 + n12] = (byte)n28;
                    byArray[n26 + n13] = (byte)n29;
                    byArray[n26 + n14] = (byte)n30;
                    ++n27;
                    n26 += 4;
                }
            }
        }
        C.memmove(l, byArray, (long)(n10 * n8));
        Cairo.cairo_surface_mark_dirty(this.surface);
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long l = Cairo.cairo_create(this.surface);
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.device = this.device;
            gCData.foregroundRGBA = this.device.COLOR_BLACK.handle;
            gCData.backgroundRGBA = this.device.COLOR_WHITE.handle;
            gCData.font = this.device.systemFont;
            gCData.image = this;
        }
        return l;
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        Cairo.cairo_destroy(l);
    }

    @Override
    public boolean isDisposed() {
        return this.surface == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (this.imageFileNameProvider != null) {
            return "Image {" + this.imageFileNameProvider.getImagePath(100) + "}";
        }
        return "Image {" + this.surface + "}";
    }
}

