/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            transferDataArray[i] = new TransferData();
            transferDataArray[i].type = nArray[i];
        }
        return transferDataArray;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        for (int i = 0; i < nArray.length; ++i) {
            if (transferData.type != (long)nArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        byte[] byArray;
        transferData.result = 0;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((byArray = (byte[])object).length == 0) {
            return;
        }
        long l = OS.g_malloc(byArray.length);
        if (l == 0L) {
            return;
        }
        C.memmove(l, byArray, (long)byArray.length);
        transferData.length = byArray.length;
        transferData.format = 8;
        transferData.pValue = l;
        transferData.result = 1;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int n = transferData.format * transferData.length / 8;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, transferData.pValue, (long)n);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object instanceof byte[] && ((byte[])object).length > 0;
    }
}

