/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextLineSpacingProvider;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    StyledTextLineSpacingProvider lineSpacingProvider;
    boolean lineSpacingComputing;
    private FontMetrics fixedLineMetrics;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int averageCharWidth;
    int tabLength;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    LineSizeInfo[] lineSizes;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    float averageLineHeight;
    int linesInAverageLineHeight;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    boolean hasLinks;
    boolean fixedPitch;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 300;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;
    static final int TABSTOPS = 64;
    static final int WRAP_INDENT = 128;
    static final int SEGMENT_CHARS = 256;
    static final int VERTICAL_INDENT = 512;

    static int cap(TextLayout textLayout, int n) {
        if (textLayout == null) {
            return n;
        }
        return Math.min(textLayout.getText().length() - 1, Math.max(0, n));
    }

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] nArray, StyleRange[] styleRangeArray, int n, int n2, int n3) {
        int n4;
        int n5 = this.styleCount << 1;
        StyleRange styleRange = null;
        int n6 = 0;
        int n7 = 0;
        if (n3 < n5) {
            styleRange = this.styles[n3 >> 1];
            n6 = this.ranges[n3];
            n7 = this.ranges[n3 + 1];
        }
        if (n5 + (n4 = n - (n3 - n2)) >= this.ranges.length) {
            int[] nArray2 = new int[this.ranges.length + n4 + 64];
            System.arraycopy(this.ranges, 0, nArray2, 0, n2);
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + (n4 >> 1) + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n2 >> 1);
            if (n5 > n3) {
                System.arraycopy(this.ranges, n3, nArray2, n2 + n, n5 - n3);
                System.arraycopy(this.styles, n3 >> 1, styleRangeArray2, n2 + n >> 1, this.styleCount - (n3 >> 1));
            }
            this.ranges = nArray2;
            this.styles = styleRangeArray2;
        } else if (n5 > n3) {
            System.arraycopy(this.ranges, n3, this.ranges, n2 + n, n5 - n3);
            System.arraycopy(this.styles, n3 >> 1, this.styles, n2 + n >> 1, this.styleCount - (n3 >> 1));
        }
        int n8 = n2;
        for (int i = 0; i < n; i += 2) {
            if (n8 > 0 && this.ranges[n8 - 2] + this.ranges[n8 - 1] == nArray[i] && styleRangeArray[i >> 1].similarTo(this.styles[n8 - 2 >> 1])) {
                int n9 = n8 - 1;
                this.ranges[n9] = this.ranges[n9] + nArray[i + 1];
                continue;
            }
            this.styles[n8 >> 1] = styleRangeArray[i >> 1];
            this.ranges[n8++] = nArray[i];
            this.ranges[n8++] = nArray[i + 1];
        }
        if (styleRange != null && this.ranges[n8 - 2] + this.ranges[n8 - 1] == n6 && styleRange.similarTo(this.styles[n8 - 2 >> 1])) {
            int n10 = n8 - 1;
            this.ranges[n10] = this.ranges[n10] + n7;
            n3 += 2;
            n += 2;
        }
        if (n5 > n3) {
            System.arraycopy(this.ranges, n2 + n, this.ranges, n8, n5 - n3);
            System.arraycopy(this.styles, n2 + n >> 1, this.styles, n8 >> 1, this.styleCount - (n3 >> 1));
        }
        n4 = n8 - n2 - (n3 - n2);
        this.styleCount += n4 >> 1;
        return n4;
    }

    int addMerge(StyleRange[] styleRangeArray, int n, int n2, int n3) {
        int n4 = n - (n3 - n2);
        StyleRange styleRange = null;
        if (n3 < this.styleCount) {
            styleRange = this.styles[n3];
        }
        if (this.styleCount + n4 >= this.styles.length) {
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + n4 + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n2);
            if (this.styleCount > n3) {
                System.arraycopy(this.styles, n3, styleRangeArray2, n2 + n, this.styleCount - n3);
            }
            this.styles = styleRangeArray2;
        } else if (this.styleCount > n3) {
            System.arraycopy(this.styles, n3, this.styles, n2 + n, this.styleCount - n3);
        }
        int n5 = n2;
        for (int i = 0; i < n; ++i) {
            StyleRange styleRange2 = styleRangeArray[i];
            if (n5 > 0) {
                StyleRange styleRange3 = this.styles[n5 - 1];
                if (styleRange3.start + styleRange3.length == styleRange2.start && styleRange2.similarTo(styleRange3)) {
                    styleRange3.length += styleRange2.length;
                    continue;
                }
            }
            this.styles[n5++] = styleRange2;
        }
        StyleRange styleRange4 = this.styles[n5 - 1];
        if (styleRange != null && styleRange4.start + styleRange4.length == styleRange.start && styleRange.similarTo(styleRange4)) {
            styleRange4.length += styleRange.length;
            ++n3;
            ++n;
        }
        if (this.styleCount > n3) {
            System.arraycopy(this.styles, n2 + n, this.styles, n5, this.styleCount - n3);
        }
        n4 = n5 - n2 - (n3 - n2);
        this.styleCount += n4;
        return n4;
    }

    void calculate(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 > this.lineSizes.length) {
            return;
        }
        int n4 = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        for (int i = n; i < n3; ++i) {
            LineSizeInfo lineSizeInfo = this.getLineSize(i);
            if (lineSizeInfo.needsRecalculateSize()) {
                TextLayout textLayout = this.getTextLayout(i);
                Rectangle rectangle = textLayout.getBounds();
                lineSizeInfo.width = rectangle.width + n4;
                lineSizeInfo.height = rectangle.height;
                this.averageLineHeight += (float)((lineSizeInfo.height - Math.round(this.averageLineHeight)) / ++this.linesInAverageLineHeight);
                this.disposeTextLayout(textLayout);
            }
            if (lineSizeInfo.width <= this.maxWidth) continue;
            this.maxWidth = lineSizeInfo.width;
            this.maxWidthLineIndex = i;
        }
    }

    LineSizeInfo getLineSize(int n) {
        if (this.lineSizes[n] == null) {
            this.lineSizes[n] = new LineSizeInfo();
        }
        return this.lineSizes[n];
    }

    void calculateClientArea() {
        int n = Math.max(0, this.styledText.getTopIndex());
        int n2 = this.content.getLineCount();
        int n3 = this.styledText.getClientArea().height;
        for (int i = 0; n3 > i && n2 > n && this.lineSizes.length > n; i += this.lineSizes[n++].height) {
            this.calculate(n, 1);
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object;
                int n;
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long l = System.currentTimeMillis();
                for (n = 0; n < StyledTextRenderer.this.lineCount; ++n) {
                    object = StyledTextRenderer.this.getLineSize(n);
                    if (!((LineSizeInfo)object).needsRecalculateSize()) continue;
                    StyledTextRenderer.this.calculate(n, 1);
                    if (System.currentTimeMillis() - l > 50L) break;
                }
                if (n < StyledTextRenderer.this.lineCount) {
                    object = StyledTextRenderer.this.styledText.getDisplay();
                    ((Display)object).asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    object = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (object != null) {
                        ((ScrollBar)object).setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            LineInfo lineInfo = this.lines[i];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFFFE;
            lineInfo.background = null;
            if (lineInfo.flags != 0) continue;
            this.lines[i] = null;
        }
    }

    void clearLineStyle(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            LineInfo lineInfo = this.lines[i];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFD31;
            if (lineInfo.flags != 0) continue;
            this.lines[i] = null;
        }
    }

    void copyInto(StyledTextRenderer styledTextRenderer) {
        int n;
        Object[] objectArray;
        if (this.ranges != null) {
            styledTextRenderer.ranges = new int[this.styleCount << 1];
            objectArray = styledTextRenderer.ranges;
            System.arraycopy(this.ranges, 0, objectArray, 0, objectArray.length);
        }
        if (this.styles != null) {
            styledTextRenderer.styles = new StyleRange[this.styleCount];
            objectArray = styledTextRenderer.styles;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = (int)((StyleRange)this.styles[n].clone());
            }
            styledTextRenderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            styledTextRenderer.lines = new LineInfo[this.lineCount];
            objectArray = styledTextRenderer.lines;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = (int)new LineInfo(this.lines[n]);
            }
            styledTextRenderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout textLayout) {
        if (this.layouts != null) {
            for (TextLayout textLayout2 : this.layouts) {
                if (textLayout2 != textLayout) continue;
                return;
            }
        }
        textLayout.dispose();
    }

    void drawBullet(Bullet bullet, GC gC, int n, int n2, int n3, int n4, int n5) {
        Font font;
        StyleRange styleRange = bullet.style;
        GlyphMetrics glyphMetrics = styleRange.metrics;
        Color color = styleRange.foreground;
        if (color != null) {
            gC.setForeground(color);
        }
        if ((font = styleRange.font) != null) {
            gC.setFont(font);
        }
        Object object = "";
        int n6 = bullet.type & 0xF;
        switch (n6) {
            case 1: {
                object = "\u2022";
                break;
            }
            case 2: {
                object = String.valueOf(n3 + 1);
                break;
            }
            case 4: {
                object = String.valueOf((char)(n3 % 26 + 97));
                break;
            }
            case 8: {
                object = String.valueOf((char)(n3 % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            object = (String)object + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout textLayout = new TextLayout(display);
        textLayout.setText((String)object);
        textLayout.setAscent(n4);
        textLayout.setDescent(n5);
        styleRange = (StyleRange)styleRange.clone();
        styleRange.metrics = null;
        if (styleRange.font == null) {
            styleRange.font = this.getFont(styleRange.fontStyle);
        }
        textLayout.setStyle(styleRange, 0, ((String)object).length());
        int n7 = n + Math.max(0, glyphMetrics.width - textLayout.getBounds().width - 8);
        textLayout.draw(gC, n7, n2);
        textLayout.dispose();
    }

    private LineDrawInfo makeLineDrawInfo(int n) {
        TextLayout textLayout = this.getTextLayout(n);
        String string = this.content.getLine(n);
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = textLayout.getBounds().height;
        return new LineDrawInfo(n, textLayout, string, n2, n3);
    }

    int drawLines(int n, int n2, int n3, int n4, int n5, GC gC, Color color, Color color2) {
        LineDrawInfo lineDrawInfo;
        boolean bl;
        boolean bl2 = bl = this.fixedLineMetrics != null;
        if (bl) {
            LineDrawInfo lineDrawInfo22;
            ArrayList<LineDrawInfo> arrayList = new ArrayList<LineDrawInfo>();
            int n6 = n4;
            for (int i = n; n6 < n5 && i < n2; n6 += lineDrawInfo22.height, ++i) {
                lineDrawInfo22 = this.makeLineDrawInfo(i);
                arrayList.add(lineDrawInfo22);
            }
            n6 = n4;
            for (LineDrawInfo lineDrawInfo22 : arrayList) {
                this.drawLineBackground(lineDrawInfo22, n6, gC, color);
                n6 += lineDrawInfo22.height;
            }
            n6 = n4;
            for (LineDrawInfo lineDrawInfo22 : arrayList) {
                this.drawLineForeground(lineDrawInfo22, n3, n6, gC, color2);
                n6 += lineDrawInfo22.height;
            }
            for (LineDrawInfo lineDrawInfo22 : arrayList) {
                this.disposeTextLayout(lineDrawInfo22.layout);
            }
            return n6 - n4;
        }
        int n7 = n4;
        for (int i = n; n7 < n5 && i < n2; n7 += lineDrawInfo.height, ++i) {
            lineDrawInfo = this.makeLineDrawInfo(i);
            this.drawLineBackground(lineDrawInfo, n7, gC, color);
            this.drawLineForeground(lineDrawInfo, n3, n7, gC, color2);
            this.disposeTextLayout(lineDrawInfo.layout);
        }
        return n7 - n4;
    }

    private void drawLineBackground(LineDrawInfo lineDrawInfo, int n, GC gC, Color color) {
        Rectangle rectangle = this.styledText.getClientArea();
        Color color2 = this.getLineBackground(lineDrawInfo.index, null);
        StyledTextEvent styledTextEvent = this.styledText.getLineBackgroundData(lineDrawInfo.offset, lineDrawInfo.text);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color2 = styledTextEvent.lineBackground;
        }
        int n2 = lineDrawInfo.layout.getVerticalIndent();
        if (color2 != null) {
            if (n2 > 0) {
                gC.setBackground(color);
                gC.fillRectangle(rectangle.x, n, rectangle.width, n2);
            }
            gC.setBackground(color2);
            gC.fillRectangle(rectangle.x, n + n2, rectangle.width, lineDrawInfo.height - n2);
        } else {
            gC.setBackground(color);
            this.styledText.drawBackground(gC, rectangle.x, n, rectangle.width, lineDrawInfo.height);
        }
    }

    private void drawLineForeground(LineDrawInfo lineDrawInfo, int n, int n2, GC gC, Color color) {
        Object object;
        int n3;
        Object[] objectArray;
        int n4;
        Object object2;
        int n5 = lineDrawInfo.text.length();
        gC.setForeground(color);
        Point[] pointArray = this.intersectingRelativeNonEmptySelections(lineDrawInfo.offset, lineDrawInfo.offset + n5);
        if (this.styledText.getBlockSelection() || pointArray.length == 0) {
            lineDrawInfo.layout.draw(gC, n, n2);
        } else {
            object2 = this.styledText.getSelectionForeground();
            Color color2 = this.styledText.getSelectionBackground();
            n4 = (this.styledText.getStyle() & 0x10000) != 0 ? 65536 : 131072;
            objectArray = pointArray;
            n3 = objectArray.length;
            for (object = 0; object < n3; ++object) {
                Point point = objectArray[object];
                int n6 = Math.max(0, point.x);
                int n7 = Math.min(n5, point.y);
                int n8 = n4;
                if (point.x <= n5 && n5 < point.y) {
                    n8 |= 0x100000;
                }
                lineDrawInfo.layout.draw(gC, n, n2, n6, n7 - 1, (Color)object2, color2, n8);
            }
        }
        object2 = null;
        int n9 = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                n4 = lineDrawInfo.index - this.topIndex;
                if (0 <= n4 && n4 < 300) {
                    object2 = this.bullets[n4];
                    n9 = this.bulletsIndices[n4];
                }
            } else {
                Bullet bullet;
                Bullet[] bulletArray = this.bullets;
                int n10 = bulletArray.length;
                for (n3 = 0; n3 < n10 && (n9 = ((Bullet)(object2 = (bullet = bulletArray[n3]))).indexOf(lineDrawInfo.index)) == -1; ++n3) {
                }
            }
        }
        if (n9 != -1 && object2 != null) {
            FontMetrics fontMetrics = lineDrawInfo.layout.getLineMetrics(0);
            int n11 = fontMetrics.getAscent() + fontMetrics.getLeading();
            if (((Bullet)object2).type == 32) {
                ((Bullet)object2).style.start = lineDrawInfo.offset;
                this.styledText.paintObject(gC, n, n2, n11, fontMetrics.getDescent(), ((Bullet)object2).style, (Bullet)object2, n9);
            } else {
                this.drawBullet((Bullet)object2, gC, n, n2, n9, n11, fontMetrics.getDescent());
            }
        }
        TextStyle[] textStyleArray = lineDrawInfo.layout.getStyles();
        objectArray = null;
        for (n3 = 0; n3 < textStyleArray.length; ++n3) {
            if (textStyleArray[n3].metrics == null) continue;
            if (objectArray == null) {
                objectArray = lineDrawInfo.layout.getRanges();
            }
            object = objectArray[n3 << 1];
            reference var14_22 = objectArray[(n3 << 1) + 1] - object + true;
            Point point = lineDrawInfo.layout.getLocation((int)object, false);
            FontMetrics fontMetrics = lineDrawInfo.layout.getLineMetrics(lineDrawInfo.layout.getLineIndex((int)object));
            StyleRange styleRange = (StyleRange)((StyleRange)textStyleArray[n3]).clone();
            styleRange.start = object + lineDrawInfo.offset;
            styleRange.length = (int)var14_22;
            int n12 = fontMetrics.getAscent() + fontMetrics.getLeading();
            this.styledText.paintObject(gC, point.x + n, point.y + n2, n12, fontMetrics.getDescent(), styleRange, null, 0);
        }
    }

    private Point[] intersectingRelativeNonEmptySelections(int n, int n2) {
        int[] nArray = this.styledText.getSelectionRanges();
        int n3 = n2 - n;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < nArray.length; i += 2) {
            Point point = new Point(nArray[i] - n, nArray[i] + nArray[i + 1] - n);
            if (point.x == point.y || point.x > n3 || point.y < 0) continue;
            arrayList.add(point);
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    int getBaseline() {
        return this.ascent;
    }

    int getCachedLineHeight(int n) {
        return this.getLineHeight(n, false);
    }

    Font getFont(int n) {
        switch (n) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(n));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(n));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(n));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int n) {
        FontData[] fontDataArray;
        for (FontData fontData : fontDataArray = this.regularFont.getFontData()) {
            fontData.setStyle(n);
        }
        return fontDataArray;
    }

    int getHeight() {
        int n = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * n + this.styledText.topMargin + this.styledText.bottomMargin;
        }
        int n2 = 0;
        int n3 = this.styledText.getWrapWidth();
        for (int i = 0; i < this.lineCount; ++i) {
            LineSizeInfo lineSizeInfo = this.getLineSize(i);
            int n4 = lineSizeInfo.height;
            if (lineSizeInfo.needsRecalculateHeight()) {
                if (n3 > 0) {
                    int n5 = this.content.getLine(i).length();
                    n4 = (n5 * this.averageCharWidth / n3 + 1) * n;
                } else {
                    n4 = n;
                }
            }
            n2 += n4;
        }
        return n2 + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    boolean hasLink(int n) {
        String string;
        if (n == -1) {
            return false;
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        StyledTextEvent styledTextEvent = this.styledText.getLineStyleData(n3, string = this.content.getLine(n2));
        if (styledTextEvent != null) {
            StyleRange[] styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                int[] nArray = styledTextEvent.ranges;
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; i += 2) {
                        if (nArray[i] > n || n >= nArray[i] + nArray[i + 1] || !styleRangeArray[i >> 1].underline || styleRangeArray[i >> 1].underlineStyle != 4) continue;
                        return true;
                    }
                } else {
                    for (StyleRange styleRange : styleRangeArray) {
                        if (styleRange.start > n || n >= styleRange.start + styleRange.length || !styleRange.underline || styleRange.underlineStyle != 4) continue;
                        return true;
                    }
                }
            }
        } else if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 >= n4) {
                return false;
            }
            int n6 = this.ranges[n5];
            int n7 = this.ranges[n5 + 1];
            StyleRange styleRange = this.styles[n5 >> 1];
            if (n6 <= n && n < n6 + n7 && styleRange.underline && styleRange.underlineStyle == 4) {
                return true;
            }
        }
        return false;
    }

    int getLineAlignment(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 2) != 0) {
            return lineInfo.alignment;
        }
        return n2;
    }

    Color getLineBackground(int n, Color color) {
        if (this.lines == null) {
            return color;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 1) != 0) {
            return lineInfo.background;
        }
        return color;
    }

    Bullet getLineBullet(int n, Bullet bullet) {
        if (this.bullets == null) {
            return bullet;
        }
        if (this.bulletsIndices != null) {
            return bullet;
        }
        for (Bullet bullet2 : this.bullets) {
            if (bullet2.indexOf(n) == -1) continue;
            return bullet2;
        }
        return bullet;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int n) {
        return this.getLineHeight(n, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getLineHeight(int n, boolean bl) {
        LineSizeInfo lineSizeInfo = this.getLineSize(n);
        if (!lineSizeInfo.needsRecalculateHeight()) return lineSizeInfo.height;
        if (this.isVariableHeight(n)) {
            if (!bl) return Math.round(this.averageLineHeight);
            this.calculate(n, 1);
            return lineSizeInfo.height;
        } else {
            lineSizeInfo.height = this.getLineHeight() + this.getLineSpacing(n) + this.getLineVerticalIndent(n);
        }
        return lineSizeInfo.height;
    }

    private boolean isVariableHeight(int n) {
        if (this.styledText.isWordWrap()) {
            return true;
        }
        StyleRange[] styleRangeArray = this.getStylesForLine(n);
        if (styleRangeArray != null) {
            for (StyleRange styleRange : styleRangeArray) {
                if (!styleRange.isVariableHeight()) continue;
                return true;
            }
        }
        return false;
    }

    private int getLineSpacing(int n) {
        Integer n2;
        if (this.styledText.lineSpacing > 0) {
            return this.styledText.lineSpacing;
        }
        if (this.lineSpacingProvider != null && (n2 = this.lineSpacingProvider.getLineSpacing(n)) != null) {
            return n2;
        }
        return 0;
    }

    private StyleRange[] getStylesForLine(int n) {
        int n2 = this.styledText.getOffsetAtLine(n);
        int n3 = this.styledText.getLine(n).length();
        return this.getStyleRanges(n2, n3, false);
    }

    int getLineIndent(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 4) != 0) {
            return lineInfo.indent;
        }
        return n2;
    }

    int getLineVerticalIndent(int n) {
        if (this.lines == null) {
            return 0;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x200) != 0) {
            return lineInfo.verticalIndent;
        }
        return 0;
    }

    int getLineWrapIndent(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x80) != 0) {
            return lineInfo.wrapIndent;
        }
        return n2;
    }

    boolean getLineJustify(int n, boolean bl) {
        if (this.lines == null) {
            return bl;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 8) != 0) {
            return lineInfo.justify;
        }
        return bl;
    }

    int[] getLineTabStops(int n, int[] nArray) {
        if (this.lines == null) {
            return nArray;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x40) != 0) {
            return lineInfo.tabStops;
        }
        return nArray;
    }

    StyledTextLineSpacingProvider getLineSpacingProvider() {
        return this.lineSpacingProvider;
    }

    int getRangeIndex(int n, int n2, int n3) {
        if (this.styleCount == 0) {
            return 0;
        }
        if (this.ranges != null) {
            while (n3 - n2 > 2) {
                int n4 = (n3 + n2) / 2 / 2 * 2;
                int n5 = this.ranges[n4] + this.ranges[n4 + 1];
                if (n5 > n) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
        } else {
            while (n3 - n2 > 1) {
                int n6 = (n3 + n2) / 2;
                int n7 = this.styles[n6].start + this.styles[n6].length;
                if (n7 > n) {
                    n3 = n6;
                    continue;
                }
                n2 = n6;
            }
        }
        return n3;
    }

    int[] getRanges(int n, int n2) {
        int[] nArray;
        if (n2 == 0) {
            return null;
        }
        int n3 = n + n2 - 1;
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 >= n4) {
                return null;
            }
            if (this.ranges[n5] > n3) {
                return null;
            }
            int n6 = Math.min(n4 - 2, this.getRangeIndex(n3, n5 - 1, n4));
            if (this.ranges[n6] > n3) {
                n6 = Math.max(n5, n6 - 2);
            }
            nArray = new int[n6 - n5 + 2];
            System.arraycopy(this.ranges, n5, nArray, 0, nArray.length);
        } else {
            int n7 = this.getRangeIndex(n, -1, this.styleCount);
            if (n7 >= this.styleCount) {
                return null;
            }
            if (this.styles[n7].start > n3) {
                return null;
            }
            int n8 = Math.min(this.styleCount - 1, this.getRangeIndex(n3, n7 - 1, this.styleCount));
            if (this.styles[n8].start > n3) {
                n8 = Math.max(n7, n8 - 1);
            }
            nArray = new int[n8 - n7 + 1 << 1];
            int n9 = n7;
            int n10 = 0;
            while (n9 <= n8) {
                StyleRange styleRange = this.styles[n9];
                nArray[n10] = styleRange.start;
                nArray[n10 + 1] = styleRange.length;
                ++n9;
                n10 += 2;
            }
        }
        if (n > nArray[0]) {
            nArray[1] = nArray[0] + nArray[1] - n;
            nArray[0] = n;
        }
        if (n3 < nArray[nArray.length - 2] + nArray[nArray.length - 1] - 1) {
            nArray[nArray.length - 1] = n3 - nArray[nArray.length - 2] + 1;
        }
        return nArray;
    }

    StyleRange[] getStyleRanges(int n, int n2, boolean bl) {
        StyleRange[] styleRangeArray;
        if (n2 == 0) {
            return null;
        }
        int n3 = n + n2 - 1;
        if (this.ranges != null) {
            var6_5 = this.styleCount << 1;
            int n4 = this.getRangeIndex(n, -1, var6_5);
            if (n4 >= var6_5) {
                return null;
            }
            if (this.ranges[n4] > n3) {
                return null;
            }
            int n5 = Math.min(var6_5 - 2, this.getRangeIndex(n3, n4 - 1, var6_5));
            if (this.ranges[n5] > n3) {
                n5 = Math.max(n4, n5 - 2);
            }
            styleRangeArray = new StyleRange[(n5 - n4 >> 1) + 1];
            if (bl) {
                int n6 = n4;
                int n7 = 0;
                while (n6 <= n5) {
                    styleRangeArray[n7] = (StyleRange)this.styles[n6 >> 1].clone();
                    styleRangeArray[n7].start = this.ranges[n6];
                    styleRangeArray[n7].length = this.ranges[n6 + 1];
                    n6 += 2;
                    ++n7;
                }
            } else {
                System.arraycopy(this.styles, n4 >> 1, styleRangeArray, 0, styleRangeArray.length);
            }
        } else {
            var6_5 = this.getRangeIndex(n, -1, this.styleCount);
            if (var6_5 >= this.styleCount) {
                return null;
            }
            if (this.styles[var6_5].start > n3) {
                return null;
            }
            int n8 = Math.min(this.styleCount - 1, this.getRangeIndex(n3, var6_5 - 1, this.styleCount));
            if (this.styles[n8].start > n3) {
                n8 = Math.max(var6_5, n8 - 1);
            }
            styleRangeArray = new StyleRange[n8 - var6_5 + 1];
            System.arraycopy(this.styles, var6_5, styleRangeArray, 0, styleRangeArray.length);
        }
        if (bl || this.ranges == null) {
            StyleRange styleRange = styleRangeArray[0];
            if (n > styleRange.start) {
                styleRangeArray[0] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = styleRange.start + styleRange.length - n;
                styleRange.start = n;
            }
            styleRange = styleRangeArray[styleRangeArray.length - 1];
            if (n3 < styleRange.start + styleRange.length - 1) {
                styleRangeArray[styleRangeArray.length - 1] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = n3 - styleRange.start + 1;
            }
        }
        return styleRangeArray;
    }

    StyleRange getStyleRange(StyleRange styleRange) {
        if (styleRange.underline && styleRange.underlineStyle == 4) {
            this.hasLinks = true;
        }
        if (styleRange.start == 0 && styleRange.length == 0 && styleRange.fontStyle == 0) {
            return styleRange;
        }
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.length = 0;
        styleRange2.start = 0;
        styleRange2.fontStyle = 0;
        if (styleRange2.font == null) {
            styleRange2.font = this.getFont(styleRange.fontStyle);
        }
        return styleRange2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TextLayout getTextLayout(int n) {
        if (this.lineSpacingProvider == null) {
            return this.getTextLayout(n, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
        }
        int n2 = this.styledText.lineSpacing;
        Integer n3 = this.lineSpacingProvider.getLineSpacing(n);
        if (n3 != null && n3 >= 0) {
            n2 = n3;
        }
        if (this.isSameLineSpacing(n, n2)) {
            return this.getTextLayout(n, this.styledText.getOrientation(), this.styledText.getWrapWidth(), n2);
        }
        TextLayout textLayout = this.getTextLayout(n, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
        if (textLayout.getSpacing() != n2) {
            textLayout.setSpacing(n2);
            if (this.lineSpacingComputing) {
                return textLayout;
            }
            try {
                this.lineSpacingComputing = true;
                this.styledText.resetCache(n, 1);
                this.styledText.setCaretLocations();
                this.styledText.redraw();
            }
            finally {
                this.lineSpacingComputing = false;
            }
        }
        return textLayout;
    }

    boolean isSameLineSpacing(int n, int n2) {
        if (this.layouts == null) {
            return false;
        }
        int n3 = n - this.topIndex;
        if (0 <= n3 && n3 < this.layouts.length) {
            TextLayout textLayout = this.layouts[n3];
            return textLayout != null && !textLayout.isDisposed() && textLayout.getSpacing() == n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    TextLayout getTextLayout(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        IME iME;
        int n7;
        int n8;
        int n9;
        TextLayout textLayout = null;
        if (this.styledText != null) {
            int n10;
            int n11;
            int n12 = n11 = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || n11 != this.topIndex) {
                int n13;
                int n14;
                TextLayout[] textLayoutArray = new TextLayout[300];
                if (this.layouts != null) {
                    for (n14 = 0; n14 < this.layouts.length; ++n14) {
                        if (this.layouts[n14] == null) continue;
                        n13 = n14 + this.topIndex - n11;
                        if (0 <= n13 && n13 < textLayoutArray.length) {
                            textLayoutArray[n13] = this.layouts[n14];
                            continue;
                        }
                        this.layouts[n14].dispose();
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && n11 != this.topIndex) {
                    n14 = n11 - this.topIndex;
                    if (n14 > 0) {
                        if (n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, n14, this.bullets, 0, this.bullets.length - n14);
                            System.arraycopy(this.bulletsIndices, n14, this.bulletsIndices, 0, this.bulletsIndices.length - n14);
                        }
                        for (n9 = n13 = Math.max(0, this.bullets.length - n14); n9 < this.bullets.length; ++n9) {
                            this.bullets[n9] = null;
                        }
                    } else {
                        if (-n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -n14, this.bullets.length + n14);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -n14, this.bulletsIndices.length + n14);
                        }
                        n13 = Math.min(this.bullets.length, -n14);
                        for (n9 = 0; n9 < n13; ++n9) {
                            this.bullets[n9] = null;
                        }
                    }
                }
                this.topIndex = n11;
                this.layouts = textLayoutArray;
            }
            if (this.layouts != null && 0 <= (n10 = n - n11) && n10 < this.layouts.length) {
                textLayout = this.layouts[n10];
                if (textLayout != null) {
                    if (n < this.lineSizes.length && this.getLineSize(n).canLayout()) {
                        return textLayout;
                    }
                } else {
                    textLayout = this.layouts[n10] = new TextLayout(this.device);
                }
            }
        }
        if (textLayout == null) {
            textLayout = new TextLayout(this.device);
        }
        Object object2 = this.content.getLine(n);
        int n15 = this.content.getOffsetAtLine(n);
        int[] nArray = null;
        char[] cArray = null;
        n9 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 16384;
        int n19 = n2;
        boolean bl = false;
        int[] nArray2 = new int[]{this.tabWidth};
        Bullet bullet = null;
        int[] nArray3 = null;
        StyleRange[] styleRangeArray = null;
        int n20 = 0;
        int n21 = 0;
        StyledTextEvent styledTextEvent = null;
        if (this.styledText != null) {
            styledTextEvent = this.styledText.getBidiSegments(n15, (String)object2);
            if (styledTextEvent != null) {
                nArray = styledTextEvent.segments;
                cArray = styledTextEvent.segmentsChars;
            }
            styledTextEvent = this.styledText.getLineStyleData(n15, (String)object2);
            n9 = this.styledText.indent;
            n16 = this.styledText.wrapIndent;
            n18 = this.styledText.alignment;
            if (this.styledText.isAutoDirection()) {
                n19 = 0x6000000;
            } else if ((this.styledText.getStyle() & Integer.MIN_VALUE) != 0) {
                n19 = n2 == 0x4000000 ? 0x2000000 : 0x4000000;
            }
            bl = this.styledText.justify;
            if (this.styledText.tabs != null) {
                nArray2 = this.styledText.tabs;
            }
        }
        if (styledTextEvent != null) {
            int n22;
            n9 = styledTextEvent.indent;
            n17 = styledTextEvent.verticalIndent;
            n16 = styledTextEvent.wrapIndent;
            n18 = styledTextEvent.alignment;
            bl = styledTextEvent.justify;
            bullet = styledTextEvent.bullet;
            nArray3 = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
            if (styledTextEvent.tabStops != null) {
                nArray2 = styledTextEvent.tabStops;
            }
            if (styleRangeArray != null) {
                n21 = styleRangeArray.length;
                if (this.styledText.isFixedLineHeight()) {
                    for (n22 = 0; n22 < n21; ++n22) {
                        if (!styleRangeArray[n22].isVariableHeight()) continue;
                        this.styledText.hasStyleWithVariableHeight = true;
                        this.styledText.verticalScrollOffset = -1;
                        this.styledText.redraw();
                        break;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[300];
                this.bulletsIndices = new int[300];
            }
            if (0 <= (n22 = n - this.topIndex) && n22 < 300) {
                this.bullets[n22] = bullet;
                this.bulletsIndices[n22] = styledTextEvent.bulletIndex;
            }
        } else {
            Bullet[] bulletArray;
            if (this.lines != null && (bulletArray = this.lines[n]) != null) {
                if ((bulletArray.flags & 4) != 0) {
                    n9 = bulletArray.indent;
                }
                if ((bulletArray.flags & 0x200) != 0) {
                    n17 = bulletArray.verticalIndent;
                }
                if ((bulletArray.flags & 0x80) != 0) {
                    n16 = bulletArray.wrapIndent;
                }
                if ((bulletArray.flags & 2) != 0) {
                    n18 = bulletArray.alignment;
                }
                if ((bulletArray.flags & 8) != 0) {
                    bl = bulletArray.justify;
                }
                if ((bulletArray.flags & 0x20) != 0) {
                    nArray = bulletArray.segments;
                }
                if ((bulletArray.flags & 0x100) != 0) {
                    cArray = bulletArray.segmentsChars;
                }
                if ((bulletArray.flags & 0x40) != 0) {
                    nArray2 = bulletArray.tabStops;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                for (Bullet object3 : this.bullets) {
                    if (object3.indexOf(n) == -1) continue;
                    bullet = object3;
                    break;
                }
            }
            nArray3 = this.ranges;
            styleRangeArray = this.styles;
            n21 = this.styleCount;
            n20 = nArray3 != null ? this.getRangeIndex(n15, -1, n21 << 1) : this.getRangeIndex(n15, -1, n21);
        }
        if (bullet != null) {
            StyleRange styleRange = bullet.style;
            GlyphMetrics glyphMetrics = styleRange.metrics;
            n9 += glyphMetrics.width;
        }
        ArrayList<StyleEntry> arrayList = new ArrayList<StyleEntry>();
        int n23 = 0;
        int n24 = ((String)object2).length();
        if (styleRangeArray != null) {
            if (nArray3 != null) {
                int n25 = n21 << 1;
                for (n8 = n20; n8 < n25; n8 += 2) {
                    int n13;
                    if (n15 > nArray3[n8]) {
                        n7 = 0;
                        n13 = Math.min(n24, nArray3[n8 + 1] - n15 + nArray3[n8]);
                    } else {
                        n7 = nArray3[n8] - n15;
                        n13 = Math.min(n24, n7 + nArray3[n8 + 1]);
                    }
                    if (n7 < n24) {
                        if (n23 < n7) {
                            arrayList.add(new StyleEntry(null, n23, n7 - 1));
                        }
                        StyleRange n33 = this.getStyleRange(styleRangeArray[n8 >> 1]);
                        int n14 = Math.max(n7, Math.min(n24, n13 + 1));
                        if (n33.metrics != null && ((String)object2).substring(n7, n14).contains("\t")) {
                            object2 = ((String)object2).substring(0, n7) + ((String)object2).substring(n7, n14).replace('\t', ' ') + (n13 < ((String)object2).length() ? ((String)object2).substring(n13 + 1, ((String)object2).length()) : "");
                        }
                        arrayList.add(new StyleEntry(n33, n7, n13));
                        n23 = Math.max(n23, n13);
                        continue;
                    }
                    break;
                }
            } else {
                void n31;
                int i = n20;
                while (n31 < n21) {
                    if (n15 > styleRangeArray[n31].start) {
                        n8 = 0;
                        n7 = Math.min(n24, styleRangeArray[n31].length - n15 + styleRangeArray[n31].start);
                    } else {
                        n8 = styleRangeArray[n31].start - n15;
                        n7 = Math.min(n24, n8 + styleRangeArray[n31].length);
                    }
                    if (n8 < n24) {
                        if (n23 < n8) {
                            arrayList.add(new StyleEntry(null, n23, n8 - 1));
                        }
                        StyleRange styleRange = this.getStyleRange(styleRangeArray[n31]);
                        int n22 = Math.max(n8, Math.min(n24, n7 + 1));
                        if (styleRange.metrics != null && ((String)object2).substring(n8, n22).contains("\t")) {
                            object2 = ((String)object2).substring(0, n8) + ((String)object2).substring(n8, n22).replace('\t', ' ') + (n7 < ((String)object2).length() ? ((String)object2).substring(n7 + 1, ((String)object2).length()) : "");
                        }
                        arrayList.add(new StyleEntry(styleRange, n8, n7));
                        n23 = Math.max(n23, n7);
                        ++n31;
                        continue;
                    }
                    break;
                }
            }
        }
        if (n23 < n24) {
            arrayList.add(new StyleEntry(null, n23, n24));
        }
        textLayout.setFont(this.regularFont);
        textLayout.setAscent(this.ascent);
        textLayout.setDescent(this.descent);
        textLayout.setFixedLineMetrics(this.fixedLineMetrics);
        textLayout.setText((String)object2);
        textLayout.setOrientation(n2);
        textLayout.setSegments(nArray);
        textLayout.setSegmentsChars(cArray);
        textLayout.setWidth(n3);
        textLayout.setSpacing(n4);
        textLayout.setTabs(nArray2);
        textLayout.setDefaultTabWidth(this.tabLength);
        textLayout.setIndent(n9);
        textLayout.setVerticalIndent(n17);
        textLayout.setWrapIndent(n16);
        textLayout.setAlignment(n18);
        textLayout.setJustify(bl);
        textLayout.setTextDirection(n19);
        for (StyleEntry styleEntry : arrayList) {
            textLayout.setStyle(styleEntry.style, styleEntry.start, styleEntry.end);
        }
        if (this.styledText != null && this.styledText.ime != null && (n8 = (iME = this.styledText.ime).getCompositionOffset()) != -1) {
            int n25;
            n7 = iME.getCommitCount();
            n6 = iME.getText().length();
            if (n6 != n7 && (n25 = this.content.getLineAtOffset(n8)) == n) {
                int[] nArray4 = iME.getRanges();
                TextStyle[] textStyleArray = iME.getStyles();
                if (nArray4.length > 0) {
                    for (n5 = 0; n5 < textStyleArray.length; ++n5) {
                        var34_66 = nArray4[n5 * 2] - n15;
                        int n26 = nArray4[n5 * 2 + 1] - n15;
                        var36_69 = textStyleArray[n5];
                        for (int i = var34_66; i <= n26 && 0 <= i && i < n24; ++i) {
                            TextStyle textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, i));
                            if (textStyle == null && i > 0) {
                                textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, i - 1));
                            }
                            if (textStyle == null && i + 1 < n24) {
                                textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, i + 1));
                            }
                            if (textStyle == null) {
                                textLayout.setStyle(var36_69, i, i);
                                continue;
                            }
                            TextStyle textStyle2 = new TextStyle(var36_69);
                            if (textStyle2.font == null) {
                                textStyle2.font = textStyle.font;
                            }
                            if (textStyle2.foreground == null) {
                                textStyle2.foreground = textStyle.foreground;
                            }
                            if (textStyle2.background == null) {
                                textStyle2.background = textStyle.background;
                            }
                            textLayout.setStyle(textStyle2, i, i);
                        }
                    }
                } else {
                    n5 = n8 - n15;
                    var34_66 = n5 + n6 - 1;
                    TextStyle textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, n5));
                    if (textStyle == null) {
                        if (n5 > 0) {
                            textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, n5 - 1));
                        }
                        if (textStyle == null && var34_66 + 1 < n24) {
                            textStyle = textLayout.getStyle(StyledTextRenderer.cap(textLayout, var34_66 + 1));
                        }
                        if (textStyle != null) {
                            var36_69 = new TextStyle();
                            var36_69.font = textStyle.font;
                            var36_69.foreground = textStyle.foreground;
                            var36_69.background = textStyle.background;
                            textLayout.setStyle(var36_69, n5, var34_66);
                        }
                    }
                }
            }
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int n27;
            int n28 = -1;
            n8 = textLayout.getLineCount();
            n7 = this.getLineHeight();
            for (n6 = 0; n6 < n8; ++n6) {
                int n29 = textLayout.getLineBounds((int)n6).height;
                if (n29 <= n7) continue;
                n7 = n29;
                n27 = n6;
            }
            if (n27 != -1) {
                FontMetrics fontMetrics = textLayout.getLineMetrics(n27);
                this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.descent = fontMetrics.getDescent();
                if (this.layouts != null) {
                    for (TextLayout textLayout2 : this.layouts) {
                        if (textLayout2 == null || textLayout2 == textLayout) continue;
                        textLayout2.setAscent(this.ascent);
                        textLayout2.setDescent(this.descent);
                    }
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.verticalScrollOffset != 0) {
                    int n30 = this.styledText.topIndex;
                    int n31 = this.styledText.topIndexY;
                    int n32 = this.getLineHeight();
                    n5 = n31 >= 0 ? (n30 - 1) * n32 + n32 - n31 : n30 * n32 - n31;
                    this.styledText.scrollVertical(n5 - this.styledText.verticalScrollOffset, true);
                }
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocations();
                this.styledText.redraw();
            }
        }
        return textLayout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            for (TextLayout textLayout : this.layouts) {
                if (textLayout == null) continue;
                textLayout.dispose();
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineSizes = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
        this.hasLinks = false;
    }

    void reset(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 > this.lineSizes.length) {
            return;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = n; i < n3; ++i) {
            treeSet.add(i);
        }
        this.reset(treeSet);
    }

    void reset(Set<Integer> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        int n = 0;
        for (Integer object : set) {
            if (object < 0 && object >= this.lineCount) continue;
            ++n;
            this.getLineSize(object).resetSize();
        }
        if (this.linesInAverageLineHeight > n) {
            this.linesInAverageLineHeight -= n;
        } else {
            this.linesInAverageLineHeight = 0;
            this.averageLineHeight = 0.0f;
        }
        if (set.contains(this.maxWidthLineIndex)) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (n != this.lineCount) {
                for (int i = 0; i < this.lineCount; ++i) {
                    LineSizeInfo lineSizeInfo = this.getLineSize(i);
                    if (lineSizeInfo.width <= this.maxWidth) continue;
                    this.maxWidth = lineSizeInfo.width;
                    this.maxWidthLineIndex = i;
                }
            }
        }
    }

    void setContent(StyledTextContent styledTextContent) {
        this.reset();
        this.content = styledTextContent;
        this.lineCount = styledTextContent.getLineCount();
        this.lineSizes = new LineSizeInfo[this.lineCount];
        this.maxWidth = 0;
        this.maxWidthLineIndex = -1;
        this.reset(0, this.lineCount);
    }

    public void setFixedLineMetrics(FontMetrics fontMetrics) {
        this.fixedLineMetrics = fontMetrics;
    }

    void setFont(Font font, int n) {
        Object object;
        TextLayout textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        this.tabLength = n;
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            textLayout.setText("    ");
            textLayout.setFont(font);
            textLayout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            textLayout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            textLayout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            textLayout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            object = textLayout.getLineMetrics(0);
            this.ascent = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading();
            this.descent = ((FontMetrics)object).getDescent();
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        textLayout.dispose();
        textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        object = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            ((StringBuilder)object).append(' ');
        }
        textLayout.setText(((StringBuilder)object).toString());
        this.tabWidth = textLayout.getBounds().width;
        textLayout.dispose();
        if (this.styledText != null) {
            GC gC = new GC(this.styledText);
            this.averageCharWidth = (int)gC.getFontMetrics().getAverageCharacterWidth();
            this.fixedPitch = gC.stringExtent((String)"l").x == gC.stringExtent((String)"W").x;
            gC.dispose();
        }
    }

    void setLineAlignment(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 2;
            this.lines[i].alignment = n3;
        }
    }

    void setLineBackground(int n, int n2, Color color) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 1;
            this.lines[i].background = color;
        }
    }

    void setLineBullet(int n, int n2, Bullet bullet) {
        int n3;
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        for (n3 = 0; n3 < this.bullets.length && bullet != this.bullets[n3]; ++n3) {
        }
        if (bullet != null) {
            if (n3 == this.bullets.length) {
                Bullet[] bulletArray = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, bulletArray, 0, this.bullets.length);
                bulletArray[n3] = bullet;
                this.bullets = bulletArray;
            }
            bullet.addIndices(n, n2);
        } else {
            this.updateBullets(n, n2, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 4;
            this.lines[i].indent = n3;
        }
    }

    void setLineVerticalIndent(int n, int n2) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        if (this.lines[n] == null) {
            this.lines[n] = new LineInfo();
        }
        this.lines[n].flags |= 0x200;
        int n3 = n2 - this.lines[n].verticalIndent;
        this.lines[n].verticalIndent = n2;
        LineSizeInfo lineSizeInfo = this.getLineSize(n);
        if (!lineSizeInfo.needsRecalculateHeight()) {
            lineSizeInfo.height += n3;
        }
    }

    void setLineWrapIndent(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x80;
            this.lines[i].wrapIndent = n3;
        }
    }

    void setLineJustify(int n, int n2, boolean bl) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 8;
            this.lines[i].justify = bl;
        }
    }

    void setLineSegments(int n, int n2, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x20;
            this.lines[i].segments = nArray;
        }
    }

    void setLineSegmentChars(int n, int n2, char[] cArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x100;
            this.lines[i].segmentsChars = cArray;
        }
    }

    void setLineTabStops(int n, int n2, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x40;
            this.lines[i].tabStops = nArray;
        }
    }

    void setLineSpacingProvider(StyledTextLineSpacingProvider styledTextLineSpacingProvider) {
        this.lineSpacingProvider = styledTextLineSpacingProvider;
    }

    void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        int n;
        int n2;
        int n3;
        if (styleRangeArray == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            this.hasLinks = false;
            return;
        }
        if (nArray == null) {
            nArray = new int[styleRangeArray.length << 1];
            StyleRange[] styleRangeArray2 = new StyleRange[styleRangeArray.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            n3 = 0;
            for (n2 = 0; n2 < styleRangeArray.length; ++n2) {
                StyleRange styleRange = styleRangeArray[n2];
                nArray[n3++] = styleRange.start;
                nArray[n3++] = styleRange.length;
                for (n = 0; n < this.stylesSetCount && !this.stylesSet[n].similarTo(styleRange); ++n) {
                }
                if (n == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        StyleRange[] styleRangeArray3 = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, styleRangeArray3, 0, this.stylesSetCount);
                        this.stylesSet = styleRangeArray3;
                    }
                    this.stylesSet[this.stylesSetCount++] = styleRange;
                }
                styleRangeArray2[n2] = this.stylesSet[n];
            }
            styleRangeArray = styleRangeArray2;
        }
        if (this.styleCount == 0) {
            if (nArray != null) {
                this.ranges = new int[nArray.length];
                System.arraycopy(nArray, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[styleRangeArray.length];
            System.arraycopy(styleRangeArray, 0, this.styles, 0, this.styles.length);
            this.styleCount = styleRangeArray.length;
            return;
        }
        if (nArray != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            n2 = 0;
            for (int i = 0; i < this.styleCount; ++i) {
                this.ranges[n2++] = this.styles[i].start;
                this.ranges[n2++] = this.styles[i].length;
            }
        }
        if (nArray == null && this.ranges != null) {
            nArray = new int[styleRangeArray.length << 1];
            n2 = 0;
            for (int i = 0; i < styleRangeArray.length; ++i) {
                nArray[n2++] = styleRangeArray[i].start;
                nArray[n2++] = styleRangeArray[i].length;
            }
        }
        if (this.ranges != null) {
            n2 = nArray[0];
            int n4 = this.styleCount << 1;
            n3 = this.getRangeIndex(n2, -1, n4);
            int n5 = n = n3 == n4 ? 1 : 0;
            if (n == 0) {
                int n6 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
                int n7 = this.getRangeIndex(n6, n3 - 1, n4);
                int n8 = n = n3 == n7 && this.ranges[n3] >= n6 ? 1 : 0;
            }
            if (n != 0) {
                this.addMerge(nArray, styleRangeArray, nArray.length, n3, n3);
                return;
            }
            int n9 = n3;
            int[] nArray2 = new int[6];
            StyleRange[] styleRangeArray4 = new StyleRange[3];
            for (int i = 0; i < nArray.length; i += 2) {
                int n10 = nArray[i];
                int n11 = n10 + nArray[i + 1];
                if (n10 == n11) continue;
                int n12 = 0;
                int n13 = 0;
                while (n9 < n4) {
                    if (n10 >= this.ranges[n3] + this.ranges[n3 + 1]) {
                        n3 += 2;
                    }
                    if (this.ranges[n9] + this.ranges[n9 + 1] > n11) break;
                    n9 += 2;
                }
                if (this.ranges[n3] < n10 && n10 < this.ranges[n3] + this.ranges[n3 + 1]) {
                    styleRangeArray4[n13 >> 1] = this.styles[n3 >> 1];
                    nArray2[n13] = this.ranges[n3];
                    nArray2[n13 + 1] = n10 - this.ranges[n3];
                    n13 += 2;
                }
                styleRangeArray4[n13 >> 1] = styleRangeArray[i >> 1];
                nArray2[n13] = n10;
                nArray2[n13 + 1] = nArray[i + 1];
                n13 += 2;
                if (n9 < n4 && this.ranges[n9] < n11 && n11 < this.ranges[n9] + this.ranges[n9 + 1]) {
                    styleRangeArray4[n13 >> 1] = this.styles[n9 >> 1];
                    nArray2[n13] = n11;
                    nArray2[n13 + 1] = this.ranges[n9] + this.ranges[n9 + 1] - n11;
                    n13 += 2;
                    n12 = 2;
                }
                int n14 = this.addMerge(nArray2, styleRangeArray4, n13, n3, n9 + n12);
                n4 += n14;
                n3 = n9 += n14;
            }
        } else {
            boolean bl;
            int n15 = styleRangeArray[0].start;
            n2 = this.getRangeIndex(n15, -1, this.styleCount);
            boolean bl2 = bl = n2 == this.styleCount;
            if (!bl) {
                n = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
                n3 = this.getRangeIndex(n, n2 - 1, this.styleCount);
                boolean bl3 = bl = n2 == n3 && this.styles[n2].start >= n;
            }
            if (bl) {
                this.addMerge(styleRangeArray, styleRangeArray.length, n2, n2);
                return;
            }
            n3 = n2;
            StyleRange[] styleRangeArray5 = new StyleRange[3];
            for (StyleRange styleRange : styleRangeArray) {
                int n16 = styleRange.start;
                int n17 = n16 + styleRange.length;
                if (n16 == n17) continue;
                int n18 = 0;
                int n19 = 0;
                while (n3 < this.styleCount) {
                    if (n16 >= this.styles[n2].start + this.styles[n2].length) {
                        ++n2;
                    }
                    if (this.styles[n3].start + this.styles[n3].length > n17) break;
                    ++n3;
                }
                StyleRange styleRange2 = this.styles[n2];
                if (styleRange2.start < n16 && n16 < styleRange2.start + styleRange2.length) {
                    int n20 = n19++;
                    StyleRange styleRange3 = (StyleRange)styleRange2.clone();
                    styleRangeArray5[n20] = styleRange3;
                    styleRange2 = styleRange3;
                    styleRange2.length = n16 - styleRange2.start;
                }
                styleRangeArray5[n19++] = styleRange;
                if (n3 < this.styleCount) {
                    styleRange2 = this.styles[n3];
                    if (styleRange2.start < n17 && n17 < styleRange2.start + styleRange2.length) {
                        int n21 = n19++;
                        StyleRange styleRange4 = (StyleRange)styleRange2.clone();
                        styleRangeArray5[n21] = styleRange4;
                        styleRange2 = styleRange4;
                        styleRange2.length += styleRange2.start - n17;
                        styleRange2.start = n17;
                        n18 = 1;
                    }
                }
                int n22 = this.addMerge(styleRangeArray5, n19, n2, n3 + n18);
                n2 = n3 += n22;
            }
        }
    }

    void textChanging(TextChangingEvent textChangingEvent) {
        int n = textChangingEvent.start;
        int n2 = textChangingEvent.newCharCount;
        int n3 = textChangingEvent.replaceCharCount;
        int n4 = textChangingEvent.newLineCount;
        int n5 = textChangingEvent.replaceLineCount;
        this.updateRanges(n, n3, n2);
        int n6 = this.content.getLineAtOffset(n);
        if (n3 == this.content.getCharCount()) {
            this.lines = null;
        }
        if (n5 == this.lineCount) {
            this.lineCount = n4;
            this.lineSizes = new LineSizeInfo[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int n7;
            int n8;
            Object[] objectArray;
            int n9;
            int n10 = n6 + n5 + 1;
            int n11 = n6 + n4 + 1;
            if (this.lineCount < n6) {
                SWT.error(6, null, "bug 478020: lineCount < startLine: " + this.lineCount + ":" + n6);
            }
            if (this.lineCount < n10) {
                SWT.error(6, null, "bug 478020: lineCount < startIndex: " + this.lineCount + ":" + n10);
            }
            if (this.lineCount + (n9 = n4 - n5) > this.lineSizes.length) {
                objectArray = new LineSizeInfo[this.lineCount + n9 + 32];
                System.arraycopy(this.lineSizes, 0, objectArray, 0, this.lineCount);
                this.lineSizes = objectArray;
            }
            if (this.lines != null && this.lineCount + n9 > this.lines.length) {
                objectArray = new LineInfo[this.lineCount + n9 + 32];
                System.arraycopy(this.lines, 0, objectArray, 0, this.lineCount);
                this.lines = objectArray;
            }
            System.arraycopy(this.lineSizes, n10, this.lineSizes, n11, this.lineCount - n10);
            for (n8 = n6; n8 < n11; ++n8) {
                this.lineSizes[n8] = null;
            }
            for (n8 = this.lineCount + n9; n8 < this.lineCount; ++n8) {
                this.lineSizes[n8] = null;
            }
            if (this.layouts != null) {
                int n12;
                n8 = n6 - this.topIndex;
                n7 = n8 + n5 + 1;
                for (n12 = n8; n12 < n7; ++n12) {
                    if (0 > n12 || n12 >= this.layouts.length) continue;
                    if (this.layouts[n12] != null) {
                        this.layouts[n12].dispose();
                    }
                    this.layouts[n12] = null;
                    if (this.bullets == null || this.bulletsIndices == null) continue;
                    this.bullets[n12] = null;
                }
                if (n9 > 0) {
                    for (n12 = this.layouts.length - 1; n12 >= n7; --n12) {
                        if (0 > n12 || n12 >= this.layouts.length) continue;
                        n11 = n12 + n9;
                        if (0 <= n11 && n11 < this.layouts.length) {
                            this.layouts[n11] = this.layouts[n12];
                            this.layouts[n12] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n11] = this.bullets[n12];
                            this.bulletsIndices[n11] = this.bulletsIndices[n12];
                            this.bullets[n12] = null;
                            continue;
                        }
                        if (this.layouts[n12] != null) {
                            this.layouts[n12].dispose();
                        }
                        this.layouts[n12] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n12] = null;
                    }
                } else if (n9 < 0) {
                    for (n12 = n7; n12 < this.layouts.length; ++n12) {
                        if (0 > n12 || n12 >= this.layouts.length) continue;
                        n11 = n12 + n9;
                        if (0 <= n11 && n11 < this.layouts.length) {
                            this.layouts[n11] = this.layouts[n12];
                            this.layouts[n12] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n11] = this.bullets[n12];
                            this.bulletsIndices[n11] = this.bulletsIndices[n12];
                            this.bullets[n12] = null;
                            continue;
                        }
                        if (this.layouts[n12] != null) {
                            this.layouts[n12].dispose();
                        }
                        this.layouts[n12] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n12] = null;
                    }
                }
            }
            if (n5 != 0 || n4 != 0) {
                n8 = this.content.getOffsetAtLine(n6);
                if (n8 != n) {
                    ++n6;
                }
                this.updateBullets(n6, n5, n4, true);
                if (this.lines != null) {
                    n10 = n6 + n5;
                    n11 = n6 + n4;
                    System.arraycopy(this.lines, n10, this.lines, n11, this.lineCount - n10);
                    for (n7 = n6; n7 < n11; ++n7) {
                        this.lines[n7] = null;
                    }
                    for (n7 = this.lineCount + n9; n7 < this.lineCount; ++n7) {
                        this.lines[n7] = null;
                    }
                }
            }
            this.lineCount += n9;
            if (this.maxWidthLineIndex != -1 && n6 <= this.maxWidthLineIndex && this.maxWidthLineIndex <= n6 + n5) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                for (n8 = 0; n8 < this.lineCount; ++n8) {
                    LineSizeInfo lineSizeInfo = this.getLineSize(n8);
                    if (lineSizeInfo.width <= this.maxWidth) continue;
                    this.maxWidth = lineSizeInfo.width;
                    this.maxWidthLineIndex = n8;
                }
            }
        }
    }

    void updateBullets(int n, int n2, int n3, boolean bl) {
        int n4;
        Object object;
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        for (Bullet bullet : this.bullets) {
            object = bullet.removeIndices(n, n2, n3, bl);
            if (object == null) continue;
            if (this.redrawLines == null) {
                this.redrawLines = object;
                continue;
            }
            int[] nArray = new int[this.redrawLines.length + ((Object)object).length];
            System.arraycopy(this.redrawLines, 0, nArray, 0, this.redrawLines.length);
            System.arraycopy(object, 0, nArray, this.redrawLines.length, ((Object)object).length);
            this.redrawLines = nArray;
        }
        int n5 = 0;
        Bullet[] bulletArray = this.bullets;
        int n6 = bulletArray.length;
        for (n4 = 0; n4 < n6; ++n4) {
            object = bulletArray[n4];
            if (object.size() != 0) continue;
            ++n5;
        }
        if (n5 > 0) {
            if (n5 == this.bullets.length) {
                this.bullets = null;
            } else {
                bulletArray = new Bullet[this.bullets.length - n5];
                n4 = 0;
                for (n6 = 0; n6 < this.bullets.length; ++n6) {
                    object = this.bullets[n6];
                    if (object.size() <= 0) continue;
                    bulletArray[n4++] = object;
                }
                this.bullets = bulletArray;
            }
        }
    }

    void updateRanges(int n, int n2, int n3) {
        if (this.styleCount == 0 || n2 == 0 && n3 == 0) {
            return;
        }
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 == n4) {
                return;
            }
            int n6 = n + n2;
            int n7 = this.getRangeIndex(n6, n5 - 1, n4);
            int n8 = n3 - n2;
            if (n5 == n7 && this.ranges[n5] < n && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                if (n3 == 0) {
                    int n9 = n5 + 1;
                    this.ranges[n9] = this.ranges[n9] - n2;
                    n7 += 2;
                } else {
                    if (n4 + 2 > this.ranges.length) {
                        int[] nArray = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, nArray, 0, n4);
                        this.ranges = nArray;
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.ranges, n5 + 2, this.ranges, n5 + 4, n4 - (n5 + 2));
                    System.arraycopy(this.styles, n5 + 2 >> 1, this.styles, n5 + 4 >> 1, this.styleCount - (n5 + 2 >> 1));
                    this.ranges[n5 + 3] = this.ranges[n5] + this.ranges[n5 + 1] - n6;
                    this.ranges[n5 + 2] = n + n3;
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    this.styles[(n5 >> 1) + 1] = this.styles[n5 >> 1];
                    n4 += 2;
                    ++this.styleCount;
                    n7 += 4;
                }
                if (n8 != 0) {
                    for (int i = n7; i < n4; i += 2) {
                        int n10 = i;
                        this.ranges[n10] = this.ranges[n10] + n8;
                    }
                }
            } else {
                if (this.ranges[n5] < n && n < this.ranges[n5] + this.ranges[n5 + 1]) {
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    n5 += 2;
                }
                if (n7 < n4 && this.ranges[n7] < n6 && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                    this.ranges[n7 + 1] = this.ranges[n7] + this.ranges[n7 + 1] - n6;
                    this.ranges[n7] = n6;
                }
                if (n8 != 0) {
                    for (int i = n7; i < n4; i += 2) {
                        int n11 = i;
                        this.ranges[n11] = this.ranges[n11] + n8;
                    }
                }
                System.arraycopy(this.ranges, n7, this.ranges, n5, n4 - n7);
                System.arraycopy(this.styles, n7 >> 1, this.styles, n5 >> 1, this.styleCount - (n7 >> 1));
                this.styleCount -= n7 - n5 >> 1;
            }
        } else {
            int n12 = this.getRangeIndex(n, -1, this.styleCount);
            if (n12 == this.styleCount) {
                return;
            }
            int n13 = n + n2;
            int n14 = this.getRangeIndex(n13, n12 - 1, this.styleCount);
            int n15 = n3 - n2;
            if (n12 == n14 && this.styles[n12].start < n && n13 < this.styles[n14].start + this.styles[n14].length) {
                if (n3 == 0) {
                    this.styles[n12].length -= n2;
                    ++n14;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.styles, n12 + 1, this.styles, n12 + 2, this.styleCount - (n12 + 1));
                    this.styles[n12 + 1] = (StyleRange)this.styles[n12].clone();
                    this.styles[n12 + 1].length = this.styles[n12].start + this.styles[n12].length - n13;
                    this.styles[n12 + 1].start = n + n3;
                    this.styles[n12].length = n - this.styles[n12].start;
                    ++this.styleCount;
                    n14 += 2;
                }
                if (n15 != 0) {
                    for (int i = n14; i < this.styleCount; ++i) {
                        this.styles[i].start += n15;
                    }
                }
            } else {
                if (this.styles[n12].start < n && n < this.styles[n12].start + this.styles[n12].length) {
                    this.styles[n12].length = n - this.styles[n12].start;
                    ++n12;
                }
                if (n14 < this.styleCount && this.styles[n14].start < n13 && n13 < this.styles[n14].start + this.styles[n14].length) {
                    this.styles[n14].length = this.styles[n14].start + this.styles[n14].length - n13;
                    this.styles[n14].start = n13;
                }
                if (n15 != 0) {
                    for (int i = n14; i < this.styleCount; ++i) {
                        this.styles[i].start += n15;
                    }
                }
                System.arraycopy(this.styles, n14, this.styles, n12, this.styleCount - n14);
                this.styleCount -= n14 - n12;
            }
        }
    }

    public boolean hasVerticalIndent() {
        return Arrays.stream(this.lines).filter(Objects::nonNull).mapToInt(lineInfo -> lineInfo.verticalIndent).anyMatch(n -> n != 0);
    }

    static class LineSizeInfo {
        private static final int RESETED_SIZE = -1;
        int height;
        int width;

        public LineSizeInfo() {
            this.resetSize();
        }

        void resetSize() {
            this.height = -1;
            this.width = -1;
        }

        boolean canLayout() {
            return !this.needsRecalculateWidth();
        }

        boolean needsRecalculateSize() {
            return this.needsRecalculateWidth() || this.needsRecalculateHeight();
        }

        boolean needsRecalculateWidth() {
            return this.width == -1;
        }

        boolean needsRecalculateHeight() {
            return this.height == -1;
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        int wrapIndent;
        boolean justify;
        int[] segments;
        char[] segmentsChars;
        int[] tabStops;
        int verticalIndent;

        public LineInfo() {
        }

        public LineInfo(LineInfo lineInfo) {
            if (lineInfo != null) {
                this.flags = lineInfo.flags;
                this.background = lineInfo.background;
                this.alignment = lineInfo.alignment;
                this.indent = lineInfo.indent;
                this.wrapIndent = lineInfo.wrapIndent;
                this.justify = lineInfo.justify;
                this.segments = lineInfo.segments;
                this.segmentsChars = lineInfo.segmentsChars;
                this.tabStops = lineInfo.tabStops;
                this.verticalIndent = lineInfo.verticalIndent;
            }
        }
    }

    private record LineDrawInfo(int index, TextLayout layout, String text, int offset, int height) {
    }

    private static final class StyleEntry {
        public final int start;
        public final int end;
        public final TextStyle style;

        public StyleEntry(TextStyle textStyle, int n, int n2) {
            this.style = textStyle;
            this.start = n;
            this.end = n2;
        }
    }
}

