/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Object var0);

    static final native void setDebug(Frame var0, boolean var1);

    static final native Object initFrame(long var0, String var2);

    static final native void validateWithBounds(Frame var0, int var1, int var2, int var3, int var4);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static final native void registerListeners(Frame var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        if (OS.isX11()) {
            GDK.gdk_x11_display_error_trap_push(GDK.gdk_display_get_default());
        }
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long l = composite.embeddedHandle;
        String string = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
        try {
            if (embeddedFrameClass != null) {
                Class.forName(string);
            }
            SWT_AWT.loadLibrary();
        }
        catch (ClassNotFoundException classNotFoundException) {
            SWT.error(20, classNotFoundException);
        }
        catch (Throwable throwable) {
            SWT.error(1, throwable, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        Frame[] frameArray = new Frame[1];
        Object object = SWT_AWT.initFrame(l, string);
        if (object == null || !(object instanceof Frame)) {
            SWT.error(1, new Throwable(), " [Error while starting AWT]");
        }
        frameArray[0] = (Frame)object;
        composite.setData(EMBEDDED_FRAME_KEY, frameArray[0]);
        if (Device.DEBUG) {
            SWT_AWT.setDebug(frameArray[0], true);
        }
        SWT_AWT.registerListeners(frameArray[0]);
        AWTEventListener aWTEventListener = aWTEvent -> {
            Window window;
            if (aWTEvent.getID() == 200 && (window = (Window)aWTEvent.getSource()).getParent() == frameArray[0]) {
                composite.getDisplay().asyncExec(() -> {
                    if (composite.isDisposed()) {
                        return;
                    }
                    Shell shell = composite.getShell();
                    long l = SWT_AWT.getAWTHandle(window);
                    if (l == 0L) {
                        return;
                    }
                    long l2 = GTK.GTK4 ? GDK.gdk_x11_surface_get_xid(GTK4.gtk_native_get_surface(GTK4.gtk_widget_get_native(shell.handle))) : GDK.gdk_x11_window_get_xid(GTK3.gtk_widget_get_window(GTK3.gtk_widget_get_toplevel(shell.handle)));
                    OS.XSetTransientForHint(GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default()), l, l2);
                });
            }
        };
        frameArray[0].getToolkit().addAWTEventListener(aWTEventListener, 64L);
        Listener listener = event -> {
            switch (event.type) {
                case 20: {
                    EventQueue.invokeLater(() -> frameArray[0].dispatchEvent(new WindowEvent(frameArray[0], 204)));
                    break;
                }
                case 19: {
                    EventQueue.invokeLater(() -> frameArray[0].dispatchEvent(new WindowEvent(frameArray[0], 203)));
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, listener);
        shell.addListener(19, listener);
        Listener listener2 = event -> {
            switch (event.type) {
                case 12: {
                    Shell shell = composite.getShell();
                    shell.removeListener(20, listener);
                    shell.removeListener(19, listener);
                    composite.setVisible(false);
                    EventQueue.invokeLater(() -> {
                        frameArray[0].getToolkit().removeAWTEventListener(aWTEventListener);
                        frameArray[0].dispose();
                    });
                    break;
                }
                case 11: {
                    Rectangle rectangle = DPIUtil.autoScaleUp(composite.getClientArea());
                    EventQueue.invokeLater(() -> frameArray[0].setSize(rectangle.width, rectangle.height));
                }
            }
        };
        composite.addListener(12, listener2);
        composite.addListener(11, listener2);
        composite.getDisplay().asyncExec(() -> {
            if (composite.isDisposed()) {
                return;
            }
            Rectangle rectangle = DPIUtil.autoScaleUp(composite.getClientArea());
            EventQueue.invokeLater(() -> {
                frameArray[0].setSize(rectangle.width, rectangle.height);
                frameArray[0].validate();
            });
        });
        return frameArray[0];
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, l);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                display.syncExec(() -> {
                    if (shell.isDisposed()) {
                        return;
                    }
                    Dimension dimension = canvas.getSize();
                    shell.setSize(DPIUtil.autoScaleDown(new Point(dimension.width, dimension.height)));
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, event -> canvas.removeComponentListener(componentAdapter));
        shell.setVisible(true);
        return shell;
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }
}

