/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.Graphene;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    long modelHandle;
    long checkRenderer;
    int columnCount;
    int sortDirection;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    long ignoreCell;
    TreeItem[] items;
    int nextId;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean firstCompute = true;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkRGBA background;
    GdkRGBA foreground;
    GdkRGBA drawForegroundRGBA;
    boolean isOwnerDrawn;
    boolean ignoreSize;
    boolean pixbufSizeSet;
    boolean hasChildren;
    int pixbufHeight;
    int pixbufWidth;
    int headerHeight;
    boolean headerVisible;
    TreeItem topItem;
    double cachedAdjustment;
    double currentAdjustment;
    Color headerBackground;
    Color headerForeground;
    boolean boundsChangedSinceLastDraw;
    boolean wasScrolled;
    boolean rowActivated;
    private long headerCSSProvider;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_SURFACE = 5;
    static final int CELL_TYPES = 6;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    @Override
    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.isOwnerDrawn) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.isOwnerDrawn = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(long l) {
        int n = this.getId(l, true);
        if (this.items[n] != null) {
            return this.items[n];
        }
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
        int n2 = GTK.gtk_tree_path_get_depth(l2);
        int[] nArray = new int[n2];
        C.memmove(nArray, GTK.gtk_tree_path_get_indices(l2), (long)(4 * n2));
        long l3 = 0L;
        if (n2 > 1) {
            GTK.gtk_tree_path_up(l2);
            l3 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter(this.modelHandle, l3, l2);
        }
        this.items[n] = new TreeItem(this, l3, 0, nArray[nArray.length - 1], l);
        GTK.gtk_tree_path_free(l2);
        if (l3 != 0L) {
            OS.g_free(l3);
        }
        return this.items[n];
    }

    TreeItem _getItem(long l, long l2, int n) {
        int n2 = this.getId(l2, true);
        if (this.items[n2] != null) {
            return this.items[n2];
        }
        this.items[n2] = new TreeItem(this, l, 0, n, l2);
        return this.items[n2];
    }

    void reallocateIds(int n) {
        TreeItem[] treeItemArray = new TreeItem[n];
        System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
        this.items = treeItemArray;
    }

    int findAvailableId() {
        int n;
        if (this.nextId >= this.items.length) {
            this.nextId = 0;
        }
        for (n = this.nextId; n < this.items.length; ++n) {
            if (this.items[n] != null) continue;
            return n;
        }
        for (n = 0; n < this.nextId; ++n) {
            if (this.items[n] != null) continue;
            return n;
        }
        n = this.items.length;
        if (this.drawCount <= 0) {
            this.reallocateIds(this.items.length + 4);
        } else {
            this.reallocateIds((this.items.length + 1) * 3 / 2);
        }
        return n;
    }

    int getId(long l, boolean bl) {
        if (bl) {
            int[] nArray = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, l, 0, nArray, -1);
            if (nArray[0] != -1) {
                return nArray[0];
            }
        }
        int n = this.findAvailableId();
        this.nextId = n + 1;
        GTK.gtk_tree_store_set(this.modelHandle, l, 0, n, -1);
        return n;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        if (l2 == this.ignoreCell) {
            return 0L;
        }
        TreeItem treeItem = this._getItem(l4);
        if (treeItem != null) {
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX2, treeItem.handle);
        }
        boolean bl = GTK.GTK_IS_CELL_RENDERER_PIXBUF(l2);
        boolean bl2 = GTK.GTK_IS_CELL_RENDERER_TEXT(l2);
        if (bl2) {
            GTK.gtk_cell_renderer_set_fixed_size(l2, -1, -1);
        }
        if (!bl && !bl2) {
            return 0L;
        }
        int n = -1;
        boolean bl3 = false;
        if (this.columnCount == 0) {
            n = 6;
            bl3 = this.firstCustomDraw;
        } else {
            TreeColumn treeColumn = (TreeColumn)this.display.getWidget(l);
            if (treeColumn != null) {
                n = treeColumn.modelIndex;
                bl3 = treeColumn.customDraw;
            }
        }
        if (n == -1) {
            return 0L;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if ((this.style & 0x10000000) != 0) {
            if (!treeItem.cached) {
                bl4 = this.checkData(treeItem);
            }
            if (treeItem.updated) {
                bl5 = true;
                treeItem.updated = false;
            }
        }
        long[] lArray = new long[1];
        if (bl4) {
            if (bl) {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 0, lArray, -1);
                OS.g_object_set(l2, OS.gicon, lArray[0], 0L);
                if (lArray[0] != 0L) {
                    OS.g_object_unref(lArray[0]);
                }
            } else {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 1, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.text, lArray[0], 0L);
                    OS.g_free(lArray[0]);
                }
            }
        }
        if (bl3) {
            if (!this.isOwnerDrawn) {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 3, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.cell_background_rgba, lArray[0], 0L);
                    GDK.gdk_rgba_free(lArray[0]);
                }
            }
            if (!bl) {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 2, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.foreground_rgba, lArray[0], 0L);
                    GDK.gdk_rgba_free(lArray[0]);
                }
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 4, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.font_desc, lArray[0], 0L);
                    OS.pango_font_description_free(lArray[0]);
                }
            }
        }
        if (bl4 || bl5) {
            this.ignoreCell = l2;
            this.setScrollWidth(l, treeItem);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            TreeItem treeItem2 = treeItem.getParentItem();
            Event event = new Event();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, GTK.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            this.currentItem = treeItem;
            treeItem.settingData = true;
            this.sendEvent(36, event);
            treeItem.settingData = false;
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            if (treeItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(long l, long l2, boolean bl) {
        long l3;
        GTK.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        int n = 0;
        int[] nArray = new int[1];
        long l4 = 0L;
        long l5 = GTK.gtk_tree_view_get_expander_column(this.handle);
        if (l5 == 0L && !GTK.gtk_tree_view_column_get_visible(l)) {
            GTK.gtk_tree_view_column_set_visible(l, true);
            l5 = GTK.gtk_tree_view_get_expander_column(this.handle);
            GTK.gtk_tree_view_column_set_visible(l, false);
        }
        if (l5 == l) {
            GdkRectangle gdkRectangle = new GdkRectangle();
            GTK.gtk_widget_realize(this.handle);
            l4 = GTK.gtk_tree_model_get_path(this.modelHandle, l2);
            GTK.gtk_tree_view_get_cell_area(this.handle, l4, l, gdkRectangle);
            n += gdkRectangle.x;
            if (!GTK.gtk_tree_view_column_get_visible(l)) {
                if (GTK.GTK4) {
                    long l6 = GTK4.gtk_image_new_from_icon_name(GTK.GTK_NAMED_ICON_PAN_DOWN);
                    GtkRequisition gtkRequisition = new GtkRequisition();
                    GTK.gtk_widget_get_preferred_size(l6, gtkRequisition, null);
                    n += gtkRequisition.width + 4;
                } else {
                    GTK3.gtk_widget_style_get(this.handle, OS.expander_size, nArray, 0L);
                    n += nArray[0] + 4;
                }
            }
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
            n += 2 * nArray[0];
        }
        if ((l3 = GTK.gtk_cell_layout_get_cells(l)) == 0L) {
            return 0;
        }
        long l7 = l3;
        while (l7 != 0L) {
            long l8 = OS.g_list_data(l7);
            if (l8 != 0L) {
                this.gtk_cell_renderer_get_preferred_size(l8, this.handle, nArray, null);
                n += nArray[0];
            }
            l7 = OS.g_list_next(l7);
        }
        OS.g_list_free(l3);
        if (bl) {
            boolean bl2;
            if (l4 == 0L) {
                l4 = GTK.gtk_tree_model_get_path(this.modelHandle, l2);
            }
            if (bl2 = GTK.gtk_tree_view_row_expanded(this.handle, l4)) {
                long l9 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                boolean bl3 = GTK.gtk_tree_model_iter_children(this.modelHandle, l9, l2);
                while (bl3) {
                    n = Math.max(n, this.calculateWidth(l, l9, true));
                    bl3 = GTK.gtk_tree_model_iter_next(this.modelHandle, l9);
                }
                OS.g_free(l9);
            }
        }
        if (l4 != 0L) {
            GTK.gtk_tree_path_free(l4);
        }
        if (GTK.gtk_tree_view_get_grid_lines(this.handle) > 0 && !GTK.GTK4) {
            GTK3.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0L);
            n += 2 * nArray[0];
        }
        return n;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        this.clear(0L, n, bl);
    }

    void clear(long l, int n, boolean bl) {
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l2, l, n);
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1);
        if (nArray[0] != -1) {
            TreeItem treeItem = this.items[nArray[0]];
            treeItem.clear();
        }
        if (bl) {
            this.clearAll(bl, l2);
        }
        OS.g_free(l2);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(bl, 0L);
    }

    void clearAll(boolean bl, long l) {
        int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n == 0) {
            return;
        }
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean bl2 = GTK.gtk_tree_model_iter_children(this.modelHandle, l2, l);
        int[] nArray = new int[1];
        while (bl2) {
            GTK.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1);
            if (nArray[0] != -1) {
                TreeItem treeItem = this.items[nArray[0]];
                treeItem.clear();
            }
            if (bl) {
                this.clearAll(bl, l2);
            }
            bl2 = GTK.gtk_tree_model_iter_next(this.modelHandle, l2);
        }
        OS.g_free(l2);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (!GTK.GTK4 && this.firstCompute) {
            for (TreeColumn treeColumn : this.columns) {
                if (treeColumn == null) continue;
                GTK.gtk_widget_set_visible(treeColumn.buttonHandle, true);
            }
            this.firstCompute = false;
        }
        GTK.gtk_widget_realize(this.handle);
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (n2 == -1 && point.y == this.getHeaderHeight()) {
            int rectangle = this.getItemHeightInPixels();
            point.y = this.getItemCount() * rectangle + this.getHeaderHeight();
            for (TreeItem treeItem : this.items) {
                if (treeItem == null || !treeItem.isExpanded) continue;
                point.y += GTK.gtk_tree_model_iter_n_children(this.modelHandle, treeItem.handle) * rectangle;
            }
        }
        Rectangle rectangle = this.computeTrimInPixels(0, 0, point.x, point.y);
        point.x = rectangle.width;
        if (point.y == this.headerHeight && this.headerVisible && (this.style & 0x10) != 0) {
            ++rectangle.height;
        }
        point.y = rectangle.height;
        return point;
    }

    void copyModel(long l, int n, long l2, int n2, long l3, long l4, int n3) {
        long l5 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long l6 = OS.g_malloc(OS.GValue_sizeof());
        C.memset(l6, 0, OS.GValue_sizeof());
        if (GTK.gtk_tree_model_iter_children(l, l5, l3)) {
            long[] lArray = new long[GTK.gtk_tree_model_iter_n_children(l, l3)];
            int n4 = 0;
            int[] nArray = new int[1];
            do {
                long l7;
                if ((l7 = OS.g_malloc(GTK.GtkTreeIter_sizeof())) == 0L) {
                    this.error(2);
                }
                GTK.gtk_tree_store_append(l2, l7, l4);
                GTK.gtk_tree_model_get(l, l5, 0, nArray, -1);
                int n5 = nArray[0];
                TreeItem treeItem = null;
                if (n5 != -1) {
                    treeItem = this.items[n5];
                    if (treeItem != null) {
                        int n6;
                        long l8 = treeItem.handle;
                        lArray[n4++] = l8;
                        for (n6 = 0; n6 < 6; ++n6) {
                            GTK.gtk_tree_model_get_value(l, l8, n6, l6);
                            GTK.gtk_tree_store_set_value(l2, l7, n6, l6);
                            OS.g_value_unset(l6);
                        }
                        for (n6 = 0; n6 < n3 - 6; ++n6) {
                            GTK.gtk_tree_model_get_value(l, l8, n + n6, l6);
                            GTK.gtk_tree_store_set_value(l2, l7, n2 + n6, l6);
                            OS.g_value_unset(l6);
                        }
                    }
                } else {
                    GTK.gtk_tree_store_set(l2, l7, 0, -1, -1);
                }
                this.copyModel(l, n, l2, n2, l5, l7, n3);
                if (treeItem != null) {
                    treeItem.handle = l7;
                    continue;
                }
                OS.g_free(l7);
            } while (GTK.gtk_tree_model_iter_next(l, l5));
            for (int i = 0; i < lArray.length; ++i) {
                long l9 = lArray[i];
                if (l9 == 0L) continue;
                GTK.gtk_tree_store_remove(l, l9);
                OS.g_free(l9);
            }
        }
        OS.g_free(l6);
        OS.g_free(l5);
    }

    void createColumn(TreeColumn treeColumn, int n) {
        long l;
        int n2;
        int n3 = 6;
        if (this.columnCount != 0) {
            int n4 = GTK.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] blArray = new boolean[n4];
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                int n5 = this.columns[n2].modelIndex;
                for (int i = 0; i < 6; ++i) {
                    blArray[n5 + i] = true;
                }
            }
            while (n3 < n4 && blArray[n3]) {
                ++n3;
            }
            if (n3 == n4) {
                long l2 = this.modelHandle;
                long[] lArray = this.getColumnTypes(this.columnCount + 4);
                long l3 = GTK.gtk_tree_store_newv(lArray.length, lArray);
                if (l3 == 0L) {
                    this.error(2);
                }
                this.copyModel(l2, 6, l3, 6, 0L, 0L, n4);
                GTK.gtk_tree_view_set_model(this.handle, l3);
                this.setModel(l3);
            }
        }
        if ((l = GTK.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            TreeColumn treeColumn2 = this.columns[0];
            this.createRenderers(treeColumn2.handle, treeColumn2.modelIndex, false, treeColumn2.style);
        }
        this.createRenderers(l, n3, n == 0, treeColumn == null ? 0 : treeColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            GTK.gtk_tree_view_column_set_sizing(l, 0);
        } else {
            GTK.gtk_tree_view_column_set_sizing(l, 2);
        }
        GTK.gtk_tree_view_column_set_resizable(l, true);
        GTK.gtk_tree_view_column_set_clickable(l, true);
        GTK.gtk_tree_view_column_set_min_width(l, 0);
        GTK.gtk_tree_view_insert_column(this.handle, l, n);
        if (this.columnCount != 0) {
            GTK.gtk_tree_view_column_set_visible(l, false);
        }
        if (treeColumn != null) {
            treeColumn.handle = l;
            treeColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            n2 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.scrolledHandle = GTK4.gtk_scrolled_window_new();
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.scrolledHandle = GTK3.gtk_scrolled_window_new(0L, 0L);
        }
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = this.getColumnTypes(1);
        this.modelHandle = GTK.gtk_tree_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
            GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK3.gtk_container_add(this.scrolledHandle, this.handle);
        }
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(l, n2);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
            } else {
                GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
        if (GTK.GTK4) {
            this.bindArrowKeyBindings();
        }
    }

    void bindArrowKeyBindings() {
        if (!GTK.GTK4) {
            return;
        }
        int[] nArray = new int[1];
        GTK.gtk_accelerator_parse(Converter.javaStringToCString("Left"), nArray, null);
        GTK4.gtk_widget_class_add_binding_signal(GTK.GTK_WIDGET_GET_CLASS(this.handle), nArray[0], 0, Converter.javaStringToCString("expand-collapse-cursor-row"), Converter.javaStringToCString("(bbb)"), false, false, false);
        GTK.gtk_accelerator_parse(Converter.javaStringToCString("Right"), nArray, null);
        GTK4.gtk_widget_class_add_binding_signal(GTK.GTK_WIDGET_GET_CLASS(this.handle), nArray[0], 0, Converter.javaStringToCString("expand-collapse-cursor-row"), Converter.javaStringToCString("(bbb)"), false, true, false);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void createItem(TreeColumn treeColumn, int n) {
        long l;
        long l2;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            treeColumn.handle = GTK.gtk_tree_view_get_column(this.handle, 0);
            GTK.gtk_tree_view_column_set_sizing(treeColumn.handle, 2);
            GTK.gtk_tree_view_column_set_visible(treeColumn.handle, false);
            treeColumn.modelIndex = 6;
            this.createRenderers(treeColumn.handle, treeColumn.modelIndex, true, treeColumn.style);
            treeColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(treeColumn, n);
        }
        long l3 = this.gtk_box_new(0, false, 3);
        if (l3 == 0L) {
            this.error(2);
        }
        if ((l2 = GTK.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_image_new()) == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(l3, l);
            GTK4.gtk_box_append(l3, l2);
            GTK.gtk_widget_hide(l);
        } else {
            GTK3.gtk_container_add(l3, l);
            GTK3.gtk_container_add(l3, l2);
            GTK.gtk_widget_show(l3);
            GTK.gtk_widget_show(l2);
        }
        treeColumn.labelHandle = l2;
        treeColumn.imageHandle = l;
        GTK.gtk_tree_view_column_set_widget(treeColumn.handle, l3);
        treeColumn.buttonHandle = GTK.gtk_tree_view_column_get_button(treeColumn.handle);
        GTK.gtk_widget_set_focus_on_click(treeColumn.buttonHandle, false);
        if (this.columnCount == this.columns.length) {
            TreeColumn[] treeColumnArray = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columns.length);
            this.columns = treeColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        if ((this.state & 0x4000) != 0) {
            long l4 = this.getFontDescription();
            treeColumn.setFontDescription(l4);
            OS.pango_font_description_free(l4);
        }
        if (this.columnCount >= 1) {
            for (int i = 0; i < this.items.length; ++i) {
                Object[] objectArray;
                TreeItem treeItem = this.items[i];
                if (treeItem == null) continue;
                Font[] fontArray = treeItem.cellFont;
                if (fontArray != null) {
                    objectArray = new Font[this.columnCount];
                    System.arraycopy(fontArray, 0, objectArray, 0, n);
                    System.arraycopy(fontArray, n, objectArray, n + 1, this.columnCount - n - 1);
                    treeItem.cellFont = objectArray;
                }
                if ((objectArray = treeItem.strings) == null) continue;
                String[] stringArray = new String[this.columnCount];
                System.arraycopy(objectArray, 0, stringArray, 0, n);
                System.arraycopy(objectArray, n, stringArray, n + 1, this.columnCount - n - 1);
                stringArray[n] = "";
                treeItem.strings = stringArray;
            }
        }
        this.updateHeaderCSS();
    }

    void createItem(TreeItem treeItem, long l, int n) {
        int n2;
        int n3;
        if (n == 0) {
            treeItem.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (treeItem.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_tree_store_prepend(this.modelHandle, treeItem.handle, l);
        } else if (n == -1) {
            treeItem.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (treeItem.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_tree_store_append(this.modelHandle, treeItem.handle, l);
        } else {
            n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l);
            if (0 > n || n > n3) {
                this.error(6);
            }
            treeItem.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (treeItem.handle == 0L) {
                this.error(2);
            }
            if (n == n3) {
                GTK.gtk_tree_store_append(this.modelHandle, treeItem.handle, l);
            } else {
                GTK.gtk_tree_store_insert(this.modelHandle, treeItem.handle, l, n);
            }
        }
        n3 = this.getId(treeItem.handle, false);
        this.items[n3] = treeItem;
        this.modelChanged = true;
        if (l == 0L && (n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) == 1) {
            Event event = new Event();
            event.detail = 0;
            this.sendEvent(56, event);
        }
    }

    void createRenderers(long l, int n, boolean bl, int n2) {
        long l2;
        long l3;
        GTK.gtk_tree_view_column_clear(l);
        if ((this.style & 0x20) != 0 && bl) {
            GTK.gtk_tree_view_column_pack_start(l, this.checkRenderer, false);
            GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.active, 1);
            GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.inconsistent, 2);
            if (!this.isOwnerDrawn) {
                GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.cell_background_rgba, 4);
            }
            if (this.isOwnerDrawn) {
                GTK.gtk_tree_view_column_set_cell_data_func(l, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, l);
            }
        }
        if (GTK.GTK4) {
            l3 = GTK.gtk_cell_renderer_pixbuf_new();
        } else {
            long l4 = l3 = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : GTK.gtk_cell_renderer_pixbuf_new();
        }
        if (l3 == 0L) {
            this.error(2);
        } else if (!this.isOwnerDrawn) {
            if ((this.style & 0x10000000) != 0 && this.pixbufSizeSet) {
                GTK.gtk_cell_renderer_set_fixed_size(l3, this.pixbufHeight, this.pixbufWidth);
            } else {
                GTK.gtk_cell_renderer_set_fixed_size(l3, 0, 0);
            }
        }
        long l5 = l2 = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : GTK.gtk_cell_renderer_text_new();
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.isOwnerDrawn) {
            OS.g_object_set_qdata(l3, Display.SWT_OBJECT_INDEX1, l);
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX1, l);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(l3, OS.mode, 1, 0L);
        }
        if ((n2 & 0x20000) != 0) {
            OS.g_object_set(l2, OS.xalign, 1.0f, 0L);
            GTK.gtk_tree_view_column_pack_end(l, l2, true);
            GTK.gtk_tree_view_column_pack_end(l, l3, false);
            GTK.gtk_tree_view_column_set_alignment(l, 1.0f);
        } else if ((n2 & 0x1000000) != 0) {
            OS.g_object_set(l2, OS.xalign, 0.5f, 0L);
            GTK.gtk_tree_view_column_pack_start(l, l3, false);
            GTK.gtk_tree_view_column_pack_end(l, l2, true);
            GTK.gtk_tree_view_column_set_alignment(l, 0.5f);
        } else {
            GTK.gtk_tree_view_column_pack_start(l, l3, false);
            GTK.gtk_tree_view_column_pack_start(l, l2, true);
            GTK.gtk_tree_view_column_set_alignment(l, 0.0f);
        }
        GTK.gtk_tree_view_column_add_attribute(l, l3, OS.pixbuf, n + 0);
        if (!this.isOwnerDrawn) {
            GTK.gtk_tree_view_column_add_attribute(l, l3, OS.cell_background_rgba, 4);
            GTK.gtk_tree_view_column_add_attribute(l, l2, OS.cell_background_rgba, 4);
        }
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.text, n + 1);
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.foreground_rgba, 3);
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.font_desc, 5);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != l) continue;
                bl2 = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.isOwnerDrawn) {
            GTK.gtk_tree_view_column_set_cell_data_func(l, l2, this.display.cellDataProc, this.handle, 0L);
            GTK.gtk_tree_view_column_set_cell_data_func(l, l3, this.display.cellDataProc, this.handle, 0L);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_iter(l, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn treeColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != treeColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        long l = treeColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = treeColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        GTK.gtk_tree_view_remove_column(this.handle, l);
        if (this.columnCount == 0) {
            long l2 = this.modelHandle;
            long[] lArray = this.getColumnTypes(1);
            long l3 = GTK.gtk_tree_store_newv(lArray.length, lArray);
            if (l3 == 0L) {
                this.error(2);
            }
            this.copyModel(l2, treeColumn.modelIndex, l3, 6, 0L, 0L, 12);
            GTK.gtk_tree_view_set_model(this.handle, l3);
            this.setModel(l3);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                TreeItem treeItem = this.items[i];
                if (treeItem == null) continue;
                long l4 = treeItem.handle;
                int n2 = treeColumn.modelIndex;
                GTK.gtk_tree_store_set(this.modelHandle, l4, n2 + 0, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, l4, n2 + 1, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, l4, n2 + 2, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, l4, n2 + 3, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, l4, n2 + 4, 0L, -1);
                Font[] fontArray = treeItem.cellFont;
                if (fontArray == null) continue;
                if (this.columnCount == 0) {
                    treeItem.cellFont = null;
                    continue;
                }
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                treeItem.cellFont = fontArray2;
            }
            if (n == 0) {
                TreeColumn treeColumn2 = this.columns[0];
                treeColumn2.style &= 0xFEFDBFFF;
                treeColumn2.style |= 0x4000;
                this.createRenderers(treeColumn2.handle, treeColumn2.modelIndex, true, treeColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n3 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n3 + 1);
        }
    }

    void destroyItem(TreeItem treeItem) {
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_store_remove(this.modelHandle, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        this.modelChanged = true;
        int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n == 0) {
            Event event = new Event();
            event.detail = 1;
            this.sendEvent(56, event);
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3 = false;
        if (OS.isX11()) {
            boolean bl4;
            if (bl) {
                long[] lArray = new long[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                    if (lArray[0] != 0L) {
                        long l = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                            bl3 = true;
                        }
                        GTK.gtk_tree_path_free(lArray[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((bl4 = super.dragDetect(n, n2, bl, false, blArray)) && bl3 && blArray != null) {
                blArray[0] = true;
            }
            return bl4;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        long[] lArray = new long[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, dArray, dArray2)) {
            if (this.getHeaderVisible()) {
                dArray2[0] = dArray2[0] - (double)this.getHeaderHeightInPixels();
            }
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    boolean bl5 = super.dragDetect(n, n2, bl, false, blArray);
                    if (bl5 && bl3 && blArray != null) {
                        blArray[0] = true;
                    }
                    return bl5;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rectangle;
        int n;
        this.checkWidget();
        if (RESIZE_ON_GETCLIENTAREA) {
            this.forceResize();
        }
        long l = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n3 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if (GTK.GTK4) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, nArray2, nArray);
            rectangle = new Rectangle(nArray2[0], nArray[0], n2, n);
        } else {
            GTK.gtk_widget_realize(this.handle);
            long l2 = this.gtk_widget_get_window(this.fixedHandle);
            long l3 = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            GDK.gdk_window_get_origin(l3, nArray, nArray3);
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            GDK.gdk_window_get_origin(l2, nArray4, nArray5);
            rectangle = new Rectangle(nArray4[0] - nArray[0], nArray5[0] - nArray3[0], n2, n);
        }
        return rectangle;
    }

    @Override
    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            long l = this.gtk_widget_get_surface(this.handle);
            this.gdk_surface_get_size(l, nArray, nArray2);
        } else {
            GTK.gtk_widget_realize(this.handle);
            this.gdk_window_get_size(GTK3.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        }
        return nArray[0];
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long l = GTK.gtk_tree_view_get_columns(this.handle);
        if (l == 0L) {
            return new int[0];
        }
        int n = 0;
        int n2 = OS.g_list_length(l);
        int[] nArray = new int[n2];
        long l2 = l;
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].handle != l3) continue;
                    nArray[n++] = i;
                    break;
                }
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return nArray;
    }

    long[] getColumnTypes(int n) {
        long[] lArray = new long[6 + n * 6];
        lArray[0] = OS.G_TYPE_INT();
        lArray[1] = OS.G_TYPE_BOOLEAN();
        lArray[2] = OS.G_TYPE_BOOLEAN();
        lArray[3] = GDK.GDK_TYPE_RGBA();
        lArray[4] = GDK.GDK_TYPE_RGBA();
        lArray[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 6; i < lArray.length; i += 6) {
            lArray[i + 0] = GDK.GDK_TYPE_PIXBUF();
            lArray[i + 1] = OS.G_TYPE_STRING();
            lArray[i + 2] = GDK.GDK_TYPE_RGBA();
            lArray[i + 3] = GDK.GDK_TYPE_RGBA();
            lArray[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            lArray[i + 5] = OS.G_TYPE_LONG();
        }
        return lArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_LIST_FOREGROUND_RGBA;
    }

    TreeItem getFocusItem() {
        long[] lArray = new long[1];
        GTK.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return null;
        }
        TreeItem treeItem = null;
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, l, lArray[0])) {
            int[] nArray = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, l, 0, nArray, -1);
            if (nArray[0] != -1) {
                treeItem = this.items[nArray[0]];
            }
        }
        OS.g_free(l);
        GTK.gtk_tree_path_free(lArray[0]);
        return treeItem;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground != null ? this.headerBackground : this.display.getSystemColor(25);
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground != null ? this.headerForeground : this.display.getSystemColor(24);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        int n = 0;
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            for (int i = 0; i < this.columnCount; ++i) {
                long l = this.columns[i].buttonHandle;
                if (l == 0L) continue;
                this.gtk_widget_get_preferred_size(l, gtkRequisition);
                n = Math.max(n, gtkRequisition.height);
            }
        } else if (GTK.GTK4) {
            int[] nArray = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, null, nArray);
            n = nArray[0];
        } else {
            GTK.gtk_widget_realize(this.handle);
            long l = this.gtk_widget_get_window(this.fixedHandle);
            long l2 = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] nArray = new int[1];
            GDK.gdk_window_get_origin(l2, null, nArray);
            int[] nArray2 = new int[1];
            GDK.gdk_window_get_origin(l, null, nArray2);
            n = nArray[0] - nArray2[0];
        }
        return n;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_headers_visible(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeItem getItem(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        try {
            if (!GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n)) {
                this.error(6);
            }
            TreeItem treeItem = this._getItem(0L, l, n);
            return treeItem;
        }
        finally {
            OS.g_free(l);
        }
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TreeItem getItemInPixels(Point point) {
        long[] lArray;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] lArray2 = new long[1];
        GTK.gtk_widget_realize(this.handle);
        int n = point.x;
        int n2 = point.y;
        if (this.getHeaderVisible() && GTK.GTK4) {
            n2 -= this.getHeaderHeight();
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray2, lArray = new long[1], null, null)) {
            return null;
        }
        if (lArray2[0] == 0L) {
            return null;
        }
        TreeItem treeItem = null;
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, l, lArray2[0])) {
            boolean bl = false;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == lArray[0]) {
                GdkRectangle gdkRectangle = new GdkRectangle();
                GTK.gtk_tree_view_get_cell_area(this.handle, lArray2[0], lArray[0], gdkRectangle);
                if ((this.style & 0x8000000) != 0) {
                    bl = n > gdkRectangle.x + gdkRectangle.width;
                } else {
                    boolean bl2 = bl = n < gdkRectangle.x;
                }
            }
            if (!bl) {
                treeItem = this._getItem(l);
            }
        }
        OS.g_free(l);
        GTK.gtk_tree_path_free(lArray2[0]);
        return treeItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int n = 0;
        int n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n2 == 0) {
            long l = GTK.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            this.ignoreSize = true;
            if (GTK.GTK4) {
                GTK4.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray);
            } else {
                GTK3.gtk_tree_view_column_cell_get_size(l, null, null, null, null, nArray);
            }
            n = nArray[0];
            long l2 = this.getTextRenderer(l);
            if (l2 != 0L) {
                GTK.gtk_cell_renderer_get_preferred_height_for_width(l2, this.handle, 0, nArray, null);
            }
            n += nArray[0];
            this.ignoreSize = false;
        } else {
            long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter_first(this.modelHandle, l);
            int n3 = Math.max(1, this.columnCount);
            for (int i = 0; i < n3; ++i) {
                long l3 = GTK.gtk_tree_view_get_column(this.handle, i);
                GTK.gtk_tree_view_column_cell_set_cell_data(l3, this.modelHandle, l, false, false);
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    GTK4.gtk_tree_view_column_cell_get_size(l3, null, null, null, nArray);
                } else {
                    GTK3.gtk_tree_view_column_cell_get_size(l3, null, null, null, null, nArray);
                }
                long l4 = this.getTextRenderer(l3);
                int[] nArray2 = new int[1];
                if (l4 != 0L) {
                    GTK.gtk_cell_renderer_get_padding(l4, null, nArray2);
                }
                n = Math.max(n, nArray[0] + nArray2[0]);
            }
            OS.g_free(l);
        }
        return n;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeItem[] getItems(long l) {
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        try {
            boolean bl = GTK.gtk_tree_model_iter_children(this.modelHandle, l2, l);
            while (bl) {
                arrayList.add(this._getItem(l, l2, arrayList.size()));
                bl = GTK.gtk_tree_model_iter_next(this.modelHandle, l2);
            }
        }
        finally {
            OS.g_free(l2);
        }
        return arrayList.toArray(new TreeItem[arrayList.size()]);
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_grid_lines(this.handle) > 0;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    long getPixbufRenderer(long l) {
        long l2 = GTK.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (GTK.GTK_IS_CELL_RENDERER_PIXBUF(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        long l2 = GTK.gtk_tree_selection_get_selected_rows(l, null);
        if (l2 != 0L) {
            long l3 = l2;
            int n = OS.g_list_length(l2);
            TreeItem[] treeItemArray = new TreeItem[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l2);
                long l5 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                if (GTK.gtk_tree_model_get_iter(this.modelHandle, l5, l4)) {
                    treeItemArray[n2] = this._getItem(l5);
                    ++n2;
                }
                l2 = OS.g_list_next(l2);
                OS.g_free(l5);
                GTK.gtk_tree_path_free(l4);
            }
            OS.g_list_free(l3);
            if (n2 < n) {
                TreeItem[] treeItemArray2 = new TreeItem[n2];
                System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n2);
                treeItemArray = treeItemArray2;
            }
            return treeItemArray;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(l);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long l) {
        long l2 = GTK.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(l);
        TreeItem treeItem = null;
        if (this.cachedAdjustment == this.currentAdjustment) {
            treeItem = this._getCachedTopItem();
        }
        if (treeItem != null && !treeItem.isDisposed()) {
            return treeItem;
        }
        long[] lArray = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        treeItem = null;
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, l2, lArray[0])) {
            treeItem = this._getItem(l2);
        }
        OS.g_free(l2);
        GTK.gtk_tree_path_free(lArray[0]);
        this.topItem = treeItem;
        return treeItem;
    }

    TreeItem _getCachedTopItem() {
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        long l2 = GTK.gtk_tree_selection_get_selected_rows(l, null);
        TreeItem treeItem = null;
        if (l2 != 0L) {
            long l3;
            long l4 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter(this.modelHandle, l4, l3 = OS.g_list_data(l2))) {
                treeItem = this._getItem(l4);
            }
            OS.g_free(l4);
            GTK.gtk_tree_path_free(l3);
            if (this.topItem == treeItem) {
                return this.topItem;
            }
            return treeItem;
        }
        if (this.topItem == null) {
            TreeItem treeItem2 = null;
            long l5 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.modelHandle, l5)) {
                treeItem2 = this._getItem(l5);
            }
            OS.g_free(l5);
            return treeItem2;
        }
        return this.topItem;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long[] lArray;
        int n;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int n2 = GDK.gdk_event_get_event_type(l2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        GDK.gdk_event_get_state(l2, nArray2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        long l3 = this.gdk_event_get_surface_or_window(l2);
        if (l3 != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland() && n2 == 4) {
            long l5 = GDK.gdk_event_peek();
            if (l5 == 0L) {
                long[] lArray2 = new long[1];
                long l6 = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray2, null, null, null) && lArray2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(l6, lArray2[0]) && ((nArray2[0] & 5) == 0 || (nArray2[0] & 4) != 0)) {
                        long l7 = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(l6, l7, 0L, 0L);
                    }
                }
            } else {
                this.gdk_event_free(l5);
            }
        }
        if ((n = nArray[0]) == 3 && n2 == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l8 = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(l8, lArray[0])) {
                l4 = 1L;
            }
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l9 = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l9, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l9, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if (n2 == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return l4;
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        super.gtk_gesture_press_event(l, n, d, d2, l2);
        if (n == 2 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
    }

    @Override
    long gtk_row_activated(long l, long l2, long l3) {
        this.rowActivated = true;
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l2);
        } else {
            GDK.gdk_event_get_keyval(l2, nArray);
        }
        switch (nArray[0]) {
            case 65293: {
                int n = this.gdk_event_get_state(l2);
                if ((n & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
        return super.gtk_key_press_event(l, l2);
    }

    void sendTreeDefaultSelection() {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem == null) {
            return;
        }
        Event event = new Event();
        event.item = treeItem;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_button_event_get_button(l2);
            nArray2[0] = GDK.gdk_event_get_modifier_state(l2);
        } else {
            GDK.gdk_event_get_button(l2, nArray);
            GDK.gdk_event_get_state(l2, nArray2);
        }
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        long l3 = this.gdk_event_get_surface_or_window(l2);
        if (GTK.GTK4 ? l3 != this.gtk_widget_get_surface(this.handle) : l3 != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland()) {
            long[] lArray = new long[1];
            long l4 = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(l4, 0L, 0L, 0L);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null) && lArray[0] != 0L && GTK.gtk_tree_selection_path_is_selected(l4, lArray[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((nArray2[0] & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
                }
                if ((nArray2[0] & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(l4, lArray[0]);
                }
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    @Override
    long gtk_changed(long l) {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem != null) {
            Event event = new Event();
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    @Override
    long gtk_expand_collapse_cursor_row(long l, long l2, long l3, long l4) {
        if (l3 != 0L && l4 != 0L) {
            this.expandAll = true;
        }
        return 0L;
    }

    void drawInheritedBackground(long l) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            long l2;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (GTK.GTK4) {
                l2 = this.gtk_widget_get_surface(this.handle);
                this.gdk_surface_get_size(l2, nArray, nArray2);
            } else {
                l2 = GTK3.gtk_tree_view_get_bin_window(this.handle);
                this.gdk_window_get_size(l2, nArray, nArray2);
            }
            long l3 = 0L;
            int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l3);
            GdkRectangle gdkRectangle = new GdkRectangle();
            boolean bl = true;
            while (n != 0 && bl && nArray2[0] > gdkRectangle.y + gdkRectangle.height) {
                long l4 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l4, l3, n - 1);
                n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l4);
                long l5 = GTK.gtk_tree_model_get_path(this.modelHandle, l4);
                GTK.gtk_tree_view_get_cell_area(this.handle, l5, 0L, gdkRectangle);
                bl = GTK.gtk_tree_view_row_expanded(this.handle, l5);
                GTK.gtk_tree_path_free(l5);
                if (l3 != 0L) {
                    OS.g_free(l3);
                }
                l3 = l4;
            }
            if (l3 != 0L) {
                OS.g_free(l3);
            }
            if (nArray2[0] > gdkRectangle.y + gdkRectangle.height) {
                this.drawBackground(control, l2, l, 0, gdkRectangle.y + gdkRectangle.height, nArray[0], nArray2[0] - (gdkRectangle.y + gdkRectangle.height));
            }
        }
    }

    @Override
    long gtk_draw(long l, long l2) {
        boolean bl = this.boundsChangedSinceLastDraw;
        this.boundsChangedSinceLastDraw = false;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (this.isOwnerDrawn && bl) {
            GTK.gtk_widget_queue_draw(this.handle);
            return 0L;
        }
        this.drawInheritedBackground(l2);
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        long l3;
        long l4;
        if (GTK.GTK4 ? (l4 = GDK.gdk_event_get_surface(l2)) != this.gtk_widget_get_surface(this.handle) : (l3 = GDK.GDK_EVENT_WINDOW(l2)) != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    @Override
    long gtk_row_has_child_toggled(long l, long l2, long l3) {
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, l3, 0, nArray, -1);
        if (nArray[0] >= this.items.length) {
            return 0L;
        }
        TreeItem treeItem = this.items[nArray[0]];
        if (treeItem == null) {
            return 0L;
        }
        int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, treeItem.handle);
        if (n != 0 && treeItem.isExpanded) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            GTK.gtk_tree_view_expand_row(this.handle, l2, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
        }
        return 0L;
    }

    @Override
    long gtk_scroll_event(long l, long l2) {
        long l3 = super.gtk_scroll_event(l, l2);
        if (!this.wasScrolled) {
            this.wasScrolled = true;
        }
        return l3;
    }

    @Override
    long gtk_start_interactive_search(long l) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(l, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_test_collapse_row(long l, long l2, long l3) {
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean bl2 = this.modelChanged || !GTK.gtk_tree_view_row_expanded(this.handle, l3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1L;
        }
        treeItem.isExpanded = false;
        if (bl2) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            GTK.gtk_tree_view_collapse_row(this.handle, l3);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_test_expand_row(long l, long l2, long l3) {
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean bl2 = this.modelChanged || GTK.gtk_tree_view_row_expanded(this.handle, l3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1L;
        }
        treeItem.isExpanded = true;
        if (bl2 || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            GTK.gtk_tree_view_expand_row(this.handle, l3, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_toggled(long l, long l2) {
        long l3 = GTK.gtk_tree_path_new_from_string(l2);
        if (l3 == 0L) {
            return 0L;
        }
        TreeItem treeItem = null;
        long l4 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, l4, l3)) {
            treeItem = this._getItem(l4);
        }
        OS.g_free(l4);
        GTK.gtk_tree_path_free(l3);
        if (treeItem != null) {
            treeItem.setChecked(!treeItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    @Override
    void gtk_widget_get_preferred_size(long l, GtkRequisition gtkRequisition) {
        long l2;
        boolean bl;
        long l3;
        if (this.columnCount == 0) {
            super.gtk_widget_get_preferred_size(l, gtkRequisition);
            return;
        }
        long l4 = l3 = GTK.gtk_tree_view_get_columns(this.handle);
        boolean bl2 = bl = l3 != 0L;
        while (l4 != 0L) {
            l2 = OS.g_list_data(l4);
            if (GTK.gtk_tree_view_column_get_visible(l2)) {
                bl = false;
                break;
            }
            l4 = OS.g_list_next(l4);
        }
        l2 = 0L;
        if (bl) {
            l2 = OS.g_list_data(l3);
            GTK.gtk_tree_view_column_set_visible(l2, true);
        }
        super.gtk_widget_get_preferred_size(l, gtkRequisition);
        if (bl) {
            GTK.gtk_tree_view_column_set_visible(l2, false);
        }
        if (l3 != 0L) {
            OS.g_list_free(l3);
        }
    }

    void hideFirstColumn() {
        long l = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(l, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.getClosure(51), false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.getClosure(50), false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.getClosure(17), false);
        OS.g_signal_connect_closure(this.modelHandle, OS.row_has_child_toggled, this.display.getClosure(84), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        long l;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        int n = -1;
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        int n2 = GTK.gtk_tree_path_get_depth(l2);
        if (n2 == 1 && (l = GTK.gtk_tree_path_get_indices(l2)) != 0L) {
            int[] nArray = new int[1];
            C.memmove(nArray, l, 4L);
            n = nArray[0];
        }
        GTK.gtk_tree_path_free(l2);
        return n;
    }

    @Override
    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    long paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK3.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void propagateDraw(long l, long l2) {
        super.propagateDraw(l, l2);
        if (this.headerVisible && this.noChildDrawing && this.wasScrolled) {
            for (TreeColumn treeColumn : this.columns) {
                if (treeColumn == null) continue;
                GTK.gtk_widget_queue_draw(treeColumn.buttonHandle);
            }
            this.wasScrolled = false;
        }
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(GTK.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TreeColumn treeColumn = this.columns[i];
                this.createRenderers(treeColumn.handle, treeColumn.modelIndex, i == 0, treeColumn.style);
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem treeItem, boolean bl) {
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, treeItem.handle, 0, nArray, -1);
        if (nArray[0] == -1) {
            return;
        }
        if (bl) {
            treeItem.release(false);
        }
        this.items[nArray[0]] = null;
    }

    void releaseItems(long l) {
        int[] nArray = new int[1];
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean bl = GTK.gtk_tree_model_iter_children(this.modelHandle, l2, l);
        while (bl) {
            this.releaseItems(l2);
            if (!this.isDisposed()) {
                TreeItem treeItem;
                GTK.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1);
                if (nArray[0] != -1 && (treeItem = this.items[nArray[0]]) != null) {
                    this.releaseItem(treeItem, true);
                }
            }
            bl = GTK.gtk_tree_model_iter_next(this.modelHandle, l2);
        }
        OS.g_free(l2);
    }

    @Override
    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.items.length; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long l, int n, int n2) {
        if (n > n2) {
            return;
        }
        int n3 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l3 == 0L) {
            this.error(2);
        }
        try {
            for (int i = n; i <= n2; ++i) {
                TreeItem treeItem;
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l3, l, n);
                int[] nArray = new int[1];
                GTK.gtk_tree_model_get(this.modelHandle, l3, 0, nArray, -1);
                TreeItem treeItem2 = treeItem = nArray[0] != -1 ? this.items[nArray[0]] : null;
                if (treeItem != null && !treeItem.isDisposed()) {
                    if (treeItem.settingData) {
                        this.throwCannotRemoveItem(i);
                    }
                    treeItem.dispose();
                    continue;
                }
                OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
                GTK.gtk_tree_store_remove(this.modelHandle, l3);
                OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            }
        }
        finally {
            OS.g_free(l3);
        }
    }

    public void removeAll() {
        int n;
        this.checkWidget();
        this.checkSetDataInProcessBeforeRemoval();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (n = 0; n < this.items.length; ++n) {
            TreeItem treeItem = this.items[n];
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
        this.items = new TreeItem[4];
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            n = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    void sendMeasureEvent(long l, long l2, long l3) {
        if (!this.ignoreSize && GTK.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(41)) {
            long l4 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
            TreeItem treeItem = null;
            if (l4 != 0L) {
                treeItem = this._getItem(l4);
            }
            if (treeItem != null && !treeItem.isDisposed()) {
                Object object;
                int n = 0;
                if (this.columnCount > 0) {
                    long l5 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
                    for (int i = 0; i < this.columnCount; ++i) {
                        if (this.columns[i].handle != l5) continue;
                        n = i;
                        break;
                    }
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (l2 != 0L) {
                    C.memmove(nArray, l2, 4L);
                }
                if (l3 != 0L) {
                    C.memmove(nArray2, l3, 4L);
                }
                GTK.gtk_cell_renderer_get_preferred_height_for_width(l, this.handle, nArray[0], nArray2, null);
                Image image = treeItem.getImage(n);
                int n2 = 0;
                if (image != null && !image.isDisposed()) {
                    object = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                    object = image.getBounds();
                    n2 = ((Rectangle)object).width;
                }
                nArray[0] = nArray[0] + n2;
                object = new GC(this);
                ((GC)object).setFont(treeItem.getFont(n));
                Event event = new Event();
                event.item = treeItem;
                event.index = n;
                event.gc = object;
                Rectangle rectangle = new Rectangle(0, 0, nArray[0], nArray2[0]);
                event.setBounds(DPIUtil.autoScaleDown(rectangle));
                long l6 = GTK.gtk_tree_model_get_path(this.modelHandle, l4);
                long l7 = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_selection_path_is_selected(l7, l6)) {
                    event.detail = 2;
                }
                GTK.gtk_tree_path_free(l6);
                this.sendEvent(41, event);
                ((Resource)object).dispose();
                Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
                nArray[0] = rectangle2.width - n2;
                if (nArray2[0] < rectangle2.height) {
                    nArray2[0] = rectangle2.height;
                }
                if (l2 != 0L) {
                    C.memmove(l2, nArray, 4L);
                }
                if (l3 != 0L) {
                    C.memmove(l3, nArray2, 4L);
                }
                GTK.gtk_cell_renderer_set_fixed_size(l, -1, nArray2[0]);
            }
        }
    }

    @Override
    long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        long l5 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l5);
        OS.call(gtkCellRendererClass.get_preferred_width, l, l2, l3, l4);
        this.sendMeasureEvent(l, l3, 0L);
        return 0L;
    }

    @Override
    long rendererSnapshotProc(long l, long l2, long l3, long l4, long l5, long l6) {
        long l7 = Graphene.graphene_rect_alloc();
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.memmove(gdkRectangle, l4, (long)GdkRectangle.sizeof);
        Graphene.graphene_rect_init(l7, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
        long l8 = GTK4.gtk_snapshot_append_cairo(l2, l7);
        this.rendererRender(l, l8, l2, l3, l4, l5, 0L, l6);
        return 0L;
    }

    @Override
    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        this.rendererRender(l, l2, 0L, l3, l4, l5, 0L, l6);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rendererRender(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TreeItem treeItem = null;
        boolean bl = false;
        long l9 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
        if (l9 != 0L) {
            treeItem = this._getItem(l9);
        }
        long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
        int n = 0;
        if (this.columnCount > 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != l10) continue;
                n = i;
                break;
            }
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.memmove(gdkRectangle, l5, (long)GdkRectangle.sizeof);
        long l11 = GTK.gtk_tree_model_get_path(this.modelHandle, l9);
        GTK.gtk_tree_view_get_background_area(this.handle, l11, l10, gdkRectangle2);
        GTK.gtk_tree_path_free(l11);
        int n2 = gdkRectangle2.y - gdkRectangle.y;
        gdkRectangle2.y -= n2;
        if (treeItem != null && (GTK.GTK_IS_CELL_RENDERER_TOGGLE(l) || n != 0 || (this.style & 0x20) == 0)) {
            long l12;
            Object object5;
            this.drawFlags = (int)l8;
            this.drawState = 16;
            long[] lArray = new long[1];
            GTK.gtk_tree_model_get(this.modelHandle, treeItem.handle, 4, lArray, -1);
            if (lArray[0] == 0L) {
                int n3 = this.columnCount == 0 ? 6 : this.columns[n].modelIndex;
                GTK.gtk_tree_model_get(this.modelHandle, treeItem.handle, n3 + 3, lArray, -1);
            }
            if (lArray[0] != 0L) {
                this.drawState |= 8;
                GDK.gdk_rgba_free(lArray[0]);
            }
            if ((l8 & 1L) != 0L) {
                this.drawState |= 2;
            }
            if ((l8 & 1L) == 0L && (l8 & 0x10L) != 0L) {
                this.drawState |= 4;
            }
            object4 = gdkRectangle2.toRectangle();
            if (l2 != 0L) {
                object5 = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(l2, (GdkRectangle)object5);
                object4.x = ((GdkRectangle)object5).x;
                object4.width = ((GdkRectangle)object5).width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (object5 = this.findBackgroundControl()) != null) {
                if (l2 != 0L) {
                    Cairo.cairo_save(l2);
                }
                this.drawBackground((Control)object5, 0L, l2, object4.x, object4.y, object4.width, object4.height);
                if (l2 != 0L) {
                    Cairo.cairo_restore(l2);
                }
            }
            if ((l12 = this.getTextRenderer(l10)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(l12, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Object object6;
                Cairo.cairo_save(l2);
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl && (object6 = this.findBackgroundControl()) == null) {
                    object6 = this;
                }
                object6 = this.getGC(l2);
                if ((this.drawState & 2) != 0) {
                    ((GC)object6).setBackground(this.display.getSystemColor(26));
                    ((GC)object6).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object6).setBackground(treeItem.getBackground(n));
                    ((GC)object6).setForeground(treeItem.getForeground(n));
                }
                ((GC)object6).setFont(treeItem.getFont(n));
                if ((this.style & 0x8000000) != 0) {
                    object4.x = this.getClientWidth() - object4.width - object4.x;
                }
                if (l2 != 0L) {
                    object3 = DPIUtil.autoScaleDown((Rectangle)object4);
                    ((GC)object6).setClipping(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height);
                } else {
                    object3 = DPIUtil.autoScaleDown((Rectangle)object4);
                    ((GC)object6).setClipping(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height);
                }
                object3 = new Event();
                try {
                    object2 = new Rectangle(object4.x, object4.y, object4.width, object4.height);
                    ((Rectangle)object2).y += n2;
                    Cairo.cairo_translate(l2, 0.0, -n2);
                    ((Event)object3).item = treeItem;
                    ((Event)object3).index = n;
                    ((Event)object3).gc = object6;
                    ((Event)object3).detail = this.drawState;
                    ((Event)object3).setBounds(DPIUtil.autoScaleDown((Rectangle)object2));
                    this.sendEvent(40, (Event)object3);
                }
                finally {
                    Cairo.cairo_translate(l2, 0.0, n2);
                }
                this.drawForegroundRGBA = null;
                this.drawState = ((Event)object3).doit ? ((Event)object3).detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) == 0 && bl) {
                    this.drawForegroundRGBA = ((GC)object6).getForeground().handle;
                }
                ((Resource)object6).dispose();
                Cairo.cairo_restore(l2);
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = this.getGC(l2);
            gC.setBackground(treeItem.getBackground(n));
            gC.fillRectangle(DPIUtil.autoScaleDown(gdkRectangle.toRectangle()));
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || GTK.GTK_IS_CELL_RENDERER_TOGGLE(l)) {
            l11 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
            GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
            OS.memmove(gtkCellRendererClass, l11);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(l)) {
                object = this.foreground != null ? this.foreground : this.display.getSystemColor((int)24).handle;
                OS.g_object_set(l, OS.foreground_rgba, (GdkRGBA)object, 0L);
            }
            if (GTK.GTK4) {
                OS.call(gtkCellRendererClass.snapshot, l, l3, l4, l5, l6, this.drawFlags);
            } else {
                OS.call(gtkCellRendererClass.render, l, l2, l4, l5, l6, this.drawFlags);
            }
        }
        if (treeItem != null && GTK.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(42)) {
            Object object7;
            if (bl) {
                this.drawState |= 2;
            }
            Rectangle rectangle = gdkRectangle2.toRectangle();
            this.ignoreSize = true;
            object4 = new int[1];
            int[] nArray = new int[1];
            this.gtk_cell_renderer_get_preferred_size(l, this.handle, nArray, null);
            this.gtk_tree_view_column_cell_get_position(l10, l, (int[])object4, null);
            this.ignoreSize = false;
            object = treeItem.getImage(n);
            int n4 = 0;
            if (object != null) {
                object3 = DPIUtil.useCairoAutoScale() ? ((Image)object).getBounds() : ((Image)object).getBoundsInPixels();
                n4 = ((Rectangle)object3).width;
            }
            if (l2 != 0L) {
                rectangle.x -= n4;
                rectangle.width += n4;
            }
            object4[0] = object4[0] - n4;
            nArray[0] = nArray[0] + n4;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == l10) {
                object3 = new GdkRectangle();
                GTK.gtk_widget_realize(this.handle);
                long l13 = GTK.gtk_tree_model_get_path(this.modelHandle, l9);
                GTK.gtk_tree_view_get_cell_area(this.handle, l13, l10, (GdkRectangle)object3);
                GTK.gtk_tree_path_free(l13);
                object4[0] = object4[0] + ((GdkRectangle)object3).x;
            }
            object3 = this.getGC(l2);
            if ((this.drawState & 2) != 0) {
                object2 = this.display.getSystemColor(26);
                object7 = this.display.getSystemColor(27);
                ((GC)object3).setBackground((Color)object2);
                ((GC)object3).setForeground((Color)object7);
            } else {
                ((GC)object3).setBackground(treeItem.getBackground(n));
                object2 = this.drawForegroundRGBA != null ? Color.gtk_new(this.display, this.drawForegroundRGBA) : treeItem.getForeground(n);
                ((GC)object3).setForeground((Color)object2);
            }
            ((GC)object3).setFont(treeItem.getFont(n));
            if ((this.style & 0x8000000) != 0) {
                rectangle.x = this.getClientWidth() - rectangle.width - rectangle.x;
            }
            object2 = DPIUtil.autoScaleDown(rectangle);
            ((GC)object3).setClipping(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
            object7 = new Event();
            try {
                Rectangle rectangle2 = new Rectangle(rectangle.x + object4[0], rectangle.y, nArray[0], rectangle.height);
                rectangle2.y += n2;
                Cairo.cairo_translate(l2, 0.0, -n2);
                ((Event)object7).item = treeItem;
                ((Event)object7).index = n;
                ((Event)object7).gc = object3;
                ((Event)object7).detail = this.drawState;
                ((Event)object7).setBounds(DPIUtil.autoScaleDown(rectangle2));
                this.sendEvent(42, (Event)object7);
            }
            finally {
                Cairo.cairo_translate(l2, 0.0, n2);
            }
            ((Resource)object3).dispose();
        }
    }

    private GC getGC(long l) {
        GCData gCData = new GCData();
        gCData.cairo = l;
        GC gC = GC.gtk_new(this, gCData);
        return gC;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.isOwnerDrawn) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!bl) continue;
            long l = GTK.gtk_tree_view_get_column(this.handle, i);
            long l2 = this.getTextRenderer(l);
            GTK.gtk_tree_view_column_set_cell_data_func(l, l2, 0L, 0L, 0L);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                item = this.columns[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem == null) {
            GTK.gtk_tree_view_set_drag_dest_row(this.handle, 0L, 0);
            return;
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        Rectangle rectangle = treeItem.getBoundsInPixels();
        long[] lArray = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, rectangle.x, rectangle.y, lArray, null, null, null)) {
            return;
        }
        if (lArray[0] == 0L) {
            return;
        }
        int n = bl ? 0 : 1;
        GTK.gtk_tree_view_set_drag_dest_row(this.handle, lArray[0], n);
        GTK.gtk_tree_path_free(lArray[0]);
    }

    void setItemCount(long l, int n) {
        boolean bl;
        int n2 = GTK.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n == n2) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        if (l == 0L && n == 0) {
            this.removeAll();
        } else {
            this.remove(l, n, n2 - 1);
        }
        if (bl) {
            long l2;
            long l3 = OS.g_malloc(2 * GTK.GtkTreeIter_sizeof());
            if (l3 == 0L) {
                this.error(2);
            }
            long l4 = l3;
            if (n2 != 0) {
                l2 = l3 + (long)GTK.GtkTreeIter_sizeof();
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l2, l, n2 - 1);
            } else {
                l2 = 0L;
            }
            for (int i = n2; i < n; ++i) {
                GTK.gtk_tree_store_insert_after(this.modelHandle, l4, l, l2);
                GTK.gtk_tree_store_set(this.modelHandle, l4, 0, -1, -1);
            }
            OS.g_free(l3);
        } else {
            for (int i = n2; i < n; ++i) {
                new TreeItem(this, l, 0, n2, 0L);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.setItemCount(0L, n);
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_iter(l, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA == null ? this.defaultBackground() : gdkRGBA;
        GdkRGBA gdkRGBA2 = this.display.getSystemColor((int)26).handle;
        String string = "treeview {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\ntreeview:selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
        this.cssBackground = string;
        String string2 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string2);
    }

    @Override
    void setBackgroundSurface(Image image) {
        this.isOwnerDrawn = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (n5 != 0) {
            this.boundsChangedSinceLastDraw = true;
        }
        GTK.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
        }
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            long l2 = this.columns[nArray[i]].handle;
            GTK.gtk_tree_view_move_column_after(this.handle, l2, l);
            l = l2;
        }
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        TreeColumn[] treeColumnArray = this.getColumns();
        for (int i = 0; i < treeColumnArray.length; ++i) {
            if (treeColumnArray[i] == null) continue;
            treeColumnArray[i].setFontDescription(l);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.foreground = gdkRGBA;
        GdkRGBA gdkRGBA2 = gdkRGBA == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : gdkRGBA;
        this.setForegroundGdkRGBA(this.handle, gdkRGBA2);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerBackground)) {
                return;
            }
        }
        this.headerBackground = color;
        this.updateHeaderCSS();
    }

    void updateHeaderCSS() {
        StringBuilder stringBuilder = new StringBuilder("button {");
        if (this.headerBackground != null) {
            stringBuilder.append("background: " + this.display.gtk_rgba_to_css_string(this.headerBackground.handle) + "; ");
        }
        if (this.headerForeground != null) {
            stringBuilder.append("color: " + this.display.gtk_rgba_to_css_string(this.headerForeground.handle) + "; ");
        }
        stringBuilder.append("}\n");
        if (this.columnCount == 0) {
            long l = GTK.gtk_tree_view_column_get_button(GTK.gtk_tree_view_get_column(this.handle, 0));
            if (this.headerCSSProvider == 0L) {
                this.headerCSSProvider = GTK.gtk_css_provider_new();
                GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(l), this.headerCSSProvider, 600);
            }
            if (GTK.GTK4) {
                GTK4.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(stringBuilder.toString()), -1L);
            } else {
                GTK3.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(stringBuilder.toString()), -1L, null);
            }
        } else {
            for (TreeColumn treeColumn : this.columns) {
                if (treeColumn == null) continue;
                treeColumn.setHeaderCSS(stringBuilder.toString());
            }
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerForeground)) {
                return;
            }
        }
        this.headerForeground = color;
        this.updateHeaderCSS();
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_set_headers_visible(this.handle, bl);
        this.headerHeight = this.getHeaderHeight();
        this.headerVisible = bl;
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
    }

    void setModel(long l) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = l;
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        if (this.items != null) {
            for (n = 0; n < this.items.length; ++n) {
                if (this.items[n] == null) continue;
                this.items[n].setOrientation(bl);
            }
        }
        if (this.columns != null) {
            for (n = 0; n < this.columns.length; ++n) {
                if (this.columns[n] == null) continue;
                this.columns[n].setOrientation(bl);
            }
        }
    }

    @Override
    void setParentBackground() {
        this.isOwnerDrawn = true;
        this.recreateRenderers();
    }

    @Override
    void setParentGdkResource(Control control) {
        if (!GTK.GTK4) {
            long l = this.eventWindow();
            GTK3.gtk_widget_set_parent_window(control.topHandle(), l);
            this.hasChildren = true;
            this.connectFixedHandleDraw();
        }
    }

    void setScrollWidth(long l, TreeItem treeItem) {
        int n;
        if (this.columnCount != 0 || this.currentItem == treeItem) {
            return;
        }
        int n2 = GTK.gtk_tree_view_column_get_fixed_width(l);
        if (n2 < (n = this.calculateWidth(l, treeItem.handle, true))) {
            GTK.gtk_tree_view_column_set_fixed_width(l, n);
        }
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem == null) continue;
            if (treeItem.isDisposed()) break;
            if (treeItem.parent != this) continue;
            long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
            this.showItem(l2, false);
            if (bl2) {
                GTK.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
            }
            GTK.gtk_tree_selection_select_iter(l, treeItem.handle);
            GTK.gtk_tree_path_free(l2);
            bl2 = false;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = treeColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem treeItem) {
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(l);
        this.topItem = treeItem;
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(l2, false);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(l2);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        GTK.gtk_tree_view_scroll_to_cell(this.handle, 0L, treeColumn.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            long l = GTK.gtk_tree_view_get_column(this.handle, i);
            if (!GTK.gtk_tree_view_column_get_visible(l)) continue;
            return false;
        }
        long l = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(l, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length != 0 && treeItemArray[0] != null) {
            this.showItem(treeItemArray[0]);
        }
    }

    void showItem(long l, boolean bl) {
        int n = GTK.gtk_tree_path_get_depth(l);
        if (n > 1) {
            int[] nArray = new int[n - 1];
            long l2 = GTK.gtk_tree_path_get_indices(l);
            C.memmove(nArray, l2, (long)(nArray.length * 4));
            long l3 = GTK.gtk_tree_path_new();
            for (int i = 0; i < nArray.length; ++i) {
                GTK.gtk_tree_path_append_index(l3, nArray[i]);
                GTK.gtk_tree_view_expand_row(this.handle, l3, false);
            }
            GTK.gtk_tree_path_free(l3);
        }
        if (bl) {
            GTK.gtk_tree_view_scroll_to_cell(this.handle, l, 0L, false, 0.5f, 0.0f);
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        long l = GTK.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(l, true);
        GTK.gtk_tree_path_free(l);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        if (!GTK.GTK4) {
            long l = this.parentingHandle();
            long l2 = GTK3.gtk_container_get_children(l);
            if (l2 == 0L) {
                return;
            }
            long l3 = l2;
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                if (l4 != 0L) {
                    GTK.gtk_widget_queue_resize(l4);
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l2);
        }
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 18: {
                if (!this.hasChildren) break;
                if (this.headerVisible) {
                    this.noChildDrawing = true;
                }
                this.propagateDraw(l, l2);
                break;
            }
            case 19: {
                long l4;
                Control control;
                int n = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
                if (n != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null || (l4 = GTK3.gtk_tree_view_get_bin_window(l)) != GTK3.gtk_widget_get_window(l)) break;
                GdkRectangle gdkRectangle = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(l2, gdkRectangle);
                this.drawBackground(control, l4, l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                break;
            }
        }
        return super.windowProc(l, l2, l3);
    }

    @Override
    Point resizeCalculationsGTK3(long l, int n, int n2) {
        int n3;
        Point point = super.resizeCalculationsGTK3(l, n, n2);
        if (l == this.scrolledHandle && this.getHeaderVisible() && (n3 = this.hScrollBarWidth()) > 0) {
            point.y = Math.max(point.y, this.getHeaderHeight() + n3 + this.getBorderWidth() * 2);
        }
        return point;
    }

    void checkSetDataInProcessBeforeRemoval() {
        for (int i = 0; i < this.items.length; ++i) {
            TreeItem treeItem = this.items[i];
            if (treeItem == null || !treeItem.settingData) continue;
            this.throwCannotRemoveItem(i);
        }
    }

    private void throwCannotRemoveItem(int n) {
        String string = "Cannot remove item with index " + n + ".";
        throw new SWTException(string);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.headerCSSProvider != 0L) {
            OS.g_object_unref(this.headerCSSProvider);
            this.headerCSSProvider = 0L;
        }
    }
}

