/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Objects;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    long arrowHandle;
    long labelHandle;
    long imageHandle;
    long eventHandle;
    long proxyMenuItem;
    long provider;
    long boxHandle;
    long groupHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    Image defaultDisableImage;
    Color background;
    Color foreground;
    String toolTipText;
    boolean drawHotImage;
    boolean mapHooked;
    boolean enabled = true;
    Image currentImage;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        this.createWidget(toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        int n3 = toolBar.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        long l;
        this.state |= 8;
        int n2 = 62;
        switch (this.style & n2) {
            case 2: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_separator_new(1);
                    if (this.handle != 0L) break;
                    this.error(2);
                    break;
                }
                this.handle = GTK3.gtk_separator_tool_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_separator_tool_item_set_draw(this.handle, true);
                break;
            }
            case 4: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_box_new(0, 0);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if ((l = GTK.gtk_button_new()) == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(l, this.boxHandle);
                    long l2 = GTK.gtk_menu_button_new();
                    if (l2 == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_box_append(this.handle, l);
                    GTK4.gtk_box_append(this.handle, l2);
                    this.arrowHandle = GTK4.gtk_widget_get_first_child(l2);
                    GTK4.gtk_menu_button_set_use_underline(l2, true);
                } else {
                    this.handle = GTK3.gtk_menu_tool_button_new(0L, null);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    l = GTK3.gtk_bin_get_child(this.handle);
                    long l3 = GTK3.gtk_container_get_children(l);
                    this.arrowHandle = OS.g_list_nth_data(l3, 1);
                    OS.g_list_free(l3);
                }
                if (this.arrowHandle == 0L) break;
                GTK.gtk_widget_set_sensitive(this.arrowHandle, true);
                break;
            }
            case 16: 
            case 32: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_toggle_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(this.handle, this.boxHandle);
                    GTK.gtk_button_set_use_underline(this.handle, true);
                    break;
                }
                this.handle = GTK3.gtk_toggle_tool_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(this.handle, this.boxHandle);
                    GTK.gtk_button_set_use_underline(this.handle, true);
                    break;
                }
                this.handle = GTK3.gtk_tool_button_new(0L, null);
                if (this.handle != 0L) break;
                this.error(2);
            }
        }
        if ((this.style & 2) == 0) {
            if (GTK.GTK4) {
                this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_widget_set_valign(this.boxHandle, 3);
                GTK4.gtk_box_append(this.boxHandle, this.imageHandle);
                GTK4.gtk_box_append(this.boxHandle, this.labelHandle);
                GTK.gtk_widget_hide(this.imageHandle);
                GTK.gtk_widget_hide(this.labelHandle);
            } else {
                this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.imageHandle = GTK3.gtk_image_new_from_surface(0L);
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_tool_button_set_icon_widget(this.handle, this.imageHandle);
                GTK3.gtk_tool_button_set_label_widget(this.handle, this.labelHandle);
                GTK3.gtk_tool_button_set_use_underline(this.handle, true);
            }
        }
        if ((this.parent.state & 0x4000) != 0) {
            l = this.parent.getFontDescription();
            this.setFontDescription(l);
            OS.pango_font_description_free(l);
        }
        if (GTK.GTK4) {
            GTK.gtk_box_set_homogeneous(this.parent.handle, false);
        } else {
            GTK3.gtk_tool_item_set_homogeneous(this.handle, false);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.eventHandle != 0L) {
            this.display.removeWidget(this.eventHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar toolBar = this.parent;
        super.dispose();
        toolBar.relayout();
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkWidget();
        this.parent.forceResize();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n = this.parent.getClientWidth() - n3 - n;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            n4 = Math.max(n4, 23);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        long l = this.topHandle();
        return GTK.gtk_widget_get_sensitive(l);
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        boolean bl = GTK.GTK4 ? GTK.gtk_toggle_button_get_active(this.handle) : GTK3.gtk_toggle_tool_button_get_active(this.handle);
        return bl;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        this.parent.forceResize();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        return gtkAllocation.width;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        return this.parent.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        return this.parent.gtk_button_release_event(l, l2);
    }

    @Override
    long gtk_clicked(long l) {
        long l2;
        Event event = new Event();
        if ((this.style & 4) != 0 && (l2 = GTK3.gtk_get_current_event()) != 0L) {
            int n = GDK.gdk_event_get_event_type(l2);
            n = Control.fixGdkEventTypeValues(n);
            long l3 = this.topHandle();
            switch (n) {
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    boolean bl = false;
                    if (l == this.arrowHandle) {
                        bl = true;
                        l3 = l;
                        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 8L);
                        GTK.gtk_toggle_button_set_active(l, false);
                        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 8L);
                    }
                    if (!bl) break;
                    event.detail = 4;
                    GtkAllocation gtkAllocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(l3, gtkAllocation);
                    event.x = DPIUtil.autoScaleDown(gtkAllocation.x);
                    if ((this.style & 0x8000000) != 0) {
                        event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - gtkAllocation.width) - event.x;
                    }
                    event.y = DPIUtil.autoScaleDown(gtkAllocation.y + gtkAllocation.height);
                    break;
                }
            }
            this.gdk_event_free(l2);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    long gtk_create_menu_proxy(long l) {
        int n;
        ImageList imageList;
        if (GTK.GTK4) {
            return 0L;
        }
        byte[] byArray = Converter.wcsToMbcs("menu-id", true);
        if (this.proxyMenuItem != 0L) {
            GTK3.gtk_tool_item_set_proxy_menu_item(l, byArray, this.proxyMenuItem);
            return 1L;
        }
        Image image = this.currentImage;
        if (image != null && (imageList = this.parent.imageList) != null && (n = imageList.indexOf(image)) != -1) {
            long l2;
            long l3;
            long l4 = imageList.getSurface(n);
            byte[] byArray2 = null;
            int[] nArray = new int[]{1};
            byArray2 = this.text == null || this.text.length() == 0 ? (nArray[0] == 0 && this.toolTipText != null ? Converter.wcsToMbcs(this.toolTipText, true) : new byte[]{0}) : Converter.wcsToMbcs(this.text, true);
            long l5 = GTK3.gtk_menu_item_new();
            if (l5 == 0L) {
                this.error(2);
            }
            if ((l3 = this.gtk_box_new(0, false, 6)) == 0L) {
                this.error(2);
            }
            if ((l2 = GTK3.gtk_accel_label_new(byArray2)) == 0L) {
                this.error(2);
            }
            GTK.gtk_label_set_xalign(this.labelHandle, 0.0f);
            GTK.gtk_widget_set_halign(this.labelHandle, 0);
            long l6 = GTK3.gtk_image_new_from_surface(l4);
            if (l6 == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(l3, l6);
            this.gtk_box_pack_end(l3, l2, true, true, 0);
            GTK3.gtk_container_add(l5, l3);
            GTK3.gtk_tool_item_set_proxy_menu_item(l, byArray, l5);
            this.proxyMenuItem = GTK3.gtk_tool_item_get_proxy_menu_item(l, byArray);
            OS.g_signal_connect(l5, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        int n;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(l, l2);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && (imageList = this.parent.imageList) != null && (n = imageList.indexOf(this.hotImage)) != -1 && this.imageHandle != 0L) {
            if (GTK.GTK4) {
                long l3 = ImageList.createPixbuf(this.hotImage);
                long l4 = GDK.gdk_texture_new_for_pixbuf(l3);
                OS.g_object_unref(l3);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, l4);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(n));
            }
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Control.fixGdkEventTypeValues(n);
        switch (n) {
            case 4: {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                }
                if (nArray[0] != 3) break;
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                this.parent.showMenu((int)dArray[0], (int)dArray2[0]);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        this.parent.hasChildFocus = true;
        this.parent.currentFocusItem = this;
        this.parent.sendFocusEvent(15);
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        this.parent.hasChildFocus = false;
        this.parent.sendFocusEvent(16);
        return 0L;
    }

    @Override
    long gtk_leave_notify_event(long l, long l2) {
        this.parent.gtk_leave_notify_event(l, l2);
        if (this.drawHotImage) {
            int n;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.image != null && (imageList = this.parent.imageList) != null && (n = imageList.indexOf(this.image)) != -1 && this.imageHandle != 0L) {
                if (GTK.GTK4) {
                    long l3 = ImageList.createPixbuf(this.image);
                    long l4 = GDK.gdk_texture_new_for_pixbuf(l3);
                    OS.g_object_unref(l3);
                    GTK4.gtk_image_set_from_paintable(this.imageHandle, l4);
                } else {
                    GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(n));
                }
            }
        }
        return 0L;
    }

    @Override
    long gtk_map(long l) {
        this.parent.fixZOrder();
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        if (GTK.GTK4) {
            long l;
            if ((this.style & 4) != 0) {
                if (this.arrowHandle != 0L) {
                    l = GTK4.gtk_gesture_click_new();
                    OS.g_signal_connect(l, OS.pressed, this.display.gesturePressReleaseProc, 100L);
                    GTK4.gtk_widget_add_controller(this.arrowHandle, l);
                }
                OS.g_signal_connect_closure(GTK4.gtk_widget_get_first_child(this.handle), OS.clicked, this.display.getClosure(8), false);
            } else {
                OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
            }
            l = GTK4.gtk_event_controller_focus_new();
            GTK4.gtk_widget_add_controller(this.handle, l);
            GTK.gtk_event_controller_set_propagation_phase(l, 3);
            OS.g_signal_connect(l, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(l, OS.leave, this.display.focusProc, 87L);
            long l2 = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(this.handle, l2);
            GTK.gtk_event_controller_set_propagation_phase(l2, 3);
            OS.g_signal_connect(l2, OS.enter, this.display.enterMotionProc, 95L);
            OS.g_signal_connect(l2, OS.leave, this.display.leaveProc, 96L);
            long l3 = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.handle, l3);
            OS.g_signal_connect(l3, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            this.eventHandle = GTK3.gtk_bin_get_child(this.handle);
            if ((this.style & 4) != 0) {
                long l = GTK3.gtk_container_get_children(this.eventHandle);
                this.eventHandle = OS.g_list_nth_data(l, 0);
                OS.g_list_free(l);
                if (this.arrowHandle != 0L) {
                    OS.g_signal_connect_closure(this.arrowHandle, OS.clicked, this.display.getClosure(8), false);
                }
            }
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
            OS.g_signal_connect_closure(this.handle, OS.create_menu_proxy, this.display.getClosure(83), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            int n = 32518;
            GTK3.gtk_widget_add_events(this.eventHandle, n);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        if (!this.mapHooked) {
            long l = this.topHandle();
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[30], 0, this.display.getClosure(30), true);
            this.mapHooked = true;
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        int n;
        ToolItem[] toolItemArray = this.parent._getTabItemList();
        if (toolItemArray != null) {
            for (n = 0; n < toolItemArray.length; ++n) {
                if (toolItemArray[n] != this) continue;
                return true;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        n = this.parent.indexOf(this);
        if (n == 0) {
            return true;
        }
        ToolItem toolItem = this.parent.getItem(n - 1);
        return (toolItem.getStyle() & 2) != 0;
    }

    @Override
    void register() {
        super.register();
        if (this.eventHandle != 0L) {
            this.display.addWidget(this.eventHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.eventHandle = 0L;
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.arrowHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.currentFocusItem == this) {
            this.parent.currentFocusItem = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
        this.disposeDefault();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            this.resizeHandle(rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    void resizeHandle(int n, int n2) {
        GTK.gtk_widget_set_size_request(this.handle, n, n2);
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.parent.gtk_widget_get_preferred_size(this.handle, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        gtkAllocation.width = n;
        gtkAllocation.height = n2;
        this.gtk_widget_size_allocate(this.handle, gtkAllocation, -1);
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i = 0; i < toolItemArray.length && toolItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && toolItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < toolItemArray.length && toolItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        Color color2 = this.background;
        this.background = color;
        if (Objects.equals(color2, this.background)) {
            return;
        }
        this.updateStyle();
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
        if (control != null) {
            this.parent.fixZOrder();
            if (!this.mapHooked) {
                OS.g_signal_connect_closure_by_id(this.topHandle(), this.display.signalIds[30], 0, this.display.getClosure(30), true);
                this.mapHooked = true;
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (this.disabledImage == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        if (image != null) {
            if (!this.enabled) {
                this._setImage(image);
            }
            this.disposeDefault();
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        long l = this.topHandle();
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        GTK.gtk_widget_set_sensitive(l, bl);
        this._setEnabledOrDisabledImage();
    }

    private void _setEnabledOrDisabledImage() {
        if (!this.enabled) {
            if (this.disabledImage == null) {
                if (this.defaultDisableImage == null && this.image != null) {
                    this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
                }
                this._setImage(this.defaultDisableImage);
            } else {
                this._setImage(this.disabledImage);
            }
        }
        if (this.enabled && this.image != null) {
            this._setImage(this.image);
        }
    }

    boolean setFocus() {
        return GTK.gtk_widget_child_focus(this.handle, 0);
    }

    void setFontDescription(long l) {
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, l);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        Color color2 = this.foreground;
        this.foreground = color;
        if (Objects.equals(color2, this.foreground)) {
            return;
        }
        this.updateStyle();
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (this.hotImage == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.disposeDefault();
        if (!this.enabled && this.disabledImage != image && this.disabledImage != null) {
            return;
        }
        this._setEnabledOrDisabledImage();
    }

    private void disposeDefault() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }

    void _setImage(Image image) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.currentImage = image;
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            if (GTK.GTK4) {
                GTK.gtk_widget_show(this.imageHandle);
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(n));
            }
        } else if (GTK.GTK4) {
            GTK4.gtk_image_clear(this.imageHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        } else {
            GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
        }
        this.recreateMenuProxy();
        this.parent.relayout();
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, n);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        if (GTK.GTK4) {
            GTK.gtk_toggle_button_set_active(this.handle, bl);
        } else {
            GTK3.gtk_toggle_tool_button_set_active(this.handle, bl);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    @Override
    boolean setTabItemFocus(boolean bl) {
        return this.setFocus();
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0L) {
            return;
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        if (GTK.GTK4) {
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        } else {
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        }
        if ((this.parent.style & 0x20000) != 0 && !GTK.GTK4) {
            GTK3.gtk_tool_item_set_is_important(this.handle, !string.isEmpty());
        }
        this.recreateMenuProxy();
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string || this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        if (this.parent.toolTipText == null) {
            if (GTK.GTK4) {
                this.setToolTipText(this.handle, string);
            } else {
                long l = GTK3.gtk_bin_get_child(this.handle);
                if ((this.style & 4) != 0) {
                    long l2 = GTK3.gtk_container_get_children(l);
                    l = OS.g_list_nth_data(l2, 0);
                    OS.g_list_free(l2);
                    if (this.arrowHandle != 0L) {
                        this.setToolTipText(this.arrowHandle, string);
                    }
                }
                this.setToolTipText(l != 0L ? l : this.handle, string);
            }
        }
        this.toolTipText = string;
        this.recreateMenuProxy();
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n));
    }

    void setWidthInPixels(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.resizeHandle(n, (this.parent.style & 0x200) != 0 ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int n) {
        if (GTK.GTK4) {
            if (n == 0) {
                GTK4.gtk_box_prepend(this.parent.handle, this.handle);
            } else if (n < 0) {
                GTK4.gtk_box_append(this.parent.handle, this.handle);
            } else {
                long l = GTK4.gtk_widget_get_first_child(this.parent.handle);
                while (l != 0L) {
                    if (n == 1) {
                        GTK4.gtk_box_insert_child_after(this.parent.handle, this.handle, l);
                        break;
                    }
                    --n;
                    l = GTK4.gtk_widget_get_next_sibling(l);
                }
            }
        } else {
            if (this.handle != 0L) {
                GTK.gtk_widget_show(this.handle);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_show(this.imageHandle);
            }
            GTK3.gtk_toolbar_insert(this.parent.handle, this.handle, n);
        }
    }

    void updateStyle() {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            if ((this.style & 4) != 0) {
                var1_1 = GTK3.gtk_bin_get_child(this.handle);
                long l = GTK3.gtk_container_get_children(var1_1);
                for (int i = 0; i < 2; ++i) {
                    long l2 = OS.g_list_nth_data(l, i);
                    long l3 = GTK.gtk_widget_get_style_context(l2);
                    GTK.gtk_style_context_add_provider(l3, this.provider, 600);
                }
                OS.g_list_free(l);
            } else {
                var1_1 = GTK3.gtk_bin_get_child(this.handle);
                long l = GTK.gtk_widget_get_style_context(var1_1);
                GTK.gtk_style_context_add_provider(l, this.provider, 600);
            }
            OS.g_object_unref(this.provider);
        }
        Object object = "";
        object = this.foreground != null ? (String)object + "button { color: " + this.display.gtk_rgba_to_css_string(this.foreground.handle) + "; }" : (String)object + this.parent.cssForeground;
        if (this.background != null) {
            object = (String)object + "button { background-image: none; background-color: " + this.display.gtk_rgba_to_css_string(this.background.handle) + "; }";
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs((String)object, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs((String)object, true), -1L, null);
        }
    }

    @Override
    String getNameText() {
        String string = super.getNameText();
        Object object = this.getData();
        if (object != null) {
            return "text: '" + string + "', data: " + String.valueOf(object);
        }
        return string;
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        if (this.hotImage != null) {
            this.hotImage.internal_gtk_refreshImageForZoom();
            this.setHotImage(this.hotImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.internal_gtk_refreshImageForZoom();
            this.setDisabledImage(this.disabledImage);
        }
        return 0L;
    }

    private void recreateMenuProxy() {
        if (!((this.style & 4) == 0 && this.proxyMenuItem == 0L || GTK.GTK4)) {
            this.proxyMenuItem = 0L;
            this.proxyMenuItem = GTK3.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
        }
    }
}

