/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc = new Callback(ToolBar.class, "MenuItemSelectedProc", 2);
    String cssBackground;
    String cssForeground = " ";

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        GTK.gtk_orientable_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.handle = GTK.gtk_box_new(0, 0);
            GTK.gtk_widget_add_css_class(this.handle, Converter.javaStringToCString("toolbar"));
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.handle = GTK3.gtk_toolbar_new();
        }
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_toolbar_set_icon_size(this.handle, 2);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = null;
        if (GTK.GTK4) {
            point = this.computeNativeSize(this.handle, n, n2, bl);
        } else {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, false);
            point = this.computeNativeSize(this.handle, n, n2, bl);
            if ((this.style & 0x40) != 0) {
                GTK3.gtk_toolbar_set_show_arrow(this.handle, true);
            }
        }
        return point;
    }

    @Override
    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n = this.indexOf(this.currentFocusItem)) == -1) {
            n = toolItemArray.length - 1;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n;
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        for (int i = 0; i < toolItemArray2.length; ++i) {
            ToolItem toolItem = toolItemArray2[i];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long enterExitHandle() {
        return this.handle;
    }

    @Override
    boolean forceFocus(long l) {
        int n = 0;
        if ((this.style & 0x8000000) != 0) {
            n = 1;
        }
        long l2 = this.handle;
        if (this.currentFocusItem != null) {
            l2 = this.currentFocusItem.handle;
        }
        if (GTK.gtk_widget_child_focus(l2, n)) {
            return true;
        }
        return super.forceFocus(l);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    ToolItem getItemInPixels(Point point) {
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (!toolItemArray[i].getBoundsInPixels().contains(point)) continue;
            return toolItemArray[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = 0;
        if (GTK.GTK4) {
            long l = GTK4.gtk_widget_get_first_child(this.handle);
            while (l != 0L) {
                ++n;
                l = GTK4.gtk_widget_get_next_sibling(l);
            }
        } else {
            long l = GTK3.gtk_container_get_children(this.handle);
            if (l == 0L) {
                return 0;
            }
            n = OS.g_list_length(l);
            OS.g_list_free(l);
        }
        return n;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        if (GTK.GTK4) {
            ArrayList<ToolItem> arrayList = new ArrayList<ToolItem>();
            long l = GTK4.gtk_widget_get_first_child(this.handle);
            while (l != 0L) {
                Widget widget = this.display.getWidget(l);
                if (widget != null) {
                    arrayList.add((ToolItem)widget);
                }
                l = GTK4.gtk_widget_get_next_sibling(l);
            }
            return arrayList.toArray(new ToolItem[arrayList.size()]);
        }
        long l = GTK3.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new ToolItem[0];
        }
        int n = OS.g_list_length(l);
        ToolItem[] toolItemArray = new ToolItem[n];
        long l2 = l;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l3 = OS.g_list_data(l);
            Widget widget = this.display.getWidget(l3);
            if (widget != null) {
                toolItemArray[n2++] = (ToolItem)widget;
            }
            l = OS.g_list_next(l);
        }
        OS.g_list_free(l2);
        if (n2 != toolItemArray.length) {
            ToolItem[] toolItemArray2 = new ToolItem[n2];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, n2);
            toolItemArray = toolItemArray2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            toolItemArray[n2++] = this.tabItemList[i];
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = super.gtk_key_press_event(l, l2);
        return l3;
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 0L;
    }

    @Override
    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (toolItem != toolItemArray[i]) continue;
            return i;
        }
        return -1;
    }

    static long MenuItemSelectedProc(long l, long l2) {
        Display display = Display.getCurrent();
        ToolItem toolItem = (ToolItem)display.getWidget(l2);
        if (toolItem != null) {
            return toolItem.getParent().menuItemSelected(l, toolItem);
        }
        return 0L;
    }

    long menuItemSelected(long l, ToolItem toolItem) {
        Event event = new Event();
        switch (toolItem.style) {
            case 4: {
                event.detail = 4;
                GtkAllocation gtkAllocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(l, gtkAllocation);
                event.x = DPIUtil.autoScaleDown(gtkAllocation.x);
                if ((this.style & 0x8000000) != 0) {
                    event.x = DPIUtil.autoScaleDown(this.getClientWidth() - gtkAllocation.width) - event.x;
                }
                event.y = DPIUtil.autoScaleDown(gtkAllocation.y + gtkAllocation.height);
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                toolItem.selectRadio();
                break;
            }
            case 32: {
                boolean bl = toolItem.getSelection();
                toolItem.setSelection(!bl);
            }
        }
        toolItem.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        int n;
        ToolItem[] toolItemArray = this.getItems();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < toolItemArray.length; ++n) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem == null) continue;
            toolItem.resizeControl();
            bl |= toolItem.text != null && toolItem.text.length() > 0;
            bl2 |= toolItem.image != null;
        }
        if (!GTK.GTK4) {
            n = 0;
            if (bl && bl2) {
                n = (this.style & 0x20000) != 0 ? 3 : 2;
            } else if (bl) {
                n = 1;
            } else if (bl2) {
                n = 0;
            }
            GTK3.gtk_toolbar_set_style(this.handle, n);
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null || toolItem.isDisposed()) continue;
            toolItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    @Override
    void reskinChildren(int n) {
        ToolItem[] toolItemArray = this._getItems();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) continue;
                toolItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        if (!GTK.GTK4) {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, false);
        }
        if (((n5 = super.setBounds(n, n2, n3, n4, bl, bl2)) & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0 && !GTK.GTK4) {
            GTK3.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return n5;
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        String string = "toolbar {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}";
        this.cssBackground = string;
        String string2 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string2);
    }

    @Override
    void setParentBackground() {
        this.setBackgroundGdkRGBA(this.handle, this.display.getSystemColor((int)37).handle);
        super.setParentBackground();
    }

    @Override
    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = new GdkRGBA();
        gdkRGBA2 = gdkRGBA != null ? gdkRGBA : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long l2 = GTK.gtk_widget_get_style_context(l);
        String string = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        String string2 = this.display.gtk_widget_class_get_css_name(l);
        GdkRGBA gdkRGBA3 = this.display.COLOR_LIST_SELECTION_TEXT_RGBA;
        String string3 = "* {color: " + string + ";}\n" + string2 + " selection {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        this.cssForeground = string3;
        String string4 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(l2, string4);
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setFontDescription(l);
        }
        this.relayout();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].updateStyle();
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        ToolItem[] toolItemArray = this._getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setOrientation(bl);
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent == this) continue;
                this.error(32);
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            String string2 = string != null ? null : toolItemArray[i].toolTipText;
            this.setToolTipText(toolItemArray[i].handle, string2);
        }
    }
}

