/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventFocus;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    long bufferHandle;
    long imContext;
    int tabs = 8;
    int lastEventTime = 0;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    long textHandle;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    int[] segments;
    static final int ITER_SIZEOF = GTK.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    GdkRGBA background;
    GdkRGBA foreground;
    long indexMark = 0L;
    double cachedAdjustment;
    double currentAdjustment;

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if ((n & 0x80) != 0) {
            this.style |= 0x300;
            if (!GTK.GTK4) {
                if ((n & 0x200) == 0) {
                    this.style &= 0xFFFFFDFF;
                    GTK.gtk_entry_set_icon_from_icon_name(this.handle, 0, null);
                } else {
                    GTK.gtk_entry_set_icon_activatable(this.handle, 0, true);
                    GTK.gtk_entry_set_icon_sensitive(this.handle, 0, true);
                }
                if ((n & 0x100) == 0) {
                    this.style &= 0xFFFFFEFF;
                }
            }
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if ((this.style & 4) != 0) {
            this.handle = (this.style & 0x80) != 0 ? GTK.gtk_search_entry_new() : GTK.gtk_entry_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                OS.swt_fixed_add(this.fixedHandle, this.handle);
                this.textHandle = GTK4.gtk_editable_get_delegate(this.handle);
                this.bufferHandle = (this.style & 0x80) == 0 ? GTK4.gtk_entry_get_buffer(this.handle) : GTK4.gtk_text_get_buffer(this.textHandle);
            } else {
                GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
                GTK3.gtk_container_add(this.fixedHandle, this.handle);
                GTK3.gtk_entry_set_width_chars(this.handle, 1);
            }
            GTK.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            if (GTK.GTK4) {
                GTK4.gtk_text_set_visibility(this.textHandle, (this.style & 0x400000) == 0);
            } else {
                GTK.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            }
            if ((this.style & 0x800) == 0) {
                GTK.gtk_entry_set_has_frame(this.handle, false);
                long l = GTK.gtk_widget_get_style_context(this.handle);
                String string = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA);
                this.gtk_css_provider_load_from_css(l, "entry {border: solid; background: " + string + ";}");
                if (!GTK.GTK4) {
                    GTK3.gtk_style_context_invalidate(l);
                }
            }
            float f = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                f = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                GTK.gtk_entry_set_alignment(this.handle, f);
            }
            if (DISABLE_EMOJI && GTK.GTK_VERSION >= OS.VERSION(3, 22, 20)) {
                GTK.gtk_entry_set_input_hints(this.handle, 1024);
            }
        } else {
            this.scrolledHandle = GTK.GTK4 ? GTK4.gtk_scrolled_window_new() : GTK3.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = GTK.gtk_text_view_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.bufferHandle = GTK.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
                GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
            } else {
                GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                GTK3.gtk_container_add(this.scrolledHandle, this.handle);
            }
            GTK.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                GTK.gtk_text_view_set_wrap_mode(this.handle, 3);
            }
            int n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, n2, n3);
            if ((this.style & 0x800) != 0) {
                if (GTK.GTK4) {
                    GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
                } else {
                    GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
                }
            }
            int n4 = 0;
            if ((this.style & 0x1000000) != 0) {
                n4 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 1;
            }
            GTK.gtk_text_view_set_justification(this.handle, n4);
        }
        this.imContext = OS.imContextLast();
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(string, false);
        this.clearSegments(true);
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_insert_text(this.handle, byArray, byArray.length, new int[]{-1});
            GTK.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            GTK.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
        }
        this.applySegments();
    }

    void applySegments() {
        int n;
        String string;
        if (this.isDisposed() || !this.hooks(49) && !this.filters(49)) {
            return;
        }
        Event event = new Event();
        event.text = string = this.getText();
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int n2 = this.segments.length;
        if (n2 == 0) {
            return;
        }
        int n3 = n = string == null ? 0 : string.length();
        for (int i = 1; i < n2; ++i) {
            if (event.segments[i] >= event.segments[i - 1] && event.segments[i] <= n) continue;
            this.error(5);
        }
        char[] cArray = event.segmentsChars;
        char[] cArray2 = new char[]{this.getOrientation() == 0x4000000 ? (char)'\u200f' : '\u200e'};
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            int n4 = GTK.gtk_entry_get_max_length(this.handle);
            if (n4 != 0) {
                GTK.gtk_entry_set_max_length(this.handle, this.translateOffset(n4));
            }
            int[] nArray = new int[1];
            for (int i = 0; i < n2; ++i) {
                nArray[0] = this.segments[i] + i;
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray = Converter.wcsToMbcs(cArray2, false);
                long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(this.bufferHandle) : GTK3.gtk_entry_get_text(this.handle);
                nArray[0] = (int)OS.g_utf16_offset_to_utf8_offset(l, nArray[0]);
                GTK.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
        } else {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n2; ++i) {
                GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray2, byArray3);
                long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray3, true);
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + i));
                OS.g_free(l);
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray4 = Converter.wcsToMbcs(cArray2, false);
                GTK.gtk_text_buffer_insert(this.bufferHandle, byArray, byArray4, byArray4.length);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
        }
    }

    void clearSegments(boolean bl) {
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2;
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            if (bl) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(this.bufferHandle) : GTK3.gtk_entry_get_text(this.handle);
                for (int i = 0; i < n; ++i) {
                    int n3 = (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i]);
                    int n4 = (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + 1);
                    GTK.gtk_editable_delete_text(this.handle, n3, n4);
                }
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            }
            if ((n2 = GTK.gtk_entry_get_max_length(this.handle)) != 0) {
                GTK.gtk_entry_set_max_length(this.handle, this.untranslateOffset(n2));
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        } else if (bl) {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            byte[] byArray4 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n; ++i) {
                GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray3, byArray4);
                long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray4, true);
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i]));
                GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + 1));
                GTK.gtk_text_buffer_delete(this.bufferHandle, byArray, byArray2);
                OS.g_free(l);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
        }
        this.segments = null;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = GTK.gtk_editable_get_position(this.handle);
            GTK.gtk_editable_select_region(this.handle, n, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        long l;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((this.style & 4) != 0) {
            long l2;
            if (GTK.GTK4) {
                var8_6 = GTK.gtk_widget_get_pango_context(this.handle);
                l2 = OS.pango_layout_new(var8_6);
            } else {
                GTK.gtk_widget_realize(this.handle);
                l2 = GTK3.gtk_entry_get_layout(this.handle);
            }
            OS.pango_layout_get_pixel_size(l2, nArray, nArray2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            var8_6 = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            long l3 = GTK.gtk_widget_create_pango_layout(this.handle, var8_6);
            OS.g_free(var8_6);
            OS.pango_layout_set_width(l3, n * 1024);
            OS.pango_layout_get_pixel_size(l3, nArray, nArray2);
            OS.g_object_unref(l3);
        }
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] byArray = Converter.wcsToMbcs(this.message, true);
            l = GTK.gtk_widget_create_pango_layout(this.handle, byArray);
            Arrays.fill(byArray, (byte)0);
            OS.pango_layout_get_pixel_size(l, nArray, nArray2);
            OS.g_object_unref(l);
            n3 = Math.max(n3, nArray[0]);
        }
        if ((this.style & 0x80) != 0) {
            GtkBorder gtkBorder = new GtkBorder();
            l = GTK.gtk_widget_get_style_context(this.handle);
            int n5 = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_padding(l, n5, gtkBorder);
            n3 += gtkBorder.left + gtkBorder.right;
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        n3 = n == -1 ? n3 : n;
        n4 = n2 == -1 ? n4 : n2;
        Rectangle rectangle = this.computeTrimInPixels(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        Object object;
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 4) != 0) {
            Object object2;
            object = new GtkBorder();
            long l = GTK.gtk_widget_get_style_context(this.handle);
            int n7 = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_padding(l, n7, (GtkBorder)object);
            rectangle.x -= ((GtkBorder)object).left;
            rectangle.y -= ((GtkBorder)object).top;
            rectangle.width += ((GtkBorder)object).left + ((GtkBorder)object).right;
            if (((GtkBorder)object).bottom == 0 && ((GtkBorder)object).top == 0) {
                object2 = this.computeNativeSize(this.handle, rectangle.width, -1, true);
                rectangle.height = ((Point)object2).y;
            } else {
                rectangle.height += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
            }
            if ((this.style & 0x800) != 0) {
                int n8 = GTK.gtk_widget_get_state_flags(this.handle);
                this.gtk_style_context_get_border(l, n8, (GtkBorder)object);
                rectangle.x -= ((GtkBorder)object).left;
                rectangle.y -= ((GtkBorder)object).top;
                rectangle.width += ((GtkBorder)object).left + ((GtkBorder)object).right;
                rectangle.height += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
            }
            if (!GTK.GTK4 || (this.style & 0x80) == 0) {
                object2 = new GdkRectangle();
                GTK.gtk_entry_get_icon_area(this.handle, 0, (GdkRectangle)object2);
                rectangle.x -= ((GdkRectangle)object2).width;
                rectangle.width += ((GdkRectangle)object2).width;
                GTK.gtk_entry_get_icon_area(this.handle, 1, (GdkRectangle)object2);
                rectangle.width += ((GdkRectangle)object2).width;
            }
        } else {
            int n9 = this.gtk_container_get_border_width_or_margin(this.handle);
            n5 += n9;
            n6 += n9;
        }
        if (!GTK.GTK4) {
            object = new int[1];
            GTK3.gtk_widget_style_get(this.handle, OS.interior_focus, (int[])object, 0L);
            if (object[0] == false) {
                GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, (int[])object, 0L);
                n5 += object[0];
                n6 += object[0];
            }
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_widget_activate_action(this.textHandle, OS.action_copy_clipboard, null);
            } else {
                GTK3.gtk_editable_copy_clipboard(this.handle);
            }
        } else {
            long l = GTK.GTK4 ? GTK4.gtk_widget_get_clipboard(this.handle) : GTK3.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_copy_clipboard(this.bufferHandle, l);
            this.applySegments();
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_widget_activate_action(this.textHandle, OS.action_cut_clipboard, null);
            } else {
                GTK3.gtk_editable_cut_clipboard(this.handle);
            }
        } else {
            long l = GTK.GTK4 ? GTK4.gtk_widget_get_clipboard(this.handle) : GTK3.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_cut_clipboard(this.bufferHandle, l, GTK.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    char[] deprocessText(char[] cArray, int n, int n2) {
        int n3;
        if (cArray == null) {
            return new char[0];
        }
        if (n < 0) {
            n = 0;
        }
        int n4 = cArray.length;
        if (n2 == -1) {
            n2 = n + n4;
        }
        if (this.segments != null && n2 > this.segments[0] && (n3 = this.segments.length) > 0 && n <= this.segments[n3 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            for (int i = n; i < n2; ++i) {
                if (n6 < n3 && i - n6 == this.segments[n6]) {
                    ++n6;
                    continue;
                }
                cArray[i - n6 + n5 - n] = cArray[i - n];
            }
            n4 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n + n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            return cArray2;
        }
        return cArray;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.bufferHandle != 0L) {
            this.display.removeWidget(this.bufferHandle);
        }
        if (this.imContext != 0L) {
            this.display.removeWidget(this.imContext);
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        return false;
    }

    @Override
    long eventWindow() {
        if ((this.style & 4) != 0) {
            long l = super.paintWindow();
            long l2 = GDK.gdk_window_get_children(l);
            if (l2 != 0L) {
                long l3 = l2;
                do {
                    l = OS.g_list_data(l3);
                } while ((l3 = OS.g_list_next(l3)) != 0L);
            }
            OS.g_list_free(l2);
            return l;
        }
        return this.paintWindow();
    }

    @Override
    boolean filterKey(long l) {
        int n = GDK.gdk_event_get_time(l);
        if (n != this.lastEventTime) {
            this.lastEventTime = n;
            if (this.imContext != 0L) {
                if (GTK.GTK4) {
                    return GTK4.gtk_im_context_filter_keypress(this.imContext, l);
                }
                return GTK3.gtk_im_context_filter_keypress(this.imContext, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    void fixIM() {
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && this.imContext != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_im_context_filter_keypress(this.imContext, this.gdkEventKey);
            } else {
                GTK3.gtk_im_context_filter_keypress(this.imContext, this.gdkEventKey);
            }
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidthInPixels();
        }
        if ((this.style & 0x800) != 0) {
            return this.getThickness((long)this.handle).x;
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
        return GTK.gtk_text_iter_get_line(byArray);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = GTK.gtk_editable_get_position(this.handle);
            n = GTK3.gtk_entry_text_index_to_layout_index(this.handle, n);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK3.gtk_entry_get_layout_offsets(this.handle, nArray, nArray2);
            long l = GTK3.gtk_entry_get_layout(this.handle);
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_index_to_pos(l, n, pangoRectangle);
            int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidthInPixels();
            int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
            return new Point(n2, n3);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_iter_location(this.handle, byArray, gdkRectangle);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        GTK.gtk_text_view_buffer_to_window_coords(this.handle, 2, gdkRectangle.x, gdkRectangle.y, nArray, nArray3);
        return new Point(nArray[0], nArray3[0]);
    }

    public int getCaretPosition() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = GTK3.gtk_entry_get_text(this.handle);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_editable_get_position(this.handle));
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, l);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            long l2 = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l2, GTK.gtk_text_iter_get_offset(byArray));
            OS.g_free(l2);
        }
        return this.untranslateOffset(n);
    }

    public int getCharCount() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (GTK.GTK4) {
                n = GTK4.gtk_entry_get_text_length(this.handle);
            } else {
                long l = GTK3.gtk_entry_get_text(this.handle);
                n = (int)OS.g_utf16_strlen(l, -1L);
            }
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = (int)OS.g_utf16_strlen(l, -1L);
            OS.g_free(l);
        }
        return this.untranslateOffset(n);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !GTK.gtk_entry_get_visibility(this.handle)) {
            return GTK.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return GTK.gtk_editable_get_editable(this.handle);
        }
        return GTK.gtk_text_view_get_editable(this.handle);
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return GTK.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        long l = this.getFontDescription();
        int n = this.fontHeight(l, this.handle);
        OS.pango_font_description_free(l);
        return n;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = -1;
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = GTK3.gtk_entry_get_layout(this.handle);
            OS.pango_layout_xy_to_index(l, point.x * 1024, point.y * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            n = (int)OS.g_utf16_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            GTK.gtk_text_view_get_iter_at_location(this.handle, byArray, point.x, point.y);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset(byArray));
            OS.g_free(l);
        }
        return this.untranslateOffset(n);
    }

    public Point getSelection() {
        Point point;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(GTK4.gtk_entry_get_buffer(this.handle)) : GTK3.gtk_entry_get_text(this.handle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
            point = new Point(nArray[0], nArray2[0]);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
            byte[] byArray3 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
            long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
            int n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset(byArray));
            int n2 = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset(byArray2));
            OS.g_free(l);
            point = new Point(n, n2);
        }
        point.x = this.untranslateOffset(point.x);
        point.y = this.untranslateOffset(point.y);
        return point;
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return Math.abs(point.y - point.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point point = this.getSelection();
        return this.getText().substring(point.x, point.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n) {
        byte[] byArray = Converter.wcsToMbcs(" ", true);
        long l = GTK.gtk_widget_create_pango_layout(this.handle, byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(l, nArray, nArray2);
        OS.g_object_unref(l);
        return nArray[0] * n;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    public char[] getTextChars() {
        byte[] byArray;
        long l;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(this.bufferHandle) : GTK3.gtk_entry_get_text(this.handle);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byArray = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray2, byArray);
            l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        }
        if (l == 0L) {
            return new char[0];
        }
        int n = C.strlen(l);
        byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        if ((this.style & 2) != 0) {
            OS.g_free(l);
        }
        char[] cArray = Converter.mbcsToWcs(byArray);
        Arrays.fill(byArray, (byte)0);
        if (this.segments != null) {
            cArray = this.deprocessText(cArray, 0, -1);
        }
        return cArray;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int n = GTK.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : this.untranslateOffset(n);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(l);
        if (this.cachedAdjustment == this.currentAdjustment && this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, this.indexMark);
            return GTK.gtk_text_iter_get_line(byArray);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        GTK.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, null);
        return GTK.gtk_text_iter_get_line(byArray);
    }

    public int getTopPixel() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTopPixelInPixels());
    }

    int getTopPixelInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        int[] nArray = new int[1];
        GTK.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, nArray);
        return nArray[0];
    }

    @Override
    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int n = GDK.gdk_event_get_event_type(l2);
        if (!this.doubleClick) {
            switch (n) {
                case 5: 
                case 6: {
                    return 1L;
                }
            }
        }
        return l3;
    }

    @Override
    long gtk_changed(long l) {
        long l2;
        boolean bl = false;
        long l3 = l2 = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            int n = GDK.gdk_event_get_event_type(l2);
            n = Text.fixGdkEventTypeValues(n);
            switch (n) {
                case 8: {
                    bl = true;
                }
            }
            this.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && !GTK.GTK4 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name(this.handle, 1, null);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if ((this.style & 4) != 0 && !GTK.gtk_editable_get_editable(this.handle)) {
            return 0L;
        }
        int n = C.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        Arrays.fill(byArray, (byte)0);
        char[] cArray2 = this.sendIMKeyEvent(1, 0L, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
            Arrays.fill(byArray, (byte)0);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(this.handle, this.fixStart);
            GTK.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_range(long l, long l2, long l3) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        C.memmove(byArray, l2, (long)byArray.length);
        C.memmove(byArray2, l3, (long)byArray2.length);
        int n = GTK.gtk_text_iter_get_offset(byArray);
        int n2 = GTK.gtk_text_iter_get_offset(byArray2);
        byte[] byArray3 = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
        long l4 = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l4, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, n2);
        OS.g_free(l4);
        String string = this.verifyText("", n, n2);
        if (string == null) {
            GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
            n = GTK.gtk_text_iter_get_offset(byArray);
            n2 = GTK.gtk_text_iter_get_offset(byArray2);
            if (n != n2) {
                this.fixStart = n;
                this.fixEnd = n2;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (string.length() > 0) {
            byte[] byArray4 = Converter.wcsToMbcs(string, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            GTK.gtk_text_buffer_delete(this.bufferHandle, byArray, byArray2);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert(this.bufferHandle, byArray, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
            Arrays.fill(byArray4, (byte)0);
        }
        return 0L;
    }

    @Override
    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = GTK3.gtk_entry_get_text(this.handle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            if (nArray[0] != nArray2[0]) {
                this.fixStart = nArray[0];
                this.fixEnd = nArray2[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(this.handle, nArray[0]);
            Arrays.fill(byArray, (byte)0);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int n = GDK.gdk_event_get_event_type(l2);
            n = Text.fixGdkEventTypeValues(n);
            switch (n) {
                case 12: {
                    boolean[] blArray = new boolean[1];
                    if (GTK.GTK4) {
                        blArray[0] = GDK.gdk_focus_event_get_in(l2);
                    } else {
                        GdkEventFocus gdkEventFocus = new GdkEventFocus();
                        GTK3.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                        boolean bl = blArray[0] = gdkEventFocus.in != 0;
                    }
                    if (!blArray[0]) break;
                    long l3 = GTK.gtk_settings_get_default();
                    OS.g_object_set(l3, GTK.gtk_entry_select_on_focus, true, 0L);
                }
            }
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long l3 = super.gtk_draw(l, l2);
        return l3;
    }

    @Override
    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    @Override
    long gtk_grab_focus(long l) {
        long l2 = super.gtk_grab_focus(l);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            long l3 = GTK.gtk_settings_get_default();
            OS.g_object_set(l3, GTK.gtk_entry_select_on_focus, false, 0L);
        }
        return l2;
    }

    @Override
    long gtk_icon_release(long l, long l2, long l3) {
        Event event = new Event();
        event.detail = l2 == 0L ? 512 : 256;
        this.sendSelectionEvent(14, event, false);
        return 0L;
    }

    @Override
    long gtk_insert_text(long l, long l2, long l3, long l4) {
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        C.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        int[] nArray = new int[1];
        C.memmove(nArray, l4, 4L);
        long l5 = GTK3.gtk_entry_get_text(this.handle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        int n = nArray[0];
        int n2 = nArray[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = nArray[0] = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n), n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2))) != string2 && this.handle != 0L) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            C.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3;
        boolean bl = false;
        boolean bl2 = false;
        if (this.hooks(49) || this.filters(49)) {
            int n = 0;
            int[] nArray = new int[1];
            if (GTK.GTK4) {
                nArray[0] = GDK.gdk_event_get_modifier_state(l2);
            } else {
                GDK.gdk_event_get_state(l2, nArray);
                GdkEventKey gdkEventKey = new GdkEventKey();
                GTK3.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
                n = gdkEventKey.length;
            }
            if (n > 0 && (nArray[0] & 0xC) == 0) {
                bl = true;
                if (this.segments != null) {
                    this.clearSegments(true);
                    bl2 = true;
                }
            }
        }
        if ((l3 = super.gtk_key_press_event(l, l2)) != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if (bl && (l3 != 0L || bl2)) {
            this.applySegments();
        }
        return l3;
    }

    @Override
    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(l2, 2);
            GTK3.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_text_buffer_insert_text(long l, long l2, long l3, long l4) {
        int n;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        C.memmove(byArray, l2, (long)byArray.length);
        int n2 = n = GTK.gtk_text_iter_get_offset(byArray);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] byArray2 = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
        long l5 = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2);
        OS.g_free(l5);
        byte[] byArray3 = new byte[(int)l4];
        C.memmove(byArray3, l3, (long)byArray3.length);
        String string = new String(Converter.mbcsToWcs(byArray3));
        String string2 = this.verifyText(string, n, n2);
        if (string2 == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (string2 != string) {
            byte[] byArray4 = Converter.wcsToMbcs(string2, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert(this.bufferHandle, l2, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            if (!GTK.GTK4) {
                OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.getClosure(23), false);
            }
            if ((this.style & 0x80) != 0 && !GTK.GTK4) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.getClosure(67), false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.getClosure(6), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.getClosure(52), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.getClosure(12), false);
        }
        if (this.imContext != 0L) {
            OS.g_signal_connect_closure(this.imContext, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(this.imContext, n2, n, 0, 0L, 0L, this.handle);
        }
        if (!GTK.GTK4) {
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        long l = 0L;
        l = GTK.GTK4 ? ((this.style & 4) != 0 ? this.textHandle : this.handle) : this.handle;
        OS.g_signal_connect_closure(l, OS.backspace, this.display.getClosure(70), false);
        OS.g_signal_connect_closure(l, OS.backspace, this.display.getClosure(71), true);
        OS.g_signal_connect_closure(l, OS.copy_clipboard, this.display.getClosure(72), false);
        OS.g_signal_connect_closure(l, OS.copy_clipboard, this.display.getClosure(73), true);
        OS.g_signal_connect_closure(l, OS.cut_clipboard, this.display.getClosure(74), false);
        OS.g_signal_connect_closure(l, OS.cut_clipboard, this.display.getClosure(75), true);
        OS.g_signal_connect_closure(l, OS.paste_clipboard, this.display.getClosure(76), false);
        OS.g_signal_connect_closure(l, OS.paste_clipboard, this.display.getClosure(77), true);
        OS.g_signal_connect_closure(l, OS.delete_from_cursor, this.display.getClosure(78), false);
        OS.g_signal_connect_closure(l, OS.delete_from_cursor, this.display.getClosure(79), true);
        OS.g_signal_connect_closure(l, OS.move_cursor, this.display.getClosure(80), false);
        OS.g_signal_connect_closure(l, OS.move_cursor, this.display.getClosure(81), true);
        OS.g_signal_connect_closure(l, OS.direction_changed, this.display.getClosure(82), true);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.clearSegments(true);
        byte[] byArray = Converter.wcsToMbcs(string, false);
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            GTK.gtk_editable_delete_selection(this.handle);
            GTK.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            GTK.gtk_editable_set_position(this.handle, nArray[0]);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            if (GTK.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray2, byArray3)) {
                GTK.gtk_text_buffer_delete(this.bufferHandle, byArray2, byArray3);
            }
            GTK.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            this.scrollIfNotVisible(byArray2, null, true);
        }
        this.applySegments();
    }

    private void scrollIfNotVisible(byte[] byArray, byte[] byArray2, boolean bl) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray3 = new byte[ITER_SIZEOF];
        GTK.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        int n = this.getLineHeight();
        int n2 = gdkRectangle.height / n;
        GTK.gtk_text_view_get_line_yrange(this.handle, byArray, nArray, null);
        if (this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray3, this.indexMark);
            GTK.gtk_text_view_get_line_yrange(this.handle, byArray3, nArray2, null);
            int n3 = (nArray[0] - nArray2[0]) / n;
            if (n3 >= n2) {
                if (bl) {
                    long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
                } else if (byArray2 != null) {
                    GTK.gtk_text_view_scroll_to_iter(this.handle, byArray2, 0.0, true, 0.0, 0.0);
                }
            }
        } else {
            nArray2[0] = 0;
            int n4 = (nArray[0] - nArray2[0]) / n;
            if (n4 >= n2) {
                if (byArray2 != null && !bl) {
                    GTK.gtk_text_view_scroll_to_iter(this.handle, byArray2, 0.0, true, 0.0, 0.0);
                } else if (bl) {
                    long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    long paintWindow() {
        if ((this.style & 4) != 0) {
            return super.paintWindow();
        }
        if (GTK.GTK4) {
            return 0L;
        }
        GTK.gtk_widget_realize(this.handle);
        return GTK3.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_widget_activate_action(this.textHandle, OS.action_paste_clipboard, null);
            } else {
                GTK3.gtk_editable_paste_clipboard(this.handle);
            }
        } else {
            long l = GTK.GTK4 ? GTK4.gtk_widget_get_clipboard(this.handle) : GTK3.gtk_clipboard_get(0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_paste_clipboard(this.bufferHandle, l, null, GTK.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    @Override
    void register() {
        super.register();
        if (this.bufferHandle != 0L) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if (this.imContext != 0L) {
            this.display.addWidget(this.imContext, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, 0);
            GTK.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray2);
        }
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA == null ? this.defaultBackground() : gdkRGBA;
        GdkRGBA gdkRGBA2 = this.display.getSystemColor((int)26).handle;
        GdkRGBA gdkRGBA3 = this.display.getSystemColor((int)27).handle;
        String string = (this.style & 4) != 0 ? "entry {background: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\nentry:selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}\nentry selection {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}" : "textview text {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\ntextview text:selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}\ntextview text selection {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        String string2 = string;
        this.cssBackground = string2;
        String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string3);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.foreground = gdkRGBA;
        GdkRGBA gdkRGBA2 = gdkRGBA == null ? this.display.COLOR_WIDGET_FOREGROUND_RGBA : gdkRGBA;
        this.setForegroundGdkRGBA(this.handle, gdkRGBA2);
    }

    @Override
    void setCursor(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l2 = GTK.GTK4 ? GDK.gdk_cursor_new_from_name("xterm", 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "xterm");
        }
        super.setCursor(l != 0L ? l : l2);
        if (l == 0L) {
            OS.g_object_unref(l2);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_visibility(this.handle, c == '\u0000');
            GTK.gtk_entry_set_invisible_char(this.handle, c);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_set_editable(this.handle, bl);
        } else {
            GTK.gtk_text_view_set_editable(this.handle, bl);
        }
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.setTabStops(this.tabs);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs(string, true);
            if (GTK.GTK4) {
                GTK4.gtk_text_set_placeholder_text(this.textHandle, byArray);
            } else {
                GTK.gtk_entry_set_placeholder_text(this.handle, byArray);
            }
            return;
        }
        this.redraw(false);
    }

    @Override
    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = this.translateOffset(n);
        if ((this.style & 4) != 0) {
            long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(GTK4.gtk_entry_get_buffer(this.handle)) : GTK3.gtk_entry_get_text(this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            GTK.gtk_editable_set_position(this.handle, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            OS.g_free(l);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, byArray);
            this.scrollIfNotVisible(byArray, byArray, false);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        if ((this.style & 4) != 0) {
            long l = GTK.GTK4 ? GTK.gtk_entry_buffer_get_text(this.bufferHandle) : GTK3.gtk_entry_get_text(this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            GTK.gtk_editable_set_position(this.handle, n);
            GTK.gtk_editable_select_region(this.handle, n, n2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            long l = GTK.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            OS.g_free(l);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, n2);
            this.scrollIfNotVisible(byArray, byArray, false);
            GTK.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray2);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.tabs = n;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n) {
        int n2 = this.getTabWidth(n);
        long l = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(l, 0, 0L, n2);
        if ((this.style & 4) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_text_set_tabs(this.textHandle, l);
            } else {
                GTK.gtk_entry_set_tabs(this.handle, l);
            }
        } else {
            GTK.gtk_text_view_set_tabs(this.handle, l);
        }
        OS.pango_tab_array_free(l);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        this.setText(cArray);
    }

    public void setTextChars(char[] cArray) {
        this.checkWidget();
        if (cArray == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(cArray), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        }
        this.setText(cArray);
    }

    void setText(char[] cArray) {
        this.clearSegments(false);
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs(cArray, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            if (GTK.GTK4) {
                GTK.gtk_entry_buffer_set_text(this.bufferHandle, byArray, -1);
            } else {
                GTK3.gtk_entry_set_text(this.handle, byArray);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            Arrays.fill(byArray, (byte)0);
        } else {
            byte[] byArray = Converter.wcsToMbcs(cArray, false);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_set_text(this.bufferHandle, byArray, byArray.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            GTK.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            long l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
            Arrays.fill(byArray, (byte)0);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && !GTK.GTK4 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name(this.handle, 1, null);
        }
        this.applySegments();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_max_length(this.handle, this.segments != null ? Math.min(LIMIT, this.translateOffset(n)) : n);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_line(this.bufferHandle, byArray, n);
        byte[] byArray2 = Converter.wcsToMbcs("index_mark", true);
        this.indexMark = GTK.gtk_text_buffer_create_mark(this.bufferHandle, byArray2, byArray, true);
        GTK.gtk_text_view_scroll_to_mark(this.handle, this.indexMark, 0.0, true, 0.0, 0.0);
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(l);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long l = GTK.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
        l = GTK.gtk_text_buffer_get_insert(this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark(this.handle, l, 0.0, true, 0.0, 0.0);
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    @Override
    boolean translateTraversal(long l) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l);
        } else {
            GDK.gdk_event_get_keyval(l, nArray);
        }
        switch (nArray[0]) {
            case 65293: 
            case 65421: {
                if (this.imContext == 0L) break;
                long[] lArray = new long[1];
                GTK.gtk_im_context_get_preedit_string(this.imContext, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n = C.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n == 0) break;
                return false;
            }
        }
        return super.translateTraversal(l);
    }

    @Override
    int traversalCode(int n, long l) {
        int n2 = super.traversalCode(n, l);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 65289 && l != 0L) {
                boolean bl;
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_event_get_modifier_state(l);
                } else {
                    GDK.gdk_event_get_state(l, nArray);
                }
                boolean bl2 = bl = (nArray[0] & 1) == 0;
                if (bl && (nArray[0] & 4) == 0) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    String verifyText(String string, int n, int n2) {
        long l;
        if (string != null && string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l2 = l = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l != 0L) {
            int n3 = GDK.gdk_event_get_event_type(l);
            n3 = Text.fixGdkEventTypeValues(n3);
            switch (n3) {
                case 8: {
                    this.setKeyState(event, l);
                }
            }
            this.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    @Override
    long windowProc(long l, long l2) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l2) {
                case 70: 
                case 72: 
                case 74: 
                case 76: {
                    this.clearSegments(true);
                    break;
                }
                case 71: 
                case 73: 
                case 75: 
                case 77: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2);
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l3) {
                case 82: {
                    this.clearSegments(true);
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3);
    }

    @Override
    long windowProc(long l, long l2, long l3, long l4) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l4) {
                case 78: {
                    this.clearSegments(true);
                    break;
                }
                case 79: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3, l4);
    }

    @Override
    long windowProc(long l, long l2, long l3, long l4, long l5) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l5) {
                case 80: {
                    if (l2 != 1L) break;
                    this.clearSegments(true);
                    break;
                }
                case 81: {
                    if (l2 != 1L) break;
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3, l4, l5);
    }
}

