/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventMotion;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    long defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;
    private static final int DEFAULT_CROSS_AXIS_SIZE = 3;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = this.getBorderWidthInPixels();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_widget_set_focusable(this.handle, true);
            this.defaultCursor = (this.style & 0x200) != 0 ? GDK.gdk_cursor_new_from_name("sb_h_double_arrow", 0L) : GDK.gdk_cursor_new_from_name("sb_v_double_arrow", 0L);
        } else {
            GTK3.gtk_widget_set_has_window(this.handle, true);
            this.defaultCursor = (this.style & 0x200) != 0 ? GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "sb_h_double_arrow") : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "sb_v_double_arrow");
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        super.gtk_gesture_press_event(l, n, d, d2, l2);
        int n2 = GDK.gdk_button_event_get_button(l2);
        if (n2 != 1 || n != 1) {
            return;
        }
        this.startX = (int)d;
        this.startY = (int)d2;
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n3 = gtkAllocation.x;
        int n4 = gtkAllocation.y;
        int n5 = gtkAllocation.width;
        int n6 = gtkAllocation.height;
        this.lastX = n3;
        this.lastY = n4;
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(l2);
        Rectangle rectangle = new Rectangle(this.lastX, this.lastY, n5, n6);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n5) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.dragging = true;
        }
    }

    @Override
    void gtk_gesture_release_event(long l, int n, double d, double d2, long l2) {
        super.gtk_gesture_release_event(l, n, d, d2, l2);
        int n2 = GDK.gdk_button_event_get_button(l2);
        if (n2 != 1 || !this.dragging) {
            return;
        }
        this.dragging = false;
    }

    @Override
    void gtk4_motion_event(long l, double d, double d2, long l2) {
        super.gtk4_motion_event(l, d, d2, l2);
        if (!this.dragging) {
            return;
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        GTK.gtk_widget_get_allocation(this.parent.handle, gtkAllocation);
        int n5 = gtkAllocation.width;
        int n6 = gtkAllocation.height;
        int n7 = this.lastX;
        int n8 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n7 = Math.min(Math.max(0, (int)d + n - this.startX), n5 - n3);
        } else {
            n8 = Math.min(Math.max(0, (int)d2 + n2 - this.startY), n6 - n4);
        }
        if (n7 == this.lastX && n8 == this.lastY) {
            return;
        }
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(l2);
        Rectangle rectangle = new Rectangle(n7, n8, n3, n4);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n3) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
        if (event.doit) {
            this.lastX = rectangle2.x;
            this.lastY = rectangle2.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n3 - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        if ((this.style & 0x10000) != 0) {
            this.setBoundsInPixels(this.lastX, this.lastY, n3, n4);
        }
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        boolean bl = super.gtk4_key_press_event(l, n, n2, n3, l2);
        if (!bl) {
            return bl;
        }
        switch (n) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int n4 = 0;
                int n5 = 0;
                int n6 = 9;
                if ((n3 & 4) != 0) {
                    n6 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (n == 65362 || n == 65364) break;
                    n4 = n == 65361 ? -n6 : n6;
                } else {
                    if (n == 65361 || n == 65363) break;
                    n5 = n == 65362 ? -n6 : n6;
                }
                GtkAllocation gtkAllocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
                int n7 = gtkAllocation.width;
                int n8 = gtkAllocation.height;
                GTK.gtk_widget_get_allocation(this.parent.handle, gtkAllocation);
                int n9 = gtkAllocation.width;
                int n10 = gtkAllocation.height;
                int n11 = this.lastX;
                int n12 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n11 = Math.min(Math.max(0, this.lastX + n4 - this.startX), n9 - n7);
                } else {
                    n12 = Math.min(Math.max(0, this.lastY + n5 - this.startY), n10 - n8);
                }
                if (n11 == this.lastX && n12 == this.lastY) {
                    return bl;
                }
                Event event = new Event();
                event.time = GDK.gdk_event_get_time(l2);
                Rectangle rectangle = new Rectangle(n11, n12, n7, n8);
                event.setBounds(DPIUtil.autoScaleDown(rectangle));
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n7) - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed() || !event.doit) break;
                Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
                this.lastX = rectangle2.x;
                this.lastY = rectangle2.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - n7 - this.lastX;
                }
                if ((this.style & 0x10000) == 0) break;
                this.setBoundsInPixels(rectangle2.x, rectangle2.y, n7, n8);
                if (!this.isDisposed()) break;
                break;
            }
        }
        return bl;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int[] nArray = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        if (nArray[0] != 1) {
            return 0L;
        }
        int n = GDK.gdk_event_get_event_type(l2);
        if (n == 5) {
            return 0L;
        }
        if (n == 6) {
            return 0L;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
        long l4 = this.gtk_widget_get_window(l);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        GDK.gdk_window_get_origin(l4, nArray2, nArray3);
        this.startX = (int)(dArray[0] - (double)nArray2[0]);
        this.startY = (int)(dArray2[0] - (double)nArray3[0]);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = gtkAllocation.width;
        int n5 = gtkAllocation.height;
        this.lastX = n2;
        this.lastY = n3;
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(l2);
        Rectangle rectangle = new Rectangle(this.lastX, this.lastY, n4, n5);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n4) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (event.doit) {
            this.dragging = true;
            Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
            this.lastX = rectangle2.x;
            this.lastY = rectangle2.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n4 - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            if ((this.style & 0x10000) != 0) {
                this.setBoundsInPixels(rectangle2.x, rectangle2.y, n4, n5);
            }
        }
        return l3;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        long l3 = super.gtk_button_release_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int[] nArray = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        if (nArray[0] != 1 || !this.dragging) {
            return 0L;
        }
        this.dragging = false;
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(l2);
        Rectangle rectangle = new Rectangle(this.lastX, this.lastY, n, n2);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return l3;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
            this.setBoundsInPixels(rectangle2.x, rectangle2.y, n, n2);
        }
        return l3;
    }

    @Override
    long gtk_draw(long l, long l2) {
        long l3 = GTK.gtk_widget_get_style_context(l);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        GTK.gtk_render_background(l3, l2, 0.0, 0.0, n, n2);
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (this.handle != 0L) {
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
            this.lastX = gtkAllocation.x;
            this.lastY = gtkAllocation.y;
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_keyval(l2, nArray);
        GDK.gdk_event_get_state(l2, nArray2);
        switch (nArray[0]) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int n = 0;
                int n2 = 0;
                int n3 = 9;
                if ((nArray2[0] & 4) != 0) {
                    n3 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (nArray[0] == 65362 || nArray[0] == 65364) break;
                    n = nArray[0] == 65361 ? -n3 : n3;
                } else {
                    if (nArray[0] == 65361 || nArray[0] == 65363) break;
                    n2 = nArray[0] == 65362 ? -n3 : n3;
                }
                GtkAllocation gtkAllocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
                int n4 = gtkAllocation.width;
                int n5 = gtkAllocation.height;
                GTK.gtk_widget_get_allocation(this.parent.handle, gtkAllocation);
                int n6 = gtkAllocation.width;
                int n7 = gtkAllocation.height;
                int n8 = this.lastX;
                int n9 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n8 = Math.min(Math.max(0, this.lastX + n - this.startX), n6 - n4);
                } else {
                    n9 = Math.min(Math.max(0, this.lastY + n2 - this.startY), n7 - n5);
                }
                if (n8 == this.lastX && n9 == this.lastY) {
                    return l3;
                }
                long l4 = this.gtk_widget_get_window(this.handle);
                int n10 = 516;
                long l5 = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int n11 = this.gdk_pointer_grab(l4, 0, false, n10, l4, l5, 0);
                Event event = new Event();
                event.time = GDK.gdk_event_get_time(l2);
                Rectangle rectangle = new Rectangle(n8, n9, n4, n5);
                event.setBounds(DPIUtil.autoScaleDown(rectangle));
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n4) - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (n11 == 0) {
                    this.gdk_pointer_ungrab(l4, 0);
                }
                if (this.isDisposed() || !event.doit) break;
                Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
                this.lastX = rectangle2.x;
                this.lastY = rectangle2.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - n4 - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBoundsInPixels(rectangle2.x, rectangle2.y, n4, n5);
                    if (this.isDisposed()) break;
                }
                int n12 = rectangle2.x;
                int n13 = rectangle2.y;
                if ((this.style & 0x200) != 0) {
                    n13 += n5 / 2;
                } else {
                    n12 += n4 / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplayInPixels(n12, n13));
            }
        }
        return l3;
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        int n;
        int n2;
        int n3;
        Object object;
        boolean bl;
        long l3 = super.gtk_motion_notify_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (!this.dragging) {
            return 0L;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
        int[] nArray = new int[1];
        GDK.gdk_event_get_state(l2, nArray);
        long l4 = this.gdk_event_get_surface_or_window(l2);
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        GTK3.memmove(gdkEventMotion, l2, (long)GdkEventMotion.sizeof);
        boolean bl2 = bl = gdkEventMotion.is_hint != 0;
        if (bl) {
            object = new int[1];
            var18_11 = new int[1];
            int[] nArray2 = new int[1];
            this.display.getWindowPointerPosition(l4, (int[])object, var18_11, nArray2);
            n3 = object[0];
            n2 = var18_11[0];
            n = nArray2[0];
        } else {
            object = new int[1];
            var18_11 = new int[1];
            GDK.gdk_window_get_origin(l4, object, var18_11);
            n3 = (int)(dArray[0] - (double)object[0]);
            n2 = (int)(dArray2[0] - (double)var18_11[0]);
            n = nArray[0];
        }
        if ((n & 0x100) == 0) {
            return 0L;
        }
        object = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, (GtkAllocation)object);
        int n4 = object.x;
        int n5 = object.y;
        int n6 = object.width;
        int n7 = object.height;
        GTK.gtk_widget_get_allocation(this.parent.handle, (GtkAllocation)object);
        int n8 = object.width;
        int n9 = object.height;
        int n10 = this.lastX;
        int n11 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n10 = Math.min(Math.max(0, n3 + n4 - this.startX), n8 - n6);
        } else {
            n11 = Math.min(Math.max(0, n2 + n5 - this.startY), n9 - n7);
        }
        if (n10 == this.lastX && n11 == this.lastY) {
            return 0L;
        }
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(l2);
        Rectangle rectangle = new Rectangle(n10, n11, n6, n7);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - n6) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
        if (event.doit) {
            this.lastX = rectangle2.x;
            this.lastY = rectangle2.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n6 - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        if ((this.style & 0x10000) != 0) {
            this.setBoundsInPixels(this.lastX, this.lastY, n6, n7);
        }
        return l3;
    }

    @Override
    long gtk_realize(long l) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0L);
        return super.gtk_realize(l);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (!GTK.GTK4) {
            GTK3.gtk_widget_add_events(this.handle, 8);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0L) {
            OS.g_object_unref(this.defaultCursor);
        }
        this.defaultCursor = 0L;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void setCursor(long l) {
        super.setCursor(l != 0L ? l : this.defaultCursor);
    }

    @Override
    int traversalCode(int n, long l) {
        return 0;
    }
}

