/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    long handle;
    private Map<Integer, String> labels;

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, MessageBox.checkStyle(shell, MessageBox.checkStyle(n)));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        int n;
        long l = this.parent != null ? this.parent.topHandle() : 0L;
        int n2 = 2;
        if ((this.style & 0x38000) != 0) {
            n2 |= 1;
        }
        int n3 = 0;
        if ((this.style & 8) != 0) {
            n3 = 1;
        }
        if ((this.style & 4) != 0) {
            n3 = 2;
        }
        if ((this.style & 1) != 0) {
            n3 = 3;
        }
        byte[] byArray = Converter.wcsToMbcs("%s", true);
        byte[] byArray2 = Converter.wcsToMbcs(this.title, true);
        this.handle = GTK.gtk_message_dialog_new(l, n2, n3, 0, byArray, byArray2);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (l != 0L) {
            if (GTK.GTK4) {
                var7_6 = GTK4.gtk_window_get_icon_name(l);
                if (var7_6 != 0L) {
                    GTK4.gtk_window_set_icon_name(this.handle, var7_6);
                }
            } else {
                var7_6 = GTK3.gtk_window_get_icon_list(l);
                if (var7_6 != 0L) {
                    GTK3.gtk_window_set_icon_list(this.handle, var7_6);
                    OS.g_list_free(var7_6);
                }
            }
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.createButtons(display.getDismissalAlignment());
        GTK.gtk_message_dialog_format_secondary_text(this.handle, byArray, Converter.javaStringToCString(this.message));
        display.addIdleProc();
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        long l2 = GTK.gtk_window_get_group(0L);
        GTK.gtk_window_group_add_window(l2, this.handle);
        int n4 = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n4 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n4, 0, display.emissionProc, this.handle, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run(display, this.handle, false);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_dialog_run(this.handle);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n4, l3);
        }
        if (GTK.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            GTK4.gtk_window_destroy(this.handle);
        } else {
            GTK3.gtk_widget_destroy(this.handle);
        }
        return n;
    }

    private void createButtons(int n) {
        if (n == 16384) {
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(32, "SWT_OK"), 32);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(512, "SWT_Abort"), 512);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(1024, "SWT_Retry"), 1024);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(64, "SWT_Yes"), 64);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(128, "SWT_No"), 128);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(2048, "SWT_Ignore"), 2048);
            }
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(256, "SWT_Cancel"), 256);
            }
        } else {
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(256, "SWT_Cancel"), 256);
            }
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(32, "SWT_OK"), 32);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(128, "SWT_No"), 128);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(64, "SWT_Yes"), 64);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(2048, "SWT_Ignore"), 2048);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(1024, "SWT_Retry"), 1024);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button(this.handle, this.getLabelForButton(512, "SWT_Abort"), 512);
            }
        }
    }

    private byte[] getLabelForButton(int n, String string) {
        if (this.labels != null && this.labels.containsKey(n) && this.labels.get(n) != null) {
            return Converter.wcsToMbcs(this.labels.get(n), true);
        }
        return Converter.wcsToMbcs(SWT.getMessage(string), true);
    }

    private static int checkStyle(int n) {
        int n2 = 4064;
        int n3 = n & n2;
        if (n3 == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }

    public void setButtonLabels(Map<Integer, String> map) {
        if (map == null) {
            this.error(4);
        }
        this.labels = map;
    }
}

