/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n5 = this.layout.getWidth();
        if (n == 0) {
            this.layout.setWidth(1);
            var7_5 = DPIUtil.autoScaleUp(this.layout.getBounds());
            n4 = 0;
            n3 = var7_5.height;
        } else {
            this.layout.setWidth(DPIUtil.autoScaleDown(n));
            var7_5 = DPIUtil.autoScaleUp(this.layout.getBounds());
            n4 = var7_5.width;
            n3 = var7_5.height;
        }
        this.layout.setWidth(n5);
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n6 = this.getBorderWidthInPixels();
        return new Point(n4 += n6 * 2, n3 += n6 * 2);
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_widget_set_focusable(this.handle, true);
        } else {
            GTK3.gtk_widget_set_has_window(this.handle, true);
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
        this.layout = new TextLayout(this.display);
        this.disabledColor = new Color(LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.layout.setFont(this.getFont());
        this.text = "";
        this.initAccessible();
    }

    @Override
    void drawWidget(GC gC) {
        int n = this.selection.x;
        int n2 = this.selection.y;
        if (n > n2) {
            n = this.selection.y;
            n2 = this.selection.x;
        }
        n2 = -1;
        n = -1;
        if ((this.state & 0x10) != 0) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n, n2, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            Rectangle[] rectangleArray = this.getRectanglesInPixels(this.focusIndex);
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = DPIUtil.autoScaleDown(rectangleArray[i]);
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    @Override
    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        this.styleLinkParts();
        this.redraw();
    }

    @Override
    void fixStyle() {
        this.fixStyle(this.handle);
    }

    void initAccessible() {
        if (GTK.GTK4) {
            return;
        }
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            @Override
            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            @Override
            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            @Override
            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            @Override
            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return this.linkColor != null ? this.linkColor : this.display.getSystemColor(36);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectanglesInPixels(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, point.y));
        } else {
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(point.x, nArray[n3] - 1));
            rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getBounds(nArray[n4 - 1], point.y));
            if (n4 - n3 > 1) {
                for (int i = n3; i < n4 - 1; ++i) {
                    rectangleArray[n5++] = DPIUtil.autoScaleUp(this.layout.getLineBounds(i));
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int n = GDK.gdk_event_get_event_type(l2);
        n = Link.fixGdkEventTypeValues(n);
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_button_event_get_button(l2);
        } else {
            GDK.gdk_event_get_button(l2, nArray);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        if (nArray[0] == 1 && n == 4) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n2 = (int)dArray[0];
            int n3 = (int)dArray2[0];
            if ((this.style & 0x8000000) != 0) {
                n2 = this.getClientWidth() - n2;
            }
            int n4 = DPIUtil.autoScaleUp(this.layout.getOffset(n2, n3, null));
            int n5 = this.selection.x;
            int n6 = this.selection.y;
            this.selection.x = n4;
            this.selection.y = -1;
            if (n5 != -1 && n6 != -1) {
                if (n5 > n6) {
                    int n7 = n5;
                    n5 = n6;
                    n6 = n7;
                }
                Rectangle rectangle = DPIUtil.autoScaleUp(this.layout.getBounds(n5, n6));
                this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            for (int i = 0; i < this.offsets.length; ++i) {
                Rectangle[] rectangleArray = this.getRectanglesInPixels(i);
                for (int j = 0; j < rectangleArray.length; ++j) {
                    Rectangle rectangle = rectangleArray[j];
                    if (!rectangle.contains(n2, n3)) continue;
                    this.focusIndex = i;
                    this.redraw();
                    return l3;
                }
            }
        }
        return l3;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        long l3 = super.gtk_button_release_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (this.focusIndex == -1) {
            return l3;
        }
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_button_event_get_button(l2);
        } else {
            GDK.gdk_event_get_button(l2, nArray);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        if (nArray[0] == 1) {
            int n = (int)dArray[0];
            int n2 = (int)dArray2[0];
            if ((this.style & 0x8000000) != 0) {
                n = this.getClientWidth() - n;
            }
            Rectangle[] rectangleArray = this.getRectanglesInPixels(this.focusIndex);
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = rectangleArray[i];
                if (!rectangle.contains(n, n2)) continue;
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendSelectionEvent(13, event, true);
                return l3;
            }
        }
        return l3;
    }

    @Override
    long gtk_draw(long l, long l2) {
        long l3 = GTK.gtk_widget_get_style_context(l);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        GTK.gtk_render_background(l3, l2, 0.0, 0.0, n, n2);
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_event_after(long l, long l2) {
        long l3 = super.gtk_event_after(l, l2);
        int n = GDK.gdk_event_get_event_type(l2);
        switch (n) {
            case 12: {
                this.redraw();
            }
        }
        return l3;
    }

    @Override
    boolean gtk4_key_press_event(long l, int n, int n2, int n3, long l2) {
        boolean bl = super.gtk4_key_press_event(l, n, n2, n3, l2);
        if (!bl && this.focusIndex != -1) {
            switch (n) {
                case 32: 
                case 65293: 
                case 65421: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    break;
                }
                case 65289: {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    break;
                }
                case 65056: {
                    if (this.focusIndex <= 0) break;
                    --this.focusIndex;
                    this.redraw();
                }
            }
        }
        return bl;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if (this.focusIndex == -1) {
            return l3;
        }
        int[] nArray = new int[1];
        GDK.gdk_event_get_keyval(l2, nArray);
        switch (nArray[0]) {
            case 32: 
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
            case 65289: {
                if (this.focusIndex >= this.offsets.length - 1) break;
                ++this.focusIndex;
                this.redraw();
                break;
            }
            case 65056: {
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return l3;
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        long l3 = super.gtk_motion_notify_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(l2, dArray, dArray2);
            nArray[0] = GDK.gdk_event_get_modifier_state(l2);
        } else {
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
            GDK.gdk_event_get_state(l2, nArray);
        }
        int n = (int)dArray[0];
        int n2 = (int)dArray2[0];
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        if ((nArray[0] & 0x100) != 0) {
            int n3 = this.selection.y;
            this.selection.y = DPIUtil.autoScaleUp(this.layout.getOffset(n, n2, null));
            if (this.selection.y != n3) {
                int n4 = this.selection.y;
                if (n3 > n4) {
                    int n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                Rectangle rectangle = this.layout.getBounds(n3, n4);
                this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
        } else {
            for (int i = 0; i < this.offsets.length; ++i) {
                Rectangle[] rectangleArray = this.getRectanglesInPixels(i);
                for (int j = 0; j < rectangleArray.length; ++j) {
                    Rectangle rectangle = rectangleArray[j];
                    if (!rectangle.contains(n, n2)) continue;
                    this.setCursor(this.display.getSystemCursor(21));
                    return l3;
                }
            }
            this.setCursor(null);
        }
        return l3;
    }

    @Override
    boolean hooksPaint() {
        return true;
    }

    @Override
    boolean mnemonicHit(char c) {
        char c2 = Character.toUpperCase(c);
        String string = this.layout.getText();
        for (int i = 0; i < this.mnemonics.length - 1; ++i) {
            char c3;
            if (this.mnemonics[i] == -1 || c2 != Character.toUpperCase(c3 = string.charAt(this.mnemonics[i]))) continue;
            if (!this.setFocus()) {
                return false;
            }
            this.focusIndex = i;
            this.redraw();
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        char c2 = Character.toUpperCase(c);
        String string = this.layout.getText();
        for (int i = 0; i < this.mnemonics.length - 1; ++i) {
            char c3;
            if (this.mnemonics[i] == -1 || c2 != Character.toUpperCase(c3 = string.charAt(this.mnemonics[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        this.linkColor = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        block22: for (int i = 0; i < n3; ++i) {
            n2 = Character.toLowerCase(stringBuilder2.charAt(i));
            if (n2 == 92 && i + 1 < n3 && ((n = Character.toLowerCase(stringBuilder2.charAt(i + 1))) == 60 || n == 62)) {
                stringBuilder2.deleteCharAt(i);
                --n3;
            }
            switch (n4) {
                case 0: {
                    if (n2 != 60) continue block22;
                    n7 = i;
                    ++n4;
                    continue block22;
                }
                case 1: {
                    if (n2 != 97) continue block22;
                    ++n4;
                    continue block22;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n4 = 7;
                            continue block22;
                        }
                        case 62: {
                            n8 = i + 1;
                            ++n4;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) continue block22;
                    n4 = 13;
                    continue block22;
                }
                case 3: {
                    if (n2 != 60) continue block22;
                    n9 = i;
                    ++n4;
                    continue block22;
                }
                case 4: {
                    n4 = n2 == 47 ? n4 + 1 : 3;
                    continue block22;
                }
                case 5: {
                    n4 = n2 == 97 ? n4 + 1 : 3;
                    continue block22;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n5] = this.parseMnemonics(stringBuilder2.toString().toCharArray(), n6, n7, stringBuilder);
                        n = stringBuilder.length();
                        this.parseMnemonics(stringBuilder2.toString().toCharArray(), n8, n9, stringBuilder);
                        this.offsets[n5] = new Point(n, stringBuilder.length() - 1);
                        if (this.ids[n5] == null) {
                            this.ids[n5] = new String(stringBuilder2.toString().toCharArray(), n8, n9 - n8);
                        }
                        ++n5;
                        n9 = n10 = i + 1;
                        n8 = n10;
                        n7 = n10;
                        n6 = n10;
                        n4 = 0;
                        continue block22;
                    }
                    n4 = 3;
                    continue block22;
                }
                case 7: {
                    n4 = n2 == 114 ? n4 + 1 : 0;
                    continue block22;
                }
                case 8: {
                    n4 = n2 == 101 ? n4 + 1 : 0;
                    continue block22;
                }
                case 9: {
                    n4 = n2 == 102 ? n4 + 1 : 0;
                    continue block22;
                }
                case 10: {
                    n4 = n2 == 61 ? n4 + 1 : 0;
                    continue block22;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n4;
                        n10 = i + 1;
                        continue block22;
                    }
                    n4 = 0;
                    continue block22;
                }
                case 12: {
                    if (n2 != 34) continue block22;
                    this.ids[n5] = new String(stringBuilder2.toString().toCharArray(), n10, i - n10);
                    n4 = 2;
                    continue block22;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n4 = 0;
                        continue block22;
                    }
                    if (n2 != 61) continue block22;
                    ++n4;
                    continue block22;
                }
                case 14: {
                    n4 = n2 == 34 ? n4 + 1 : 0;
                    continue block22;
                }
                case 15: {
                    if (n2 != 34) continue block22;
                    n4 = 2;
                    continue block22;
                }
                default: {
                    n4 = 0;
                }
            }
        }
        if (n6 < n3) {
            n2 = this.parseMnemonics(stringBuilder2.toString().toCharArray(), n6, n7, stringBuilder);
            n = this.parseMnemonics(stringBuilder2.toString().toCharArray(), Math.max(n7, n8), n3, stringBuilder);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n5] = n;
        } else {
            this.mnemonics[n5] = -1;
        }
        if (this.offsets.length != n5) {
            Point[] pointArray = new Point[n5];
            System.arraycopy(this.offsets, 0, pointArray, 0, n5);
            this.offsets = pointArray;
            String[] stringArray = new String[n5];
            System.arraycopy(this.ids, 0, stringArray, 0, n5);
            this.ids = stringArray;
            int[] nArray = new int[n5 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n5 + 1);
            this.mnemonics = nArray;
        }
        return stringBuilder.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuilder stringBuilder) {
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '&') {
                if (i + 1 < n2 && cArray[i + 1] == '&') {
                    stringBuilder.append(cArray[i]);
                    ++i;
                    continue;
                }
                n3 = stringBuilder.length();
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        return n3;
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.layout.setWidth(DPIUtil.autoScaleDown(n3 > 0 ? n3 : -1));
            this.redraw();
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.layout.setFont(Font.gtk_new(this.display, l));
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.linkColor)) {
                return;
            }
        } else if (this.linkColor == null) {
            return;
        }
        this.linkColor = color;
        if (this.getEnabled()) {
            this.styleLinkParts();
            this.redraw();
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        this.layout.setOrientation(this.style & 0x6000000);
        if (!bl) {
            this.redraw(true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        this.styleLinkParts();
        int[] nArray = new int[this.offsets.length * 2];
        for (int i = 0; i < this.offsets.length; ++i) {
            Point point = this.offsets[i];
            nArray[i * 2] = point.x;
            nArray[i * 2 + 1] = point.y + 1;
        }
        this.layout.setSegments(nArray);
        TextStyle textStyle = new TextStyle(null, null, null);
        textStyle.underline = true;
        for (int i = 0; i < this.mnemonics.length; ++i) {
            int n = this.mnemonics[i];
            if (n == -1) continue;
            this.layout.setStyle(textStyle, n, n);
        }
        this.redraw();
    }

    @Override
    void showWidget() {
        super.showWidget();
        this.fixStyle(this.handle);
    }

    void styleLinkParts() {
        boolean bl = (this.state & 0x10) == 0;
        TextStyle textStyle = new TextStyle(null, bl ? this.getLinkForeground() : this.disabledColor, null);
        textStyle.underline = true;
        for (int i = 0; i < this.offsets.length; ++i) {
            Point point = this.offsets[i];
            this.layout.setStyle(textStyle, point.x, point.y);
        }
    }

    @Override
    int traversalCode(int n, long l) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int n2 = super.traversalCode(n, l);
        if (n == 65289 && this.focusIndex < this.offsets.length - 1) {
            return n2 & 0xFFFFFFEF;
        }
        if (n == 65056 && this.focusIndex > 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }
}

